import sys
import re
import uuid

HOST = "0.0.0.0"
PORT = 80

#Protocol used

PROTOCOL = ''

SUCCESS = 200

#HTTP Error codes

#NO_CONTENT_ERROR_CODE = 204
BAD_REQUEST_ERROR_CODE = 400
INTERNAL_SERVER_ERROR_CODE = 500
#SERVICE_UNAVAILABLE = 503
INVALID_LOGIN = 401




#Messages error codes
#ERROR: It was not possible to conclude the action requested (unkown/others)
UNSPECIFIED_ERROR_CODE = 1
UNSPECIFIED_ERROR_MSG = "Device {}: It was not possible to conclude the action requested"
"""
#ERROR: bad formatted UCI
BAD_UCI_FORMAT_ERROR_CODE = 1001
BAD_UCI_FORMAT_ERROR_MSG = "UCI wrong format"
#ERROR: UCI not found
BAD_UCI_VALUE_ERROR_CODE = 1002
#ERROR: POST request came with empty params(ucis/ips) to set
#SET_EMPTY_UCI_ERROR_CODE = 1003
EMPTY_PARAM_ERROR_CODE = 1003
#ERROR: It was not possible to set the UCI values received
SET_UCI_ERROR_CODE = 1004
#ERROR: It was not possible to commit the changes
COMMIT_UCI_ERROR_CODE = 1005
#ERROR: It was not possible to revert the changes
REVERT_UCI_ERROR_CODE = 1006
"""



#NO ERROR MESSAGE
ALL_OK = 0

# when json body cannot be converted to json object or unexpected keys
INVALID_JSON_ERROR_CODE = 10
INVALID_JSON_ERROR_MSG = "Invalid JSON"

INVALID_PARAMETER_ERROR_CODE = 11
INVALID_PARAMETER_ERROR_MSG = "Invalid parameter {}"

INVALID_PASSWORD_ERROR_CODE = 12
INVALID_PASSWORD_ERROR_MSG = "Current password invalid"

INVALID_VALUE_ERROR_CODE = 13
INVALID_VALUE_ERROR_MSG = "Invalid value"

#Connection refused
CONNECTION_REFUSED_ERROR_CODE = 20
CONNECTION_REFUSED_ERROR_MSG = "Device {}: Connection refused"
#Connection Error Unspecified
CONNECTION_ERROR_CODE = 21
CONNECTION_ERROR_MSG = "Device {}: Connection error"
#Connection reseted
#CONNECTION_RESETED_ERROR_CODE = 22
#CONNECTION_RESETED_ERROR_MSG = "Device {}: Connection reseted"

#used only for internal functions
EXCEPTION_OCCURRED_ERROR_CODE = 100
UNEXPECTED_BEHAVIOR_ERROR_CODE = 101

#ERROR: IP addr to set speaker test is empty


# File Path to store servicesList to restart
restartServicesFile = "/tmp/servicesToRestart"
passwdFile = "/barix/local/etc/.passwd"
JSONSourcesFile = "/mnt/data/aes67/sourcesList.json"
localSourcesFile = "/mnt/data/aes67/localSources.json"
sinkConfigFile = "/mnt/data/aes67/sink.json"


UPLOAD_FOLDER = "/mnt/data/uploads"
MAX_FILE_SIZE_UPDATE = 256 * 1024 * 1024
CA_CERTIFICATES_FOLDER = "/mnt/data/ca-certificates"
UPDATES_FOLDER = "/mnt/data/updates"
SSL_CERTIFICATES_FOLDER = "/mnt/data/certs"

SESSION_KEY_FILE="/tmp/SESSION_KEY"
FW_UPDATE_FILE="/tmp/FW_UPDATE"


#user credentials
USERNAME = "admin"
REALM = "Barix Login"

def printException(msg, exception):
    exc_type, exc_obj, tb = sys.exc_info()
    filename = tb.tb_frame.f_code.co_filename
    lineno = tb.tb_lineno
    print("Exception on file {} on line {}: {} - {}".format(filename, lineno, msg, exception))


def isIpAddr(strIP):
    if re.search('^(((0|1)?[0-9]?[0-9])|(2[0-4][0-9])|(25[0-5]))\.(((0|1)?[0-9]?[0-9])|(2[0-4][0-9])|(25[0-5]))\.(((0|1)?[0-9]?[0-9])|(2[0-4][0-9])|(25[0-5]))\.(((0|1)?[0-9]?[0-9])|(2[0-4][0-9])|(25[0-5]))$', strIP) is not None:
        print("Is IP address")
        return True
    return False

