import os
import ast
import logging
import subprocess
import shlex
import time
import hashlib
#import requests
import json
import psutil
import ifaddr
import urllib
from ipaddress import ip_address, IPv4Address

from pathlib import Path

from os.path import isfile, join
from werkzeug.utils import secure_filename

#from barix import HttpMethod

from .common import *
from uci import Uci, UciExceptionNotFound, UciException
from .uci import *

import app.common as common

from OpenSSL import crypto, SSL

from flask import session

log = logging.getLogger('werkzeug')

#readyState = True

def restartServices():
    #global readyState
    # check if file already exists
    if os.path.isfile(restartServicesFile):
        finished = False
        while not finished:
            try:
                proc = None
                # read services from file
                servicesList, error = readFromRestartServicesFile()
                if error != ALL_OK:
                    log.error("ATTENTION! It was not possible to check services to restart.")
                    finished = True
                else:
                    if len(servicesList) > 0:
                        log.debug('List of services to restart: {}'.format(servicesList))
                        # epic.main.volume
                        # reboot
                        # restart_main_app
                        # S20ntpd
                        if "reboot" in servicesList:
                            cmd = "reboot"
                            log.debug("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            proc.wait()
                        else:
                            #path = "/barix/config/templates/rc.d/"
                            path = "/etc/rc5.d/"
                            # restart services by order
                            sortedServicesList = sorted(servicesList)
                            log.debug('Sorted list of services to restart: {}'.format(sortedServicesList))
                            service = sortedServicesList.pop(0)
                            if service == "ae_ms.volume.out0":
                                try:
                                    redirectionURL = "http://127.0.0.1:48081/api/v1/reload-settings"
                                    r = urllib.request.Request(url=redirectionURL, method='PUT')
                                    resp = urllib.request.urlopen(r)
                                except Exception as e:
                                    log.error(e)
                                    raise e
                            elif service == "epic.main.volume":
                                uci = Uci()
                                vol = uci.get("epic", "main", "volume")
                                try:
                                    f = open("/etc/barix/soundcard.conf", 'r')
                                    lines = f.read().split('\n')
                                    for line in lines:
                                        if line.startswith('master.control'):
                                            mixer = ((line.split('='))[1]).strip('\n')
                                    f.close()
                                except Exception as e:
                                    printException("An error occured while getting mixer", e)
                                    mixer = "Line Out"
                                cmd = "/usr/bin/amixer -q -c 0 set '" + mixer + "' " + vol + "%"
                                log.debug("Executing: {}".format(cmd))
                                proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            elif service == "Z60restart_main_app":
                                cmd = "barix-wd --pid-file=/var/run/msx00-app.pid --restart"
                                log.debug("Executing: {}".format(cmd))
                                proc = subprocess.Popen(shlex.split(cmd), shell=False)
                                # proc.wait()
                                # if "Z70restart_dsp" in servicesList:
                                #     time.sleep(15)
                                #     cmd = "barix-wd --pid-file=/var/run/ms700-dsp.pid --restart"
                                #     log.debug("Executing: {}".format(cmd))
                                #     proc = subprocess.Popen(shlex.split(cmd), shell=False)
                                #     sortedServicesList.remove("Z70restart_dsp")
                            # elif service == "Z70restart_dsp":
                            #     log.debug("dsp is restarted after main app")
                            #     sortedServicesList.append("Z70restart_dsp")
                            elif service == "start_dropbear":
                                cmd = "/barix/hooks/application/dropbear.hook start"
                                log.debug("Executing: {}".format(cmd))
                                proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            elif service == "start_snmp":
                                cmd = "/etc/init.d/snmpd start"
                                log.debug("Executing: {}".format(cmd))
                                proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            elif service == "stop_snmp":
                                cmd = "/etc/init.d/snmpd stop"
                                log.debug("Executing: {}".format(cmd))
                                proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            elif service == "device_alias":
                                # change name in snmpd.conf
                                uci = Uci()
                                device_alias = uci.get("epic", "main", "device_alias")
                                updateSnmpSysName(device_alias)
                                # restart service
                                cmd = "/etc/init.d/snmpd restart"
                                log.debug("Executing: {}".format(cmd))
                                proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            else:
                                cmd = path + service + " restart"
                                log.debug("Restarting: {}".format(cmd))
                                proc = subprocess.Popen(shlex.split(cmd), shell=False)

                            # delete service from file
                            res = writeIntoRestartServicesFile(sortedServicesList)
                            if res != ALL_OK:
                                pass
                            #finished = True
                            if proc is not None:
                                proc.wait()
                                if proc.returncode != 0:
                                    log.debug("Error trying to restart service {}:{}".format(service, proc.returncode))
                                else:
                                    log.debug("Service {} restarted with success.".format(service))
                    else:
                        log.debug("No services to restart: file {} is empty".format(restartServicesFile))
                        finished = True
            except Exception as e:
                printException("An error occured while reading services from file", e)
                finished = True
            time.sleep(1)
    else:
        log.debug("No services to restart: file {} does not exist".format(restartServicesFile))

def createListOfServicesToRestart(ucis_list):
    log.debug("Creating list of services to restart")
    servicesToRestart = []
    log.debug("Ucis changed: {}".format(ucis_list))
    for uci in ucis_list:
        try:
            config = uci[0]
            if config == "dropbear":
                uci = Uci()
                dropbear = uci.get("dropbear", "RunCtl", "enable")
                if dropbear == "1" or dropbear == "on_until_reboot":
                    servicesToRestart.append('start_dropbear')
                else:
                    servicesToRestart.append('reboot')
            elif config == "epic":
                section = uci[1]
                option = uci[2]
                if section == "main" and option == "volume":
                    servicesToRestart.append('epic.main.volume')
                elif section == "main" and option == "device_alias":
                    # log.debug("Changes on epic.main.device_alias uci config do not require do restart any service")
                    servicesToRestart.append('device_alias')
                elif (section == "main" and option == "fw_update_auto") or (section == "main" and option == "fw_update_url"):
                    servicesToRestart.append('reboot')
                elif section == "snmp" and option == "enable":
                    uci = Uci()
                    snmp_enabled = uci.get("epic", "snmp", "enable")
                    if snmp_enabled == 'true':
                        servicesToRestart.append('start_snmp')
                    else:
                        servicesToRestart.append('stop_snmp')
                else:
                    servicesToRestart.append('Z60restart_main_app')
                    # deviceType = getDeviceModel()
                    # if deviceType == "MS-700":
                    #     servicesToRestart.append('Z70restart_dsp')
            elif config == "ae_ms":
                section = uci[1]
                option = uci[2]
                if section == "volume" and option == "out0":
                    servicesToRestart.append('ae_ms.volume.out0')
            elif config == "httpd":
                # for now, only webui password from httpd can be changed
                # technically doesn't require to restart anything, but a reboot seems nice
                servicesToRestart.append('reboot')
                # when one is able to change http(s), backend has to be restarted. if not possible, reboot the device
                # section = uci[1]
                # option = uci[2]
                # if section == "webserver" and option == "protocol":
                #    servicesToRestart.append("flask_backend") # restart backend from new_webui
                #    servicesToRestart.append('reboot')
            elif config == "network":
                servicesToRestart.append('reboot')
            elif config == "ntp":
                #servicesToRestart.append("S20ntpd")
                servicesToRestart.append('reboot')
            elif config == "proxy_config":
                log.debug("Changes on proxy_config uci config do not require do restart any service")
            elif config == "security":
                #log.debug("Changes on security uci config do not require do restart any service")
                servicesToRestart.append('reboot')
            elif config == "sonic_ip":
                #log.debug("Changes on sonic_ip uci config do not require do restart any service")
                servicesToRestart.append('reboot')
            elif config == "timezone":
                servicesToRestart.append('S20timezone-handler')
            else:
                log.debug("Unrecognized UCI config: {}".format(config))
        except Exception as e:
            log.error(e)
            return -1, None, EXCEPTION_OCCURRED_ERROR_CODE

    if len(servicesToRestart) > 0:
        # reading services from file
        """
        servicesFromFile = []
        # check if file already exists
        if isfile(restartServicesFile):
            try:
                f = open(restartServicesFile, 'r')
                servicesFromFile = f.readlines()
                #log.debug('file contents {}'.format(content))
                #if content != '':
                    #servicesFromFile = ast.literal_eval(content)
            except Exception as e:
                log.error(e)
                return EXCEPTION_OCCURRED_ERROR_CODE
        """
        # read services from file
        servicesFromFile,error = readFromRestartServicesFile()
        if error != ALL_OK:
            return -1, None, EXCEPTION_OCCURRED_ERROR_CODE
        # join services from list and from file
        listOfServices = []
        for service in servicesFromFile:
            listOfServices.append(service)
        for service in servicesToRestart:
            listOfServices.append(service)
        # remove duplicates
        setOfServices = set(listOfServices)
        log.debug("List of services to write into file: {}".format(setOfServices))
        """
        log.debug("Write into file: {}".format(strListOfServices))
        try:
            f = open(restartServicesFile, 'w')
            f.write(strListOfServices)
            f.close()
        except Exception as e:
            log.error(e)
            return EXCEPTION_OCCURRED_ERROR_CODE
        """
        res = writeIntoRestartServicesFile(setOfServices)
        if res != ALL_OK:
            return -1, None, EXCEPTION_OCCURRED_ERROR_CODE
    else:
        log.debug("No services to restart")

    return len(servicesToRestart), ALL_OK

def readFromRestartServicesFile():
    #log.debug("Reading services from file {}".format(restartServicesFile))
    servicesFromFile = []
    # check if file already exists
    if isfile(restartServicesFile):
        try:
            f = open(restartServicesFile, 'r')
            content = f.readlines()
            for elem in content:
                servicesFromFile.append(elem.strip('\n'))
            # log.debug('file contents {}'.format(content))
            # if content != '':
            # servicesFromFile = ast.literal_eval(content)
        except Exception as e:
            log.error("An error occured while reading from file {}:{}".format(restartServicesFile,e))
            return servicesFromFile, EXCEPTION_OCCURRED_ERROR_CODE
    return servicesFromFile, ALL_OK

def writeIntoRestartServicesFile(listOfServices):
    strListOfServices = ""
    for service in listOfServices:
        strListOfServices = strListOfServices + service + "\n"
    #log.debug(strListOfServices)
    strListOfServices = strListOfServices[:-1] #remove last \n
    log.debug("Writting into file {}: {}".format(restartServicesFile, strListOfServices))
    try:
        f = open(restartServicesFile, 'w')
        f.write(strListOfServices)
        f.close()
    except Exception as e:
        log.error("Error writing into {}:{}".format(restartServicesFile), e)
        return EXCEPTION_OCCURRED_ERROR_CODE
    return ALL_OK

def setNewWebUIpassword(passwd):
    #user = "admin"
    #realm = "Barix Login"
    #log.debug("WebUI password {}".format(passwd))
    strToDigest = USERNAME + ":" + REALM + ":" + passwd
    try:
        digest = hashlib.md5(strToDigest.encode('utf-8')).hexdigest()
    except Exception as e:
        log.debug("Can not calculate digest for the provided password")
        log.error(e)
        return EXCEPTION_OCCURRED_ERROR_CODE
    #log.debug("Calculated digest {}".format(digest))
    try:
        f = open(passwdFile, 'w')
        strToWrite = USERNAME+":"+REALM+":"+digest
        f.write(strToWrite)
        f.close()
        # generate new session Key
        generateNewSessionKey()
    except Exception as e:
        log.debug("Error while writting new password in file:")
        log.error(e)
        return EXCEPTION_OCCURRED_ERROR_CODE
    #session['sessionID'] = ""
    #session.modified = True
    #session.clear()
    return enableOrdisableWebUIpassword('true')

def enableOrdisableWebUIpassword(flag_value):
    # set webUI password flag to true
    error, reason, ucisConfigured = setNewUciConfigs({'httpd.webserver.password_set' : flag_value}, True, False)
    if error != ALL_OK:
        return UNEXPECTED_BEHAVIOR_ERROR_CODE
    return ALL_OK

def currPasswordIsValid(passwd):
    strToDigest = USERNAME+":"+REALM+":"+passwd
    try:
        digest = hashlib.md5(strToDigest.encode('utf-8')).hexdigest()
        print(digest)
    except Exception as e:
        log.debug("Can not calculate digest for the provided password")
        log.error(e)
        return False, EXCEPTION_OCCURRED_ERROR_CODE
    md5sum = ''
    try:
        f = open(passwdFile, 'r')
        content = f.read()
        f.close()
    except Exception as e:
        log.debug("Error while reading passwd file contents:")
        log.error(e)
        return False, EXCEPTION_OCCURRED_ERROR_CODE
    fileLines = content.split('\n')
    for line in fileLines:
        tmpStr = USERNAME+':'+REALM+':'
        if line.startswith(tmpStr):
            md5sum = line.split(':')[2]
            break
    print(md5sum)
    if md5sum != '':
        return digest == md5sum, ALL_OK
    else:
        return False, ALL_OK

def getWebUIPwd(username):
    webuiPassword = None
    try:
        f = open(passwdFile, 'r')
        content = f.read()
        f.close()
    except Exception as e:
        log.debug("Error while reading passwd file contents:")
        log.error(e)
    try:
        fileLines = content.split('\n')
        for line in fileLines:
            tmpStr = username + ':' + REALM + ':'
            if line.startswith(tmpStr):
                webuiPassword = line.split(':')[2]
                break
    except Exception as e:
        log.error(e)
    #log.debug(webuiPassword)
    return webuiPassword

"""
def isIpAddr(strIP):
    if re.search('^(((0|1)?[0-9]?[0-9])|(2[0-4][0-9])|(25[0-5]))\.(((0|1)?[0-9]?[0-9])|(2[0-4][0-9])|(25[0-5]))\.(((0|1)?[0-9]?[0-9])|(2[0-4][0-9])|(25[0-5]))\.(((0|1)?[0-9]?[0-9])|(2[0-4][0-9])|(25[0-5]))$', strIP) is not None:
        print("Is IP address")
        return True
    return False
"""

def getFWVer():
    fwVerFile = "/barix/info/VERSION"
    try:
        with open(fwVerFile) as file:
            fw_version = file.read().strip('\n')
            log.debug("FW Version: {}".format(fw_version))
            return fw_version
    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getKernelVer():
    kernelVerFile = "/proc/version"
    try:
        with open(kernelVerFile) as file:
            kernelVer = file.read().strip('\n')
            log.debug("kernelVer: {}".format(kernelVer))
            return kernelVer
    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getBootloaderVer():
    bootloaderVerFile = "/barix/info/BOOTVERSION"
    try:
        with open(bootloaderVerFile) as file:
            bootloaderVer = file.read().strip('\n')
            log.debug("bootloaderVer: {}".format(bootloaderVer))
            return bootloaderVer

    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getMACaddr():
    macAddrFile = "/sys/class/net/eth0/address"
    try:
        with open(macAddrFile) as file:
            mac_addr = file.read().upper().strip('\n')
            log.debug("MAC Address: {}".format(mac_addr))
            return mac_addr
    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getDeviceType():
    devTypeFile = "/tmp/factory_info_partition/factory_info_json"
    try:
        with open(devTypeFile) as json_file:
            factInfoJson = json.load(json_file)
            device_type = factInfoJson["HW_DEVICE"]["Product_Name"]
            log.debug("Device Type: {}".format(device_type))
            return device_type
    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getDeviceTypeID():
    devTypeFile = "/tmp/factory_info_partition/factory_info_json"
    try:
        with open(devTypeFile) as json_file:
            factInfoJson = json.load(json_file)
            device_type_id = factInfoJson["HW_DEVICE"]["Product_ID"]
            log.debug("Device Type ID: {}".format(device_type_id))
            return device_type_id
    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getIPAMType():
    devTypeFile = "/tmp/factory_info_partition/factory_info_json"
    try:
        with open(devTypeFile) as json_file:
            factInfoJson = json.load(json_file)
            ipamType = factInfoJson["HW_DEVICE"]["IPAM_Name"]
            log.debug("IPAM Type: {}".format(ipamType))
            return ipamType
    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getIPAMTypeID():
    devTypeFile = "/tmp/factory_info_partition/factory_info_json"
    try:
        with open(devTypeFile) as json_file:
            factInfoJson = json.load(json_file)
            ipam_type_id = factInfoJson["HW_DEVICE"]["Legacy_IPAM_Type"]
            log.debug("Device Type ID: {}".format(ipam_type_id))
            return ipam_type_id
    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getHWTypeID():
    devTypeFile = "/tmp/factory_info_partition/factory_info_json"
    try:
        with open(devTypeFile) as json_file:
            factInfoJson = json.load(json_file)
            hw_type_id = factInfoJson["HW_DEVICE"]["Legacy_HW_Type"]
            log.debug("HW Type ID: {}".format(hw_type_id))
            return hw_type_id
    except Exception as e:
        log.exception("Exception found: {}".format(e))

def getWiredConnStatus():
    f = open("/sys/class/net/eth0/operstate", 'r')
    res = f.read()
    f.close()
    return res.strip('\n')

def getIPaddr(ifname):
    adapters = ifaddr.get_adapters()
    for adapter in adapters:
        if( adapter.nice_name == ifname ):
            for ip in adapter.ips:
                try:
                    if type(ip_address(str(ip.ip))) is IPv4Address:
                        log.debug("{} ip address: {}".format(ifname, ip.ip))
                        return ip.ip
                except ValueError:
                    log.debug("Invalid ip address for {}".format(ifname))
    return ''

def getNetmask():
    """cmd = ["ifconfig", "eth0", "|", "sed",  "-n", "'s/.*Mask:\([0-9.]\+\).*/\1/p'", "|", "tr", "-d", "'\\n'"]
    process = subprocess.run(cmd, capture_output=True)
    output = process.stdout
    print(output)
    return output"""
    process = subprocess.run(['ifconfig', 'eth0'], capture_output=True)
    output = process.stdout
    decodedOut = output.decode("utf-8")
    lines = decodedOut.split('\n')
    for line in lines:
        if line.find("netmask"):
            elems = line.split(' ')
            for idx in range(0, len(elems)):
                if elems[idx] == 'netmask':
                    return elems[idx+1]
    return ''

def getDefaultGW():
    """cmd = ["route", "-n", "|", "grep", "eth0", "|", "grep", "'^0.0.0.0'", "|", "awk", "'{print $2}'"]
    process = subprocess.run(cmd, capture_output=True)
    output = process.stdout
    print(output)
    return output"""
    ps1 = subprocess.Popen(['route', '-n'], stdout=subprocess.PIPE)
    ps2 = subprocess.Popen(['grep', 'eth0'], stdin=ps1.stdout, stdout=subprocess.PIPE)
    ps3 = subprocess.Popen(['grep', '^0.0.0.0'], stdin=ps2.stdout, stdout=subprocess.PIPE)
    output = subprocess.check_output(['awk', '{print $2}'], stdin=ps3.stdout)
    ps1.wait()
    ps2.wait()
    ps3.wait()
    decodedOutput = output.decode("utf-8").strip('\n')
    print(decodedOutput)
    return decodedOutput

def getDnsServers():
    """
    ps1 = subprocess.Popen(['grep', 'nameserver', '/etc/resolv.conf'], stdout=subprocess.PIPE)
    output = subprocess.check_output(['awk', '{print $2}'], stdin=ps1.stdout)
    ps1.wait()
    decodedOutput = output.decode("utf-8").strip('\n')
    print(decodedOutput)
    return decodedOutput
    """
    #uci = Uci()
    dns_type, _ = getUciValue('network', 'eth0', 'dns_type')
    if dns_type == "AUTO":
        return "Auto"
    else:
        dns_servers = []
        dns1, _ = getUciValue('network', 'eth0', 'dns1')
        if dns1 != '' and dns1 != None:
            dns_servers.append(dns1)
        dns2, _ = getUciValue('network', 'eth0', 'dns2')
        if dns2 != '' and dns2 != None:
            dns_servers.append(dns2)
        return dns_servers

def getApplication():
    try:
        uci = Uci()
        result = uci.get("flexa_app","AppParam","app_name")
    except UciExceptionNotFound:
        log.debug("uci.get param \"{}\" NOT FOUND".format("flexa_app.AppParam.app_name"))
        result = ''  # an uci with an empty string value is the same a non existing string
    except Exception as e:
        log.error(e)
        result = ""
    return result

def getAppVersion():
    try:
        uci = Uci()
        result = uci.get("flexa_app","AppParam","version")
    except UciExceptionNotFound:
        log.debug("uci.get param \"{}\" NOT FOUND".format("flexa_app.AppParam.version"))
        result = ''  # an uci with an empty string value is the same a non existing string
    except Exception as e:
        log.error(e)
        result = ""
    return result

def getSystemTime():
    #return datetime.datetime.now().strftime("%a %b %d %X %Z %Y");
    return time.time()

def getUpTime():
    return psutil.boot_time()

def getLicenses():
    licenses = []
    try:
        process = subprocess.run(["qiba-spi-get-license.sh"], capture_output=True)
        output = process.stdout
        decodedOutput = output.decode("utf-8")
        log.debug(decodedOutput)
        tmp_lic_list = decodedOutput.split('\n')
        for tmp_lic in tmp_lic_list:
            if tmp_lic != '':
                data = tmp_lic.split(' ')
                log.debug(data)
                log.debug(len(data))
                return_dict = {"lic_name": data[0], "lic_status": data[5], "issue_date": data[3], "expire_date": data[4],
                               "lic_id": data[1]}
                if data[2] == "N/A":
                    return_dict["lic_features"] = data[2]
                else:
                    lic_features = data[2][5:-1]
                    return_dict["lic_features"] = lic_features

                process = subprocess.run(["qiba-check-license", data[0]], capture_output=True)
                output = process.stdout

                decodedOutput = output.decode("utf-8")

                if decodedOutput.strip('\n') == data[2]:
                    return_dict["lic_sign"] = "Valid"
                else:
                    return_dict["lic_sign"] = "Invalid"

                licenses.append(return_dict)
    except Exception as e:
        log.error("Error retrieving licenses from the device: {}".format(e))
        licenses = None
    log.debug(licenses)
    return licenses

def getMassStorageDevices():
    #{"mountedDevices":[{"type":"USB","mountAs":"rw","fsType":"vfat","size":"3.7G","used":"155.1M","available":"3.6G","use":"4%","mountPoint":"/run/media/sda1"}]}
    massStorageDevicesList = []

    ps1 = subprocess.Popen(['df', '-h'], stdout=subprocess.PIPE)
    ps2 = subprocess.run(['grep', '/media/'], stdin=ps1.stdout, capture_output=True)
    ps1.wait()
    output = ps2.stdout
    #print(output)
    storageDevices = output.decode("utf-8").split('\n')
    #print(len(storageDevices))

    for line in storageDevices:
        if line != '':
            massStorageDeviceJSON = {}
            #print(line)
            dev = line.split(' ')
            paramsList = []
            for elem in dev:
                if elem != '':
                    paramsList.append(elem)
            print(paramsList)
            ps2 = subprocess.Popen(['mount'], stdout=subprocess.PIPE)
            output = subprocess.check_output(['grep', paramsList[0]], stdin=ps2.stdout)
            ps2.wait()
            mountLine = output.decode("utf-8")
            print(mountLine)
            mountLineDetails = mountLine.split(' ')
            print(mountLineDetails)

            if mountLineDetails[0].startswith("/dev/sd"):
                massStorageDeviceJSON["type"] = "USB"
            elif mountLineDetails[0].startswith("/dev/mmcblk"):
                massStorageDeviceJSON["type"] = "microSD"
            else:
                return {"error": "error"}

            massStorageDeviceJSON["mountAs"] = mountLineDetails[5].strip('(').split(',')[0]
            massStorageDeviceJSON["fsType"] = mountLineDetails[4]
            massStorageDeviceJSON["size"] = paramsList[1]
            massStorageDeviceJSON["used"] = paramsList[2]
            massStorageDeviceJSON["available"] = paramsList[3]
            massStorageDeviceJSON["use"] = paramsList[4].strip('%')
            massStorageDeviceJSON["mountPoint"] = paramsList[5]
            massStorageDevicesList.append(massStorageDeviceJSON)

    return massStorageDevicesList

def getLastFileLines(filename, nLines):
    lines = []
    for line in reversed(list(open(filename))):
        if nLines > 0:
            lines.append(line)
            nLines-=1
        else:
            break
    stringLines = ""
    for line in reversed(lines):
        stringLines += line
    return stringLines

def getAppNameFromManifest():
    name = ''
    try:
        if isfile('/mnt/data/package/manifest.json'):
            with open('/mnt/data/package/manifest.json') as json_file:
                data = json.load(json_file)
                if 'name' in data:
                    name=data['name']
                else:
                    name = "Flexa"
        else:
            name = "device"
    except Exception as e:
        log.error(e)

    return name

def getCertificates():
    try:
        certificatesList = []
        process = subprocess.run(['custom-ca-mgr', 'status'], capture_output=True)
        output = process.stdout
        decodedOutput = output.decode("utf-8")
        print(decodedOutput)
        lines = decodedOutput.split('\n')
        for line in lines:
            elems = line.split(' ')
            if len(elems) > 1: # last \n counts as one entire line
                #print(elems)
                filename = elems[1]
                #print(CA_CERTIFICATES_FOLDER)
                filePath = os.path.join(CA_CERTIFICATES_FOLDER, filename)
                #print(filePath)
                fileSize = os.path.getsize(filePath)
                state = elems[0]
                certificatesList.append({"name": filename, "size": fileSize, "state": state})
    except Exception as e:
        log.error(e)
        return None
    log.debug("certificatesList")
    log.debug(certificatesList)
    return certificatesList

def addCertificates(tmp_filepath, filename):
    try:
        #print('openssl x509 -in /tmp/foo')
        process = subprocess.run(['openssl', 'x509', '-in', tmp_filepath], capture_output=True)
        output = process.stdout
        print("output")
        print(output)
        decodedOutput = output.decode("utf-8")
        log.debug(decodedOutput)
        stderr = process.stderr
        print("stderr")
        print(stderr)
        print('...')
        empty = ''.encode("utf-8")
        if stderr != empty:
            return None
        print("skip")
    except Exception as e:
        log.error(e)
        return None
    try:
        final_filepath = os.path.join(CA_CERTIFICATES_FOLDER, filename)
        subprocess.run(['mv', tmp_filepath, final_filepath])
        #print('custom-ca-mgr', 'refresh')
        subprocess.run(['custom-ca-mgr', 'refresh'])
        return True
    except Exception as e:
        log.error(e)
        return False

def removeCertificates(certificatesList):
    counter = 0
    for certificateName in certificatesList:
        try:
            filePath = os.path.join(CA_CERTIFICATES_FOLDER, certificateName)
            if os.path.isfile(filePath):
                os.remove(filePath)
                counter+= 1
        except Exception as e:
            log.error(e)
    try:
        process = subprocess.run(['custom-ca-mgr', 'refresh'], capture_output=False)
    except Exception as e:
        log.error(e)
    log.debug("counter")
    log.debug(counter)
    return counter

def generateSSLCerts():
    # if certs dir does not exist, create it
    p = Path(SSL_CERTIFICATES_FOLDER)
    if not p.exists():
        try:
            p.mkdir()
        except Exception as e:
            log.error(e)

    # if certificate do not exist, generate it
    if os.path.isfile(os.path.join(SSL_CERTIFICATES_FOLDER, 'barix.pem')):
        log.debug("SSL certificate already exist, do not need to create")
    else:
        try:
            # generate RSA key pair
            k = crypto.PKey()
            k.generate_key(crypto.TYPE_RSA, 2048)

            emailAddress = "info@barix.com"
            countryName = "CH"
            stateOrProvinceName = "Zurich"
            localityName = "Dubendorf"
            organizationName = "Barix AG"
            commonName = "barix.local"
            cert = crypto.X509()
            cert.get_subject().C = countryName
            cert.get_subject().ST = stateOrProvinceName
            cert.get_subject().L = localityName
            cert.get_subject().O = organizationName
            cert.get_subject().CN = commonName
            cert.get_subject().emailAddress = emailAddress
            #cert.set_serial_number(serialNumber)
            cert.gmtime_adj_notBefore(0)
            cert.gmtime_adj_notAfter(20*365*24*60*60)
            cert.set_issuer(cert.get_subject())
            cert.set_pubkey(k)
            cert.sign(k, 'sha256')

            with open(os.path.join(SSL_CERTIFICATES_FOLDER, 'barix.pem'), "w") as f:
                f.write(crypto.dump_privatekey(crypto.FILETYPE_PEM, k).decode("utf-8"))

            with open(os.path.join(SSL_CERTIFICATES_FOLDER, 'barix.pem'), "a") as f:
                f.write(crypto.dump_certificate(crypto.FILETYPE_PEM, cert).decode("utf-8"))

            # set chmod of certificate file
            os.chmod(os.path.join(SSL_CERTIFICATES_FOLDER, 'barix.pem'), 0o400)

            # set uci value
            error, reason, ucisConfigured = setNewUciConfigs({'httpd.ssl.certificate':os.path.join(SSL_CERTIFICATES_FOLDER, 'barix.pem')}, True, False)
            if error == EXCEPTION_OCCURRED_ERROR_CODE:
                return Response(status=INTERNAL_SERVER_ERROR_CODE)
            elif error == INVALID_PARAMETER_ERROR_CODE:
                return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                              "msg": INVALID_PARAMETER_ERROR_MSG.format(reason)}
                log.error(return_msg)
                return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
        except Exception as e:
            log.error("Error while generating SSL certificates: {}".format(e))

def getSessionKey():
    #return uuid.uuid4().hex
    sessionKey = None
    # if file does not exist, create it
    if not os.path.isfile(SESSION_KEY_FILE):
        sessionKey = generateNewSessionKey()
    else: # file exists
        f = open(SESSION_KEY_FILE, 'r')
        sessionKey = f.read()
        if sessionKey == '': # file is empty
            sessionKey = generateNewSessionKey()
    return sessionKey

def generateNewSessionKey():
    sessionKey = uuid.uuid4().hex
    log.debug("New SESSION_KEY: {}".format(sessionKey))
    writeInFile(SESSION_KEY_FILE, sessionKey)
    return sessionKey

def getDeviceModel():
    deviceModelFile = "/barix/apps/epic-sip/MODEL"
    deviceModel = "MS-500A"
    if os.path.isfile(deviceModelFile):
        try:
            f = open(deviceModelFile, 'r')
            content = f.read().strip('\r\n')
            if content == "MS300B":
                deviceModel = "MS-300B"
            elif content == "MS500A":
                deviceModel = "MS-500A"
            elif content == "MS700":
                deviceModel = "MS-700"
            else:
                deviceModel = content
            f.close()
        except Exception as e:
            log.error("Error reading file {}: {}".format(deviceModelFile, e))
            raise e
    return deviceModel

def getOpenSourceLicenses():
    openSourceLicenses = []
    openSourceLicensesFile = "/barix/info/licenses-report.csv"
    try:
        with open(openSourceLicensesFile) as file:
            fileContent = file.read()
            fileContent = fileContent.replace('"', '')
            fileLines = fileContent.splitlines()
            for line in fileLines:
                license = line.split(',')
                openSourceLicenses.append(license)
    except Exception as e:
        log.error("Error trying to get open source licenses: {}".format(e))
    # print(openSourceLicenses)
    return openSourceLicenses



"""
Content must be string
"""
def writeInFile(filePath, content):
    error = ALL_OK
    try:
        f = open(filePath, 'w')
        f.write(content)
        f.close()
    except Exception as e:
        log.error("Error while writing in file {}: {}".format(filePath, e))
        error = EXCEPTION_OCCURRED_ERROR_CODE
    return error

def reboot():
    status_code = 200
    #return_msg = "OK"
    # TODO: check if there is no updater process running
    try:
        cmd = ["reboot"]
        subprocess.Popen(cmd)
    except Exception as e:
        log.debug(e)
        #return_msg = e
        status_code = 500
    return status_code

def resetToDefaults():
    status_code = 200
    return_msg = "OK"
    try:
        cmd = ["/usr/bin/barix-restore-defaults.sh", "soft", ">", "/dev/null", "2>&1"]
        subprocess.Popen(cmd)
    except Exception as e:
        log.debug(e)
        return_msg = e
        status_code = 500
    return status_code, return_msg


def updateSnmpSysName(new_alias):
    snmp_config_filepath = "/etc/snmp/snmpd.conf"
    if os.path.isfile(snmp_config_filepath):
        with open(snmp_config_filepath, 'r') as file:
            lines = file.readlines()

        for i, line in enumerate(lines):
            key, value = line.split(' ', 1)
            if key == "sysName":
                lines[i] = f"sysName \"{new_alias}\"\n"
                break

        with open(snmp_config_filepath, 'w') as file:
            file.writelines(lines)


from functools import wraps
from flask import session, Response

def login_required(f):
    @wraps(f)
    def decorated_function(*args, **kwargs):
        # log.debug("Session Key: {}".format(getSessionKey()))
        # log.debug("Session: {}".format(session))
        uciCli = Uci()
        login_uci = uciCli.get('httpd', 'webserver', 'password_set')
        if login_uci == 'true':
            if 'sessionID' not in session or session['sessionID'] != getSessionKey():
                return Response("Login required", status=INVALID_LOGIN, headers={"Content-Type": "text/plain"})
            #elif session['sessionID'] != common.SESSION_KEY:
            #    return Response("Session expired", status=INVALID_LOGIN, headers={"Content-Type" : "text/plain"})
            else:
                return f(*args, **kwargs)
        else:
            return f(*args, **kwargs)
    return decorated_function
