(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["main"],{

/***/ "+u1T":
/*!*************************************************************!*\
  !*** ./src/app/services/additional.certificates.service.ts ***!
  \*************************************************************/
/*! exports provided: AdditionalCertificatesService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AdditionalCertificatesService", function() { return AdditionalCertificatesService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../environments/environment */ "AytR");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "kU1M");







const CERTIFICATES_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].certificatesEndpoint;
class AdditionalCertificatesService {
    constructor(httpClient) {
        this.httpClient = httpClient;
        this.httpOptions = {
            observe: 'response'
        };
    }
    upload(file) {
        //console.log(file);
        // Create form data
        let formData = new FormData();
        formData.append('certificate', file, file.name);
        //console.log(formData.getAll('certificate'));
        // Make http post request over api
        // with formData as req
        return this.httpClient.post(CERTIFICATES_ENDPOINT, formData, this.httpOptions).pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    get() {
        //console.log('CERTIFICATES_ENDPOINT get', CERTIFICATES_ENDPOINT);
        return this.httpClient.get(CERTIFICATES_ENDPOINT, this.httpOptions).pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    delete(certificateList) {
        //console.log('CERTIFICATES_ENDPOINT delete', CERTIFICATES_ENDPOINT);
        let options = {
            headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_3__["HttpHeaders"]({
                'Content-Type': 'application/json'
            }),
            responseType: 'text',
            observe: 'response',
            body: {
                'payload': certificateList
            }
        };
        return this.httpClient.delete(CERTIFICATES_ENDPOINT, options).pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    handleError(error) {
        if (error.error instanceof ErrorEvent) {
            // A client-side or network error occurred. Handle it accordingly.
            console.error('An error occurred:', error.error.message);
        }
        else {
            // The backend returned an unsuccessful response code.
            // The response body may contain clues as to what went wrong.
            console.error(`Backend returned code ${error.status}, ` +
                `body was: ${error.error}`);
        }
        // Return an observable with a user-facing error message.
        //return throwError('Something bad happened; please try again later.');
        return Object(rxjs__WEBPACK_IMPORTED_MODULE_1__["of"])(error); //returns HttpErrorResponse with status 0
    }
}
AdditionalCertificatesService.ɵfac = function AdditionalCertificatesService_Factory(t) { return new (t || AdditionalCertificatesService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_3__["HttpClient"])); };
AdditionalCertificatesService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: AdditionalCertificatesService, factory: AdditionalCertificatesService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](AdditionalCertificatesService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_3__["HttpClient"] }]; }, null); })();


/***/ }),

/***/ "/jIo":
/*!****************************************************************!*\
  !*** ./src/app/firmware-updater/firmware-updater.component.ts ***!
  \****************************************************************/
/*! exports provided: FirmwareUpdaterComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FirmwareUpdaterComponent", function() { return FirmwareUpdaterComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var _services_firmware_upload_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../services/firmware-upload.service */ "H95c");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _services_system_functions_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/system-functions.service */ "8K7A");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _angular_material_progress_bar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/progress-bar */ "bv9b");










function FirmwareUpdaterComponent_div_8_Template(rf, ctx) { if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "hr", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "input", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function FirmwareUpdaterComponent_div_8_Template_input_change_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5); const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r4.onChange($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function FirmwareUpdaterComponent_div_8_Template_button_click_5_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r6.onUpload(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](6, "Upload");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "hr", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r0.invalid);
} }
const _c0 = function (a0) { return { "color": a0 }; };
function FirmwareUpdaterComponent_div_9_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "p", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const messageObj_r8 = ctx.$implicit;
    const i_r9 = ctx.index;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c0, i_r9 === ctx_r7.progressMessagesStatus.length - 1 ? messageObj_r8[1] : "#aca8a8"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](messageObj_r8[0]);
} }
function FirmwareUpdaterComponent_div_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, FirmwareUpdaterComponent_div_9_div_1_Template, 3, 4, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r1.progressMessagesStatus);
} }
function FirmwareUpdaterComponent_div_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "mat-progress-bar", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx_r2.progress);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("", ctx_r2.progress, "%");
} }
function FirmwareUpdaterComponent_div_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "mat-progress-bar", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("mode", ctx_r3.mode);
} }
class FirmwareUpdaterComponent {
    constructor(fileUploadService, httpResponseHandler, toastrService, systemFuncsService) {
        this.fileUploadService = fileUploadService;
        this.httpResponseHandler = httpResponseHandler;
        this.toastrService = toastrService;
        this.systemFuncsService = systemFuncsService;
        this.fileExtensionsAllowed = [];
        this.invalid = true;
        this.progress = 0;
        this.mode = "indeterminate";
        //showUpdateFinished: boolean;
        this.progressMessagesStatus = [];
        this.successColor = '#333333';
        this.errorColor = 'red';
    }
    ngOnInit() {
        //console.log(this.fileExtensionsAllowed);
        for (let i = 0; i < this.fileExtensionsAllowed.length; i++) {
            this.fileExtensionsAllowed[i] = this.fileExtensionsAllowed[i].toLowerCase().replace('.', '');
        }
        //console.log(this.fileExtensionsAllowed);
        this.showUploadSection = true;
        this.showProgressSection = false;
        this.showFileUploadProgressBar = false;
        this.showProgressBar = false;
        //this.showUpdateFinished = false;
        this.homePageURL = window.location.protocol + "//" + window.location.hostname; //+ ":80"
    }
    onChange(event) {
        this.invalid = true;
        // check if file is valid
        this.file = event.target.files[0];
        if (this.file) {
            // check if file extension is valid
            let fileExtension = this.file.name.split('.').pop();
            if (!this.fileExtensionsAllowed.includes(fileExtension.toLowerCase())) {
                this.invalid = true;
                //this.toastr.show("Format \"." + fileExtension + "\" not supported!", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-warning'});
                this.toastrService.showWarningMessage("Format \"." + fileExtension + "\" not supported!");
            }
            else {
                this.invalid = false;
            }
            if (!this.invalid) {
                // check if file size is allowed
                //console.log(this.file.size);
                if (this.file.size > this.max_file_size) {
                    this.invalid = true;
                    //this.toastr.show("File is too large!", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-warning'});
                    this.toastrService.showWarningMessage("File is too large!");
                }
                else {
                    this.invalid = false;
                }
            }
        }
    }
    onUpload() {
        if (!this.invalid) {
            //console.log(this.file);
            this.error = false;
            this.showProgressBar = true;
            this.fileUploadService.getUpdateStatus().subscribe(res => {
                switch (res.status) {
                    case 200:
                        if (res.body === "finished" || res.body === "error") {
                            this.showProgressBar = false;
                            this.progressMessagesStatus.push(['Uploading firmware update file...', this.successColor]);
                            //hide upload file section and show file upload progress bar
                            this.showUploadSection = false;
                            this.showFileUploadProgressBar = true;
                            this.showProgressSection = true;
                            this.fileUploadService.upload(this.file).subscribe(res => {
                                //console.log(res);
                                if (res.type === _angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpEventType"].UploadProgress) {
                                    this.progress = Math.round(100 * res.loaded / res.total);
                                    //console.log("Progress:", this.progress);
                                    if (this.progress === 100) {
                                        setTimeout(() => {
                                            this.showFileUploadProgressBar = false;
                                            if (!this.error)
                                                this.showProgressBar = true;
                                        }, 1000);
                                    }
                                }
                                else if (res instanceof _angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpResponse"]) {
                                    //console.log("Status:", res.status);
                                    switch (res.status) {
                                        case 200:
                                            //this.showFileUploadProgressBar = false;
                                            this.showProgressBar = false;
                                            this.progressMessagesStatus.push(['Firmware update file uploaded with success.', this.successColor]);
                                            setTimeout(() => {
                                                //this.showProgressBar = true;
                                                this.progressMessagesStatus.push(['Installing firmware update...', this.successColor]);
                                                this.showProgressBar = true;
                                                this.checkUpdateStatus();
                                            }, 800);
                                            break;
                                        default:
                                            console.log("Unexpected return code: ", res.status);
                                            //this.httpResponseHandler.handleUnexpectedHttpErrorResponse(res.status);
                                            break;
                                    }
                                }
                                else if (res instanceof _angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpErrorResponse"]) {
                                    console.log("HTTP Error Response");
                                    console.log(res);
                                }
                            }, err => {
                                console.log("Error");
                                console.log(err);
                                this.error = true;
                                //this.progress = 0;
                                /*if (err.error && err.error.message) {
                                  console.log(err.error.message);
                                } else {
                                  console.log('Could not upload the file!');
                                }*/
                                this.progressMessagesStatus.push(['Error uploading file. ', this.errorColor]);
                                this.showFileUploadProgressBar = false;
                                this.showProgressBar = false;
                                if (err.status === 413 || err.statusText === "REQUEST ENTITY TOO LARGE") {
                                    //this.toastr.show("File is too large!", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-warning'});
                                    this.toastrService.showWarningMessage("File is too large!");
                                }
                                else if (err.status === 409 || err.statusText === "CONFLICT") {
                                    //this.toastr.show("There is an update already running.", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                                    this.toastrService.showErrorMessage("There is an update already running.");
                                }
                                else if (err.error === "No file") {
                                    //this.toastr.show("No file provided", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                                    this.toastrService.showErrorMessage("No file provided.");
                                }
                            });
                        }
                        else {
                            this.error = true;
                            this.progressMessagesStatus.push(['Error uploading file. ', this.errorColor]);
                            this.showProgressBar = false;
                            //this.toastr.show("There is an update already running.", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                            this.toastrService.showErrorMessage("There is an update already running.");
                        }
                        break;
                    case 401:
                        this.httpResponseHandler.handle401HttpErrorResponse(res.error);
                        break;
                    case 500:
                        this.httpResponseHandler.handle500HttpErrorResponse();
                        break;
                    default:
                        console.log("Unexpected return code: ", res.status);
                        this.httpResponseHandler.handleUnexpectedHttpErrorResponse(res.status);
                        break;
                }
            });
        }
    }
    checkUpdateStatus() {
        this.fileUploadService.getUpdateStatus().subscribe(status => {
            if (status.status === 200) {
                //console.log(status.body);
                if (status.body === "rebooting") {
                    this.showProgressBar = false;
                    this.progressMessagesStatus.push(['Update complete!', this.successColor]);
                    setTimeout(() => {
                        this.showProgressBar = true;
                        //this.progressMessagesStatus.push(['Device is rebooting. When finished, you can return to the home page or reload this page.', this.successColor]);
                        this.progressMessagesStatus.push(['Please wait while the device is rebooting. The page will be automatically reloaded.', this.successColor]);
                        setTimeout(() => this.reloadWebUI(), 10000);
                    }, 1000);
                }
                else if (status.body === "error") {
                    //console.log("Stop checking for status");
                    this.showProgressBar = false;
                    this.showFileUploadProgressBar = false;
                    this.progressMessagesStatus.push(['An error occurred during the installation.', this.errorColor]);
                }
                else if (status.body === "finished") {
                    //missed reboot
                    this.showProgressBar = false;
                    this.progressMessagesStatus.push(['Update complete!', this.successColor]);
                    setTimeout(() => {
                        this.reloadWebUI();
                    }, 1000);
                }
                else { //installing
                    setTimeout(() => {
                        this.checkUpdateStatus();
                    }, 3000);
                }
            }
            else if (status.status === 401) {
                this.httpResponseHandler.handle401HttpErrorResponse(status.error);
            }
            else {
                setTimeout(() => {
                    this.checkUpdateStatus();
                }, 1000);
            }
        });
    }
    reloadWebUI() {
        this.systemFuncsService.appIsRunning().subscribe(res => {
            //console.log(res);
            if (res.status === 200) {
                window.location.href = window.location.protocol + '//' + window.location.hostname;
            }
            else {
                setTimeout(() => this.reloadWebUI(), 1000);
            }
        });
    }
}
FirmwareUpdaterComponent.ɵfac = function FirmwareUpdaterComponent_Factory(t) { return new (t || FirmwareUpdaterComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_firmware_upload_service__WEBPACK_IMPORTED_MODULE_2__["FirmwareUploadService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_toastr_message_service__WEBPACK_IMPORTED_MODULE_4__["ToastrMessageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_functions_service__WEBPACK_IMPORTED_MODULE_5__["SystemFunctionsService"])); };
FirmwareUpdaterComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: FirmwareUpdaterComponent, selectors: [["app-firmware-updater"]], inputs: { fileExtensionsAllowed: "fileExtensionsAllowed", max_file_size: "max_file_size" }, decls: 12, vars: 4, consts: [[1, "alignCenter", 2, "font-weight", "500", "font-size", "12px"], ["src", "../assets/images/warning.png"], [2, "font-size", "12px", "font-weight", "500"], [4, "ngIf"], ["class", "progressMsgs", 4, "ngIf"], ["style", "margin: 8px;", 4, "ngIf"], ["style", "margin: 7px;", 4, "ngIf"], [2, "margin-top", "20px", "margin-left", "0"], [2, "display", "flex", "flex-direction", "row"], ["type", "file", "accept", ".tar", 2, "min-width", "400px", 3, "change"], [2, "display", "flex", "justify-content", "end"], ["title", "Upload firmware image", 1, "alignRight", 3, "disabled", "click"], [1, "progressMsgs"], [4, "ngFor", "ngForOf"], [3, "ngStyle"], [2, "margin", "8px"], [3, "value"], [1, "progress-bar-label"], [2, "margin", "7px"], [1, "example-margin", 3, "mode"]], template: function FirmwareUpdaterComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "img", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](2, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "WARNING ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Please read the instructions before updating.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, FirmwareUpdaterComponent_div_8_Template, 8, 1, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, FirmwareUpdaterComponent_div_9_Template, 2, 1, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, FirmwareUpdaterComponent_div_10_Template, 4, 2, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](11, FirmwareUpdaterComponent_div_11_Template, 2, 1, "div", 6);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showUploadSection);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showProgressSection);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showFileUploadProgressBar);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showProgressBar);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_6__["NgIf"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgStyle"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_7__["DefaultStyleDirective"], _angular_material_progress_bar__WEBPACK_IMPORTED_MODULE_8__["MatProgressBar"]], styles: [".alignRight[_ngcontent-%COMP%] {\n    margin-left: auto;\n    margin-right: 0;\n}\n\n.progress-bar-label[_ngcontent-%COMP%] {\n    \n    left: 50%;\n    position: relative;\n    color: #333333;\n    line-height: 17px;\n    font-size: 14px;\n    font-weight: 600;\n    font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n}\n\n.progressMsgs[_ngcontent-%COMP%] {\n    white-space: pre-line;\n    font-size: 15px;\n    \n    font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n    margin-top: 20px;\n}\n\n.successMsg[_ngcontent-%COMP%] {\n    text-align: center;\n    font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n    font-size: 16px;\n}\n\n\n\n  .mat-progress-bar-fill:after {\n    \n    background-color: #71a0d4 !important;\n}\n\n\n\n  .mat-progress-bar {\n    height: 9px !important;\n}\n\n  .mat-progress-bar-buffer {\n    background-color: #d4d8dd;\n}\n\n\n\nprogress[_ngcontent-%COMP%]{\n    vertical-align:baseline\n}\n\n@-webkit-keyframes progress-bar-stripes{\n    from{\n        background-position:1rem 0\n    }\n    to{\n        background-position:0 0\n    }\n}\n\n@keyframes progress-bar-stripes{\n    from{\n        background-position:1rem 0\n    }\n    to{\n        background-position:0 0\n    }\n}\n\n.progress[_ngcontent-%COMP%]{\n    display:flex;\n    height:1rem;\n    overflow:hidden;\n    font-size:.75rem;\n    background-color: #d4d8dd;\n    border-radius:.25rem;\n    position: relative;\n}\n\n.progress-bar[_ngcontent-%COMP%]{\n    display:flex;\n    flex-direction:column;\n    justify-content:center;\n    color:#fff;\n    text-align:center;\n    background-color:#007bff;\n    transition:width .6s ease\n}\n\n.progress-bar-striped[_ngcontent-%COMP%]{\n    background-image:linear-gradient(45deg,rgba(255,255,255,.15) 25%,transparent 25%,transparent 50%,rgba(255,255,255,.15) 50%,rgba(255,255,255,.15) 75%,transparent 75%,transparent);\n    background-size:1rem 1rem\n}\n\n.progress-bar-animated[_ngcontent-%COMP%]{\n    -webkit-animation:progress-bar-stripes 1s linear infinite;\n    animation:progress-bar-stripes 1s linear infinite\n}\n/*# sourceMappingURL=data:application/json;base64,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 */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FirmwareUpdaterComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-firmware-updater',
                templateUrl: './firmware-updater.component.html',
                styleUrls: ['./firmware-updater.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_firmware_upload_service__WEBPACK_IMPORTED_MODULE_2__["FirmwareUploadService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"] }, { type: _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_4__["ToastrMessageService"] }, { type: _services_system_functions_service__WEBPACK_IMPORTED_MODULE_5__["SystemFunctionsService"] }]; }, { fileExtensionsAllowed: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Input"]
        }], max_file_size: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Input"]
        }] }); })();


/***/ }),

/***/ "/q1Y":
/*!*************************************!*\
  !*** ./src/app/validators/utils.ts ***!
  \*************************************/
/*! exports provided: INT_NUMBER_REGEX, HOST_REGEX */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "INT_NUMBER_REGEX", function() { return INT_NUMBER_REGEX; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HOST_REGEX", function() { return HOST_REGEX; });
const INT_NUMBER_REGEX = "^-?\\d+$";
const HOST_REGEX = "(^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$)|(^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]).)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9-]*[A-Za-z0-9])$)";


/***/ }),

/***/ 0:
/*!***************************!*\
  !*** multi ./src/main.ts ***!
  \***************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /home/ana/Barix/audio-enhancement/ae-epic-sip/web-ui/frontend/src/main.ts */"zUnb");


/***/ }),

/***/ "0BQl":
/*!**********************************************************!*\
  !*** ./src/app/system-status/system-status.component.ts ***!
  \**********************************************************/
/*! exports provided: SystemStatusComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SystemStatusComponent", function() { return SystemStatusComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/material/dialog */ "0IaG");
/* harmony import */ var _open_source_licenses_open_source_licenses_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../open-source-licenses/open-source-licenses.component */ "S1LR");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/system-info.service */ "4e9C");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var ngx_toastr__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ngx-toastr */ "5eHb");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_material_expansion__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/expansion */ "7EHt");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _device_license_device_license_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../device-license/device-license.component */ "bnPd");
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/table */ "+0xr");
/* harmony import */ var _angular_material_progress_bar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/progress-bar */ "bv9b");
















function SystemStatusComponent_div_5_div_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_ng_template_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_41_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_ng_template_42_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
const _c0 = function (a0) { return { "font-style": a0 }; };
function SystemStatusComponent_div_5_div_77_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const dns_server_r21 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c0, dns_server_r21.style));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](dns_server_r21.value);
} }
function SystemStatusComponent_div_5_div_83_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_ng_template_84_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_103_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_ng_template_104_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_107_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "app-device-license", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const lic_r22 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("license", lic_r22);
} }
function SystemStatusComponent_div_5_div_113_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_ng_template_114_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_117_th_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " Type ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_117_td_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const device_r39 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", device_r39.type, " ");
} }
function SystemStatusComponent_div_5_div_117_th_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " Usage ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_117_td_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "mat-progress-bar", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const device_r40 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("value", device_r40.use);
} }
function SystemStatusComponent_div_5_div_117_th_9_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " Size ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_117_td_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const device_r41 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", device_r41.size, " ");
} }
function SystemStatusComponent_div_5_div_117_th_12_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " Used ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_117_td_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const device_r42 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", device_r42.used, " ");
} }
function SystemStatusComponent_div_5_div_117_th_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " Avail. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_117_td_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const device_r43 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", device_r43.available, " ");
} }
function SystemStatusComponent_div_5_div_117_th_18_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " F. Sys ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_117_td_19_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const device_r44 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", device_r44.fsType, " ");
} }
function SystemStatusComponent_div_5_div_117_th_21_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " Status ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_div_117_td_22_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const device_r45 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", device_r45.mountAs === "rw" ? "read-write" : "read-only", " ");
} }
function SystemStatusComponent_div_5_div_117_tr_23_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "tr", 44);
} }
function SystemStatusComponent_div_5_div_117_tr_24_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "tr", 45);
} }
function SystemStatusComponent_div_5_div_117_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "table", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](2, 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, SystemStatusComponent_div_5_div_117_th_3_Template, 2, 0, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, SystemStatusComponent_div_5_div_117_td_4_Template, 2, 1, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](5, 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](6, SystemStatusComponent_div_5_div_117_th_6_Template, 2, 0, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](7, SystemStatusComponent_div_5_div_117_td_7_Template, 2, 1, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](8, 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, SystemStatusComponent_div_5_div_117_th_9_Template, 2, 0, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, SystemStatusComponent_div_5_div_117_td_10_Template, 2, 1, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](11, 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](12, SystemStatusComponent_div_5_div_117_th_12_Template, 2, 0, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, SystemStatusComponent_div_5_div_117_td_13_Template, 2, 1, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](14, 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](15, SystemStatusComponent_div_5_div_117_th_15_Template, 2, 0, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](16, SystemStatusComponent_div_5_div_117_td_16_Template, 2, 1, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](17, 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](18, SystemStatusComponent_div_5_div_117_th_18_Template, 2, 0, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](19, SystemStatusComponent_div_5_div_117_td_19_Template, 2, 1, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](20, 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](21, SystemStatusComponent_div_5_div_117_th_21_Template, 2, 0, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](22, SystemStatusComponent_div_5_div_117_td_22_Template, 2, 1, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](23, SystemStatusComponent_div_5_div_117_tr_23_Template, 1, 0, "tr", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](24, SystemStatusComponent_div_5_div_117_tr_24_Template, 1, 0, "tr", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("dataSource", ctx_r18.massStorageDevs);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matHeaderRowDef", ctx_r18.massStorageDevsTableColums);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matRowDefColumns", ctx_r18.massStorageDevsTableColums);
} }
function SystemStatusComponent_div_5_ng_template_118_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "p", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "no mass storage devices detected");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SystemStatusComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    const _r48 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-accordion", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "mat-expansion-panel", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SystemStatusComponent_div_5_Template_mat_expansion_panel_opened_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r47 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r47.DevInfoPanelOpenState = true; })("closed", function SystemStatusComponent_div_5_Template_mat_expansion_panel_closed_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r49 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r49.DevInfoPanelOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](6, SystemStatusComponent_div_5_div_6_Template, 3, 0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](7, SystemStatusComponent_div_5_ng_template_7_Template, 2, 0, "ng-template", null, 8, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, " Device Information ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "table", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13, "Hardware type");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18, "IPAM Type");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](23, "MAC address");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28, "Linux kernel version");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33, "Bootloader version");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](34, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](36, "mat-accordion", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](37, "mat-expansion-panel", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SystemStatusComponent_div_5_Template_mat_expansion_panel_opened_37_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r50 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r50.NetworkPanelOpenState = true; })("closed", function SystemStatusComponent_div_5_Template_mat_expansion_panel_closed_37_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r51 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r51.NetworkPanelOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](38, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](39, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](40, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](41, SystemStatusComponent_div_5_div_41_Template, 3, 0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](42, SystemStatusComponent_div_5_ng_template_42_Template, 2, 0, "ng-template", null, 12, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](44, " Network ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](45, "table", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](46, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](47, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](48, "h4");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](49, "Wired Connection");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](50, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](51, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](52, "table", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](53, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](54, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](55, "Status");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](56, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](57);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](58, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](59, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](60, "IP address");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](61, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](62);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](63, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](64, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](65, "Netmask");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](66, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](67);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](68, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](69, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](70, "Default gateway");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](71, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](72);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](73, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](74, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](75, "DNS Servers");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](76, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](77, SystemStatusComponent_div_5_div_77_Template, 3, 4, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](78, "mat-accordion", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](79, "mat-expansion-panel", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SystemStatusComponent_div_5_Template_mat_expansion_panel_opened_79_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r52 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r52.SystemPanelOpenState = true; })("closed", function SystemStatusComponent_div_5_Template_mat_expansion_panel_closed_79_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r53 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r53.SystemPanelOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](80, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](81, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](82, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](83, SystemStatusComponent_div_5_div_83_Template, 3, 0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](84, SystemStatusComponent_div_5_ng_template_84_Template, 2, 0, "ng-template", null, 19, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](86, " System ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](87, "table", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](88, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](89, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](90, "System time (refresh)");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](91, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](92);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](93, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](94, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](95, "Uptime");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](96, "td", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](97);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](98, "mat-accordion", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](99, "mat-expansion-panel", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SystemStatusComponent_div_5_Template_mat_expansion_panel_opened_99_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r54 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r54.LicensesPanelOpenState = true; })("closed", function SystemStatusComponent_div_5_Template_mat_expansion_panel_closed_99_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r55 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r55.LicensesPanelOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](100, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](101, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](102, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](103, SystemStatusComponent_div_5_div_103_Template, 3, 0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](104, SystemStatusComponent_div_5_ng_template_104_Template, 2, 0, "ng-template", null, 20, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](106, " Licenses ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](107, SystemStatusComponent_div_5_div_107_Template, 2, 1, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](108, "mat-accordion", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](109, "mat-expansion-panel", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SystemStatusComponent_div_5_Template_mat_expansion_panel_opened_109_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r56 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r56.StorageDevPanelOpenState = true; })("closed", function SystemStatusComponent_div_5_Template_mat_expansion_panel_closed_109_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r57 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r57.StorageDevPanelOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](110, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](111, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](112, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](113, SystemStatusComponent_div_5_div_113_Template, 3, 0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](114, SystemStatusComponent_div_5_ng_template_114_Template, 2, 0, "ng-template", null, 22, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](116, " Mass storage devices ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](117, SystemStatusComponent_div_5_div_117_Template, 25, 3, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](118, SystemStatusComponent_div_5_ng_template_118_Template, 2, 0, "ng-template", null, 23, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](120, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](121, "button", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SystemStatusComponent_div_5_Template_button_click_121_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r48); const ctx_r58 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r58.showOpenSourceLibsLicenses(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](122, " Open Source Licenses ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](8);
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](43);
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](85);
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](105);
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](115);
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](119);
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("expanded", ctx_r0.DevInfoPanelOpenState);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.DevInfoPanelOpenState)("ngIfElse", _r2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate2"](" ", ctx_r0.device_type, " (", ctx_r0.device_type_ID, ") ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate2"](" ", ctx_r0.IPAM_type, " (", ctx_r0.IPAM_type_ID, ") ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r0.mac_addr, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r0.kernel_ver, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r0.boot_ver, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("expanded", ctx_r0.NetworkPanelOpenState);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.NetworkPanelOpenState)("ngIfElse", _r5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.connection_status);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.ip_addr);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.netmask);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r0.default_gateway, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r0.DNS_servers);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.SystemPanelOpenState)("ngIfElse", _r9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r0.sys_time, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r0.uptime, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.LicensesPanelOpenState)("ngIfElse", _r12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r0.licenses);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.StorageDevPanelOpenState)("ngIfElse", _r16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.massStorageDevs.length > 0)("ngIfElse", _r19);
} }
class SystemStatusComponent {
    constructor(systemInfoService, configsService, router, toastr, httpResponseHandler, matDialog) {
        this.systemInfoService = systemInfoService;
        this.configsService = configsService;
        this.router = router;
        this.toastr = toastr;
        this.httpResponseHandler = httpResponseHandler;
        this.matDialog = matDialog;
        this.loadFinished = false;
        this.DevInfoPanelOpenState = false;
        this.NetworkPanelOpenState = false;
        this.SystemPanelOpenState = false;
        this.LicensesPanelOpenState = false;
        this.StorageDevPanelOpenState = false;
        this.device_type = "";
        this.device_type_ID = "";
        this.IPAM_type = "";
        this.IPAM_type_ID = "";
        this.kernel_ver = "";
        this.boot_ver = "";
        this.connection_status = "";
        this.mac_addr = "";
        this.ip_addr = "";
        this.netmask = "";
        this.default_gateway = "";
        this.DNS_servers = [];
        this.app = "";
        this.uptime = "";
        this.licenses = [];
        this.massStorageDevs = [];
        this.massStorageDevsTableColums = ["type", "usage", "size", "used", "available", "fsType", "mountAs"];
        this.open_source_licenses = [];
        this.settingsList = ["device_type", "device_type_ID", "IPAM_type", "IPAM_type_ID", "mac_addr", "conn_status", "ip_addr", "netmask", "default_gateway", "DSN_servers", "kernelVer", "bootloaderVer", "sys_time", "uptime", "license", "massStorageDev", "open_source_licenses"];
    }
    ngOnInit() {
        this.systemInfoService.getSystemInfo(this.settingsList).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    this.device_type = data.body["device_type"];
                    this.device_type_ID = data.body["device_type_ID"];
                    this.IPAM_type = data.body["IPAM_type"];
                    this.IPAM_type_ID = data.body["IPAM_type_ID"];
                    this.mac_addr = data.body["mac_addr"];
                    this.kernel_ver = data.body["kernelVer"];
                    this.boot_ver = data.body["bootloaderVer"];
                    if (data.body["conn_status"] === "up") {
                        this.connection_status = "Connected";
                    }
                    else {
                        this.connection_status = "Disconnected";
                    }
                    this.ip_addr = data.body["ip_addr"];
                    this.netmask = data.body["netmask"];
                    this.default_gateway = data.body["default_gateway"];
                    if (typeof (data.body["DSN_servers"]) === "string") {
                        this.DNS_servers.push({ 'value': data.body["DSN_servers"], 'style': 'normal' });
                    }
                    else {
                        let dns_servers_list = data.body["DSN_servers"];
                        if (dns_servers_list.length === 2) {
                            this.DNS_servers.push({ 'value': dns_servers_list[0], 'style': 'normal' });
                            this.DNS_servers.push({ 'value': dns_servers_list[1], 'style': 'normal' });
                        }
                        else if (dns_servers_list.length === 1) {
                            this.DNS_servers.push({ 'value': dns_servers_list[0], 'style': 'normal' });
                            this.DNS_servers.push({ 'value': "Not configured", 'style': 'italic' });
                        }
                        else {
                            this.DNS_servers.push({ 'value': "Not configured", 'style': 'italic' });
                            this.DNS_servers.push({ 'value': "Not configured", 'style': 'italic' });
                        }
                    }
                    //this.sys_time = (data.body["sys_time"]*1000);
                    let sys_dateTime = new Date(data.body["sys_time"] * 1000);
                    let daysOfWeek = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
                    let monthsOfYear = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                    this.sys_time = daysOfWeek[sys_dateTime.getUTCDay()] + " " + monthsOfYear[sys_dateTime.getUTCMonth()] + " " + sys_dateTime.getUTCDate() + " " + sys_dateTime.getUTCHours().toString().padStart(2, '0') + ":" + sys_dateTime.getUTCMinutes().toString().padStart(2, '0') + ":" + sys_dateTime.getUTCSeconds().toString().padStart(2, '0') + " UTC " + sys_dateTime.getUTCFullYear();
                    this.uptime = this.calculateTimeDiff(data.body["uptime"], data.body["sys_time"]);
                    if (data.body['licenses'] !== null) {
                        this.licenses = data.body['licenses'];
                    }
                    this.massStorageDevs = data.body["massStorageDev"];
                    this.open_source_licenses = data.body["open_source_licenses"].slice(1);
                    this.loadFinished = true;
                    //open first panel by default
                    setTimeout(() => {
                        this.DevInfoPanelOpenState = true;
                    }, 500);
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500: //INTERNAL_SERVER_ERROR
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    this.loadFinished = true;
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    this.loadFinished = true;
                    break;
            }
        });
    }
    calculateTimeDiff(pyTimestamp, sys_dateTime) {
        //console.log(pyTimestamp);
        //console.log(new Date(sys_dateTime).getTime());
        let timediff = new Date(sys_dateTime).getTime() - pyTimestamp; //javascript timestamp is in miliseconds
        //let timediff = Math.floor(new Date().getTime()/1000) - pyTimestamp; //javascript timestamp is in miliseconds
        let tMins = Math.floor(timediff / 60);
        let nSecs = (timediff % 60);
        let tHours = Math.floor(tMins / 60);
        let nMins = (tMins % 60);
        let nDays = Math.floor(tHours / 24);
        let nHours = (tHours % 24);
        return nDays + " days, " + nHours + " hours, " + nMins + " minutes, " + nSecs + " seconds";
    }
    showOpenSourceLibsLicenses() {
        const dialogConfig = new _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialogConfig"]();
        dialogConfig.height = "88%";
        dialogConfig.data = this.open_source_licenses;
        this.matDialog.open(_open_source_licenses_open_source_licenses_component__WEBPACK_IMPORTED_MODULE_2__["OpenSourceLicensesComponent"], dialogConfig);
    }
}
SystemStatusComponent.ɵfac = function SystemStatusComponent_Factory(t) { return new (t || SystemStatusComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_3__["SystemInfoService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_4__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_5__["Router"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](ngx_toastr__WEBPACK_IMPORTED_MODULE_6__["ToastrService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_7__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialog"])); };
SystemStatusComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: SystemStatusComponent, selectors: [["app-system-status"]], decls: 6, vars: 1, consts: [["href", "https://fonts.googleapis.com/icon?family=Material+Icons", "rel", "stylesheet"], [1, "container"], [1, "tab-content"], [4, "ngIf"], [2, "width", "550px"], ["hideToggle", "", 1, "config-card", "mat-elevation-z0", 3, "expanded", "opened", "closed"], [1, "visual"], [4, "ngIf", "ngIfElse"], ["devInfoClosedPanel", ""], [1, "t1"], [1, "label"], [1, "value"], ["devNetworkClosedPanel", ""], ["colspan", "2", 1, "label"], ["colspan", "2"], [1, "section3"], [1, "label", 2, "vertical-align", "top"], [3, "ngStyle", 4, "ngFor", "ngForOf"], ["hideToggle", "", 1, "config-card", "mat-elevation-z0", 3, "opened", "closed"], ["systemClosedPanel", ""], ["licClosedPanel", ""], [4, "ngFor", "ngForOf"], ["storageDevClosedPanel", ""], ["noStorageDev", ""], [1, "open-source-licenses-widget"], ["type", "button", 1, "hyperlinkBtn", 3, "click"], [3, "ngStyle"], [1, "badge"], [3, "license"], ["mat-table", "", "id", "massStorageDevsTable", 3, "dataSource"], ["matColumnDef", "type"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "usage"], ["matColumnDef", "size"], ["matColumnDef", "used"], ["matColumnDef", "available"], ["matColumnDef", "fsType"], ["matColumnDef", "mountAs"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], ["mat-header-cell", ""], ["mat-cell", ""], ["mode", "determinate", 3, "value"], ["mat-header-row", ""], ["mat-row", ""], [2, "font-size", "15px", "font-weight", "normal", "font-family", "'SourceSansPro', Arial, Helvetica, sans-serif", "color", "#333333"]], template: function SystemStatusComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "link", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4, "System Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, SystemStatusComponent_div_5_Template, 123, 29, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.loadFinished);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_8__["NgIf"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_9__["MatAccordion"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_9__["MatExpansionPanel"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_9__["MatExpansionPanelHeader"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_9__["MatExpansionPanelTitle"], _angular_common__WEBPACK_IMPORTED_MODULE_8__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_8__["NgStyle"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_10__["DefaultStyleDirective"], _device_license_device_license_component__WEBPACK_IMPORTED_MODULE_11__["DeviceLicenseComponent"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatTable"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatColumnDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatHeaderCellDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatCellDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatHeaderRowDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatRowDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatHeaderCell"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatCell"], _angular_material_progress_bar__WEBPACK_IMPORTED_MODULE_13__["MatProgressBar"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatHeaderRow"], _angular_material_table__WEBPACK_IMPORTED_MODULE_12__["MatRow"]], styles: ["#massStorageDevsTable[_ngcontent-%COMP%]{\n  \n  margin-left: 8px;\n  background-color: #EEEEEE;\n\n  width: 100%;\n}\n\n  .mat-progress-bar-buffer {\n  background-color: rgb(0, 200, 0);\n}\n\n  .mat-progress-bar-fill::after {\n  background-color: #c80000;\n}\n\n.mat-progress-bar[_ngcontent-%COMP%] {\n  height: 12px;\n}\n\n.mat-header-row[_ngcontent-%COMP%] {\n  height: 30px;\n}\n\n.mat-row[_ngcontent-%COMP%] {\n  height: 30px;\n}\n\n.mat-header-cell[_ngcontent-%COMP%]{\n  background-color: #DDDDDD;\n\n  text-align: center;\n\n  border-right-width: 1px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n\n  \n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\n.mat-cell[_ngcontent-%COMP%] {\n  \n  text-align: center;\n}\n\n\n\n.mat-header-cell[_ngcontent-%COMP%]:last-of-type {\n  border-right-style: none;\n  padding-right: 0;\n}\n\n.mat-cell[_ngcontent-%COMP%]:last-of-type {\n  padding-right: 0;\n}\n\n.mat-header-cell[_ngcontent-%COMP%]:first-of-type {\n  padding-left: 0;\n}\n\n.mat-cell[_ngcontent-%COMP%]:first-of-type {\n  padding-left: 0;\n}\n\n.open-source-licenses-widget[_ngcontent-%COMP%] {\n  text-align: right;\n  width: 570px;\n}\n\n.hyperlinkBtn[_ngcontent-%COMP%] {\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  background-color: transparent;\n  border: none;\n  color: #417CAF;\n  text-decoration: none;\n  cursor: pointer;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](SystemStatusComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-system-status',
                templateUrl: './system-status.component.html',
                styleUrls: ['./system-status.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_3__["SystemInfoService"] }, { type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_4__["DeviceConfigService"] }, { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__["Router"] }, { type: ngx_toastr__WEBPACK_IMPORTED_MODULE_6__["ToastrService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_7__["HTTPResponseHandlerService"] }, { type: _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialog"] }]; }, null); })();


/***/ }),

/***/ "0mv3":
/*!***************************************************!*\
  !*** ./src/app/services/device-config.service.ts ***!
  \***************************************************/
/*! exports provided: DeviceConfigService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DeviceConfigService", function() { return DeviceConfigService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../environments/environment */ "AytR");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "kU1M");







const DEVICE_UCIS_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].deviceUcisEndpoint;
const FACTORY_DEFAULTS_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].resetFactoryDefaultsEndpoint;
const SETTINGS_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].settingsEndpoint;
const REMOTE_SOURCES_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].remoteSourcesEndpoint;
const VOLUME_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].volumeControlEndpoint;
class DeviceConfigService {
    constructor(httpClient) {
        this.httpClient = httpClient;
        this.httpOptions = {
            headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpHeaders"]({
                'Content-Type': 'application/json'
            }),
            observe: 'response'
        };
    }
    getUcis(ucisList) {
        let values = '';
        let isFirst = true;
        Object.keys(ucisList).forEach((key) => {
            //uciList.push(settingsList[key]);
            if (isFirst) {
                isFirst = false;
            }
            else {
                values += '&';
            }
            values += ucisList[key];
        });
        const url = DEVICE_UCIS_ENDPOINT + '?' + values;
        //console.log('REST UCI get "%s"', url);
        return this.httpClient.get(url, this.httpOptions).pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    setUcis(uciList) {
        const payload = {
            commit: true
        };
        if (uciList !== {}) {
            payload['options'] = uciList;
        }
        //console.log(JSON.stringify(payload));
        return this.httpClient.put(DEVICE_UCIS_ENDPOINT, JSON.stringify(payload), this.httpOptions)
            .pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    setSettings(uciList, passwords) {
        const payload = {
            commit: true
        };
        if (uciList !== {}) {
            payload['ucis'] = uciList;
        }
        if (passwords !== {}) {
            payload['pwdSettings'] = passwords;
        }
        //console.log(JSON.stringify(payload));
        return this.httpClient.put(SETTINGS_ENDPOINT, JSON.stringify(payload), this.httpOptions)
            .pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    resetFactoryDefaults() {
        //console.log('FACTORY_DEFAULTS_ENDPOINT get "%s"', FACTORY_DEFAULTS_ENDPOINT);
        return this.httpClient.get(FACTORY_DEFAULTS_ENDPOINT, { observe: 'response' })
            .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    setVolume(uciDict) {
        return this.httpClient.put(VOLUME_ENDPOINT, JSON.stringify(uciDict), this.httpOptions)
            .pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    handleError(error) {
        if (error.error instanceof ErrorEvent) {
            // A client-side or network error occurred. Handle it accordingly.
            console.error('An error occurred:', error.error.message);
        }
        else {
            // The backend returned an unsuccessful response code.
            // The response body may contain clues as to what went wrong.
            console.error(`Backend returned code ${error.status}, ` +
                `body was: ${error.error}`);
        }
        // Return an observable with a user-facing error message.
        //return throwError('Something bad happened; please try again later.');
        return Object(rxjs__WEBPACK_IMPORTED_MODULE_1__["of"])(error); //returns HttpErrorResponse with status 0
    }
}
DeviceConfigService.ɵfac = function DeviceConfigService_Factory(t) { return new (t || DeviceConfigService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"])); };
DeviceConfigService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: DeviceConfigService, factory: DeviceConfigService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](DeviceConfigService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"] }]; }, null); })();


/***/ }),

/***/ "2TRi":
/*!************************************************!*\
  !*** ./src/app/defaults/defaults.component.ts ***!
  \************************************************/
/*! exports provided: DefaultsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DefaultsComponent", function() { return DefaultsComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_system_functions_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/system-functions.service */ "8K7A");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ "ofXK");







function DefaultsComponent_div_2_div_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](2, "img", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "h3", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r1.waitingMessage);
} }
function DefaultsComponent_div_2_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "p", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Reverts all settings to factory defaults.");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](3, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function DefaultsComponent_div_2_div_6_Template_button_click_4_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r4); const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r3.resetFactoryDefaults(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Reset Factory Defaults");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", !ctx_r2.defaults_opt);
} }
function DefaultsComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "h2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Factory Defaults");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](3, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, DefaultsComponent_div_2_div_5_Template, 6, 1, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](6, DefaultsComponent_div_2_div_6_Template, 6, 1, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.rebooting);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r0.rebooting);
} }
class DefaultsComponent {
    constructor(configsService, toastrService, httpResponseHandler, systemFuncsService) {
        this.configsService = configsService;
        this.toastrService = toastrService;
        this.httpResponseHandler = httpResponseHandler;
        this.systemFuncsService = systemFuncsService;
        this.loadFinished = false;
        this.defaults_opt = false;
        this.complete = false;
    }
    ngOnInit() {
        this.configsService.getUcis({ 'defaults_opt': 'security.defaults.enabled' }).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    //build device form group
                    if (data.body["security.defaults.enabled"] === "true") {
                        this.defaults_opt = true;
                    }
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
            this.loadFinished = true;
        });
    }
    resetFactoryDefaults() {
        this.configsService.resetFactoryDefaults().subscribe(data => {
            //console.log("Status:", data.status);
            switch (data.status) {
                case 200:
                    this.complete = true;
                    this.toastrService.showSuccessMessage("Settings successfully reverted to factory defaults.");
                    this.waitingMessage = "Please wait while the device reboots. The page will be automatically reloaded.";
                    this.rebooting = true;
                    setTimeout(() => this.reloadWebUI(), 20000);
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    let error_msg = "It wasn't possible to reset configurations to Factory Defaults. Please try again or reboot your device if error persists.";
                    //this.toastr.show(error_msg, '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                    this.toastrService.showErrorMessage(error_msg);
                    break;
            }
        });
    }
    reloadWebUI() {
        this.systemFuncsService.appIsRunning().subscribe(res => {
            //console.log(res);
            if (res.status === 200) {
                window.location.href = window.location.protocol + '//' + window.location.hostname;
            }
            else {
                setTimeout(() => this.reloadWebUI(), 1000);
            }
        });
    }
}
DefaultsComponent.ɵfac = function DefaultsComponent_Factory(t) { return new (t || DefaultsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_1__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_toastr_message_service__WEBPACK_IMPORTED_MODULE_2__["ToastrMessageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_functions_service__WEBPACK_IMPORTED_MODULE_4__["SystemFunctionsService"])); };
DefaultsComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: DefaultsComponent, selectors: [["app-defaults"]], decls: 17, vars: 1, consts: [[1, "container"], [1, "tab-content"], [4, "ngIf"], [1, "tab-help"], [1, "section1"], ["id", "non_format", 1, "section1"], [1, "loading-ripple"], ["src", "assets/images/Ripple-1s-170px.gif"], [2, "white-space", "pre-line"], [2, "font-size", "15px", "font-weight", "normal", "font-family", "'SourceSansPro', Arial, Helvetica, sans-serif", "color", "#333333"], ["type", "submit", 1, "redBtn", "actionBtn", 3, "disabled", "click"]], template: function DefaultsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, DefaultsComponent_div_2_Template, 7, 2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Help");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Factory Defaults");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10, "Click on \"Reset Factory Defaults\" to revert all settings (except Network settings) to the factory defaults.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](12, "A local user can completely reset the device to factory defaults (Hardware Reset) including Network settings pressing the RESET button in the front plate of the device during approximately 10 seconds.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15, "NOTE:");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, " The feature is disabled if the \"Reset Factory Defaults\" function is disabled from the Security Settings page.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.loadFinished);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_5__["NgIf"]], styles: [".section1[_ngcontent-%COMP%]{\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvZGVmYXVsdHMvZGVmYXVsdHMuY29tcG9uZW50LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNFLFdBQVc7RUFDWCx5QkFBd0I7VUFBeEIsd0JBQXdCO0VBQ3hCLHVCQUFzQjtVQUF0QixzQkFBc0I7QUFDeEIiLCJmaWxlIjoic3JjL2FwcC9kZWZhdWx0cy9kZWZhdWx0cy5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLnNlY3Rpb24xe1xuICBtYXJnaW46IDhweDtcbiAgbWFyZ2luLWlubGluZS1zdGFydDogOHB4O1xuICBtYXJnaW4taW5saW5lLWVuZDogOHB4O1xufVxuIl19 */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](DefaultsComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-defaults',
                templateUrl: './defaults.component.html',
                styleUrls: ['./defaults.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_1__["DeviceConfigService"] }, { type: _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_2__["ToastrMessageService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"] }, { type: _services_system_functions_service__WEBPACK_IMPORTED_MODULE_4__["SystemFunctionsService"] }]; }, null); })();


/***/ }),

/***/ "4e9C":
/*!*************************************************!*\
  !*** ./src/app/services/system-info.service.ts ***!
  \*************************************************/
/*! exports provided: SystemInfoService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SystemInfoService", function() { return SystemInfoService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../environments/environment */ "AytR");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ "kU1M");







const HEADER_SYS_INFO_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].headerSysInfoEndpoint;
const FW_INFO_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].fwInfoEndpoint;
const SYS_STATUS_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].systemStatusEndpoint;
const SYS_LOG_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].systemLogEndpoint;
const DOWNLOAD_LOGS_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].downloadLogsEndpoint;
const SYS_INFO_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].systemInfoEndpoint;
const SYS_TYPE_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].systemTypeEndpoint;
const APP_STATUS_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].appStatusEndpoint;
/* AES67 specific status */
class SystemInfoService {
    constructor(httpClient) {
        this.httpClient = httpClient;
        this.httpOptions = {
            headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_3__["HttpHeaders"]({
                'Content-Type': 'application/json'
            }),
            observe: 'response'
        };
    }
    getHeaderSystemInfo() {
        //console.log('HEADER_SYS_INFO_ENDPOINT get "%s"', HEADER_SYS_INFO_ENDPOINT);
        return this.httpClient.get(HEADER_SYS_INFO_ENDPOINT, { observe: 'response', responseType: 'text' })
            .pipe(
        /*tap( // Log the result or error
          data => console.log(data),
          error => console.log("Error!", error)
        )*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    getCurrentFWInfo() {
        //console.log('HEADER_SYS_INFO_ENDPOINT get "%s"', FW_INFO_ENDPOINT);
        return this.httpClient.get(FW_INFO_ENDPOINT, this.httpOptions).pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    getSystemStatus() {
        //console.log('SYS_STATUS_ENDPOINT get "%s"', SYS_STATUS_ENDPOINT);
        return this.httpClient.get(SYS_STATUS_ENDPOINT, this.httpOptions).pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    getSystemLog() {
        //console.log('SYS_LOG_ENDPOINT get "%s"', SYS_LOG_ENDPOINT);
        return this.httpClient.get(SYS_LOG_ENDPOINT, { observe: 'response', responseType: 'text' })
            .pipe(
        /*tap( // Log the result or error
          //data => console.log(data),
          error => console.log("Error!", error)
        )*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    downloadLogs() {
        //console.log('DOWNLOAD_LOGS_ENDPOINT get "%s"', DOWNLOAD_LOGS_ENDPOINT);
        /*let requestOptions = {
            headers: new HttpHeaders({
              'Content-Type':  'application/x-tar'
            }),
            observe: 'response' as 'response'
          };
        return this.httpClient.get(DOWNLOAD_LOGS_ENDPOINT, requestOptions);*/
        //return this.httpClient.get(DOWNLOAD_LOGS_ENDPOINT, {responseType: 'blob' as 'json'});
        return this.httpClient.get(DOWNLOAD_LOGS_ENDPOINT, { responseType: 'blob', observe: 'response' }).pipe(
        //tap(resp => console.log('request response', resp))
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    getSystemInfo(settingsList) {
        let values = '';
        let isFirst = true;
        settingsList.forEach(setting => {
            //uciList.push(settingsList[key]);
            if (isFirst) {
                isFirst = false;
            }
            else {
                values += '&';
            }
            values += setting;
        });
        const url = SYS_INFO_ENDPOINT + '?' + values;
        //console.log('REST SYS get "%s"', url);
        return this.httpClient.get(url, this.httpOptions).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    getSystemType() {
        //console.log('SYS_TYPE_ENDPOINT get "%s"', SYS_TYPE_ENDPOINT);
        return this.httpClient.get(SYS_TYPE_ENDPOINT, this.httpOptions).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    getAppStatus() {
        //console.log('APP_STATUS_ENDPOINT get "%s"', APP_STATUS_ENDPOINT);
        return this.httpClient.get(APP_STATUS_ENDPOINT, this.httpOptions).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__["catchError"])(err1 => this.handleError(err1)));
    }
    handleError(error) {
        if (error.error instanceof ErrorEvent) {
            // A client-side or network error occurred. Handle it accordingly.
            console.error('An error occurred:', error.error.message);
        }
        else {
            // The backend returned an unsuccessful response code.
            // The response body may contain clues as to what went wrong.
            console.error(`Backend returned code ${error.status}, ` +
                `body was: ${error.error}`);
        }
        // Return an observable with a user-facing error message.
        //return throwError('Something bad happened; please try again later.');
        return Object(rxjs__WEBPACK_IMPORTED_MODULE_1__["of"])(error); //returns HttpErrorResponse with status 0
    }
}
SystemInfoService.ɵfac = function SystemInfoService_Factory(t) { return new (t || SystemInfoService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_3__["HttpClient"])); };
SystemInfoService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: SystemInfoService, factory: SystemInfoService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](SystemInfoService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_3__["HttpClient"] }]; }, null); })();


/***/ }),

/***/ "5Cdf":
/*!************************************************************!*\
  !*** ./src/app/serial-gateway/serial-gateway.component.ts ***!
  \************************************************************/
/*! exports provided: SerialGatewayComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SerialGatewayComponent", function() { return SerialGatewayComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _validators_serial_gw_custom_validators_directive__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../validators/serial-gw-custom-validators.directive */ "zcCI");
/* harmony import */ var _validators_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../validators/utils */ "/q1Y");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../services/system-info.service */ "4e9C");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_material_radio__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/radio */ "QibW");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _angular_material_form_field__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/form-field */ "kmnG");
/* harmony import */ var _angular_material_select__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/select */ "d3UM");
/* harmony import */ var _angular_material_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/core */ "FKr1");
















function SerialGatewayComponent_div_3_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "Baud rate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "mat-form-field", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "mat-select", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "mat-option", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8, "9600");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "mat-option", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10, "19200");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "mat-option", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](12, "38400");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "mat-option", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14, "57600");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "mat-option", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, "115200");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19, "Databits");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "mat-radio-group", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "mat-radio-button", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](23, "7");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "mat-radio-button", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25, "8");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28, "Parity");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](30, "mat-form-field", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "mat-select", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "mat-option", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33, "None");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](34, "mat-option", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](35, "Even");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](36, "mat-option", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](37, "Odd");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](38, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](39, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](40, "Stopbits");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](41, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](42, "mat-radio-group", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](43, "mat-radio-button", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](44, "1");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](45, "mat-radio-button", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](46, "2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r4.form.get("databits").value === "7");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r4.form.get("databits").value === "8");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r4.form.get("stopbits").value === "1");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r4.form.get("stopbits").value === "2");
} }
const _c0 = function (a0) { return { "input-error": a0 }; };
function SerialGatewayComponent_div_3_tr_21_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Host");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c0, ctx_r5.form.get("host").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("disabled", ctx_r5.form.get("mode").value === "disabled" ? "" : null);
} }
function SerialGatewayComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "form", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngSubmit", function SerialGatewayComponent_div_3_Template_form_ngSubmit_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r7); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r6.submit(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "table", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, SerialGatewayComponent_div_3_ng_container_3_Template, 47, 4, "ng-container", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "h4");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "TCP to Serial Gateway");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](8, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "table", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14, "TCP Gateway");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "mat-radio-group", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "mat-radio-button", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18, "On");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "mat-radio-button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](20, "Off");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](21, SerialGatewayComponent_div_3_tr_21_Template, 5, 4, "tr", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](24, "TCP Port");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](26, "input", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](28, "hr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](30, "button", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SerialGatewayComponent_div_3_Template_button_click_30_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r7); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r8.cancelChanges(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](31, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "button", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33, "Submit");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx_r0.show_settings_component);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("formGroup", ctx_r0.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model !== "CZA-1300" && ctx_r0.device_model !== "MS-775");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("mode").value === "server");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("mode").value === "disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.form.get("mode").value === "client");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](8, _c0, ctx_r0.form.get("port").invalid && ctx_r0.form.get("mode").value !== "disabled"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("disabled", ctx_r0.form.get("mode").value === "disabled" ? "" : null);
} }
function SerialGatewayComponent_ng_container_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Serial Interface");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "h4", null, 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Baud rate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, " Configure the baud rate of the serial interface.");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](8, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, " Supported values are ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11, "9600");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](12, ", ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14, "19200");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15, ", ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](17, "38400");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18, ", ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](20, "57600");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](21, " or ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](23, "115200");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](24, ". ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "h4", null, 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](27, "Databits");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](28, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](29, " Configure the number of databits in each character.");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](30, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](31, " Values supported are ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33, "7");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](34, " or ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](35, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](36, "8");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](37, ". ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](38, "h4", null, 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](40, "Parity");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](41, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](42, " Configure the parity of the serial interface.");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](43, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](44, " Values supported are ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](45, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](46, "None");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](47, ", ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](48, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](49, "Even");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](50, " or ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](51, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](52, "Odd");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](53, ". ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](54, "h4", null, 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](56, "Stopbits");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](57, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](58, " Configure the number of stop bits to send.");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](59, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](60, " Values supported are ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](61, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](62, "1");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](63, " or ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](64, "em");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](65, "2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](66, ". ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} }
class SerialGatewayComponent {
    constructor(configsService, toastrService, httpResponseHandler, systemInfoService) {
        this.configsService = configsService;
        this.toastrService = toastrService;
        this.httpResponseHandler = httpResponseHandler;
        this.systemInfoService = systemInfoService;
        /* Backup */ //used to check what changed exactly, to decide which message should show while submitting
        this.backupSettingsDict = {};
        this.ucisList = {
            'mode': 'epic.serialgw.mode',
            'host': 'epic.serialgw.host',
            'port': 'epic.serialgw.port'
        };
        //loadFinished = false;
        this.show_loading_component = false;
        //whileSubmit = false;
        this.show_settings_component = false;
        this.ValidIpAddressRegex = new RegExp("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        this.ValidHostnameRegex = new RegExp("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9])$");
    }
    ngOnInit() {
        this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({}, [_validators_serial_gw_custom_validators_directive__WEBPACK_IMPORTED_MODULE_2__["HostValidator"]]);
        this.systemInfoService.getSystemInfo(["device_model"]).subscribe(data => {
            switch (data.status) {
                case 200:
                    this.device_model = data.body["device_model"];
                    if (this.device_model !== 'CZA-1300' && this.device_model !== 'MS-775') {
                        this.ucisList['baudrate'] = 'epic.serialgw.baud';
                        this.ucisList['databits'] = 'epic.serialgw.databits';
                        this.ucisList['parity'] = 'epic.serialgw.parity';
                        this.ucisList['stopbits'] = 'epic.serialgw.stopbits';
                    }
                    this.loadDataFromDevice();
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    loadDataFromDevice() {
        this.dataIsAvailable = false;
        this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        this.configsService.getUcis(this.ucisList).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    //store for backup
                    this.backupSettings(data.body);
                    //build device form group
                    this.buildDeviceFormGroup(data.body);
                    this.show_loading_component = false;
                    this.show_settings_component = true;
                    this.dataIsAvailable = true;
                    this.hostInvalid = false;
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    backupSettings(configDict) {
        Object.keys(configDict).forEach(key => {
            this.backupSettingsDict[key] = configDict[key];
        });
        //console.log(this.backupSettingsDict);
    }
    buildDeviceFormGroup(configDict) {
        // client mode was withdrawn for now
        if (configDict["epic.serialgw.mode"] === "client") {
            this.form.addControl('mode', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"]('', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        }
        else {
            this.form.addControl('mode', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.serialgw.mode"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        }
        this.form.addControl('host', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.serialgw.host"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(_validators_utils__WEBPACK_IMPORTED_MODULE_3__["HOST_REGEX"])]));
        this.form.addControl('port', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.serialgw.port"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(_validators_utils__WEBPACK_IMPORTED_MODULE_3__["INT_NUMBER_REGEX"]), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(1024), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(65535)]));
        if (Object.keys(configDict).includes("epic.serialgw.baud")) {
            this.form.addControl('baudrate', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.serialgw.baud"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        }
        if (Object.keys(configDict).includes("epic.serialgw.databits")) {
            this.form.addControl('databits', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.serialgw.databits"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        }
        if (Object.keys(configDict).includes("epic.serialgw.parity")) {
            this.form.addControl('parity', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.serialgw.parity"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        }
        if (Object.keys(configDict).includes("epic.serialgw.stopbits")) {
            this.form.addControl('stopbits', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.serialgw.stopbits"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        }
    }
    cancelChanges() {
        this.show_settings_component = false;
        /*Object.keys(this.settingsForm.value).forEach(key => {
          this.settingsForm.removeControl(key);
        });
        console.log(this.settingsForm.value);*/
        this.loadDataFromDevice();
    }
    submit() {
        //console.log(this.form);
        //check if passwords are valid
        if (this.formIsValid()) {
            this.show_settings_component = false;
            this.submitMessage = "processing...";
            this.show_loading_component = true; // start loading spinner
            setTimeout(() => {
                //build dict with ucis to send
                let settingsToSubmit = {};
                Object.keys(this.form.value).forEach(key => {
                    if (key !== 'host' || (key === 'host' && this.form.get('mode').value === 'client'))
                        settingsToSubmit[this.ucisList[key]] = this.form.get(key).value;
                });
                //console.log("settingsToSubmit");
                //console.log(settingsToSubmit);
                this.configsService.setUcis(settingsToSubmit).subscribe(data => {
                    //console.log(data.status);
                    switch (data.status) {
                        case 200: //SUCCESS
                            //this.toastr.show('Configurations set successfully.', '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-success'});
                            this.toastrService.showSuccessMessage('Configurations set successfully.');
                            this.submitMessage = "The application will restart. Please wait. The page will be automatically reloaded.";
                            setTimeout(() => this.loadDataFromDevice(), 4000);
                            break;
                        case 400: //BAD_REQUEST
                            //console.log(data);
                            //this.toastr.show(data.error['msg'], '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                            this.toastrService.showErrorMessage(data.error['msg']);
                            break;
                        case 401:
                            this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                            break;
                        case 500: //INTERNAL_SERVER_ERROR
                            this.httpResponseHandler.handle500HttpErrorResponse();
                            break;
                        default:
                            console.log("Unexpected return code: ", data.status);
                            this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                            break;
                    }
                });
            }, 1300);
        }
        else {
            //this.toastr.show("Can't submit because configurations are invalid!", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
            this.toastrService.showErrorMessage("Can't submit because configurations are invalid!");
        }
    }
    formIsValid() {
        //console.log(this.form.invalid);
        //console.log(this.form.controls);
        if (this.form.invalid) {
            for (const key in this.form.controls) {
                //console.log(key)
                //console.log(this.form.controls[key].invalid);
                if (this.form.controls[key].invalid) {
                    if (key === 'host' && this.form.get('mode').value !== "client") {
                        //do nothing
                    }
                    else if (key === 'port' && this.form.get('mode').value === "disabled") {
                        //do nothing
                    }
                    else {
                        return false;
                    }
                }
            }
        }
        return true;
    }
}
SerialGatewayComponent.ɵfac = function SerialGatewayComponent_Factory(t) { return new (t || SerialGatewayComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_4__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__["ToastrMessageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_6__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_7__["SystemInfoService"])); };
SerialGatewayComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: SerialGatewayComponent, selectors: [["app-serial-gateway"]], decls: 37, vars: 4, consts: [["href", "https://fonts.googleapis.com/icon?family=Material+Icons", "rel", "stylesheet"], [1, "container"], [1, "tab-content"], ["class", "content", 3, "hidden", 4, "ngIf"], [1, "content", 3, "hidden"], [1, "loading-ripple"], ["src", "assets/images/Ripple-1s-170px.gif"], [1, "tab-help"], [4, "ngIf"], ["tcpGateway", ""], ["tcpPort", ""], ["autocomplete", "off", 3, "formGroup", "ngSubmit"], [1, "t1"], [1, "label"], ["colspan", "2"], [1, "section3"], [1, "value"], ["aria-label", "Select an option", "formControlName", "mode"], ["value", "server", 3, "checked"], ["value", "disabled", 3, "checked"], ["matInput", "", "placeholder", "From 1024 to 65535", "formControlName", "port", 1, "input", 3, "ngClass"], [2, "width", "580px"], [2, "margin-top", "20px", "margin-left", "0"], [2, "float", "right"], ["type", "button", 1, "redBtn", "actionBtn", 3, "click"], ["type", "submit", 1, "submitBtn", "actionBtn"], ["appearance", "fill"], ["formControlName", "baudrate"], ["value", "9600"], ["value", "19200"], ["value", "38400"], ["value", "57600"], ["value", "115200"], ["aria-label", "Select an option", "formControlName", "databits"], ["value", "7", 3, "checked"], ["value", "8", 3, "checked"], ["formControlName", "parity"], ["value", "NONE"], ["value", "EVEN"], ["value", "ODD"], ["aria-label", "Select an option", "formControlName", "stopbits"], ["value", "1", 3, "checked"], ["value", "2", 3, "checked"], ["matInput", "", "placeholder", "Hostname or IP Address", "formControlName", "host", 1, "input", 3, "ngClass"], ["baudrate", ""], ["databits", ""], ["parity", ""], ["stopbits", ""]], template: function SerialGatewayComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "link", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, SerialGatewayComponent_div_3_Template, 34, 10, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "img", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](12, "Help");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, SerialGatewayComponent_ng_container_13_Template, 67, 0, "ng-container", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15, "TCP to Serial Gateway");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "h4", null, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19, "TCP Gateway");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](21, " Enable or Disable the TCP Gateway. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "h4", null, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](24, "TCP Port");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](26, " Listening port of the TCP gateway for incoming connection.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](27, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28, " It accepts values from ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](30, "1024");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](31, " to ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33, "65535");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](34, ". ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](35, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](36, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.dataIsAvailable);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx.show_loading_component);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx.submitMessage);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.device_model !== "CZA-1300" && ctx.device_model !== "MS-775");
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_8__["NgIf"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["ɵangular_packages_forms_forms_y"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroupDirective"], _angular_material_radio__WEBPACK_IMPORTED_MODULE_9__["MatRadioGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControlName"], _angular_material_radio__WEBPACK_IMPORTED_MODULE_9__["MatRadioButton"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["DefaultValueAccessor"], _angular_common__WEBPACK_IMPORTED_MODULE_8__["NgClass"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_10__["DefaultClassDirective"], _angular_material_form_field__WEBPACK_IMPORTED_MODULE_11__["MatFormField"], _angular_material_select__WEBPACK_IMPORTED_MODULE_12__["MatSelect"], _angular_material_core__WEBPACK_IMPORTED_MODULE_13__["MatOption"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL3NlcmlhbC1nYXRld2F5L3NlcmlhbC1nYXRld2F5LmNvbXBvbmVudC5jc3MifQ== */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](SerialGatewayComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-serial-gateway',
                templateUrl: './serial-gateway.component.html',
                styleUrls: ['./serial-gateway.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_4__["DeviceConfigService"] }, { type: _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__["ToastrMessageService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_6__["HTTPResponseHandlerService"] }, { type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_7__["SystemInfoService"] }]; }, null); })();


/***/ }),

/***/ "70H3":
/*!************************************************!*\
  !*** ./src/app/settings/settings.component.ts ***!
  \************************************************/
/*! exports provided: SettingsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SettingsComponent", function() { return SettingsComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _timezone_selector_timezone_selector_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../timezone-selector/timezone-selector.component */ "K095");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/system-info.service */ "4e9C");
/* harmony import */ var _services_system_functions_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../services/system-functions.service */ "8K7A");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _angular_material_expansion__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/expansion */ "7EHt");
/* harmony import */ var _angular_material_form_field__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/form-field */ "kmnG");
/* harmony import */ var _angular_material_select__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/select */ "d3UM");
/* harmony import */ var _angular_material_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/core */ "FKr1");
/* harmony import */ var _angular_material_radio__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/radio */ "QibW");
/* harmony import */ var _additional_certificates_additional_certificates_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../additional-certificates/additional.certificates.component */ "fSrv");
/* harmony import */ var _angular_material_slider__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/material/slider */ "5RNC");




















function SettingsComponent_div_3_tr_13_td_3_Template(rf, ctx) { if (rf & 1) {
    const _r41 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-slider", 70);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SettingsComponent_div_3_tr_13_td_3_Template_mat_slider_input_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r41); const ctx_r40 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3); return ctx_r40.onVolumeChange($event, "volume"); })("mousedown", function SettingsComponent_div_3_tr_13_td_3_Template_mat_slider_mousedown_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r41); const ctx_r42 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3); return ctx_r42.changing_volume = true; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r38 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("\u00A0\u00A0\u00A0", ctx_r38.settingsForm.get("volume").value, "% ");
} }
function SettingsComponent_div_3_tr_13_td_4_Template(rf, ctx) { if (rf & 1) {
    const _r44 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-slider", 71);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SettingsComponent_div_3_tr_13_td_4_Template_mat_slider_input_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r44); const ctx_r43 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3); return ctx_r43.onVolumeChange($event, "volume"); })("mousedown", function SettingsComponent_div_3_tr_13_td_4_Template_mat_slider_mousedown_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r44); const ctx_r45 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3); return ctx_r45.changing_volume = true; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r39 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("\u00A0\u00A0\u00A0", ctx_r39.settingsForm.get("volume").value, "dB ");
} }
function SettingsComponent_div_3_tr_13_Template(rf, ctx) { if (rf & 1) {
    const _r47 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_tr_13_Template_td_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r47); const ctx_r46 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](27); return ctx_r46.scrollToId(_r3); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Master Volume");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, SettingsComponent_div_3_tr_13_td_3_Template, 3, 1, "td", 56);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, SettingsComponent_div_3_tr_13_td_4_Template, 3, 1, "td", 56);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r12.device_model !== "MS-700");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r12.device_model === "MS-700");
} }
function SettingsComponent_div_3_div_19_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_ng_template_20_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
const _c0 = function (a0) { return { "input-error": a0 }; };
function SettingsComponent_div_3_tr_42_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "IP Address");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 72);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](1, _c0, ctx_r16.settingsForm.get("static_ip_addr").invalid));
} }
function SettingsComponent_div_3_tr_43_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Netmask");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 73);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](1, _c0, ctx_r17.settingsForm.get("static_netmask").invalid));
} }
function SettingsComponent_div_3_tr_44_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Gateway IP Address");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 74);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](1, _c0, ctx_r18.settingsForm.get("static_gateway").invalid));
} }
function SettingsComponent_div_3_tr_45_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "DHCP Host Name");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 75);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](1, _c0, ctx_r19.settingsForm.get("dhcp_name").invalid));
} }
function SettingsComponent_div_3_tr_60_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Primary DNS");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 76);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](1, _c0, ctx_r20.settingsForm.get("dns1_server").invalid));
} }
function SettingsComponent_div_3_tr_61_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Alternative DNS");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 77);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](1, _c0, ctx_r21.settingsForm.get("dns2_server").invalid));
} }
function SettingsComponent_div_3_div_67_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_ng_template_68_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_div_97_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_ng_template_98_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_tr_129_Template(rf, ctx) { if (rf & 1) {
    const _r49 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_tr_129_Template_tr_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r49); const ctx_r48 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](91); return ctx_r48.scrollToId(_r8); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Automatic Firmware Update URL");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 78);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](1, _c0, ctx_r28.settingsForm.get("fw_update_auto").value === "true" && ctx_r28.settingsForm.get("fw_update_url").value === ""));
} }
function SettingsComponent_div_3_td_142_Template(rf, ctx) { if (rf & 1) {
    const _r51 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "input", 79);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SettingsComponent_div_3_td_142_Template_input_input_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r51); const ctx_r50 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r50.pwd_old = $event.target["value"]; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "input", 80);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SettingsComponent_div_3_td_142_Template_input_input_2_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r51); const ctx_r52 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r52.pwd_set = $event.target["value"]; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "input", 81);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SettingsComponent_div_3_td_142_Template_input_input_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r51); const ctx_r53 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r53.pwd_chk = $event.target["value"]; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r29 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx_r29.pwd_old);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx_r29.pwd_set);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx_r29.pwd_chk);
} }
function SettingsComponent_div_3_td_143_Template(rf, ctx) { if (rf & 1) {
    const _r55 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "input", 82);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SettingsComponent_div_3_td_143_Template_input_input_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r55); const ctx_r54 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r54.pwd_set = $event.target["value"]; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "input", 81);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SettingsComponent_div_3_td_143_Template_input_input_2_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r55); const ctx_r56 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r56.pwd_chk = $event.target["value"]; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r30 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx_r30.pwd_set);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx_r30.pwd_chk);
} }
function SettingsComponent_div_3_div_151_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_ng_template_152_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_ng_container_176_Template(rf, ctx) { if (rf & 1) {
    const _r58 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_ng_container_176_Template_tr_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r58); const ctx_r57 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](130); return ctx_r57.scrollToId(_r10); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "Relay 3");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "mat-radio-group", 83);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, "Enabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_ng_container_176_Template_tr_click_10_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r58); const ctx_r59 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](130); return ctx_r59.scrollToId(_r10); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](12, "Relay 4");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "mat-radio-group", 84);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, "Disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18, "Enabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r34 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r34.settingsForm.get("relay_3").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r34.settingsForm.get("relay_3").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r34.settingsForm.get("relay_4").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r34.settingsForm.get("relay_4").value === "true");
} }
function SettingsComponent_div_3_div_182_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_ng_template_183_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SettingsComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r61 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "form", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngSubmit", function SettingsComponent_div_3_Template_form_ngSubmit_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r60 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r60.submit(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_td_click_4_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r62 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](14); return ctx_r62.scrollToId(_r1); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Device Alias");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "input", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_8_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r63 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](19); return ctx_r63.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10, "Description");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](12, "input", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, SettingsComponent_div_3_tr_13_Template, 5, 2, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "mat-accordion", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "mat-expansion-panel", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SettingsComponent_div_3_Template_mat_expansion_panel_opened_15_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r64 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r64.NetworkPanelOpenState = true; })("closed", function SettingsComponent_div_3_Template_mat_expansion_panel_closed_15_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r65 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r65.NetworkPanelOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](19, SettingsComponent_div_3_div_19_Template, 3, 0, "div", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](20, SettingsComponent_div_3_ng_template_20_Template, 2, 0, "ng-template", null, 33, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](22, " Network Settings ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "h4");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](27, "Ethernet");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](28, "td");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_29_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r66 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](35); return ctx_r66.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](30, "td", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "table", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](33, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](34, "DHCP");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](35, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](36, "mat-form-field", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](37, "mat-select", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("selectionChange", function SettingsComponent_div_3_Template_mat_select_selectionChange_37_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r67 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r67.DHCPSettingChanged(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](38, "mat-option", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](39, "Yes");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](40, "mat-option", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](41, "No");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](42, SettingsComponent_div_3_tr_42_Template, 5, 3, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](43, SettingsComponent_div_3_tr_43_Template, 5, 3, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](44, SettingsComponent_div_3_tr_44_Template, 5, 3, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](45, SettingsComponent_div_3_tr_45_Template, 5, 3, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](46, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_46_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r68 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](63); return ctx_r68.scrollToId(_r5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](47, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](48, "h4");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](49, "DNS");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](50, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](51, "mat-form-field", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](52, "mat-select", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](53, "mat-option", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](54, "Auto");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](55, "mat-option", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](56, "Manual");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](57, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_57_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r69 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](63); return ctx_r69.scrollToId(_r5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](58, "td", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](59, "table", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](60, SettingsComponent_div_3_tr_60_Template, 5, 3, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](61, SettingsComponent_div_3_tr_61_Template, 5, 3, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](62, "mat-accordion", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](63, "mat-expansion-panel", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SettingsComponent_div_3_Template_mat_expansion_panel_opened_63_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r70 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r70.TimePanelOpenState = true; })("closed", function SettingsComponent_div_3_Template_mat_expansion_panel_closed_63_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r71 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r71.TimePanelOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](64, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](65, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](66, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](67, SettingsComponent_div_3_div_67_Template, 3, 0, "div", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](68, SettingsComponent_div_3_ng_template_68_Template, 2, 0, "ng-template", null, 43, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](70, " Time Settings ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](71, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](72, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_72_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r72 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](81); return ctx_r72.scrollToId(_r6); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](73, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](74, "Timezone");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](75, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](76, "app-timezone-selector", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](77, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_77_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r73 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](86); return ctx_r73.scrollToId(_r7); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](78, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](79, "NTP Server 1");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](80, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](81, "input", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](82, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_82_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r74 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](86); return ctx_r74.scrollToId(_r7); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](83, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](84, "NTP Server 2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](85, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](86, "input", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](87, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_87_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r75 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](86); return ctx_r75.scrollToId(_r7); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](88, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](89, "NTP Server 3");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](90, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](91, "input", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](92, "mat-accordion", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](93, "mat-expansion-panel", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SettingsComponent_div_3_Template_mat_expansion_panel_opened_93_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r76 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r76.SecurityPanelOpenState = true; })("closed", function SettingsComponent_div_3_Template_mat_expansion_panel_closed_93_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r77 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r77.SecurityPanelOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](94, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](95, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](96, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](97, SettingsComponent_div_3_div_97_Template, 3, 0, "div", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](98, SettingsComponent_div_3_ng_template_98_Template, 2, 0, "ng-template", null, 48, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](100, " Security Settings ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](101, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](102, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_102_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r78 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](91); return ctx_r78.scrollToId(_r8); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](103, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](104, "Reset Factory Defaults");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](105, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](106, "mat-radio-group", 49);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](107, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](108, "Disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](109, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](110, "Enabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](111, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_111_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r79 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](91); return ctx_r79.scrollToId(_r8); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](112, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](113, "Update Function");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](114, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](115, "mat-radio-group", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](116, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](117, "Disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](118, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](119, "Enabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](120, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_120_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r80 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](91); return ctx_r80.scrollToId(_r8); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](121, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](122, "Automatic Firmware Update");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](123, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](124, "mat-radio-group", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](125, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](126, "Yes");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](127, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](128, "No");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](129, SettingsComponent_div_3_tr_129_Template, 5, 3, "tr", 54);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](130, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_130_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r81 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](91); return ctx_r81.scrollToId(_r8); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](131, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](132, "Reboot Function");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](133, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](134, "mat-radio-group", 55);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](135, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](136, "Disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](137, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](138, "Enabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](139, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_139_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r82 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](91); return ctx_r82.scrollToId(_r8); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](140, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](141, "Web UI Password");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](142, SettingsComponent_div_3_td_142_Template, 4, 3, "td", 56);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](143, SettingsComponent_div_3_td_143_Template, 3, 2, "td", 56);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](144, "div", 57);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_div_click_144_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r83 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](125); return ctx_r83.scrollToId(_r9); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](145, "app-additional-certificates", 58);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("loadingEvent", function SettingsComponent_div_3_Template_app_additional_certificates_loadingEvent_145_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r84 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r84.setShowLoading($event); })("eventFinished", function SettingsComponent_div_3_Template_app_additional_certificates_eventFinished_145_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r85 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r85.finishLoading($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](146, "mat-accordion", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](147, "mat-expansion-panel", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SettingsComponent_div_3_Template_mat_expansion_panel_opened_147_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r86 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r86.RelayConfigOpenState = true; })("closed", function SettingsComponent_div_3_Template_mat_expansion_panel_closed_147_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r87 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r87.RelayConfigOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](148, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](149, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](150, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](151, SettingsComponent_div_3_div_151_Template, 3, 0, "div", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](152, SettingsComponent_div_3_ng_template_152_Template, 2, 0, "ng-template", null, 59, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](154, " Relay Configuration ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](155, "p", 60);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](156, "Activate relay during SIP calls or playback of a notification");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](157, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](158, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_158_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r88 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](130); return ctx_r88.scrollToId(_r10); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](159, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](160);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](161, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](162, "mat-radio-group", 61);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](163, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](164, "Disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](165, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](166, "Enabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](167, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_167_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r89 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](130); return ctx_r89.scrollToId(_r10); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](168, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](169);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](170, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](171, "mat-radio-group", 62);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](172, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](173, "Disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](174, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](175, "Enabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](176, SettingsComponent_div_3_ng_container_176_Template, 19, 4, "ng-container", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](177, "mat-accordion", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](178, "mat-expansion-panel", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SettingsComponent_div_3_Template_mat_expansion_panel_opened_178_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r90 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r90.SnmpSettingsOpenState = true; })("closed", function SettingsComponent_div_3_Template_mat_expansion_panel_closed_178_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r91 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r91.SnmpSettingsOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](179, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](180, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](181, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](182, SettingsComponent_div_3_div_182_Template, 3, 0, "div", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](183, SettingsComponent_div_3_ng_template_183_Template, 2, 0, "ng-template", null, 63, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](185, " SNMP Configuration ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](186, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](187, "tr", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_tr_click_187_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r92 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](141); return ctx_r92.scrollToId(_r11); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](188, "td", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](189, "Enable");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](190, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](191, "mat-radio-group", 64);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](192, "mat-radio-button", 50);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](193, "Disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](194, "mat-radio-button", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](195, "Enabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](196, "div", 65);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](197, "hr", 66);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](198, "div", 67);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](199, "button", 68);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SettingsComponent_div_3_Template_button_click_199_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r61); const ctx_r93 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r93.cancelChanges(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](200, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](201, "button", 69);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](202, "Submit");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](21);
    const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](69);
    const _r26 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](99);
    const _r32 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](153);
    const _r36 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](184);
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx_r0.show_settings_component);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("formGroup", ctx_r0.settingsForm);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](46, _c0, ctx_r0.settingsForm.get("alias").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](48, _c0, ctx_r0.settingsForm.get("device_description").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model !== "MS-775" && ctx_r0.device_model !== "CZA-1300");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.NetworkPanelOpenState)("ngIfElse", _r14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.settingsForm.get("method").value === "static");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.settingsForm.get("method").value === "static");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.settingsForm.get("method").value === "static");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.settingsForm.get("method").value === "dhcp");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r0.settingsForm.get("method").value === "static");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.settingsForm.get("dns_type").value === "MANUAL");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.settingsForm.get("dns_type").value === "MANUAL");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.TimePanelOpenState)("ngIfElse", _r23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("timezone", ctx_r0.settingsForm.get("timezone").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](50, _c0, ctx_r0.settingsForm.get("ntp1_server").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](52, _c0, ctx_r0.settingsForm.get("ntp2_server").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](54, _c0, ctx_r0.settingsForm.get("ntp3_server").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.SecurityPanelOpenState)("ngIfElse", _r26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("defaults_opt").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("defaults_opt").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("update_opt").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("update_opt").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("fw_update_auto").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("fw_update_auto").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.settingsForm.get("fw_update_auto").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("reboot_opt").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("reboot_opt").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.webui_pwd_flag);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r0.webui_pwd_flag);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.RelayConfigOpenState)("ngIfElse", _r32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.device_model === "Barionet-MAE" ? "Digital Output 1" : "Relay 1");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("relay_1").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("relay_1").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.device_model === "Barionet-MAE" ? "Digital Output 2" : "Relay 2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("relay_2").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("relay_2").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model === "MS-700" || ctx_r0.device_model === "CZA-1300" || ctx_r0.device_model === "MS-775" || ctx_r0.device_model === "Barionet-MAE");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.SnmpSettingsOpenState)("ngIfElse", _r36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("snmp_enable").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.settingsForm.get("snmp_enable").value === "true");
} }
class SettingsComponent {
    constructor(configsService, httpResponseHandler, systemInfoService, systemFuncsService, toastrService) {
        this.configsService = configsService;
        this.httpResponseHandler = httpResponseHandler;
        this.systemInfoService = systemInfoService;
        this.systemFuncsService = systemFuncsService;
        this.toastrService = toastrService;
        /* Forms */
        this.settingsForm = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        /* Backup */ //used to check what changed exactly, to decide which message should show while submitting
        this.backupSettingsDict = {};
        this.ucisList = {
            'alias': 'epic.main.device_alias',
            'device_description': 'epic.main.description',
            // 'sonic_ip':'sonic_ip.general.enabled',
            // 'sonic_ip_vol':'sonic_ip.general.volume',
            'web_proto': 'httpd.webserver.protocol',
            'method': 'network.eth0.proto',
            'dhcp_name': 'network.eth0.dhcpname',
            'static_ip_addr': 'network.eth0.ipaddr',
            'static_netmask': 'network.eth0.netmask',
            'static_gateway': 'network.eth0.gateway',
            'dns_type': 'network.eth0.dns_type',
            'dns1_server': 'network.eth0.dns1',
            'dns2_server': 'network.eth0.dns2',
            'timezone': 'timezone.config.value',
            'ntp1_server': 'ntp.source.server1',
            'ntp2_server': 'ntp.source.server2',
            'ntp3_server': 'ntp.source.server3',
            'defaults_opt': 'security.defaults.enabled',
            'update_opt': 'security.update.enabled',
            'reboot_opt': 'security.reset.enabled',
            'webui_pwd_flag': 'httpd.webserver.password_set',
            'fw_update_auto': 'epic.main.fw_update_auto',
            'fw_update_url': 'epic.main.fw_update_url',
            'relay_1': 'epic.io.notify_relay1',
            'relay_2': 'epic.io.notify_relay2',
            'snmp_enable': 'epic.snmp.enable'
        };
        this.pwd_set = '';
        this.pwd_old = '';
        this.pwd_chk = '';
        //System type
        this.HW_type_ID = null;
        this.hasSNMPSettings = false;
        this.hasPoESettings = false;
        this.dataIsAvailable = false;
        //loadFinished = false;
        this.show_loading_component = false;
        //whileSubmit = false;
        this.show_settings_component = false;
        this.changing_volume = false;
        /* State Variables */
        this.NetworkPanelOpenState = false;
        this.TimePanelOpenState = false;
        this.SecurityPanelOpenState = false;
        this.RelayConfigOpenState = false;
        this.SnmpSettingsOpenState = false;
    }
    ngOnInit() {
        this.loadDataFromDevice();
    }
    loadDataFromDevice() {
        this.dataIsAvailable = false;
        this.settingsForm = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        this.systemInfoService.getSystemInfo(["device_model"]).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    this.device_model = data.body["device_model"];
                    if (this.device_model === "MS-700") {
                        this.ucisList["volume"] = "ae_ms.volume.out0";
                        this.ucisList["relay_3"] = "epic.io.notify_relay3";
                        this.ucisList["relay_4"] = "epic.io.notify_relay4";
                    }
                    else if (this.device_model === "CZA-1300" || this.device_model === "MS-775") {
                        this.ucisList["relay_3"] = "epic.io.notify_relay3";
                        this.ucisList["relay_4"] = "epic.io.notify_relay4";
                    }
                    else if (this.device_model === "Barionet-MAE") {
                        this.ucisList["volume"] = "epic.main.volume";
                        this.ucisList["relay_3"] = "epic.io.notify_relay3";
                        this.ucisList["relay_4"] = "epic.io.notify_relay4";
                    }
                    else {
                        this.ucisList["volume"] = "epic.main.volume";
                    }
                    this.configsService.getUcis(this.ucisList).subscribe(data => {
                        //console.log("Status:", data.status);
                        //console.log("Received:", data.body);
                        switch (data.status) {
                            case 200:
                                //store for backup
                                this.backupSettings(data.body);
                                //build device form group
                                this.buildDeviceFormGroup(data.body);
                                this.webui_pwd_flag = this.getBooleanFromValue(data.body["httpd.webserver.password_set"]);
                                this.pwd_set = '';
                                this.pwd_old = '';
                                this.pwd_chk = '';
                                this.NetworkPanelOpenState = false;
                                this.TimePanelOpenState = false;
                                this.SecurityPanelOpenState = false;
                                this.RelayConfigOpenState = false;
                                this.SnmpSettingsOpenState = false;
                                //this.whileSubmit = false;
                                //this.loadFinished = true;
                                this.show_loading_component = false;
                                this.show_settings_component = true;
                                this.dataIsAvailable = true;
                                break;
                            case 401:
                                this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                                break;
                            case 500:
                                this.httpResponseHandler.handle500HttpErrorResponse();
                                break;
                            default:
                                console.log("Unexpected return code: ", data.status);
                                this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                                break;
                        }
                    });
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    backupSettings(configDict) {
        Object.keys(configDict).forEach(key => {
            this.backupSettingsDict[key] = configDict[key];
        });
        //console.log(this.backupSettingsDict);
    }
    getBooleanFromValue(value) {
        let bool;
        switch (value) {
            case "true":
                bool = true;
                break;
            case "false":
                bool = false;
                break;
            case "http":
                bool = false;
                break;
            case "https":
                bool = true;
                break;
            default:
                console.log("Unknown value: ", value);
                break;
        }
        return bool;
    }
    buildDeviceFormGroup(configDict) {
        const ALIAS_REGEX = "^[\\w\\s#|&\\/.,\\-]*$";
        const DESCRIPTION_REGEX = "^.*$";
        const GENERAL_IP_ADDRESS_REGEX = "(^$)|(^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$)";
        const HTTP_URL_REGEX = "^http[s]?:\\/\\/(.+)$";
        const NTP_URL_REGEX = "(^$)|(^(http[s]*:\\/\\/)?(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]).)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9-]*[A-Za-z0-9])$)";
        this.settingsForm.addControl('alias', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.main.device_alias"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(ALIAS_REGEX)));
        if (Object.keys(configDict).includes("epic.main.volume")) {
            this.settingsForm.addControl('volume', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.main.volume"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(100), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required]));
        }
        if (Object.keys(configDict).includes("ae_ms.volume.out0")) {
            this.settingsForm.addControl('volume', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["ae_ms.volume.out0"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(-79), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(16), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required]));
        }
        // this.settingsForm.addControl('sonic_ip', new FormControl(configDict["sonic_ip.general.enabled"], Validators.required));
        // this.settingsForm.addControl('sonic_ip_vol', new FormControl(configDict["sonic_ip.general.volume"], [Validators.min(0), Validators.max(100), Validators.required]));
        this.settingsForm.addControl('web_proto', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["httpd.webserver.protocol"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('method', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["network.eth0.proto"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('dhcp_name', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["network.eth0.dhcpname"]));
        this.settingsForm.addControl('static_ip_addr', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["network.eth0.ipaddr"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(GENERAL_IP_ADDRESS_REGEX)));
        this.settingsForm.addControl('static_netmask', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["network.eth0.netmask"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(GENERAL_IP_ADDRESS_REGEX)));
        this.settingsForm.addControl('static_gateway', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["network.eth0.gateway"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(GENERAL_IP_ADDRESS_REGEX)));
        this.settingsForm.addControl('dns_type', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["network.eth0.dns_type"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('dns1_server', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["network.eth0.dns1"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(GENERAL_IP_ADDRESS_REGEX)));
        this.settingsForm.addControl('dns2_server', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["network.eth0.dns2"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(GENERAL_IP_ADDRESS_REGEX)));
        //this.settingsForm.addControl('syslog_addr', new FormControl(configDict["syslogd.remote.ipaddr"]));
        this.settingsForm.addControl('timezone', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["timezone.config.value"]));
        this.settingsForm.addControl('ntp1_server', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["ntp.source.server1"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(NTP_URL_REGEX)));
        this.settingsForm.addControl('ntp2_server', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["ntp.source.server2"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(NTP_URL_REGEX)));
        this.settingsForm.addControl('ntp3_server', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["ntp.source.server3"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(NTP_URL_REGEX)));
        this.settingsForm.addControl('defaults_opt', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["security.defaults.enabled"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('update_opt', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["security.update.enabled"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('reboot_opt', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["security.reset.enabled"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('fw_update_auto', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.main.fw_update_auto"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('fw_update_url', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.main.fw_update_url"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(HTTP_URL_REGEX)));
        //console.log(this.settingsForm);
        this.settingsForm.addControl('relay_1', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.io.notify_relay1"] === 'true' ? 'true' : 'false', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('relay_2', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.io.notify_relay2"] === 'true' ? 'true' : 'false', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        if (Object.keys(configDict).includes("epic.io.notify_relay3")) {
            this.settingsForm.addControl('relay_3', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.io.notify_relay3"] === 'true' ? 'true' : 'false', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        }
        if (Object.keys(configDict).includes("epic.io.notify_relay4")) {
            this.settingsForm.addControl('relay_4', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.io.notify_relay4"] === 'true' ? 'true' : 'false', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        }
        this.settingsForm.addControl('snmp_enable', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.snmp.enable"] === 'true' ? 'true' : 'false', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.settingsForm.addControl('device_description', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.main.description"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(DESCRIPTION_REGEX)));
    }
    //Make value update while slider is moving
    onVolumeChange(event, formName) {
        //console.log(event.value);
        this.settingsForm.get(formName).setValue(event.value);
    }
    cancelChanges() {
        this.show_settings_component = false;
        /*Object.keys(this.settingsForm.value).forEach(key => {
          this.settingsForm.removeControl(key);
        });
        console.log(this.settingsForm.value);*/
        this.loadDataFromDevice();
    }
    submit() {
        //console.log(this.settingsForm);
        //check if passwords are valid
        if (this.passwordsAreValid()) {
            if (this.formIsValid()) {
                this.show_settings_component = false;
                this.submitMessage = "processing...";
                this.show_loading_component = true; // start loading spinner
                setTimeout(() => {
                    //build dict with ucis to send
                    let settingsToSubmit = {};
                    Object.keys(this.settingsForm.value).forEach(key => {
                        if ((key === "dns1_server" || key === 'dns2_server') && this.settingsForm.get('dns_type').value === "AUTO") {
                            //don't add
                        }
                        else if ((key === "static_ip_addr" || key === 'static_netmask' || key === 'static_gateway') && this.settingsForm.get('method').value === "dhcp") {
                            //don't add
                        }
                        else if (key === "dhcp_name" && this.settingsForm.get('method').value === "static") {
                            //don't add
                        }
                        else if (key === "timezone") {
                            //console.log("get timezone", this.timezone.timezoneForm.value);
                            settingsToSubmit[this.ucisList[key]] = this.timezone.timezoneForm.value;
                        }
                        else {
                            settingsToSubmit[this.ucisList[key]] = this.settingsForm.get(key).value;
                        }
                    });
                    //console.log("settingsToSubmit");
                    //console.log(settingsToSubmit);
                    //send passwords as well
                    let passwords = {};
                    if (this.pwd_old !== '') {
                        passwords['pwd_old'] = this.pwd_old;
                    }
                    if (this.pwd_set !== '') {
                        passwords['pwd_set'] = this.pwd_set;
                    }
                    this.configsService.setSettings(settingsToSubmit, passwords).subscribe(data => {
                        //console.log(data.status);
                        switch (data.status) {
                            case 200: //SUCCESS
                                //this.systemService.isAppReady(() => this.finishSubmit());
                                //this.toastr.show('Configurations set successfully.', '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-success'});
                                this.toastrService.showSuccessMessage('Configurations set successfully.');
                                //console.log(data.body);
                                this.finishSubmit(data.body.ucisSet);
                                break;
                            case 400: //BAD_REQUEST
                                //console.log(data);
                                //this.toastr.show(data.error['msg'], '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                                this.toastrService.showErrorMessage(data.error['msg']);
                                this.loadDataFromDevice();
                                break;
                            case 401:
                                this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                                break;
                            case 500: //INTERNAL_SERVER_ERROR
                                this.httpResponseHandler.handle500HttpErrorResponse();
                                break;
                            default:
                                console.log("Unexpected return code: ", data.status);
                                this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                                break;
                        }
                    });
                }, 1300);
            }
        }
    }
    finishSubmit(settingsConfigured) {
        // if ip address possibly changed; dhcp/static ip address
        if (settingsConfigured.includes('network.eth0.proto') || settingsConfigured.includes('network.eth0.ipaddr')) { // device rebooted and can't automatically reload
            this.submitMessage = "The device will reboot. Please wait until the end of the process and enter the new URL with the new IP Address.";
        }
        else {
            let rebootChanges = false;
            for (let idx in settingsConfigured) {
                if (settingsConfigured[idx].startsWith("network") || settingsConfigured[idx].startsWith("sonic_ip")
                    || settingsConfigured[idx].startsWith("ntp") || settingsConfigured[idx].startsWith("security")) {
                    rebootChanges = true;
                    break;
                }
            }
            if (rebootChanges || settingsConfigured.includes('httpd.webserver.protocol')
                || settingsConfigured.includes('httpd.webserver.password_set')
                || settingsConfigured.includes('epic.main.fw_update_auto')
                || settingsConfigured.includes('epic.main.fw_update_url')) { // device rebooted but can automatically reload
                this.submitMessage = "The device will reboot. Please wait. The page will be automatically reloaded.";
                setTimeout(() => this.reloadWebUI(), 5000);
            }
            else { // nothing needed
                this.loadDataFromDevice();
            }
        }
    }
    formIsValid() {
        // console.log("Form is invalid?", this.settingsForm.invalid);
        // console.log(this.settingsForm.get('volume').value);
        if (this.settingsForm.invalid) {
            //let invalid = true;
            for (let key in this.settingsForm.controls) {
                if (this.settingsForm.get(key).invalid) {
                    if ((key === "dns1_server" || key === 'dns2_server') && this.settingsForm.get('dns_type').value === "AUTO") {
                        //invalid = false;
                    }
                    else if ((key === "static_ip_addr" || key === 'static_netmask' || key === 'static_gateway') && this.settingsForm.get('method').value === "dhcp") {
                        //invalid = false;
                    }
                    else {
                        // console.log(key);
                        //this.toastr.show("Configuration is invalid!", '', {closeButton: true, disableTimeOut: true, toastClass: 'my-toast-error'});
                        this.toastrService.showErrorMessage("Configuration is invalid!");
                        return false;
                    }
                }
            }
            /*if (invalid) {
              this.toastr.show("Configuration is invalid!", '', {closeButton: true, disableTimeOut: true, toastClass: 'my-toast-error'});
              return false;
            }*/
        }
        if (this.settingsForm.get('ntp1_server').value === "" && this.settingsForm.get('ntp2_server').value === "" && this.settingsForm.get('ntp3_server').value === "") {
            //this.toastr.show("At least 1 NTP server should be configured!", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
            this.toastrService.showErrorMessage("At least 1 NTP server should be configured!");
            return false;
        }
        if (this.settingsForm.get('dns_type').value === "MANUAL" && this.settingsForm.get('dns1_server').value === "" && this.settingsForm.get('dns2_server').value === "") {
            //this.toastr.show("At least 1 DNS server should be configured!", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
            this.toastrService.showErrorMessage("At least 1 DNS server should be configured!");
            return false;
        }
        if (this.settingsForm.get('fw_update_auto').value === "true" && this.settingsForm.get('fw_update_url').value === "") {
            //this.toastr.show("Configuration is invalid!", '', {closeButton: true, disableTimeOut: true, toastClass: 'my-toast-error'});
            this.toastrService.showErrorMessage("Configuration is invalid!");
            return false;
        }
        if (!this.timezone.isValid) {
            this.toastrService.showErrorMessage("Configuration is invalid!");
            return false;
        }
        return true;
    }
    passwordsAreValid() {
        if (!this.checkPasswordsMatch()) {
            alert("Passwords don't match! Please correct them before submitting your changes!");
            return false;
        }
        if (this.webui_pwd_flag && this.pwd_old === '' && this.pwd_set !== '') {
            alert("You can not set a new password without inputting the current one!");
            return false;
        }
        return true;
    }
    checkPasswordsMatch() {
        if (this.pwd_set === this.pwd_chk) {
            return true;
        }
        else {
            return false;
        }
    }
    reloadWebUI() {
        this.systemFuncsService.appIsRunning().subscribe(res => {
            //console.log(res);
            if (res.status === 200) {
                window.location.href = this.settingsForm.get('web_proto').value + '://' + window.location.hostname + "/settings";
            }
            else {
                setTimeout(() => this.reloadWebUI(), 1000);
            }
        });
    }
    submitVolume() {
        if (this.changing_volume) {
            //to keep the ability to change the volume without submitting
            let uciDict = { [this.ucisList['volume']]: this.settingsForm.get('volume').value };
            this.configsService.setVolume(uciDict).subscribe(data => {
                //console.log(data.status);
                switch (data.status) {
                    case 200: //SUCCESS
                        //this.systemService.isAppReady(() => this.finishSubmit());
                        //console.log("Volume set with success");
                        break;
                    case 400: //BAD_REQUEST
                        //console.log(data);
                        //this.toastr.show(data.error['msg'], '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                        this.toastrService.showErrorMessage(data.error['msg']);
                        break;
                    case 401:
                        this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                        break;
                    case 500: //INTERNAL_SERVER_ERROR
                        this.httpResponseHandler.handle500HttpErrorResponse();
                        break;
                    default:
                        console.log("Unexpected return code: ", data.status);
                        this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                        break;
                }
                this.changing_volume = false;
            });
        }
        else {
            //console.log("not changing volume");
        }
    }
    /*public setTitle(newTitle: string) {
      this.titleService.setTitle(newTitle);
    }*/
    setShowLoading($event) {
        //console.log("set showLoading event");
        //console.log($event);
        this.show_loading_component = $event;
        this.show_settings_component = !$event;
    }
    finishLoading(data) {
        //console.log("finish loading event");
        //console.log(data);
        this.loadDataFromDevice();
        //this.toastr.show(data["toast-msg"], '', {closeButton : true, disableTimeOut: true, toastClass: data["toast-class"]});
        this.toastrService.showErrorMessage(data["toast-msg"]);
    }
    scrollToId(el) {
        el.scrollIntoView({ 'behavior': 'smooth' });
    }
    DHCPSettingChanged() {
        let dhcp_value = this.settingsForm.get('method').value;
        if (dhcp_value === 'static') {
            this.settingsForm.get('dns_type').setValue('MANUAL');
        }
    }
}
SettingsComponent.ɵfac = function SettingsComponent_Factory(t) { return new (t || SettingsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_3__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_5__["SystemInfoService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_functions_service__WEBPACK_IMPORTED_MODULE_6__["SystemFunctionsService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_toastr_message_service__WEBPACK_IMPORTED_MODULE_7__["ToastrMessageService"])); };
SettingsComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: SettingsComponent, selectors: [["app-settings"]], viewQuery: function SettingsComponent_Query(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_timezone_selector_timezone_selector_component__WEBPACK_IMPORTED_MODULE_2__["TimezoneSelectorComponent"], true);
    } if (rf & 2) {
        var _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.timezone = _t.first);
    } }, decls: 149, vars: 4, consts: [["href", "https://fonts.googleapis.com/icon?family=Material+Icons", "rel", "stylesheet"], [1, "container", 3, "mouseup"], [1, "tab-content"], ["class", "content", 3, "hidden", 4, "ngIf"], [1, "content", 3, "hidden"], [1, "loading-ripple"], ["src", "assets/images/Ripple-1s-170px.gif"], [1, "tab-help"], ["alias", ""], ["description", ""], [3, "hidden"], ["masterVolume", ""], ["dhcp", ""], ["dns", ""], ["timezone", ""], ["ntp", ""], ["security", ""], ["certificates", ""], ["relayConfig", ""], ["snmpSettings", ""], ["autocomplete", "off", 3, "formGroup", "ngSubmit"], [1, "t1"], [1, "label", 3, "click"], [1, "value"], ["matInput", "", "placeholder", "Device Alias", "formControlName", "alias", 1, "input", 3, "ngClass"], [3, "click"], [1, "label"], ["matInput", "", "formControlName", "device_description", 2, "padding", "3px", "width", "378px", 3, "ngClass"], [4, "ngIf"], [2, "width", "550px"], ["hideToggle", "", 1, "config-card", "mat-elevation-z0", 3, "opened", "closed"], [1, "visual"], [4, "ngIf", "ngIfElse"], ["networkClosedPanel", ""], ["colspan", "2"], [1, "section3"], ["appearance", "fill"], ["formControlName", "method", 3, "selectionChange"], ["value", "dhcp"], ["value", "static"], ["formControlName", "dns_type"], ["value", "AUTO", 3, "disabled"], ["value", "MANUAL"], ["timeClosedPanel", ""], [3, "timezone"], ["matInput", "", "placeholder", "NTP Server 1", "formControlName", "ntp1_server", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "NTP Server 2", "formControlName", "ntp2_server", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "NTP Server 3", "formControlName", "ntp3_server", 1, "input", 3, "ngClass"], ["secClosedPanel", ""], ["aria-label", "Select an option", "formControlName", "defaults_opt"], ["value", "false", 1, "settings-mat-radio-btn", 3, "checked"], ["value", "true", 1, "settings-mat-radio-btn", 3, "checked"], ["aria-label", "Select an option", "formControlName", "update_opt"], ["aria-label", "Select an option", "formControlName", "fw_update_auto"], [3, "click", 4, "ngIf"], ["aria-label", "Select an option", "formControlName", "reboot_opt"], ["class", "value", 4, "ngIf"], [2, "margin", "8px 0 8px 8px", 3, "click"], [3, "loadingEvent", "eventFinished"], ["relaysClosedPanel", ""], [2, "font-size", "12px", "margin-left", "10px"], ["aria-label", "Select an option", "formControlName", "relay_1"], ["aria-label", "Select an option", "formControlName", "relay_2"], ["snmpClosedPanel", ""], ["aria-label", "Select an option", "formControlName", "snmp_enable"], [2, "width", "580px"], [2, "margin-top", "20px", "margin-left", "0"], [2, "float", "right"], ["type", "button", 1, "redBtn", "actionBtn", 3, "click"], ["type", "submit", 1, "submitBtn", "actionBtn"], ["min", "0", "max", "100", "step", "1", "formControlName", "volume", 3, "input", "mousedown"], ["min", "-79", "max", "16", "step", "1", "formControlName", "volume", 3, "input", "mousedown"], ["matInput", "", "placeholder", "Static IP Address", "formControlName", "static_ip_addr", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Netmask", "formControlName", "static_netmask", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Default Gateway IP Address", "formControlName", "static_gateway", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "DHCP Hostname", "formControlName", "dhcp_name", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Primary DNS IP Address", "formControlName", "dns1_server", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Alternative DNS IP Address", "formControlName", "dns2_server", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "URL", "formControlName", "fw_update_url", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Old Password", "type", "password", 1, "pwdInput", 3, "value", "input"], ["matInput", "", "placeholder", "New Password", "type", "password", 1, "pwdInput", 3, "value", "input"], ["matInput", "", "placeholder", "Confirm Password", "type", "password", 1, "pwdInput", 3, "value", "input"], ["matInput", "", "placeholder", "Password", "type", "password", 1, "pwdInput", 3, "value", "input"], ["aria-label", "Select an option", "formControlName", "relay_3"], ["aria-label", "Select an option", "formControlName", "relay_4"]], template: function SettingsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "link", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("mouseup", function SettingsComponent_Template_div_mouseup_1_listener() { return ctx.submitVolume(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, SettingsComponent_div_3_Template, 203, 56, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "img", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](12, "Help");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "h4", null, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15, "Device Alias");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](17, " Define an alias for the device. Useful for distinguishing multiple devices on the same network and browser favorites. Need to reload page to view changes. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "h4", null, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](20, "Device Description");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](22, " Small description that can be used to better identify the device. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](23, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](24, " This description can be used by SNMP, for example. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "h4", null, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28, "Master Volume");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](30, " Use the master volume slider to adjust in real-time the general output volume of the device. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](32, "Network Settings");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](33, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](34, "h4", null, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](36, "Ethernet DHCP");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](37, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](38, " Enable ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](39, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](40, "\"DHCP\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](41, " for automatic assignment of IP address, Netmask, Gateway and Primary/Alternative DNS.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](42, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](43, " Select ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](44, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](45, "\"Static\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](46, " for manually assigning IP address, Netmask, Gateway and Primary/Alternative DNS.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](47, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](48, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](49, "Note:");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](50, " If set to ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](51, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](52, "\"Static\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](53, ", all fields are mandatory (except Alternative DNS).");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](54, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](55, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](56, "DHCP Host Name");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](57, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](58, " When ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](59, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](60, "\"DHCP\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](61, " is selected as protocol, you can optionally set a DHCP Host Name to be sent in the DHCP request. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](62, "h4", null, 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](64, "DNS");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](65, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](66, " Choose the method to define the selection of Domain Name Server.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](67, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](68, " If ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](69, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](70, "\"Auto\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](71, ", the device will automatically retrieve the DNS servers.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](72, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](73, " If ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](74, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](75, "\"Manual\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](76, ", you will have to manually indicate at least one DNS server. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](77, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](78, "Time Settings");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](79, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](80, "h4", null, 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](82, "Timezone");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](83, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](84, " Select the timezone more appropriate to the device. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](85, "h4", null, 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](87, "NTP");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](88, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](89, " Set up to 3 NTP servers for internet time adjustment. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](90, "h3", null, 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](92, "Security Settings");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](93, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](94, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](95, "Reset factory defaults");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](96, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](97, " Enable or disable the ability to reset the device to its factory default settings. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](98, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](99, "Update function");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](100, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](101, " Enable or disable the Web Update function of the device. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](102, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](103, "Automatic firmware update");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](104, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](105, " Enable or disable the automatic update of the device.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](106, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](107, " The MS-500A will check the update URL overnight, after 02:00, and will install the firmware update if it detects that the file has changed. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](108, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](109, "Automatic firmware update URL");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](110, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](111, " Set the URL from where the device should download the firmware package to update.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](112, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](113, " Available when Automatic firmware update is enabled. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](114, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](115, "Reboot Function");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](116, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](117, " Enable or disable the ability to reboot the device from the web UI Reboot page. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](118, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](119, "Web UI password");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](120, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](121, " Set a new Web UI password for the current admin user.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](122, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](123, " If the new password is empty, login will be disabled. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](124, "h4", null, 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](126, "Additional Certificates");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](127, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](128, " Upload here additional CA Certificates (.crt) file that might be required to secure the connection with the device ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](129, "h3", null, 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](131, "Relay Configuration");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](132, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](133, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](134, " Activate relay during SIP calls or playback of a notification.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](135, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](136, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](137, "Note:");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](138, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](139, " Input function is not available while the relay is ON.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](140, "h3", null, 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](142, "SNMP Configuration");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](143, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](144, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](145, " Activate or deactivate SNMP.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](146, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](147, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](148, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.dataIsAvailable);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx.show_loading_component);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx.submitMessage);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", ctx.device_model === "MS-775" || ctx.device_model === "CZA-1300");
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_8__["NgIf"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["ɵangular_packages_forms_forms_y"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroupDirective"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControlName"], _angular_common__WEBPACK_IMPORTED_MODULE_8__["NgClass"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_9__["DefaultClassDirective"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_10__["MatAccordion"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_10__["MatExpansionPanel"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_10__["MatExpansionPanelHeader"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_10__["MatExpansionPanelTitle"], _angular_material_form_field__WEBPACK_IMPORTED_MODULE_11__["MatFormField"], _angular_material_select__WEBPACK_IMPORTED_MODULE_12__["MatSelect"], _angular_material_core__WEBPACK_IMPORTED_MODULE_13__["MatOption"], _timezone_selector_timezone_selector_component__WEBPACK_IMPORTED_MODULE_2__["TimezoneSelectorComponent"], _angular_material_radio__WEBPACK_IMPORTED_MODULE_14__["MatRadioGroup"], _angular_material_radio__WEBPACK_IMPORTED_MODULE_14__["MatRadioButton"], _additional_certificates_additional_certificates_component__WEBPACK_IMPORTED_MODULE_15__["AdditionalCertificatesComponent"], _angular_material_slider__WEBPACK_IMPORTED_MODULE_16__["MatSlider"]], styles: [".pwdInput[_ngcontent-%COMP%] {\n  width: 100px;\n  margin-right: 2px;\n  padding: 3px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvc2V0dGluZ3Mvc2V0dGluZ3MuY29tcG9uZW50LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNFLFlBQVk7RUFDWixpQkFBaUI7RUFDakIsWUFBWTtBQUNkIiwiZmlsZSI6InNyYy9hcHAvc2V0dGluZ3Mvc2V0dGluZ3MuY29tcG9uZW50LmNzcyIsInNvdXJjZXNDb250ZW50IjpbIi5wd2RJbnB1dCB7XG4gIHdpZHRoOiAxMDBweDtcbiAgbWFyZ2luLXJpZ2h0OiAycHg7XG4gIHBhZGRpbmc6IDNweDtcbn1cbiJdfQ== */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](SettingsComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-settings',
                templateUrl: './settings.component.html',
                styleUrls: ['./settings.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_3__["DeviceConfigService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__["HTTPResponseHandlerService"] }, { type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_5__["SystemInfoService"] }, { type: _services_system_functions_service__WEBPACK_IMPORTED_MODULE_6__["SystemFunctionsService"] }, { type: _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_7__["ToastrMessageService"] }]; }, { timezone: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["ViewChild"],
            args: [_timezone_selector_timezone_selector_component__WEBPACK_IMPORTED_MODULE_2__["TimezoneSelectorComponent"]]
        }] }); })();


/***/ }),

/***/ "8K7A":
/*!******************************************************!*\
  !*** ./src/app/services/system-functions.service.ts ***!
  \******************************************************/
/*! exports provided: SystemFunctionsService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SystemFunctionsService", function() { return SystemFunctionsService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../environments/environment */ "AytR");







const REBOOT_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_4__["environment"].rebootEndpoint;
//const APP_STATE_ENDPOINT = environment.appStateEndpoint;
const HOME_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_4__["environment"].homeEndpoint;
class SystemFunctionsService {
    constructor(httpClient) {
        this.httpClient = httpClient;
        this.httpOptions = {
            headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpHeaders"]({
                'Content-Type': 'application/json'
            }),
            observe: 'response'
        };
    }
    reboot() {
        //console.log('REBOOT_ENDPOINT get "%s"', REBOOT_ENDPOINT);
        return this.httpClient.get(REBOOT_ENDPOINT, this.httpOptions).pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["catchError"])(err1 => this.handleError(err1)));
    }
    appIsRunning() {
        //console.log('Home endpoint get "%s"', HOME_ENDPOINT);
        return this.httpClient.get(HOME_ENDPOINT, { observe: 'response' }).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["catchError"])(err1 => this.handleError(err1)));
    }
    /*getAppState(): Observable<any> {
      console.log('Checking if backend is working...');
      return this.httpClient.get<string>(APP_STATE_ENDPOINT).pipe(
          timeout(2000),
          catchError(e => {
            console.log("timeout");
            // do something on a timeout
            return of(false);
          })
      );
    }*/
    /*async isAppReady(callback){
      console.log("is app ready? wait 1 sec before trying...")
      setTimeout( () => {
        this.getAppState().subscribe(res => {
          console.log(res);
          console.log(res === false);
          if (res === false) {
            console.log("Wait");
            this.checkAppState(callback);
          } else { //res.body === true
            console.log("Clear");
            console.log("wait 1 sec before trying again just to be sure...");
            setTimeout( () => {
              this.getAppState().subscribe(res => {
                console.log(res);
                console.log(res === false);
                if (res === false) {
                  console.log("Wait");
                  this.checkAppState(callback);
                } else { //res.body === true
                  console.log("Clear");
                  callback();
                }
              });
            }, 2000);
          }
        });
      }, 1000);
    }*/
    /*async checkAppState() {
      return new Promise<boolean>( resolve => {
        this.getAppState().subscribe(res => {
          console.log(res);
          //when app is unreachable, res === null?
          if (res === null) {
            console.log("Wait");
            resolve(false);
          } else if (res.status === 200 && res.body === false) {
            console.log("Wait");
            resolve(false);
          } else { //res.body === true
            console.log("Clear");
            resolve(true);
          }
        });
      });
    }*/
    /*checkAppState(callback) {
      setTimeout( () => {
        this.getAppState().subscribe(res => {
          console.log(res);
          //when app is unreachable, res === null?
          if (res === false) {
            console.log("Wait");
            this.checkAppState(callback);
          } else { //res.body === true
            console.log("Clear");
            callback();
          }
        });
      }, 1000);
    }*/
    handleError(error) {
        if (error.error instanceof ErrorEvent) {
            // A client-side or network error occurred. Handle it accordingly.
            console.error('An error occurred:', error.error.message);
        }
        else {
            // The backend returned an unsuccessful response code.
            // The response body may contain clues as to what went wrong.
            console.error(`Backend returned code ${error.status}, ` +
                `body was: ${error.error}`);
        }
        // Return an observable with a user-facing error message.
        //return throwError('Something bad happened; please try again later.');
        return Object(rxjs__WEBPACK_IMPORTED_MODULE_2__["of"])(error); //returns HttpErrorResponse with status 0
    }
}
SystemFunctionsService.ɵfac = function SystemFunctionsService_Factory(t) { return new (t || SystemFunctionsService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpClient"])); };
SystemFunctionsService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: SystemFunctionsService, factory: SystemFunctionsService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](SystemFunctionsService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpClient"] }]; }, null); })();


/***/ }),

/***/ "9vUh":
/*!****************************************!*\
  !*** ./src/app/home/home.component.ts ***!
  \****************************************/
/*! exports provided: HomeComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HomeComponent", function() { return HomeComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/system-info.service */ "4e9C");
/* harmony import */ var _services_cz300_settings_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/cz300-settings.service */ "GANk");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_material_card__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/card */ "Wp6s");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/slide-toggle */ "1jcm");
/* harmony import */ var _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/progress-spinner */ "Xa2L");












function HomeComponent_div_5_tr_45_Template(rf, ctx) { if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_tr_45_Template_td_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r19); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](96); return ctx_r18.scrollToId(_r6); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "SIP Remote Peer");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r12.appStatusJSON["sipPeer"]);
} }
function HomeComponent_div_5_tr_52_Template(rf, ctx) { if (rf & 1) {
    const _r21 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_tr_52_Template_td_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r21); const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](101); return ctx_r20.scrollToId(_r7); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "SIP Registration Code");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r13.appStatusJSON["sipRegistrationCode"]);
} }
function HomeComponent_div_5_mat_card_53_Template(rf, ctx) { if (rf & 1) {
    const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-card");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-card-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Inputs and Relays");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "mat-card-content");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "table", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "th", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "th", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8, " MODE ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10, " STATE ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_53_Template_td_click_12_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23); const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](125); return ctx_r22.scrollToId(_r9); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13, "1");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "td", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "td", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_53_Template_td_click_21_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23); const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](125); return ctx_r24.scrollToId(_r9); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](22, "2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "td", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "td", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r14.appStatusJSON["ioStatus"]["io1"]["mode"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r14.appStatusJSON["ioStatus"]["io1"]["state"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r14.appStatusJSON["ioStatus"]["io2"]["mode"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r14.appStatusJSON["ioStatus"]["io2"]["state"]);
} }
function HomeComponent_div_5_mat_card_54_Template(rf, ctx) { if (rf & 1) {
    const _r26 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-card");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-card-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Power Usage");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "mat-card-content");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_54_Template_td_click_6_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r26); const ctx_r25 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](69); return ctx_r25.scrollToId(_r5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Real-Time");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_54_Template_td_click_12_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r26); const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](69); return ctx_r27.scrollToId(_r5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13, "1 Hour Average");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_54_Template_td_click_18_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r26); const ctx_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](69); return ctx_r28.scrollToId(_r5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19, "1 Hour Peak");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r15.appStatusJSON["powerStatus"]["realTime"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r15.appStatusJSON["powerStatus"]["powerAvg"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r15.appStatusJSON["powerStatus"]["powerMax"]);
} }
function HomeComponent_div_5_mat_card_55_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    const _r33 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_55_ng_container_9_Template_td_click_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r33); const ctx_r32 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3); const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](153); return ctx_r32.scrollToId(_r10); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const idx_r31 = ctx.$implicit;
    const ctx_r29 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("Input ", idx_r31.toString(), "");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r29.appStatusJSON["ioStatus"]["in" + idx_r31.toString()]);
} }
function HomeComponent_div_5_mat_card_55_ng_container_10_Template(rf, ctx) { if (rf & 1) {
    const _r36 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_55_ng_container_10_Template_td_click_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r36); const ctx_r35 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3); const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](153); return ctx_r35.scrollToId(_r10); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const idx_r34 = ctx.$implicit;
    const ctx_r30 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("Output ", idx_r34.toString(), "");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r30.appStatusJSON["ioStatus"]["out" + idx_r34.toString()]);
} }
const _c0 = function () { return [1, 2, 3, 4]; };
function HomeComponent_div_5_mat_card_55_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-card");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-card-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Inputs and Outputs");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "mat-card-content", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "table", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "th", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8, " STATE ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, HomeComponent_div_5_mat_card_55_ng_container_9_Template, 7, 2, "ng-container", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, HomeComponent_div_5_mat_card_55_ng_container_10_Template, 7, 2, "ng-container", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](2, _c0));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction0"](3, _c0));
} }
function HomeComponent_div_5_mat_card_56_mat_spinner_23_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "mat-spinner", 42);
} if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("diameter", 30);
} }
const _c1 = function (a0) { return { "color": a0 }; };
function HomeComponent_div_5_mat_card_56_Template(rf, ctx) { if (rf & 1) {
    const _r39 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-card");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-card-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Amplifier Status");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "mat-card-content", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "table", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "th", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "th", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8, " STATE ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_56_Template_td_click_10_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r38 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](168); return ctx_r38.scrollToId(_r11); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11, "Input");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "td", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "label", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "tr", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "td", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_mat_card_56_Template_td_click_16_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r40 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](168); return ctx_r40.scrollToId(_r11); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](17, "Output");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "label", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "div", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "mat-slide-toggle", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function HomeComponent_div_5_mat_card_56_Template_mat_slide_toggle_change_22_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r41 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r41.changeAmpStatus($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](23, HomeComponent_div_5_mat_card_56_mat_spinner_23_Template, 1, 1, "mat-spinner", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](7, _c1, ctx_r17.appStatusJSON["ampStatus"]["enabled"] ? "green" : "red"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r17.appStatusJSON["ampStatus"]["enabled"] ? "POWERED" : "NOT POWERED");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", ctx_r17.output_power_style);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r17.appStatusJSON["ampStatus"]["power"] === 0 ? "STANDBY DISABLED" : "STANDBY ENABLED");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r17.toggle_checked)("disabled", ctx_r17.toggle_disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r17.toggle_loading);
} }
function HomeComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    const _r43 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-card");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "mat-card-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "General");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "mat-card-content");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_Template_td_click_7_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r43); const ctx_r42 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](11); return ctx_r42.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8, "Currently Playing");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "mat-card");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "mat-card-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14, "Notification");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "mat-card-content");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_Template_td_click_18_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r43); const ctx_r44 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](31); return ctx_r44.scrollToId(_r3); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19, "Current Status");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "mat-card");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "mat-card-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25, "Background Music");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "mat-card-content");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](28, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_Template_td_click_29_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r43); const ctx_r45 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](50); return ctx_r45.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](30, "Current Status");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](34, "mat-card");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](35, "mat-card-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](36, "SIP");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](37, "mat-card-content");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](38, "table", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](39, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](40, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_Template_td_click_40_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r43); const ctx_r46 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](69); return ctx_r46.scrollToId(_r5); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](41, "Current Status");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](42, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](43, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](44);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](45, HomeComponent_div_5_tr_45_Template, 6, 1, "tr", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](46, "tr", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](47, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HomeComponent_div_5_Template_td_click_47_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r43); const ctx_r47 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](115); return ctx_r47.scrollToId(_r8); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](48, "SIP Registration Status");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](49, "td", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](50, "label", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](52, HomeComponent_div_5_tr_52_Template, 6, 1, "tr", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](53, HomeComponent_div_5_mat_card_53_Template, 29, 4, "mat-card", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](54, HomeComponent_div_5_mat_card_54_Template, 23, 3, "mat-card", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](55, HomeComponent_div_5_mat_card_55_Template, 11, 4, "mat-card", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](56, HomeComponent_div_5_mat_card_56_Template, 24, 9, "mat-card", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.showAudioStatus(ctx_r0.appStatusJSON["audioStatus"]));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.showSourceStatus(ctx_r0.appStatusJSON["hpnStatus"]));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.showSourceStatus(ctx_r0.appStatusJSON["bgmStatus"]));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.showSIPStatus(ctx_r0.appStatusJSON["sipStatus"]));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.appStatusJSON["sipPeer"] !== null);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.appStatusJSON["sipRegStatus"] === "REGISTERED" ? "Registered" : "Not registered");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.appStatusJSON["sipRegistrationCode"] !== null);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model === "MS-300B" || ctx_r0.device_model === "MS-500A");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model === "MS-700");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model === "MS-700" || ctx_r0.device_model === "CZA-1300" || ctx_r0.device_model === "MS-775" || ctx_r0.device_model === "Barionet-MAE");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model === "CZA-1300" || ctx_r0.device_model === "MS-775");
} }
function HomeComponent_div_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](3, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](5, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](8, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](9, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](10, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](11, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](12, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](13, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](14, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, "Getting status...");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
class HomeComponent {
    constructor(configsService, toastrService, httpResponseHandler, systemInfoService, cz300SettingsService) {
        this.configsService = configsService;
        this.toastrService = toastrService;
        this.httpResponseHandler = httpResponseHandler;
        this.systemInfoService = systemInfoService;
        this.cz300SettingsService = cz300SettingsService;
        this.count500Error = 0;
        this.toggle_loading = false;
        this.toggle_disabled = false;
        this.KNOWN_DEVICE_MODELS = ["MS-300B", "MS-500A", "MS-700", "MS-775", "CZA-1300", "Barionet-MAE"];
    }
    ngOnInit() {
        this.dataIsAvailable = false;
        this.systemInfoService.getSystemInfo(["device_model"]).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    this.device_model = data.body["device_model"];
                    if (!this.KNOWN_DEVICE_MODELS.includes(this.device_model)) {
                        this.toastrService.showErrorMessage("Unknown board type \"" + this.device_model + "\"!");
                    }
                    this.loadDataFromDevice();
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    loadDataFromDevice() {
        this.systemInfoService.getAppStatus().subscribe(data => {
            switch (data.status) {
                case 200:
                    this.count500Error = 0;
                    if (data.body.hasOwnProperty('appStatus')) {
                        let bodyJSON = JSON.parse(data.body['appStatus']);
                        // ["ampStatus"]["enabled"] -> INPUT -> true/false : "POWERED"/"NOT POWERED"
                        // ["ampStatus"]["power"] -> OUTPUT -> 1 / 0 : "STDBY"/"ACTIVE"
                        // 1 -> "STDBY" -> "STANDBY ENABLED" -> orange
                        // 0 -> "ACTIVE" -> "STANDBY DISABLED" -> green
                        if (this.toggle_loading) { // loading means that the amp standby status should not update, use previous value
                            if (Object.keys(this.appStatusJSON).includes("ampStatus") && Object.keys(this.appStatusJSON["ampStatus"]).includes("power")) {
                                bodyJSON["ampStatus"]["power"] = this.appStatusJSON["ampStatus"]["power"];
                            }
                        }
                        this.appStatusJSON = bodyJSON;
                        if (!this.toggle_loading && Object.keys(this.appStatusJSON).includes("ampStatus") && Object.keys(this.appStatusJSON["ampStatus"]).includes("power")) {
                            this.toggle_checked = this.appStatusJSON["ampStatus"]["power"] === 1;
                            this.output_power_style = { 'color': this.appStatusJSON['ampStatus']['power'] === 0 ? 'green' : 'orange' };
                        }
                        this.dataIsAvailable = true;
                        this.timeout = setTimeout(() => { if (window.location.pathname === '/home')
                            this.loadDataFromDevice(); }, 1000);
                    }
                    else {
                        this.toastrService.showErrorMessage("Error retrieving App status.");
                    }
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    // this.httpResponseHandler.handle500HttpErrorResponse();
                    this.dataIsAvailable = false;
                    this.count500Error++;
                    if (this.count500Error === 30) {
                        this.httpResponseHandler.handle500HttpErrorResponse();
                        this.timeout = setTimeout(() => { if (window.location.pathname === '/home')
                            this.loadDataFromDevice(); }, 1000);
                    }
                    else {
                        this.timeout = setTimeout(() => { if (window.location.pathname === '/home')
                            this.loadDataFromDevice(); }, 1000);
                    }
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    ngOnDestroy() {
        //clearTimeout(this.timeout);
    }
    showSIPStatus(sipStatus) {
        let stringStatus;
        // NOT CONFIGURED | IDLE | CALLING | RINGING | CONNECTED | GETTING_NOTIF
        switch (sipStatus) {
            case 'NOT CONFIGURED':
                stringStatus = "Not configured";
                break;
            case 'IDLE':
                stringStatus = "Idle";
                break;
            case 'CALLING':
                stringStatus = "Calling";
                break;
            case 'RINGING':
                stringStatus = "Ringing";
                break;
            case 'CONNECTED':
                stringStatus = "Connected";
                break;
            case 'GETTING_NOTIF':
                stringStatus = "Getting notification";
                break;
            default:
                console.log("SIP status", sipStatus, "unrecognized");
                //this.toastr.show("Error retrieving App status.", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                this.toastrService.showErrorMessage("Error retrieving App status.");
        }
        return stringStatus;
    }
    showAudioStatus(audioStatus) {
        let stringStatus;
        // IDLE | SIP | HPN | BGM
        switch (audioStatus) {
            case 'IDLE':
                stringStatus = "Nothing";
                break;
            case 'SIP':
                stringStatus = "SIP";
                break;
            case 'HPN':
                stringStatus = "Notification";
                break;
            case 'BGM':
                stringStatus = "Background Music";
                break;
            default:
                console.log("Audio status", audioStatus, "unrecognized");
                //this.toastr.show("Error retrieving App status.", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                this.toastrService.showErrorMessage("Error retrieving App status.");
        }
        return stringStatus;
    }
    showSourceStatus(sourceStatus) {
        let stringStatus;
        // NOT CONFIGURED | IDLE | ALIVE
        switch (sourceStatus) {
            case 'IDLE':
                stringStatus = "Idle";
                break;
            case 'NOT CONFIGURED':
                stringStatus = "Not configured";
                break;
            case 'ALIVE':
                stringStatus = "Alive";
                break;
            default:
                console.log("Source status", sourceStatus, "unrecognized");
                //this.toastr.show("Error retrieving App status.", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                this.toastrService.showErrorMessage("Error retrieving App status.");
        }
        return stringStatus;
    }
    scrollToId(el) {
        el.scrollIntoView({ 'behavior': 'smooth' });
    }
    changeAmpStatus($event) {
        this.toggle_checked = $event.checked;
        this.toggle_loading = true;
        this.toggle_disabled = true;
        this.output_power_style = { 'color': 'grey' };
        this.cz300SettingsService.switchAmpStatus().subscribe(data => {
            switch (data.status) {
                case 200:
                    setTimeout(() => {
                        this.toggle_loading = false;
                        this.toggle_disabled = false;
                    }, 3000);
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    this.toggle_loading = false;
                    this.toggle_disabled = false;
                    break;
                default:
                    this.toastrService.showErrorMessage("It was not possible to switch the amplifier standby status");
                    this.toggle_loading = false;
                    this.toggle_disabled = false;
                    break;
            }
        });
    }
}
HomeComponent.ɵfac = function HomeComponent_Factory(t) { return new (t || HomeComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_1__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_toastr_message_service__WEBPACK_IMPORTED_MODULE_2__["ToastrMessageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_4__["SystemInfoService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_cz300_settings_service__WEBPACK_IMPORTED_MODULE_5__["CZ300SettingsService"])); };
HomeComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: HomeComponent, selectors: [["app-home"]], decls: 190, vars: 4, consts: [["href", "https://fonts.googleapis.com/icon?family=Material+Icons", "rel", "stylesheet"], [1, "container"], [1, "tab-content"], ["style", "margin: 20px 20px 0 0;", 4, "ngIf"], [4, "ngIf"], [1, "tab-help"], ["audioStatusHelp", ""], ["hpnStatusHelp", ""], ["bgmStatusHelp", ""], ["sipStatusHelp", ""], ["sipPeerHelp", ""], ["sipRegCodeHelp", ""], ["sipRegStatusHelp", ""], [3, "hidden"], ["inputsRelayHelp", ""], ["inputsOutputsHelp", ""], ["amplifierStatus", ""], [2, "color", "green"], [2, "color", "red"], [2, "color", "orange"], [2, "margin", "20px 20px 0 0"], [1, "t1"], [2, "line-height", "30px"], [1, "label", 3, "click"], [1, "value"], [2, "font-style", "italic"], ["style", "line-height: 30px;", 4, "ngIf"], ["id", "inputsRelaysTable", 1, "t1", 2, "border-collapse", "collapse"], [1, "bottom-borders", 2, "line-height", "30px"], [1, "first-td", "right-borders"], [1, "right-borders", "td-width"], [1, "td-width"], [1, "first-td", "right-borders", 3, "click"], [2, "padding", "8px 8px 15px 8px"], ["id", "inputsOutputsTable", 2, "border-collapse", "collapse"], [4, "ngFor", "ngForOf"], [2, "border-collapse", "collapse", "width", "100%"], [2, "font-style", "italic", 3, "ngStyle"], ["id", "ampStandby", 1, "td-width"], [2, "width", "4vw", "display", "flex", "flex-direction", "row", "justify-content", "center", "align-items", "center"], [3, "checked", "disabled", "change"], [3, "diameter", 4, "ngIf"], [3, "diameter"], ["id", "loading-status"], [1, "lds-default"]], template: function HomeComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "link", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4, "Application Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, HomeComponent_div_5_Template, 57, 11, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](6, HomeComponent_div_6_Template, 17, 0, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, "Help");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "h4", null, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](12, "Audio Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14, " Status of the Audio: indicates which audio source is currently playing.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](15, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, " Possible states are: ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](20, "Nothing");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](23, "SIP");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](26, "Background Music");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](28, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](29, "Notification");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](30, "h4", null, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](32, "Notification Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](33, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](34, " Status of the High Priority Notification.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](35, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](36, " Possible states are: ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](37, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](38, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](39, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](40, "Not configured");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](41, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](42, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](43, "Idle");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](44, " when it is configured but source stream is dead.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](45, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](46, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](47, "Alive");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](48, " when it is configured and source stream is alive.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](49, "h4", null, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](51, "Background Music Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](52, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](53, " Status of the Background Music.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](54, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](55, " Possible states are: ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](56, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](57, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](58, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](59, "Not configured");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](60, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](61, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](62, "Idle");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](63, " when it is configured but source stream is dead.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](64, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](65, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](66, "Alive");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](67, " when it is configured and source stream is alive.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](68, "h4", null, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](70, "SIP Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](71, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](72, " Status of SIP.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](73, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](74, " Possible states are: ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](75, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](76, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](77, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](78, "Not configured");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](79, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](80, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](81, "Idle");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](82, " when SIP is configured without an active call.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](83, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](84, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](85, "Calling");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](86, " when it is currently calling a peer.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](87, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](88, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](89, "Ringing");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](90, " when it is currently receiving a call.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](91, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](92, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](93, "Connected");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](94, " when a call is established.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](95, "h4", null, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](97, "SIP Peer");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](98, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](99, " Remote endpoint from a SIP call, visible only when a SIP call is established. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](100, "h4", null, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](102, "SIP Registration Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](103, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](104, " Status of SIP Registration.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](105, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](106, " Possible states are: ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](107, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](108, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](109, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](110, "Registered");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](111, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](112, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](113, "Not registered");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](114, "h4", null, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](116, "SIP Registration Code");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](117, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](118, " Code returned by SIP Server to the latest registration attempt.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](119, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](120, " If SIP Registration Status is ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](121, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](122, "Not registered");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](123, ", this code can provide more detailed information about why the registration process failed. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](124, "div", 13, 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](126, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](127, "Inputs and Relays");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](128, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](129, " Device's relays and inputs current mode and status.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](130, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](131, " The pins can be in mode ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](132, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](133, "Relay");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](134, " or ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](135, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](136, "Input");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](137, ", and their state can be ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](138, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](139, "On");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](140, " or ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](141, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](142, "Off");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](143, ".");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](144, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](145, " If mode is ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](146, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](147, "Relay");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](148, ", state will always be ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](149, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](150, "On");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](151, ". ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](152, "div", 13, 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](154, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](155, "Inputs and Outputs");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](156, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](157, " Device's inputs and outputs current status.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](158, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](159, " Their state can be ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](160, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](161, "ON");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](162, " or ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](163, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](164, "OFF");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](165, ".");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](166, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](167, "div", null, 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](169, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](170, "Amplifier Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](171, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](172, "Indicates the current Amplifier status.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](173, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](174, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](175, "For the input, the status can be ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](176, "span", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](177, "POWERED");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](178, " or ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](179, "span", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](180, "NOT POWERED");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](181, ".");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](182, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](183, "For the output, the status can be ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](184, "span", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](185, "ACTIVE");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](186, " or ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](187, "span", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](188, "STDBY");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](189, ".");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.dataIsAvailable);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx.dataIsAvailable);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](118);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", ctx.device_model === "MS-700" || ctx.device_model === "MS-775" || ctx.device_model === "CZA-1300");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](28);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", ctx.device_model !== "MS-700" && ctx.device_model !== "MS-775" && ctx.device_model !== "CZA-1300");
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_6__["NgIf"], _angular_material_card__WEBPACK_IMPORTED_MODULE_7__["MatCard"], _angular_material_card__WEBPACK_IMPORTED_MODULE_7__["MatCardTitle"], _angular_material_card__WEBPACK_IMPORTED_MODULE_7__["MatCardContent"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgStyle"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_8__["DefaultStyleDirective"], _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_9__["MatSlideToggle"], _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_10__["MatSpinner"]], styles: ["mat-card[_ngcontent-%COMP%] {\n    \n    max-width: 420px;\n    border-radius: 25px;\n    border: 1px solid #182857;\n    padding: 0!important;\n    overflow: hidden;\n    margin: 20px;\n}\n\nmat-card-title[_ngcontent-%COMP%] {\n    background-color: #182857;\n    color: white;\n    text-align: center;\n    font-size: 18px;\n    padding: 5px;\n}\n\n.right-borders[_ngcontent-%COMP%] {\n    border-right: #AAAAAA 1px solid;\n}\n\n.bottom-borders[_ngcontent-%COMP%] {\n    border-bottom: #AAAAAA 1px solid;\n}\n\n.td-width[_ngcontent-%COMP%] {\n    min-width: 100px;\n    text-align: center;\n}\n\n.first-td[_ngcontent-%COMP%] {\n    width: 140px;\n    text-align: center;\n}\n\n#inputsRelaysTable[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]:nth-child(even){background-color: #f2f2f2;}\n\n#inputsRelaysTable[_ngcontent-%COMP%] {\n    \n    margin: auto;\n}\n\n#inputsOutputsTable[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]:nth-child(even){background-color: #f2f2f2;}\n\n#inputsOutputsTable[_ngcontent-%COMP%] {\n    width: 100%;\n}\n\n\n\n\n\n\n\n.lds-default[_ngcontent-%COMP%] {\n    display: inline-block;\n    position: relative;\n    width: 80px;\n    height: 80px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%] {\n    position: absolute;\n    width: 6px;\n    height: 6px;\n    background: #182857;\n    border-radius: 50%;\n    -webkit-animation: lds-default 1.2s linear infinite;\n            animation: lds-default 1.2s linear infinite;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(1) {\n    -webkit-animation-delay: 0s;\n            animation-delay: 0s;\n    top: 37px;\n    left: 66px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(2) {\n    -webkit-animation-delay: -0.1s;\n            animation-delay: -0.1s;\n    top: 22px;\n    left: 62px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(3) {\n    -webkit-animation-delay: -0.2s;\n            animation-delay: -0.2s;\n    top: 11px;\n    left: 52px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(4) {\n    -webkit-animation-delay: -0.3s;\n            animation-delay: -0.3s;\n    top: 7px;\n    left: 37px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(5) {\n    -webkit-animation-delay: -0.4s;\n            animation-delay: -0.4s;\n    top: 11px;\n    left: 22px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(6) {\n    -webkit-animation-delay: -0.5s;\n            animation-delay: -0.5s;\n    top: 22px;\n    left: 11px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(7) {\n    -webkit-animation-delay: -0.6s;\n            animation-delay: -0.6s;\n    top: 37px;\n    left: 7px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(8) {\n    -webkit-animation-delay: -0.7s;\n            animation-delay: -0.7s;\n    top: 52px;\n    left: 11px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(9) {\n    -webkit-animation-delay: -0.8s;\n            animation-delay: -0.8s;\n    top: 62px;\n    left: 22px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(10) {\n    -webkit-animation-delay: -0.9s;\n            animation-delay: -0.9s;\n    top: 66px;\n    left: 37px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(11) {\n    -webkit-animation-delay: -1s;\n            animation-delay: -1s;\n    top: 62px;\n    left: 52px;\n}\n\n.lds-default[_ngcontent-%COMP%]   div[_ngcontent-%COMP%]:nth-child(12) {\n    -webkit-animation-delay: -1.1s;\n            animation-delay: -1.1s;\n    top: 52px;\n    left: 62px;\n}\n\n@-webkit-keyframes lds-default {\n    0%, 20%, 80%, 100% {\n        transform: scale(1);\n    }\n    50% {\n        transform: scale(1.5);\n    }\n}\n\n@keyframes lds-default {\n    0%, 20%, 80%, 100% {\n        transform: scale(1);\n    }\n    50% {\n        transform: scale(1.5);\n    }\n}\n\n#loading-status[_ngcontent-%COMP%] {\n    position: relative;\n    margin-top: 20%;\n    text-align: center;\n}\n\n.example-section[_ngcontent-%COMP%] {\n    display: flex;\n    align-content: center;\n    align-items: center;\n}\n\n.example-margin[_ngcontent-%COMP%] {\n    margin: 10px;\n}\n\n#ampStandby[_ngcontent-%COMP%] {\n    display: flex;\n    flex-direction: row;\n    justify-content: flex-end;\n    align-items: center;\n}\n\n.ampStandbyDiv[_ngcontent-%COMP%] {\n    width: 80px;\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](HomeComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-home',
                templateUrl: './home.component.html',
                styleUrls: ['./home.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_1__["DeviceConfigService"] }, { type: _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_2__["ToastrMessageService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"] }, { type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_4__["SystemInfoService"] }, { type: _services_cz300_settings_service__WEBPACK_IMPORTED_MODULE_5__["CZ300SettingsService"] }]; }, null); })();


/***/ }),

/***/ "AytR":
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/*! exports provided: environment */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "environment", function() { return environment; });
// This file can be replaced during build by using the `fileReplacements` array.
// `ng build --prod` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.
const environment = {
    production: false,
    headerSysInfoEndpoint: "/rest/info/header",
    fwInfoEndpoint: "/rest/info/firmware",
    deviceUcisEndpoint: "/rest/uci",
    settingsEndpoint: "/rest/settings",
    rebootEndpoint: "/rest/reboot",
    systemStatusEndpoint: "/rest/info/system",
    systemLogEndpoint: "/rest/logs/system",
    downloadLogsEndpoint: "/rest/logs",
    resetFactoryDefaultsEndpoint: "/rest/reset",
    aes67configsEndpoint: "/rest/aes67",
    ptpStatusEndpoint: "/rest/ptp/status",
    ptpConfigEndpoint: "/rest/ptp/config",
    rtpSinkStatusEndpoint: "/rest/sink/status",
    remoteSourcesEndpoint: "/rest/sources",
    sinkEndpoint: "/rest/sink",
    loginEndpoint: "/rest/login",
    appStateEndpoint: "/rest/app/state",
    volumeControlEndpoint: "/rest/settings/volume",
    systemInfoEndpoint: "/rest/system/info",
    systemTypeEndpoint: "/rest/system/type",
    certificatesEndpoint: "/rest/system/cert",
    aes67TestEndpoint: "/rest/aes67/ready",
    fwUpdateEndpoint: "/rest/system/update",
    homeEndpoint: "/",
    appStatusEndpoint: "/rest/app/status",
    switchAmpEndpoint: "/switch-amp"
};
/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/dist/zone-error';  // Included with Angular CLI.


/***/ }),

/***/ "CTeh":
/*!********************************************!*\
  !*** ./src/app/reboot/reboot.component.ts ***!
  \********************************************/
/*! exports provided: RebootComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RebootComponent", function() { return RebootComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_system_functions_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../services/system-functions.service */ "8K7A");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "ofXK");






function RebootComponent_div_2_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "h2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Reboot");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](3, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "p", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](6, "This lets the device restart.");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "button", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function RebootComponent_div_2_div_1_Template_button_click_8_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3); const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r2.rebootSystem(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, "Reboot the device");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", !ctx_r1.reset_opt);
} }
function RebootComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, RebootComponent_div_2_div_1_Template, 10, 1, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "img", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r0.rebooting);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx_r0.rebooting);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.waitingMessage);
} }
class RebootComponent {
    constructor(configsService, systemFuncsService, httpResponseHandler) {
        this.configsService = configsService;
        this.systemFuncsService = systemFuncsService;
        this.httpResponseHandler = httpResponseHandler;
        this.loadFinished = false;
        this.reset_opt = false;
        this.rebooting = false;
        this.subscription = null;
        this.counter = 50;
    }
    ngOnInit() {
        this.configsService.getUcis({ 'defaults_opt': 'security.reset.enabled' }).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    //build device form group
                    if (data.body["security.reset.enabled"] === "true") {
                        this.reset_opt = true;
                    }
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
            this.loadFinished = true;
        });
    }
    rebootSystem() {
        this.systemFuncsService.reboot().subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    // this.url = window.location.protocol + "//" + window.location.hostname; //+ ":80";
                    // this.rebooting = true;
                    // this.countDown();
                    // setTimeout(()=> {
                    //   //console.log("unsubscribe");
                    //   if (this.subscription !== null) this.subscription.unsubscribe()
                    // }, 52000);
                    this.waitingMessage = "Please wait while the device reboots. The page will be automatically reloaded.";
                    this.rebooting = true;
                    setTimeout(() => this.reloadWebUI(), 20000);
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    // countDown(){
    //   this.subscription = interval(1000)
    //       .subscribe(x => {
    //         if (this.counter > 0) this.counter -= 1;
    //       });
    // }
    reloadWebUI() {
        this.systemFuncsService.appIsRunning().subscribe(res => {
            //console.log(res);
            if (res.status === 200) {
                window.location.href = window.location.protocol + '//' + window.location.hostname;
            }
            else {
                setTimeout(() => this.reloadWebUI(), 1000);
            }
        });
    }
}
RebootComponent.ɵfac = function RebootComponent_Factory(t) { return new (t || RebootComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_1__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_functions_service__WEBPACK_IMPORTED_MODULE_2__["SystemFunctionsService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"])); };
RebootComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: RebootComponent, selectors: [["app-reboot"]], decls: 19, vars: 1, consts: [[1, "container"], [1, "tab-content"], [4, "ngIf"], [1, "tab-help"], [1, "content", 3, "hidden"], [1, "loading-ripple"], ["src", "assets/images/Ripple-1s-170px.gif"], [1, "section1"], [2, "font-size", "15px", "font-weight", "normal", "font-family", "'SourceSansPro', Arial, Helvetica, sans-serif", "color", "#333333"], [1, "redBtn", "actionBtn", 3, "disabled", "click"]], template: function RebootComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, RebootComponent_div_2_Template, 8, 3, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Help");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Reboot the device");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, " Click \"Reboot the device\" to restart the device. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11, " The reboot may also be triggered by briefly pushing the \"IP RESET\" button on the fron plate of the MS-500A. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14, "NOTE:");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15, " The feature is disabled if the ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](17, "\"Reset\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18, " function is disabled from the Security Settings page. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.loadFinished);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_4__["NgIf"]], styles: ["#rebootingDiv[_ngcontent-%COMP%] {\n    font-family: Arial, Helvetica, sans-serif;\n    font-size: 13px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvcmVib290L3JlYm9vdC5jb21wb25lbnQuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0lBQ0kseUNBQXlDO0lBQ3pDLGVBQWU7QUFDbkIiLCJmaWxlIjoic3JjL2FwcC9yZWJvb3QvcmVib290LmNvbXBvbmVudC5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyIjcmVib290aW5nRGl2IHtcbiAgICBmb250LWZhbWlseTogQXJpYWwsIEhlbHZldGljYSwgc2Fucy1zZXJpZjtcbiAgICBmb250LXNpemU6IDEzcHg7XG59XG4iXX0= */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](RebootComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-reboot',
                templateUrl: './reboot.component.html',
                styleUrls: ['./reboot.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_1__["DeviceConfigService"] }, { type: _services_system_functions_service__WEBPACK_IMPORTED_MODULE_2__["SystemFunctionsService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"] }]; }, null); })();


/***/ }),

/***/ "GANk":
/*!****************************************************!*\
  !*** ./src/app/services/cz300-settings.service.ts ***!
  \****************************************************/
/*! exports provided: CZ300SettingsService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CZ300SettingsService", function() { return CZ300SettingsService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../environments/environment */ "AytR");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common/http */ "tk/3");







const SWITCH_AMP_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].switchAmpEndpoint;
class CZ300SettingsService {
    constructor(httpClient) {
        this.httpClient = httpClient;
        this.httpOptions = {
            headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpHeaders"]({
                'Content-Type': 'application/json'
            }),
            observe: 'response'
        };
    }
    switchAmpStatus() {
        const url = SWITCH_AMP_ENDPOINT;
        //console.log('REST UCI get "%s"', url);
        return this.httpClient.get(url, this.httpOptions).pipe(
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_2__["catchError"])(err1 => this.handleError(err1)));
    }
    handleError(error) {
        if (error.error instanceof ErrorEvent) {
            // A client-side or network error occurred. Handle it accordingly.
            console.error('An error occurred:', error.error.message);
        }
        else {
            // The backend returned an unsuccessful response code.
            // The response body may contain clues as to what went wrong.
            console.error(`Backend returned code ${error.status}, ` +
                `body was: ${error.error}`);
        }
        // Return an observable with a user-facing error message.
        //return throwError('Something bad happened; please try again later.');
        return Object(rxjs__WEBPACK_IMPORTED_MODULE_1__["of"])(error); //returns HttpErrorResponse with status 0
    }
}
CZ300SettingsService.ɵfac = function CZ300SettingsService_Factory(t) { return new (t || CZ300SettingsService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpClient"])); };
CZ300SettingsService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: CZ300SettingsService, factory: CZ300SettingsService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](CZ300SettingsService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpClient"] }]; }, null); })();


/***/ }),

/***/ "GMR4":
/*!****************************************!*\
  !*** ./src/app/logs/logs.component.ts ***!
  \****************************************/
/*! exports provided: LogsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogsComponent", function() { return LogsComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services/system-info.service */ "4e9C");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");





function LogsComponent_div_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "pre");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.logLines);
} }
class LogsComponent {
    constructor(getSystemInfo, httpResponseHandler) {
        this.getSystemInfo = getSystemInfo;
        this.httpResponseHandler = httpResponseHandler;
        this.loadFinished = false;
        this.logLines = "";
    }
    ngOnInit() {
        this.getLogData();
    }
    getLogData() {
        this.getSystemInfo.getSystemLog().subscribe(data => {
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    if (data.body !== '') {
                        this.logLines = data.body;
                        this.loadFinished = true;
                    }
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    refresh() {
        this.loadFinished = false;
        this.getLogData();
    }
    downloadAllLogs() {
        this.getSystemInfo.downloadLogs().subscribe((response) => {
            switch (response.status) {
                case 200:
                    //console.log(response);
                    let dataType = response.body.type;
                    //console.log(dataType);
                    let filename = response.headers.get('content-disposition').split('=')[1];
                    console.log(response.headers.get('content-disposition'));
                    console.log(filename);
                    filename = filename.replace(/"/g, '');
                    console.log(filename);
                    let binaryData = [];
                    binaryData.push(response.body);
                    let url = window.URL.createObjectURL(new Blob(binaryData, { type: dataType }));
                    //window.open(url);
                    let anchor = document.createElement("a");
                    anchor.download = filename;
                    anchor.href = url;
                    anchor.click();
                    //console.log("file downloaded");
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(response.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", response.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(response.status);
                    break;
            }
        });
    }
}
LogsComponent.ɵfac = function LogsComponent_Factory(t) { return new (t || LogsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_1__["SystemInfoService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_2__["HTTPResponseHandlerService"])); };
LogsComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: LogsComponent, selectors: [["app-logs"]], decls: 11, vars: 1, consts: [["href", "https://fonts.googleapis.com/icon?family=Material+Icons", "rel", "stylesheet"], [1, "container"], ["id", "logHeader"], ["id", "buttons"], [3, "click"], ["id", "logContent", 4, "ngIf"], ["id", "logContent"]], template: function LogsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "link", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4, "System log");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function LogsComponent_Template_button_click_6_listener() { return ctx.downloadAllLogs(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Download all messages");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function LogsComponent_Template_button_click_8_listener() { return ctx.refresh(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, "Refresh");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, LogsComponent_div_10_Template, 3, 1, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.loadFinished);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"]], styles: ["#logHeader[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n}\n\n#logHeader[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%]{\n  margin-left: 16px;\n}\n\n#buttons[_ngcontent-%COMP%] {\n  width: 300px;\n  display: flex;\n  justify-content: space-evenly;\n  align-items: center;\n}\n\n#buttons[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  \n  min-width: 70px;\n  color: rgb(51, 51, 51);\n  cursor: pointer;\n  font-size: 15px;\n}\n\n#logContent[_ngcontent-%COMP%] {\n  background-color: #333333;\n  color: #CCCCCC;\n  border: 1px solid #CCCCCC;\n  overflow: auto;\n  height: 90%;\n  padding: 5px;\n  font-size: 12px;\n  margin: 4px ;\n}\n\npre[_ngcontent-%COMP%] {\n  margin: 0;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvbG9ncy9sb2dzLmNvbXBvbmVudC5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxhQUFhO0VBQ2IsOEJBQThCO0FBQ2hDOztBQUVBO0VBQ0UsaUJBQWlCO0FBQ25COztBQUVBO0VBQ0UsWUFBWTtFQUNaLGFBQWE7RUFDYiw2QkFBNkI7RUFDN0IsbUJBQW1CO0FBQ3JCOztBQUVBO0VBQ0Usd0RBQXdEO0VBQ3hEO29CQUNrQjtFQUNsQixlQUFlO0VBQ2Ysc0JBQXNCO0VBQ3RCLGVBQWU7RUFDZixlQUFlO0FBQ2pCOztBQUVBO0VBQ0UseUJBQXlCO0VBQ3pCLGNBQWM7RUFDZCx5QkFBeUI7RUFDekIsY0FBYztFQUNkLFdBQVc7RUFDWCxZQUFZO0VBQ1osZUFBZTtFQUNmLFlBQVk7QUFDZDs7QUFFQTtFQUNFLFNBQVM7QUFDWCIsImZpbGUiOiJzcmMvYXBwL2xvZ3MvbG9ncy5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiI2xvZ0hlYWRlciB7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cblxuI2xvZ0hlYWRlciBoMntcbiAgbWFyZ2luLWxlZnQ6IDE2cHg7XG59XG5cbiNidXR0b25zIHtcbiAgd2lkdGg6IDMwMHB4O1xuICBkaXNwbGF5OiBmbGV4O1xuICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWV2ZW5seTtcbiAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbn1cblxuI2J1dHRvbnMgYnV0dG9uIHtcbiAgZm9udC1mYW1pbHk6IFNvdXJjZVNhbnNQcm8sIEFyaWFsLCBIZWx2ZXRpY2EsIHNhbnMtc2VyaWY7XG4gIC8qbWFyZ2luOiAwcHggNHB4O1xuICBwYWRkaW5nOiAxcHggNnB4OyovXG4gIG1pbi13aWR0aDogNzBweDtcbiAgY29sb3I6IHJnYig1MSwgNTEsIDUxKTtcbiAgY3Vyc29yOiBwb2ludGVyO1xuICBmb250LXNpemU6IDE1cHg7XG59XG5cbiNsb2dDb250ZW50IHtcbiAgYmFja2dyb3VuZC1jb2xvcjogIzMzMzMzMztcbiAgY29sb3I6ICNDQ0NDQ0M7XG4gIGJvcmRlcjogMXB4IHNvbGlkICNDQ0NDQ0M7XG4gIG92ZXJmbG93OiBhdXRvO1xuICBoZWlnaHQ6IDkwJTtcbiAgcGFkZGluZzogNXB4O1xuICBmb250LXNpemU6IDEycHg7XG4gIG1hcmdpbjogNHB4IDtcbn1cblxucHJlIHtcbiAgbWFyZ2luOiAwO1xufVxuIl19 */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](LogsComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-logs',
                templateUrl: './logs.component.html',
                styleUrls: ['./logs.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_1__["SystemInfoService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_2__["HTTPResponseHandlerService"] }]; }, null); })();


/***/ }),

/***/ "H95c":
/*!*****************************************************!*\
  !*** ./src/app/services/firmware-upload.service.ts ***!
  \*****************************************************/
/*! exports provided: FirmwareUploadService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FirmwareUploadService", function() { return FirmwareUploadService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ "qCKp");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../environments/environment */ "AytR");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common/http */ "tk/3");







const FILE_UPLOAD_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].fwUpdateEndpoint;
class FirmwareUploadService {
    constructor(httpClient) {
        this.httpClient = httpClient;
        this.httpOptions = {
            observe: 'response'
        };
    }
    upload(file) {
        //console.log(file);
        // Create form data
        let formData = new FormData();
        formData.append('fwImage', file, file.name);
        //console.log(formData.getAll('certificate'));
        // Make http post request over api
        // with formData as req
        /*return this.httpClient.post<any>(FILE_UPLOAD_ENDPOINT,formData, {
          reportProgress: true,
          observe: 'events',
          responseType: 'json',
          //rejectUnauthorized: false,
          /*headers: new HttpHeaders({
            'rejectUnauthorized': 'false'
          })*/
        /*}).pipe(
            catchError(err1 => this.handleError(err1))
        );*/
        const req = new _angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpRequest"]('POST', FILE_UPLOAD_ENDPOINT, formData, {
            reportProgress: true,
            responseType: 'json',
        });
        return this.httpClient.request(req);
    }
    getUpdateStatus() {
        //console.log('Check Update Status GET "%s"', FILE_UPLOAD_ENDPOINT);
        return this.httpClient.get(FILE_UPLOAD_ENDPOINT, this.httpOptions).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_2__["catchError"])(err1 => this.handleError(err1)));
    }
    handleError(error) {
        if (error.error instanceof ErrorEvent) {
            // A client-side or network error occurred. Handle it accordingly.
            console.error('An error occurred:', error.error.message);
        }
        else {
            // The backend returned an unsuccessful response code.
            // The response body may contain clues as to what went wrong.
            console.error(`Backend returned code ${error.status}, ` +
                `body was: ${error.error}`);
        }
        // Return an observable with a user-facing error message.
        //return throwError('Something bad happened; please try again later.');
        return Object(rxjs__WEBPACK_IMPORTED_MODULE_1__["of"])(error); //returns HttpErrorResponse with status 0
    }
}
FirmwareUploadService.ɵfac = function FirmwareUploadService_Factory(t) { return new (t || FirmwareUploadService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpClient"])); };
FirmwareUploadService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: FirmwareUploadService, factory: FirmwareUploadService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](FirmwareUploadService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpClient"] }]; }, null); })();


/***/ }),

/***/ "K095":
/*!******************************************************************!*\
  !*** ./src/app/timezone-selector/timezone-selector.component.ts ***!
  \******************************************************************/
/*! exports provided: TimezoneSelectorComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TimezoneSelectorComponent", function() { return TimezoneSelectorComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_material_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material/select */ "d3UM");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _angular_material_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/core */ "FKr1");








function TimezoneSelectorComponent_mat_option_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-option", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("onSelectionChange", function TimezoneSelectorComponent_mat_option_1_Template_mat_option_onSelectionChange_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3); const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r2.timezoneChanged($event); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const timezoneObj_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("value", timezoneObj_r1.value);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](timezoneObj_r1.name);
} }
const _c0 = function (a0) { return { "input-error": a0 }; };
class TimezoneSelectorComponent {
    constructor() {
        this.timezonesList = [
            { "name": 'Africa/Abidjan', "value": 'Africa/Abidjan' },
            { "name": 'Africa/Accra', "value": 'Africa/Accra' },
            { "name": 'Africa/Addis_Ababa', "value": 'Africa/Addis_Ababa' },
            { "name": 'Africa/Algiers', "value": 'Africa/Algiers' },
            { "name": 'Africa/Asmara', "value": 'Africa/Asmara' },
            { "name": 'Africa/Asmera', "value": 'Africa/Asmera' },
            { "name": 'Africa/Bamako', "value": 'Africa/Bamako' },
            { "name": 'Africa/Bangui', "value": 'Africa/Bangui' },
            { "name": 'Africa/Banjul', "value": 'Africa/Banjul' },
            { "name": 'Africa/Bissau', "value": 'Africa/Bissau' },
            { "name": 'Africa/Blantyre', "value": 'Africa/Blantyre' },
            { "name": 'Africa/Brazzaville', "value": 'Africa/Brazzaville' },
            { "name": 'Africa/Bujumbura', "value": 'Africa/Bujumbura' },
            { "name": 'Africa/Cairo', "value": 'Africa/Cairo' },
            { "name": 'Africa/Casablanca', "value": 'Africa/Casablanca' },
            { "name": 'Africa/Ceuta', "value": 'Africa/Ceuta' },
            { "name": 'Africa/Conakry', "value": 'Africa/Conakry' },
            { "name": 'Africa/Dakar', "value": 'Africa/Dakar' },
            { "name": 'Africa/Dar_es_Salaam', "value": 'Africa/Dar_es_Salaam' },
            { "name": 'Africa/Djibouti', "value": 'Africa/Djibouti' },
            { "name": 'Africa/Douala', "value": 'Africa/Douala' },
            { "name": 'Africa/El_Aaiun', "value": 'Africa/El_Aaiun' },
            { "name": 'Africa/Freetown', "value": 'Africa/Freetown' },
            { "name": 'Africa/Gaborone', "value": 'Africa/Gaborone' },
            { "name": 'Africa/Harare', "value": 'Africa/Harare' },
            { "name": 'Africa/Johannesburg', "value": 'Africa/Johannesburg' },
            { "name": 'Africa/Juba', "value": 'Africa/Juba' },
            { "name": 'Africa/Kampala', "value": 'Africa/Kampala' },
            { "name": 'Africa/Khartoum', "value": 'Africa/Khartoum' },
            { "name": 'Africa/Kigali', "value": 'Africa/Kigali' },
            { "name": 'Africa/Kinshasa', "value": 'Africa/Kinshasa' },
            { "name": 'Africa/Lagos', "value": 'Africa/Lagos' },
            { "name": 'Africa/Libreville', "value": 'Africa/Libreville' },
            { "name": 'Africa/Lome', "value": 'Africa/Lome' },
            { "name": 'Africa/Luanda', "value": 'Africa/Luanda' },
            { "name": 'Africa/Lubumbashi', "value": 'Africa/Lubumbashi' },
            { "name": 'Africa/Lusaka', "value": 'Africa/Lusaka' },
            { "name": 'Africa/Malabo', "value": 'Africa/Malabo' },
            { "name": 'Africa/Maputo', "value": 'Africa/Maputo' },
            { "name": 'Africa/Maseru', "value": 'Africa/Maseru' },
            { "name": 'Africa/Mbabane', "value": 'Africa/Mbabane' },
            { "name": 'Africa/Mogadishu', "value": 'Africa/Mogadishu' },
            { "name": 'Africa/Monrovia', "value": 'Africa/Monrovia' },
            { "name": 'Africa/Nairobi', "value": 'Africa/Nairobi' },
            { "name": 'Africa/Ndjamena', "value": 'Africa/Ndjamena' },
            { "name": 'Africa/Niamey', "value": 'Africa/Niamey' },
            { "name": 'Africa/Nouakchott', "value": 'Africa/Nouakchott' },
            { "name": 'Africa/Ouagadougou', "value": 'Africa/Ouagadougou' },
            { "name": 'Africa/Porto-Novo', "value": 'Africa/Porto-Novo' },
            { "name": 'Africa/Sao_Tome', "value": 'Africa/Sao_Tome' },
            { "name": 'Africa/Timbuktu', "value": 'Africa/Timbuktu' },
            { "name": 'Africa/Tripoli', "value": 'Africa/Tripoli' },
            { "name": 'Africa/Tunis', "value": 'Africa/Tunis' },
            { "name": 'Africa/Windhoek', "value": 'Africa/Windhoek' },
            { "name": 'AKST9AKDT', "value": 'AKST9AKDT' },
            { "name": 'America/Adak', "value": 'America/Adak' },
            { "name": 'America/Anchorage', "value": 'America/Anchorage' },
            { "name": 'America/Anguilla', "value": 'America/Anguilla' },
            { "name": 'America/Antigua', "value": 'America/Antigua' },
            { "name": 'America/Araguaina', "value": 'America/Araguaina' },
            { "name": 'America/Argentina/Buenos_Aires', "value": 'America/Argentina/Buenos_Aires' },
            { "name": 'America/Argentina/Catamarca', "value": 'America/Argentina/Catamarca' },
            { "name": 'America/Argentina/ComodRivadavia', "value": 'America/Argentina/ComodRivadavia' },
            { "name": 'America/Argentina/Cordoba', "value": 'America/Argentina/Cordoba' },
            { "name": 'America/Argentina/Jujuy', "value": 'America/Argentina/Jujuy' },
            { "name": 'America/Argentina/La_Rioja', "value": 'America/Argentina/La_Rioja' },
            { "name": 'America/Argentina/Mendoza', "value": 'America/Argentina/Mendoza' },
            { "name": 'America/Argentina/Rio_Gallegos', "value": 'America/Argentina/Rio_Gallegos' },
            { "name": 'America/Argentina/Salta', "value": 'America/Argentina/Salta' },
            { "name": 'America/Argentina/San_Juan', "value": 'America/Argentina/San_Juan' },
            { "name": 'America/Argentina/San_Luis', "value": 'America/Argentina/San_Luis' },
            { "name": 'America/Argentina/Tucuman', "value": 'America/Argentina/Tucuman' },
            { "name": 'America/Argentina/Ushuaia', "value": 'America/Argentina/Ushuaia' },
            { "name": 'America/Aruba', "value": 'America/Aruba' },
            { "name": 'America/Asuncion', "value": 'America/Asuncion' },
            { "name": 'America/Atikokan', "value": 'America/Atikokan' },
            { "name": 'America/Atka', "value": 'America/Atka' },
            { "name": 'America/Bahia', "value": 'America/Bahia' },
            { "name": 'America/Bahia_Banderas', "value": 'America/Bahia_Banderas' },
            { "name": 'America/Barbados', "value": 'America/Barbados' },
            { "name": 'America/Belem', "value": 'America/Belem' },
            { "name": 'America/Belize', "value": 'America/Belize' },
            { "name": 'America/Blanc-Sablon', "value": 'America/Blanc-Sablon' },
            { "name": 'America/Boa_Vista', "value": 'America/Boa_Vista' },
            { "name": 'America/Bogota', "value": 'America/Bogota' },
            { "name": 'America/Boise', "value": 'America/Boise' },
            { "name": 'America/Buenos_Aires', "value": 'America/Buenos_Aires' },
            { "name": 'America/Cambridge_Bay', "value": 'America/Cambridge_Bay' },
            { "name": 'America/Campo_Grande', "value": 'America/Campo_Grande' },
            { "name": 'America/Cancun', "value": 'America/Cancun' },
            { "name": 'America/Caracas', "value": 'America/Caracas' },
            { "name": 'America/Catamarca', "value": 'America/Catamarca' },
            { "name": 'America/Cayenne', "value": 'America/Cayenne' },
            { "name": 'America/Cayman', "value": 'America/Cayman' },
            { "name": 'America/Chicago', "value": 'America/Chicago' },
            { "name": 'America/Chihuahua', "value": 'America/Chihuahua' },
            { "name": 'America/Coral_Harbour', "value": 'America/Coral_Harbour' },
            { "name": 'America/Cordoba', "value": 'America/Cordoba' },
            { "name": 'America/Costa_Rica', "value": 'America/Costa_Rica' },
            { "name": 'America/Creston', "value": 'America/Creston' },
            { "name": 'America/Cuiaba', "value": 'America/Cuiaba' },
            { "name": 'America/Curacao', "value": 'America/Curacao' },
            { "name": 'America/Danmarkshavn', "value": 'America/Danmarkshavn' },
            { "name": 'America/Dawson', "value": 'America/Dawson' },
            { "name": 'America/Dawson_Creek', "value": 'America/Dawson_Creek' },
            { "name": 'America/Denver', "value": 'America/Denver' },
            { "name": 'America/Detroit', "value": 'America/Detroit' },
            { "name": 'America/Dominica', "value": 'America/Dominica' },
            { "name": 'America/Edmonton', "value": 'America/Edmonton' },
            { "name": 'America/Eirunepe', "value": 'America/Eirunepe' },
            { "name": 'America/El_Salvador', "value": 'America/El_Salvador' },
            { "name": 'America/Ensenada', "value": 'America/Ensenada' },
            { "name": 'America/Fort_Wayne', "value": 'America/Fort_Wayne' },
            { "name": 'America/Fortaleza', "value": 'America/Fortaleza' },
            { "name": 'America/Glace_Bay', "value": 'America/Glace_Bay' },
            { "name": 'America/Godthab', "value": 'America/Godthab' },
            { "name": 'America/Goose_Bay', "value": 'America/Goose_Bay' },
            { "name": 'America/Grand_Turk', "value": 'America/Grand_Turk' },
            { "name": 'America/Grenada', "value": 'America/Grenada' },
            { "name": 'America/Guadeloupe', "value": 'America/Guadeloupe' },
            { "name": 'America/Guatemala', "value": 'America/Guatemala' },
            { "name": 'America/Guayaquil', "value": 'America/Guayaquil' },
            { "name": 'America/Guyana', "value": 'America/Guyana' },
            { "name": 'America/Halifax', "value": 'America/Halifax' },
            { "name": 'America/Havana', "value": 'America/Havana' },
            { "name": 'America/Hermosillo', "value": 'America/Hermosillo' },
            { "name": 'America/Indiana/Indianapolis', "value": 'America/Indiana/Indianapolis' },
            { "name": 'America/Indiana/Knox', "value": 'America/Indiana/Knox' },
            { "name": 'America/Indiana/Marengo', "value": 'America/Indiana/Marengo' },
            { "name": 'America/Indiana/Petersburg', "value": 'America/Indiana/Petersburg' },
            { "name": 'America/Indiana/Tell_City', "value": 'America/Indiana/Tell_City' },
            { "name": 'America/Indiana/Vevay', "value": 'America/Indiana/Vevay' },
            { "name": 'America/Indiana/Vincennes', "value": 'America/Indiana/Vincennes' },
            { "name": 'America/Indiana/Winamac', "value": 'America/Indiana/Winamac' },
            { "name": 'America/Indianapolis', "value": 'America/Indianapolis' },
            { "name": 'America/Inuvik', "value": 'America/Inuvik' },
            { "name": 'America/Iqaluit', "value": 'America/Iqaluit' },
            { "name": 'America/Jamaica', "value": 'America/Jamaica' },
            { "name": 'America/Jujuy', "value": 'America/Jujuy' },
            { "name": 'America/Juneau', "value": 'America/Juneau' },
            { "name": 'America/Kentucky/Louisville', "value": 'America/Kentucky/Louisville' },
            { "name": 'America/Kentucky/Monticello', "value": 'America/Kentucky/Monticello' },
            { "name": 'America/Knox_IN', "value": 'America/Knox_IN' },
            { "name": 'America/Kralendijk', "value": 'America/Kralendijk' },
            { "name": 'America/La_Paz', "value": 'America/La_Paz' },
            { "name": 'America/Lima', "value": 'America/Lima' },
            { "name": 'America/Los_Angeles', "value": 'America/Los_Angeles' },
            { "name": 'America/Louisville', "value": 'America/Louisville' },
            { "name": 'America/Lower_Princes', "value": 'America/Lower_Princes' },
            { "name": 'America/Maceio', "value": 'America/Maceio' },
            { "name": 'America/Managua', "value": 'America/Managua' },
            { "name": 'America/Manaus', "value": 'America/Manaus' },
            { "name": 'America/Marigot', "value": 'America/Marigot' },
            { "name": 'America/Martinique', "value": 'America/Martinique' },
            { "name": 'America/Matamoros', "value": 'America/Matamoros' },
            { "name": 'America/Mazatlan', "value": 'America/Mazatlan' },
            { "name": 'America/Mendoza', "value": 'America/Mendoza' },
            { "name": 'America/Menominee', "value": 'America/Menominee' },
            { "name": 'America/Merida', "value": 'America/Merida' },
            { "name": 'America/Metlakatla', "value": 'America/Metlakatla' },
            { "name": 'America/Mexico_City', "value": 'America/Mexico_City' },
            { "name": 'America/Miquelon', "value": 'America/Miquelon' },
            { "name": 'America/Moncton', "value": 'America/Moncton' },
            { "name": 'America/Monterrey', "value": 'America/Monterrey' },
            { "name": 'America/Montevideo', "value": 'America/Montevideo' },
            { "name": 'America/Montreal', "value": 'America/Montreal' },
            { "name": 'America/Montserrat', "value": 'America/Montserrat' },
            { "name": 'America/Nassau', "value": 'America/Nassau' },
            { "name": 'America/New_York', "value": 'America/New_York' },
            { "name": 'America/Nipigon', "value": 'America/Nipigon' },
            { "name": 'America/Nome', "value": 'America/Nome' },
            { "name": 'America/Noronha', "value": 'America/Noronha' },
            { "name": 'America/North_Dakota/Beulah', "value": 'America/North_Dakota/Beulah' },
            { "name": 'America/North_Dakota/Center', "value": 'America/North_Dakota/Center' },
            { "name": 'America/North_Dakota/New_Salem', "value": 'America/North_Dakota/New_Salem' },
            { "name": 'America/Ojinaga', "value": 'America/Ojinaga' },
            { "name": 'America/Panama', "value": 'America/Panama' },
            { "name": 'America/Pangnirtung', "value": 'America/Pangnirtung' },
            { "name": 'America/Paramaribo', "value": 'America/Paramaribo' },
            { "name": 'America/Phoenix', "value": 'America/Phoenix' },
            { "name": 'America/Port_of_Spain', "value": 'America/Port_of_Spain' },
            { "name": 'America/Port-au-Prince', "value": 'America/Port-au-Prince' },
            { "name": 'America/Porto_Acre', "value": 'America/Porto_Acre' },
            { "name": 'America/Porto_Velho', "value": 'America/Porto_Velho' },
            { "name": 'America/Puerto_Rico', "value": 'America/Puerto_Rico' },
            { "name": 'America/Rainy_River', "value": 'America/Rainy_River' },
            { "name": 'America/Rankin_Inlet', "value": 'America/Rankin_Inlet' },
            { "name": 'America/Recife', "value": 'America/Recife' },
            { "name": 'America/Regina', "value": 'America/Regina' },
            { "name": 'America/Resolute', "value": 'America/Resolute' },
            { "name": 'America/Rio_Branco', "value": 'America/Rio_Branco' },
            { "name": 'America/Rosario', "value": 'America/Rosario' },
            { "name": 'America/Santa_Isabel', "value": 'America/Santa_Isabel' },
            { "name": 'America/Santarem', "value": 'America/Santarem' },
            { "name": 'America/Santiago', "value": 'America/Santiago' },
            { "name": 'America/Santo_Domingo', "value": 'America/Santo_Domingo' },
            { "name": 'America/Sao_Paulo', "value": 'America/Sao_Paulo' },
            { "name": 'America/Scoresbysund', "value": 'America/Scoresbysund' },
            { "name": 'America/Shiprock', "value": 'America/Shiprock' },
            { "name": 'America/Sitka', "value": 'America/Sitka' },
            { "name": 'America/St_Barthelemy', "value": 'America/St_Barthelemy' },
            { "name": 'America/St_Johns', "value": 'America/St_Johns' },
            { "name": 'America/St_Kitts', "value": 'America/St_Kitts' },
            { "name": 'America/St_Lucia', "value": 'America/St_Lucia' },
            { "name": 'America/St_Thomas', "value": 'America/St_Thomas' },
            { "name": 'America/St_Vincent', "value": 'America/St_Vincent' },
            { "name": 'America/Swift_Current', "value": 'America/Swift_Current' },
            { "name": 'America/Tegucigalpa', "value": 'America/Tegucigalpa' },
            { "name": 'America/Thule', "value": 'America/Thule' },
            { "name": 'America/Thunder_Bay', "value": 'America/Thunder_Bay' },
            { "name": 'America/Tijuana', "value": 'America/Tijuana' },
            { "name": 'America/Toronto', "value": 'America/Toronto' },
            { "name": 'America/Tortola', "value": 'America/Tortola' },
            { "name": 'America/Vancouver', "value": 'America/Vancouver' },
            { "name": 'America/Virgin', "value": 'America/Virgin' },
            { "name": 'America/Whitehorse', "value": 'America/Whitehorse' },
            { "name": 'America/Winnipeg', "value": 'America/Winnipeg' },
            { "name": 'America/Yakutat', "value": 'America/Yakutat' },
            { "name": 'America/Yellowknife', "value": 'America/Yellowknife' },
            { "name": 'Antarctica/Casey', "value": 'Antarctica/Casey' },
            { "name": 'Antarctica/Davis', "value": 'Antarctica/Davis' },
            { "name": 'Antarctica/DumontDUrville', "value": 'Antarctica/DumontDUrville' },
            { "name": 'Antarctica/Macquarie', "value": 'Antarctica/Macquarie' },
            { "name": 'Antarctica/Mawson', "value": 'Antarctica/Mawson' },
            { "name": 'Antarctica/McMurdo', "value": 'Antarctica/McMurdo' },
            { "name": 'Antarctica/Palmer', "value": 'Antarctica/Palmer' },
            { "name": 'Antarctica/Rothera', "value": 'Antarctica/Rothera' },
            { "name": 'Antarctica/South_Pole', "value": 'Antarctica/South_Pole' },
            { "name": 'Antarctica/Syowa', "value": 'Antarctica/Syowa' },
            { "name": 'Antarctica/Vostok', "value": 'Antarctica/Vostok' },
            { "name": 'Arctic/Longyearbyen', "value": 'Arctic/Longyearbyen' },
            { "name": 'Asia/Aden', "value": 'Asia/Aden' },
            { "name": 'Asia/Almaty', "value": 'Asia/Almaty' },
            { "name": 'Asia/Amman', "value": 'Asia/Amman' },
            { "name": 'Asia/Anadyr', "value": 'Asia/Anadyr' },
            { "name": 'Asia/Aqtau', "value": 'Asia/Aqtau' },
            { "name": 'Asia/Aqtobe', "value": 'Asia/Aqtobe' },
            { "name": 'Asia/Ashgabat', "value": 'Asia/Ashgabat' },
            { "name": 'Asia/Ashkhabad', "value": 'Asia/Ashkhabad' },
            { "name": 'Asia/Baghdad', "value": 'Asia/Baghdad' },
            { "name": 'Asia/Bahrain', "value": 'Asia/Bahrain' },
            { "name": 'Asia/Baku', "value": 'Asia/Baku' },
            { "name": 'Asia/Bangkok', "value": 'Asia/Bangkok' },
            { "name": 'Asia/Beirut', "value": 'Asia/Beirut' },
            { "name": 'Asia/Bishkek', "value": 'Asia/Bishkek' },
            { "name": 'Asia/Brunei', "value": 'Asia/Brunei' },
            { "name": 'Asia/Calcutta', "value": 'Asia/Calcutta' },
            { "name": 'Asia/Choibalsan', "value": 'Asia/Choibalsan' },
            { "name": 'Asia/Chongqing', "value": 'Asia/Chongqing' },
            { "name": 'Asia/Chungking', "value": 'Asia/Chungking' },
            { "name": 'Asia/Colombo', "value": 'Asia/Colombo' },
            { "name": 'Asia/Dacca', "value": 'Asia/Dacca' },
            { "name": 'Asia/Damascus', "value": 'Asia/Damascus' },
            { "name": 'Asia/Dhaka', "value": 'Asia/Dhaka' },
            { "name": 'Asia/Dili', "value": 'Asia/Dili' },
            { "name": 'Asia/Dubai', "value": 'Asia/Dubai' },
            { "name": 'Asia/Dushanbe', "value": 'Asia/Dushanbe' },
            { "name": 'Asia/Gaza', "value": 'Asia/Gaza' },
            { "name": 'Asia/Harbin', "value": 'Asia/Harbin' },
            { "name": 'Asia/Hebron', "value": 'Asia/Hebron' },
            { "name": 'Asia/Ho_Chi_Minh', "value": 'Asia/Ho_Chi_Minh' },
            { "name": 'Asia/Hong_Kong', "value": 'Asia/Hong_Kong' },
            { "name": 'Asia/Hovd', "value": 'Asia/Hovd' },
            { "name": 'Asia/Irkutsk', "value": 'Asia/Irkutsk' },
            { "name": 'Asia/Istanbul', "value": 'Asia/Istanbul' },
            { "name": 'Asia/Jakarta', "value": 'Asia/Jakarta' },
            { "name": 'Asia/Jayapura', "value": 'Asia/Jayapura' },
            { "name": 'Asia/Jerusalem', "value": 'Asia/Jerusalem' },
            { "name": 'Asia/Kabul', "value": 'Asia/Kabul' },
            { "name": 'Asia/Kamchatka', "value": 'Asia/Kamchatka' },
            { "name": 'Asia/Karachi', "value": 'Asia/Karachi' },
            { "name": 'Asia/Kashgar', "value": 'Asia/Kashgar' },
            { "name": 'Asia/Kathmandu', "value": 'Asia/Kathmandu' },
            { "name": 'Asia/Katmandu', "value": 'Asia/Katmandu' },
            { "name": 'Asia/Kolkata', "value": 'Asia/Kolkata' },
            { "name": 'Asia/Krasnoyarsk', "value": 'Asia/Krasnoyarsk' },
            { "name": 'Asia/Kuala_Lumpur', "value": 'Asia/Kuala_Lumpur' },
            { "name": 'Asia/Kuching', "value": 'Asia/Kuching' },
            { "name": 'Asia/Kuwait', "value": 'Asia/Kuwait' },
            { "name": 'Asia/Macao', "value": 'Asia/Macao' },
            { "name": 'Asia/Macau', "value": 'Asia/Macau' },
            { "name": 'Asia/Magadan', "value": 'Asia/Magadan' },
            { "name": 'Asia/Makassar', "value": 'Asia/Makassar' },
            { "name": 'Asia/Manila', "value": 'Asia/Manila' },
            { "name": 'Asia/Muscat', "value": 'Asia/Muscat' },
            { "name": 'Asia/Nicosia', "value": 'Asia/Nicosia' },
            { "name": 'Asia/Novokuznetsk', "value": 'Asia/Novokuznetsk' },
            { "name": 'Asia/Novosibirsk', "value": 'Asia/Novosibirsk' },
            { "name": 'Asia/Omsk', "value": 'Asia/Omsk' },
            { "name": 'Asia/Oral', "value": 'Asia/Oral' },
            { "name": 'Asia/Phnom_Penh', "value": 'Asia/Phnom_Penh' },
            { "name": 'Asia/Pontianak', "value": 'Asia/Pontianak' },
            { "name": 'Asia/Pyongyang', "value": 'Asia/Pyongyang' },
            { "name": 'Asia/Qatar', "value": 'Asia/Qatar' },
            { "name": 'Asia/Qyzylorda', "value": 'Asia/Qyzylorda' },
            { "name": 'Asia/Rangoon', "value": 'Asia/Rangoon' },
            { "name": 'Asia/Riyadh', "value": 'Asia/Riyadh' },
            { "name": 'Asia/Saigon', "value": 'Asia/Saigon' },
            { "name": 'Asia/Sakhalin', "value": 'Asia/Sakhalin' },
            { "name": 'Asia/Samarkand', "value": 'Asia/Samarkand' },
            { "name": 'Asia/Seoul', "value": 'Asia/Seoul' },
            { "name": 'Asia/Shanghai', "value": 'Asia/Shanghai' },
            { "name": 'Asia/Singapore', "value": 'Asia/Singapore' },
            { "name": 'Asia/Taipei', "value": 'Asia/Taipei' },
            { "name": 'Asia/Tashkent', "value": 'Asia/Tashkent' },
            { "name": 'Asia/Tbilisi', "value": 'Asia/Tbilisi' },
            { "name": 'Asia/Tehran', "value": 'Asia/Tehran' },
            { "name": 'Asia/Tel_Aviv', "value": 'Asia/Tel_Aviv' },
            { "name": 'Asia/Thimbu', "value": 'Asia/Thimbu' },
            { "name": 'Asia/Thimphu', "value": 'Asia/Thimphu' },
            { "name": 'Asia/Tokyo', "value": 'Asia/Tokyo' },
            { "name": 'Asia/Ujung_Pandang', "value": 'Asia/Ujung_Pandang' },
            { "name": 'Asia/Ulaanbaatar', "value": 'Asia/Ulaanbaatar' },
            { "name": 'Asia/Ulan_Bator', "value": 'Asia/Ulan_Bator' },
            { "name": 'Asia/Urumqi', "value": 'Asia/Urumqi' },
            { "name": 'Asia/Vientiane', "value": 'Asia/Vientiane' },
            { "name": 'Asia/Vladivostok', "value": 'Asia/Vladivostok' },
            { "name": 'Asia/Yakutsk', "value": 'Asia/Yakutsk' },
            { "name": 'Asia/Yekaterinburg', "value": 'Asia/Yekaterinburg' },
            { "name": 'Asia/Yerevan', "value": 'Asia/Yerevan' },
            { "name": 'Atlantic/Azores', "value": 'Atlantic/Azores' },
            { "name": 'Atlantic/Bermuda', "value": 'Atlantic/Bermuda' },
            { "name": 'Atlantic/Canary', "value": 'Atlantic/Canary' },
            { "name": 'Atlantic/Cape_Verde', "value": 'Atlantic/Cape_Verde' },
            { "name": 'Atlantic/Faeroe', "value": 'Atlantic/Faeroe' },
            { "name": 'Atlantic/Faroe', "value": 'Atlantic/Faroe' },
            { "name": 'Atlantic/Jan_Mayen', "value": 'Atlantic/Jan_Mayen' },
            { "name": 'Atlantic/Madeira', "value": 'Atlantic/Madeira' },
            { "name": 'Atlantic/Reykjavik', "value": 'Atlantic/Reykjavik' },
            { "name": 'Atlantic/South_Georgia', "value": 'Atlantic/South_Georgia' },
            { "name": 'Atlantic/St_Helena', "value": 'Atlantic/St_Helena' },
            { "name": 'Atlantic/Stanley', "value": 'Atlantic/Stanley' },
            { "name": 'Australia/ACT', "value": 'Australia/ACT' },
            { "name": 'Australia/Adelaide', "value": 'Australia/Adelaide' },
            { "name": 'Australia/Brisbane', "value": 'Australia/Brisbane' },
            { "name": 'Australia/Broken_Hill', "value": 'Australia/Broken_Hill' },
            { "name": 'Australia/Canberra', "value": 'Australia/Canberra' },
            { "name": 'Australia/Currie', "value": 'Australia/Currie' },
            { "name": 'Australia/Darwin', "value": 'Australia/Darwin' },
            { "name": 'Australia/Eucla', "value": 'Australia/Eucla' },
            { "name": 'Australia/Hobart', "value": 'Australia/Hobart' },
            { "name": 'Australia/LHI', "value": 'Australia/LHI' },
            { "name": 'Australia/Lindeman', "value": 'Australia/Lindeman' },
            { "name": 'Australia/Lord_Howe', "value": 'Australia/Lord_Howe' },
            { "name": 'Australia/Melbourne', "value": 'Australia/Melbourne' },
            { "name": 'Australia/North', "value": 'Australia/North' },
            { "name": 'Australia/NSW', "value": 'Australia/NSW' },
            { "name": 'Australia/Perth', "value": 'Australia/Perth' },
            { "name": 'Australia/Queensland', "value": 'Australia/Queensland' },
            { "name": 'Australia/South', "value": 'Australia/South' },
            { "name": 'Australia/Sydney', "value": 'Australia/Sydney' },
            { "name": 'Australia/Tasmania', "value": 'Australia/Tasmania' },
            { "name": 'Australia/Victoria', "value": 'Australia/Victoria' },
            { "name": 'Australia/West', "value": 'Australia/West' },
            { "name": 'Australia/Yancowinna', "value": 'Australia/Yancowinna' },
            { "name": 'Brazil/Acre', "value": 'Brazil/Acre' },
            { "name": 'Brazil/DeNoronha', "value": 'Brazil/DeNoronha' },
            { "name": 'Brazil/East', "value": 'Brazil/East' },
            { "name": 'Brazil/West', "value": 'Brazil/West' },
            { "name": 'Canada/Atlantic', "value": 'Canada/Atlantic' },
            { "name": 'Canada/Central', "value": 'Canada/Central' },
            { "name": 'Canada/Eastern', "value": 'Canada/Eastern' },
            { "name": 'Canada/East-Saskatchewan', "value": 'Canada/East-Saskatchewan' },
            { "name": 'Canada/Mountain', "value": 'Canada/Mountain' },
            { "name": 'Canada/Newfoundland', "value": 'Canada/Newfoundland' },
            { "name": 'Canada/Pacific', "value": 'Canada/Pacific' },
            { "name": 'Canada/Saskatchewan', "value": 'Canada/Saskatchewan' },
            { "name": 'Canada/Yukon', "value": 'Canada/Yukon' },
            { "name": 'CET', "value": 'CET' },
            { "name": 'Chile/Continental', "value": 'Chile/Continental' },
            { "name": 'Chile/EasterIsland', "value": 'Chile/EasterIsland' },
            { "name": 'CST6CDT', "value": 'CST6CDT' },
            { "name": 'Cuba', "value": 'Cuba' },
            { "name": 'EET', "value": 'EET' },
            { "name": 'Egypt', "value": 'Egypt' },
            { "name": 'Eire', "value": 'Eire' },
            { "name": 'EST', "value": 'EST' },
            { "name": 'EST5EDT', "value": 'EST5EDT' },
            { "name": 'Etc./GMT', "value": 'Etc./GMT' },
            { "name": 'Etc./GMT+0', "value": 'Etc./GMT+0' },
            { "name": 'Etc./UCT', "value": 'Etc./UCT' },
            { "name": 'Etc./Universal', "value": 'Etc./Universal' },
            { "name": 'Etc./UTC', "value": 'Etc./UTC' },
            { "name": 'Etc./Zulu', "value": 'Etc./Zulu' },
            { "name": 'Europe/Amsterdam', "value": 'Europe/Amsterdam' },
            { "name": 'Europe/Andorra', "value": 'Europe/Andorra' },
            { "name": 'Europe/Athens', "value": 'Europe/Athens' },
            { "name": 'Europe/Belfast', "value": 'Europe/Belfast' },
            { "name": 'Europe/Belgrade', "value": 'Europe/Belgrade' },
            { "name": 'Europe/Berlin', "value": 'Europe/Berlin' },
            { "name": 'Europe/Bratislava', "value": 'Europe/Bratislava' },
            { "name": 'Europe/Brussels', "value": 'Europe/Brussels' },
            { "name": 'Europe/Bucharest', "value": 'Europe/Bucharest' },
            { "name": 'Europe/Budapest', "value": 'Europe/Budapest' },
            { "name": 'Europe/Chisinau', "value": 'Europe/Chisinau' },
            { "name": 'Europe/Copenhagen', "value": 'Europe/Copenhagen' },
            { "name": 'Europe/Dublin', "value": 'Europe/Dublin' },
            { "name": 'Europe/Gibraltar', "value": 'Europe/Gibraltar' },
            { "name": 'Europe/Guernsey', "value": 'Europe/Guernsey' },
            { "name": 'Europe/Helsinki', "value": 'Europe/Helsinki' },
            { "name": 'Europe/Isle_of_Man', "value": 'Europe/Isle_of_Man' },
            { "name": 'Europe/Istanbul', "value": 'Europe/Istanbul' },
            { "name": 'Europe/Jersey', "value": 'Europe/Jersey' },
            { "name": 'Europe/Kaliningrad', "value": 'Europe/Kaliningrad' },
            { "name": 'Europe/Kiev', "value": 'Europe/Kiev' },
            { "name": 'Europe/Lisbon', "value": 'Europe/Lisbon' },
            { "name": 'Europe/Ljubljana', "value": 'Europe/Ljubljana' },
            { "name": 'Europe/London', "value": 'Europe/London' },
            { "name": 'Europe/Luxembourg', "value": 'Europe/Luxembourg' },
            { "name": 'Europe/Madrid', "value": 'Europe/Madrid' },
            { "name": 'Europe/Malta', "value": 'Europe/Malta' },
            { "name": 'Europe/Mariehamn', "value": 'Europe/Mariehamn' },
            { "name": 'Europe/Minsk', "value": 'Europe/Minsk' },
            { "name": 'Europe/Monaco', "value": 'Europe/Monaco' },
            { "name": 'Europe/Moscow', "value": 'Europe/Moscow' },
            { "name": 'Europe/Nicosia', "value": 'Europe/Nicosia' },
            { "name": 'Europe/Oslo', "value": 'Europe/Oslo' },
            { "name": 'Europe/Paris', "value": 'Europe/Paris' },
            { "name": 'Europe/Podgorica', "value": 'Europe/Podgorica' },
            { "name": 'Europe/Prague', "value": 'Europe/Prague' },
            { "name": 'Europe/Riga', "value": 'Europe/Riga' },
            { "name": 'Europe/Rome', "value": 'Europe/Rome' },
            { "name": 'Europe/Samara', "value": 'Europe/Samara' },
            { "name": 'Europe/San_Marino', "value": 'Europe/San_Marino' },
            { "name": 'Europe/Sarajevo', "value": 'Europe/Sarajevo' },
            { "name": 'Europe/Simferopol', "value": 'Europe/Simferopol' },
            { "name": 'Europe/Skopje', "value": 'Europe/Skopje' },
            { "name": 'Europe/Sofia', "value": 'Europe/Sofia' },
            { "name": 'Europe/Stockholm', "value": 'Europe/Stockholm' },
            { "name": 'Europe/Tallinn', "value": 'Europe/Tallinn' },
            { "name": 'Europe/Tirane', "value": 'Europe/Tirane' },
            { "name": 'Europe/Tiraspol', "value": 'Europe/Tiraspol' },
            { "name": 'Europe/Uzhgorod', "value": 'Europe/Uzhgorod' },
            { "name": 'Europe/Vaduz', "value": 'Europe/Vaduz' },
            { "name": 'Europe/Vatican', "value": 'Europe/Vatican' },
            { "name": 'Europe/Vienna', "value": 'Europe/Vienna' },
            { "name": 'Europe/Vilnius', "value": 'Europe/Vilnius' },
            { "name": 'Europe/Volgograd', "value": 'Europe/Volgograd' },
            { "name": 'Europe/Warsaw', "value": 'Europe/Warsaw' },
            { "name": 'Europe/Zagreb', "value": 'Europe/Zagreb' },
            { "name": 'Europe/Zaporozhye', "value": 'Europe/Zaporozhye' },
            { "name": 'Europe/Zurich', "value": 'Europe/Zurich' },
            { "name": 'GB', "value": 'GB' },
            { "name": 'GB-Eire', "value": 'GB-Eire' },
            { "name": 'GMT', "value": 'GMT' },
            { "name": 'GMT+0', "value": 'GMT+0' },
            { "name": 'GMT0', "value": 'GMT0' },
            { "name": 'GMT-0', "value": 'GMT-0' },
            { "name": 'Greenwich', "value": 'Greenwich' },
            { "name": 'Hong Kong', "value": 'Hong Kong' },
            { "name": 'HST', "value": 'HST' },
            { "name": 'Iceland', "value": 'Iceland' },
            { "name": 'Indian/Antananarivo', "value": 'Indian/Antananarivo' },
            { "name": 'Indian/Chagos', "value": 'Indian/Chagos' },
            { "name": 'Indian/Christmas', "value": 'Indian/Christmas' },
            { "name": 'Indian/Cocos', "value": 'Indian/Cocos' },
            { "name": 'Indian/Comoro', "value": 'Indian/Comoro' },
            { "name": 'Indian/Kerguelen', "value": 'Indian/Kerguelen' },
            { "name": 'Indian/Mahe', "value": 'Indian/Mahe' },
            { "name": 'Indian/Maldives', "value": 'Indian/Maldives' },
            { "name": 'Indian/Mauritius', "value": 'Indian/Mauritius' },
            { "name": 'Indian/Mayotte', "value": 'Indian/Mayotte' },
            { "name": 'Indian/Reunion', "value": 'Indian/Reunion' },
            { "name": 'Iran', "value": 'Iran' },
            { "name": 'Israel', "value": 'Israel' },
            { "name": 'Jamaica', "value": 'Jamaica' },
            { "name": 'Japan', "value": 'Japan' },
            { "name": 'JST-9', "value": 'JST-9' },
            { "name": 'Kwajalein', "value": 'Kwajalein' },
            { "name": 'Libya', "value": 'Libya' },
            { "name": 'MET', "value": 'MET' },
            { "name": 'Mexico/BajaNorte', "value": 'Mexico/BajaNorte' },
            { "name": 'Mexico/BajaSur', "value": 'Mexico/BajaSur' },
            { "name": 'Mexico/General', "value": 'Mexico/General' },
            { "name": 'MST', "value": 'MST' },
            { "name": 'MST7MDT', "value": 'MST7MDT' },
            { "name": 'Navajo', "value": 'Navajo' },
            { "name": 'NZ', "value": 'NZ' },
            { "name": 'NZ-CHAT', "value": 'NZ-CHAT' },
            { "name": 'Pacific/Apia', "value": 'Pacific/Apia' },
            { "name": 'Pacific/Auckland', "value": 'Pacific/Auckland' },
            { "name": 'Pacific/Chatham', "value": 'Pacific/Chatham' },
            { "name": 'Pacific/Chuuk', "value": 'Pacific/Chuuk' },
            { "name": 'Pacific/Easter', "value": 'Pacific/Easter' },
            { "name": 'Pacific/Efate', "value": 'Pacific/Efate' },
            { "name": 'Pacific/Enderbury', "value": 'Pacific/Enderbury' },
            { "name": 'Pacific/Fakaofo', "value": 'Pacific/Fakaofo' },
            { "name": 'Pacific/Fiji', "value": 'Pacific/Fiji' },
            { "name": 'Pacific/Funafuti', "value": 'Pacific/Funafuti' },
            { "name": 'Pacific/Galapagos', "value": 'Pacific/Galapagos' },
            { "name": 'Pacific/Gambier', "value": 'Pacific/Gambier' },
            { "name": 'Pacific/Guadalcanal', "value": 'Pacific/Guadalcanal' },
            { "name": 'Pacific/Guam', "value": 'Pacific/Guam' },
            { "name": 'Pacific/Honolulu', "value": 'Pacific/Honolulu' },
            { "name": 'Pacific/Johnston', "value": 'Pacific/Johnston' },
            { "name": 'Pacific/Kiritimati', "value": 'Pacific/Kiritimati' },
            { "name": 'Pacific/Kosrae', "value": 'Pacific/Kosrae' },
            { "name": 'Pacific/Kwajalein', "value": 'Pacific/Kwajalein' },
            { "name": 'Pacific/Majuro', "value": 'Pacific/Majuro' },
            { "name": 'Pacific/Marquesas', "value": 'Pacific/Marquesas' },
            { "name": 'Pacific/Midway', "value": 'Pacific/Midway' },
            { "name": 'Pacific/Nauru', "value": 'Pacific/Nauru' },
            { "name": 'Pacific/Niue', "value": 'Pacific/Niue' },
            { "name": 'Pacific/Norfolk', "value": 'Pacific/Norfolk' },
            { "name": 'Pacific/Noumea', "value": 'Pacific/Noumea' },
            { "name": 'Pacific/Pago_Pago', "value": 'Pacific/Pago_Pago' },
            { "name": 'Pacific/Palau', "value": 'Pacific/Palau' },
            { "name": 'Pacific/Pitcairn', "value": 'Pacific/Pitcairn' },
            { "name": 'Pacific/Pohnpei', "value": 'Pacific/Pohnpei' },
            { "name": 'Pacific/Ponape', "value": 'Pacific/Ponape' },
            { "name": 'Pacific/Port_Moresby', "value": 'Pacific/Port_Moresby' },
            { "name": 'Pacific/Rarotonga', "value": 'Pacific/Rarotonga' },
            { "name": 'Pacific/Saipan', "value": 'Pacific/Saipan' },
            { "name": 'Pacific/Samoa', "value": 'Pacific/Samoa' },
            { "name": 'Pacific/Tahiti', "value": 'Pacific/Tahiti' },
            { "name": 'Pacific/Tarawa', "value": 'Pacific/Tarawa' },
            { "name": 'Pacific/Tongatapu', "value": 'Pacific/Tongatapu' },
            { "name": 'Pacific/Truk', "value": 'Pacific/Truk' },
            { "name": 'Pacific/Wake', "value": 'Pacific/Wake' },
            { "name": 'Pacific/Wallis', "value": 'Pacific/Wallis' },
            { "name": 'Pacific/Yap', "value": 'Pacific/Yap' },
            { "name": 'Poland', "value": 'Poland' },
            { "name": 'Portugal', "value": 'Portugal' },
            { "name": 'PRC', "value": 'PRC' },
            { "name": 'PST8PDT', "value": 'PST8PDT' },
            { "name": 'ROC', "value": 'ROC' },
            { "name": 'ROK', "value": 'ROK' },
            { "name": 'Singapore', "value": 'Singapore' },
            { "name": 'Turkey', "value": 'Turkey' },
            { "name": 'UCT', "value": 'UCT' },
            { "name": 'Universal', "value": 'Universal' },
            { "name": 'US/Alaska', "value": 'US/Alaska' },
            { "name": 'US/Aleutian', "value": 'US/Aleutian' },
            { "name": 'US/Arizona', "value": 'US/Arizona' },
            { "name": 'US/Central', "value": 'US/Central' },
            { "name": 'US/Eastern', "value": 'US/Eastern' },
            { "name": 'US/East-Indiana', "value": 'US/East-Indiana' },
            { "name": 'US/Hawaii', "value": 'US/Hawaii' },
            { "name": 'US/Indiana-Starke', "value": 'US/Indiana-Starke' },
            { "name": 'US/Michigan', "value": 'US/Michigan' },
            { "name": 'US/Mountain', "value": 'US/Mountain' },
            { "name": 'US/Pacific', "value": 'US/Pacific' },
            { "name": 'US/Pacific-New', "value": 'US/Pacific-New' },
            { "name": 'US/Samoa', "value": 'US/Samoa' },
            { "name": 'UTC', "value": 'UTC' },
            { "name": 'WET', "value": 'WET' },
            { "name": 'W-SU', "value": 'W-SU' },
            { "name": 'Zulu', "value": 'Zulu' }
        ];
    }
    ngOnInit() {
        //console.log("onInit", this.timezone);
        this.timezoneForm = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](this.timezone, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required);
        //console.log("timezone:", this.timezone === '');
        //console.log("not in list:", !this.timezoneIsInList(this.timezone));
        //console.log("if:", this.timezone === '' || !this.timezoneIsInList(this.timezone) );
        this.checkIfIsValid();
    }
    timezoneIsInList(timezone) {
        let isInList = false;
        for (let i = 0; i < this.timezonesList.length; i++) {
            if (this.timezonesList[i].value === timezone) {
                isInList = true;
                break;
            }
        }
        //console.log("isInList", isInList);
        return isInList;
    }
    timezoneChanged(event) {
        //console.log(event);
        if (event.isUserInput) {
            //console.log("changed", event.source.value);
            this.timezoneForm.setValue(event.source.value);
            this.checkIfIsValid();
        }
    }
    checkIfIsValid() {
        if (this.timezoneForm.value === '' || !this.timezoneIsInList(this.timezoneForm.value)) {
            this.isValid = false;
        }
        else {
            this.isValid = true;
        }
        return this.isValid;
    }
}
TimezoneSelectorComponent.ɵfac = function TimezoneSelectorComponent_Factory(t) { return new (t || TimezoneSelectorComponent)(); };
TimezoneSelectorComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: TimezoneSelectorComponent, selectors: [["app-timezone-selector"]], inputs: { timezone: "timezone" }, decls: 2, vars: 5, consts: [[1, "custom-select", 3, "ngClass", "formControl"], [3, "value", "onSelectionChange", 4, "ngFor", "ngForOf"], [3, "value", "onSelectionChange"]], template: function TimezoneSelectorComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "mat-select", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, TimezoneSelectorComponent_mat_option_1_Template, 2, 2, "mat-option", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](3, _c0, !ctx.checkIfIsValid()))("formControl", ctx.timezoneForm);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.timezonesList);
    } }, directives: [_angular_material_select__WEBPACK_IMPORTED_MODULE_2__["MatSelect"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgClass"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_4__["DefaultClassDirective"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControlDirective"], _angular_common__WEBPACK_IMPORTED_MODULE_3__["NgForOf"], _angular_material_core__WEBPACK_IMPORTED_MODULE_5__["MatOption"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL3RpbWV6b25lLXNlbGVjdG9yL3RpbWV6b25lLXNlbGVjdG9yLmNvbXBvbmVudC5jc3MifQ== */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](TimezoneSelectorComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-timezone-selector',
                templateUrl: './timezone-selector.component.html',
                styleUrls: ['./timezone-selector.component.css', '../general.css']
            }]
    }], function () { return []; }, { timezone: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Input"]
        }] }); })();


/***/ }),

/***/ "Kx0C":
/*!********************************************************!*\
  !*** ./src/app/sip-settings/sip-settings.component.ts ***!
  \********************************************************/
/*! exports provided: SipSettingsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SipSettingsComponent", function() { return SipSettingsComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/system-info.service */ "4e9C");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_material_expansion__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/expansion */ "7EHt");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _angular_material_form_field__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/form-field */ "kmnG");
/* harmony import */ var _angular_material_select__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/select */ "d3UM");
/* harmony import */ var _angular_material_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/core */ "FKr1");
/* harmony import */ var _angular_material_slider__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/slider */ "5RNC");
/* harmony import */ var _angular_material_radio__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/radio */ "QibW");
















function SipSettingsComponent_div_3_div_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_ng_template_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_div_42_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_ng_template_43_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_tr_60_Template(rf, ctx) { if (rf & 1) {
    const _r28 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_tr_60_Template_tr_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r28); const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](41); return ctx_r27.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Input");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "mat-form-field", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "mat-select", 58);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "mat-option", 59);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Line In");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "mat-option", 60);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, "Mic In");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
const _c0 = function (a0) { return { "input-error": a0 }; };
function SipSettingsComponent_div_3_tr_61_Template(rf, ctx) { if (rf & 1) {
    const _r30 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_tr_61_Template_tr_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r30); const ctx_r29 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](41); return ctx_r29.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Mic Gain");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](4, "input", 61);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "\u00A0dB ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](1, _c0, ctx_r15.form.get("mic_in_gain").invalid));
} }
function SipSettingsComponent_div_3_tr_71_Template(rf, ctx) { if (rf & 1) {
    const _r32 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_tr_71_Template_tr_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r32); const ctx_r31 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](41); return ctx_r31.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "td", 62);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "table", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Level");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "input", 63);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10, "Timeout");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](12, "input", 64);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13, "\u00A0ms ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c0, ctx_r16.form.get("hdx_level").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](4, _c0, ctx_r16.form.get("hdx_timeout").invalid));
} }
function SipSettingsComponent_div_3_div_86_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_ng_template_87_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_div_115_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_ng_template_116_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_ng_container_150_Template(rf, ctx) { if (rf & 1) {
    const _r34 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_ng_container_150_Template_tr_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r34); const ctx_r33 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](107); return ctx_r33.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "td", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "Input 3");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_ng_container_150_Template_tr_click_4_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r34); const ctx_r35 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](107); return ctx_r35.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "table", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8, "Alias");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](10, "input", 65);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13, "Call ID");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](15, "input", 66);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_ng_container_150_Template_tr_click_16_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r34); const ctx_r36 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](107); return ctx_r36.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "td", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18, "Input 4");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_ng_container_150_Template_tr_click_19_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r34); const ctx_r37 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](107); return ctx_r37.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "table", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](23, "Alias");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](25, "input", 67);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28, "Call ID");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](30, "input", 68);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
} if (rf & 2) {
    const ctx_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c0, ctx_r23.form.get("autodial3").invalid || ctx_r23.form.get("autodial3_alias").value !== "" && ctx_r23.form.get("autodial3").value === ""));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](4, _c0, ctx_r23.form.get("autodial4").invalid || ctx_r23.form.get("autodial4_alias").value !== "" && ctx_r23.form.get("autodial4").value === ""));
} }
function SipSettingsComponent_div_3_div_156_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u2212");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_ng_template_157_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "+");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r39 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "form", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngSubmit", function SipSettingsComponent_div_3_Template_form_ngSubmit_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r38 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r38.submit(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "mat-accordion", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "mat-expansion-panel", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SipSettingsComponent_div_3_Template_mat_expansion_panel_opened_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r40 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r40.ProtocolSettingsOpenState = true; })("closed", function SipSettingsComponent_div_3_Template_mat_expansion_panel_closed_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r41 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r41.ProtocolSettingsOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](7, SipSettingsComponent_div_3_div_7_Template, 3, 0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, SipSettingsComponent_div_3_ng_template_8_Template, 2, 0, "ng-template", null, 19, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10, " Protocol Settings ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "table", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_12_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r42 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](13); return ctx_r42.scrollToId(_r1); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](13, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14, "SIP Domain");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](16, "input", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_17_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r43 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](13); return ctx_r43.scrollToId(_r1); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19, "SIP ID (username)");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](21, "input", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_22_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r44 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](13); return ctx_r44.scrollToId(_r1); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](24, "SIP Password");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](26, "input", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_27_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r45 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](13); return ctx_r45.scrollToId(_r1); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](28, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](29, "SIP Transport");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](30, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "mat-form-field", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "mat-select", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](33, "mat-option", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](34, "UDP");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](35, "mat-option", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](36, "TCP");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](37, "mat-accordion", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](38, "mat-expansion-panel", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SipSettingsComponent_div_3_Template_mat_expansion_panel_opened_38_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r46 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r46.AudioSettingsOpenState = true; })("closed", function SipSettingsComponent_div_3_Template_mat_expansion_panel_closed_38_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r47 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r47.AudioSettingsOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](39, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](40, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](41, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](42, SipSettingsComponent_div_3_div_42_Template, 3, 0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](43, SipSettingsComponent_div_3_ng_template_43_Template, 2, 0, "ng-template", null, 31, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](45, " Audio Settings ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](46, "table", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](47, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_47_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r48 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](41); return ctx_r48.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](48, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](49, "Output Volume");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](50, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](51, "mat-slider", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SipSettingsComponent_div_3_Template_mat_slider_input_51_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r49 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r49.onVolumeChange($event, "sip_volume"); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](52);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](53, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_53_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r50 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](41); return ctx_r50.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](54, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](55, "Input gain");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](56, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](57, "mat-slider", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function SipSettingsComponent_div_3_Template_mat_slider_input_57_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r51 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r51.onVolumeChange($event, "input_gain"); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](58, "\u00A0dB>");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](59);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](60, SipSettingsComponent_div_3_tr_60_Template, 10, 0, "tr", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](61, SipSettingsComponent_div_3_tr_61_Template, 6, 3, "tr", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](62, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_62_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r52 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](41); return ctx_r52.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](63, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](64, "Half duplex");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](65, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](66, "mat-radio-group", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](67, "mat-radio-button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](68, "On");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](69, "mat-radio-button", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](70, "Off");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](71, SipSettingsComponent_div_3_tr_71_Template, 14, 6, "tr", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](72, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_72_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r53 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](41); return ctx_r53.scrollToId(_r2); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](73, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](74, "Acoustic echo cancellation");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](75, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](76, "mat-radio-group", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](77, "mat-radio-button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](78, "On");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](79, "mat-radio-button", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](80, "Off");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](81, "mat-accordion", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](82, "mat-expansion-panel", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SipSettingsComponent_div_3_Template_mat_expansion_panel_opened_82_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r54 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r54.CallSettingsOpenState = true; })("closed", function SipSettingsComponent_div_3_Template_mat_expansion_panel_closed_82_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r55 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r55.CallSettingsOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](83, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](84, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](85, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](86, SipSettingsComponent_div_3_div_86_Template, 3, 0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](87, SipSettingsComponent_div_3_ng_template_87_Template, 2, 0, "ng-template", null, 39, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](89, " Call Settings ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](90, "table", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](91, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_91_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r56 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](90); return ctx_r56.scrollToId(_r3); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](92, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](93, "Call timeout");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](94, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](95, "input", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](96, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_96_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r57 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](90); return ctx_r57.scrollToId(_r3); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](97, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](98, "Stream timeout");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](99, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](100, "input", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](101, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_101_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r58 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](90); return ctx_r58.scrollToId(_r3); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](102, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](103, "Beep on Call Answer");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](104, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](105, "mat-radio-group", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](106, "mat-radio-button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](107, "On");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](108, "mat-radio-button", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](109, "Off");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](110, "mat-accordion", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](111, "mat-expansion-panel", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SipSettingsComponent_div_3_Template_mat_expansion_panel_opened_111_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r59 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r59.OutboundCallsOpenState = true; })("closed", function SipSettingsComponent_div_3_Template_mat_expansion_panel_closed_111_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r60 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r60.OutboundCallsOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](112, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](113, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](114, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](115, SipSettingsComponent_div_3_div_115_Template, 3, 0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](116, SipSettingsComponent_div_3_ng_template_116_Template, 2, 0, "ng-template", null, 43, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](118, " Outbound Calls ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](119, "table", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](120, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_120_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r61 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](107); return ctx_r61.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](121, "td", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](122, "Input 1");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](123, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_123_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r62 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](107); return ctx_r62.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](124, "table", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](125, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](126, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](127, "Alias");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](128, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](129, "input", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](130, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](131, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](132, "Call ID");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](133, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](134, "input", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](135, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_135_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r63 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](107); return ctx_r63.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](136, "td", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](137, "Input 2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](138, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_138_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r64 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](107); return ctx_r64.scrollToId(_r4); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](139, "table", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](140, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](141, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](142, "Alias");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](143, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](144, "input", 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](145, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](146, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](147, "Call ID");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](148, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](149, "input", 49);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](150, SipSettingsComponent_div_3_ng_container_150_Template, 31, 6, "ng-container", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](151, "mat-accordion", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](152, "mat-expansion-panel", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("opened", function SipSettingsComponent_div_3_Template_mat_expansion_panel_opened_152_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r65 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r65.InboundCallsOpenState = true; })("closed", function SipSettingsComponent_div_3_Template_mat_expansion_panel_closed_152_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r66 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r66.InboundCallsOpenState = false; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](153, "mat-expansion-panel-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](154, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](155, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](156, SipSettingsComponent_div_3_div_156_Template, 3, 0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](157, SipSettingsComponent_div_3_ng_template_157_Template, 2, 0, "ng-template", null, 50, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](159, " Inbound Calls ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](160, "table", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](161, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_161_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r67 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](125); return ctx_r67.scrollToId(_r7); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](162, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](163, "Auto Answer");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](164, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](165, "mat-radio-group", 51);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](166, "mat-radio-button", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](167, "On");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](168, "mat-radio-button", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](169, "Off");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](170, "tr", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_tr_click_170_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r68 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](125); return ctx_r68.scrollToId(_r7); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](171, "td", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](172, "Auto Answer Timeout");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](173, "td", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](174, "input", 52);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](175, "div", 53);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](176, "hr", 54);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](177, "div", 55);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](178, "button", 56);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function SipSettingsComponent_div_3_Template_button_click_178_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r39); const ctx_r69 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r69.cancelChanges(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](179, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](180, "button", 57);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](181, "Submit");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](9);
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](44);
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](88);
    const _r21 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](117);
    const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](158);
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx_r0.show_settings_component);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("formGroup", ctx_r0.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.ProtocolSettingsOpenState)("ngIfElse", _r9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](34, _c0, ctx_r0.form.get("sip_server_ip").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](36, _c0, ctx_r0.form.get("sip_username").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](38, _c0, ctx_r0.form.get("sip_password").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.AudioSettingsOpenState)("ngIfElse", _r12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("\u00A0\u00A0\u00A0", ctx_r0.form.get("sip_volume").value, "% ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("\u00A0\u00A0\u00A0", ctx_r0.form.get("input_gain").value, "% ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model !== "MS-700" && ctx_r0.device_model !== "CZA-1300" && ctx_r0.device_model !== "MS-775" && ctx_r0.device_model !== "Barionet-MAE");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model !== "MS-700" && ctx_r0.device_model !== "CZA-1300" && ctx_r0.device_model !== "MS-775" && ctx_r0.device_model !== "Barionet-MAE" && ctx_r0.form.get("audio_input").value === "MICIN");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("half_duplex").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("half_duplex").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.form.get("half_duplex").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("echo_cancellation").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("echo_cancellation").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.CallSettingsOpenState)("ngIfElse", _r18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](40, _c0, ctx_r0.form.get("sip_call_timeout").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](42, _c0, ctx_r0.form.get("sip_stream_timeout").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("beep_on_answer").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("beep_on_answer").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.OutboundCallsOpenState)("ngIfElse", _r21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](44, _c0, ctx_r0.form.get("autodial1").invalid || ctx_r0.form.get("autodial1_alias").value !== "" && ctx_r0.form.get("autodial1").value === ""));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](46, _c0, ctx_r0.form.get("autodial2").invalid || ctx_r0.form.get("autodial2_alias").value !== "" && ctx_r0.form.get("autodial2").value === ""));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.device_model === "MS-700" || ctx_r0.device_model === "CZA-1300" || ctx_r0.device_model === "MS-775");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.InboundCallsOpenState)("ngIfElse", _r25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("auto_answer").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("auto_answer").value === "false");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](48, _c0, ctx_r0.form.get("auto_answer_timeout").invalid));
} }
function SipSettingsComponent_p_113_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " You can configure up to 2 inputs for outbound calls. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function SipSettingsComponent_p_114_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " You can configure up to 4 inputs for outbound calls. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
class SipSettingsComponent {
    constructor(configsService, httpResponseHandler, systemInfoService, toastrService) {
        this.configsService = configsService;
        this.httpResponseHandler = httpResponseHandler;
        this.systemInfoService = systemInfoService;
        this.toastrService = toastrService;
        /* Forms */
        this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        /* Backup */ //used to check what changed exactly, to decide which message should show while submitting
        this.backupSettingsDict = {};
        this.ucisList = {
            'sip_server_ip': 'epic.sip.domain',
            'sip_username': 'epic.sip.username',
            'sip_password': 'epic.sip.password',
            'sip_transport': 'epic.sip.transport',
            'sip_volume': 'epic.sip.volume',
            'input_gain': 'epic.sip.input_gain',
            'audio_input': 'epic.sip.input',
            //'line_in_gain': 'epic.sip.linein_gain',
            'mic_in_gain': 'epic.sip.micin_gain',
            'half_duplex': 'epic.sip.half_duplex',
            'hdx_level': 'epic.sip.hdx_level',
            'hdx_timeout': 'epic.sip.hdx_timeout',
            'echo_cancellation': 'epic.sip.aec',
            'sip_call_timeout': 'epic.sip.call_timeout',
            'sip_stream_timeout': 'epic.sip.stream_timeout',
            'beep_on_answer': 'epic.sip.beep_on_answer',
            'autodial1_alias': 'epic.sip.autodial1_alias',
            'autodial1': 'epic.sip.autodial1',
            'autodial2_alias': 'epic.sip.autodial2_alias',
            'autodial2': 'epic.sip.autodial2',
            'auto_answer': 'epic.sip.auto_answer',
            'auto_answer_timeout': 'epic.sip.answer_time',
        };
        this.dataIsAvailable = false;
        //loadFinished = false;
        this.show_loading_component = false;
        //whileSubmit = false;
        this.show_settings_component = false;
        /* State Variables */
        this.ProtocolSettingsOpenState = false;
        this.AudioSettingsOpenState = false;
        this.CallSettingsOpenState = false;
        this.OutboundCallsOpenState = false;
        this.InboundCallsOpenState = false;
    }
    ngOnInit() {
        this.dataIsAvailable = false;
        this.systemInfoService.getSystemInfo(["device_model"]).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    this.device_model = data.body["device_model"];
                    if (this.device_model === "MS-700" || this.device_model === 'CZA-1300' || this.device_model === 'MS-775') {
                        this.ucisList["autodial3_alias"] = "epic.sip.autodial3_alias";
                        this.ucisList["autodial3"] = "epic.sip.autodial3";
                        this.ucisList["autodial4_alias"] = "epic.sip.autodial4_alias";
                        this.ucisList["autodial4"] = "epic.sip.autodial4";
                    }
                    this.loadDataFromDevice();
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    loadDataFromDevice() {
        this.dataIsAvailable = false;
        this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        this.configsService.getUcis(this.ucisList).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    //store for backup
                    this.backupSettings(data.body);
                    //build device form group
                    this.buildDeviceFormGroup(data.body);
                    //console.log(this.settingsForm);
                    this.ProtocolSettingsOpenState = false;
                    this.AudioSettingsOpenState = false;
                    this.CallSettingsOpenState = false;
                    this.OutboundCallsOpenState = false;
                    this.InboundCallsOpenState = false;
                    this.show_loading_component = false;
                    this.show_settings_component = true;
                    this.dataIsAvailable = true;
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    backupSettings(configDict) {
        Object.keys(configDict).forEach(key => {
            this.backupSettingsDict[key] = configDict[key];
        });
        //console.log(this.backupSettingsDict);
    }
    getBooleanFromValue(value) {
        let bool;
        switch (value) {
            case "true":
                bool = true;
                break;
            case "false":
                bool = false;
                break;
            case "http":
                bool = false;
                break;
            case "https":
                bool = true;
                break;
            default:
                console.log("Unknown value: ", value);
                break;
        }
        return bool;
    }
    buildDeviceFormGroup(configDict) {
        const SIP_REGEX = "^([0-9]|[1-8][0-9]|9[0-9]|1[0-9]{2}|2[01][0-9]|22[0-3])(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d?|0)){3}$|^(([a-zA-Z0-9-]+\\.)*[a-zA-Z]+)$";
        const INT_NUMBER_REGEX = "^-?\\d+$";
        const DECIMAL_NUMBER_REGEX = "^-?\\d+(\\.\\d+)?";
        const SIP_AUTODIAL_REGEX = "(^$)|(^(sip:\\/\\/.+@([a-zA-Z]+\\.)*[a-zA-Z]+)|([a-zA-Z0-9])+$)";
        this.form.addControl('sip_server_ip', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.domain"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(SIP_REGEX)]));
        this.form.addControl('sip_username', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.username"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.form.addControl('sip_password', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.password"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.form.addControl('sip_transport', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.transport"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.form.addControl('sip_volume', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.volume"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(100)]));
        this.form.addControl('input_gain', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.input_gain"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(100)]));
        this.form.addControl('audio_input', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.input"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.form.addControl('mic_in_gain', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.micin_gain"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(INT_NUMBER_REGEX), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(42)]));
        this.form.addControl('half_duplex', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.half_duplex"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.form.addControl('hdx_level', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.hdx_level"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(DECIMAL_NUMBER_REGEX), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0.0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(1.0)]));
        this.form.addControl('hdx_timeout', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.hdx_timeout"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(INT_NUMBER_REGEX), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(10), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(2000)]));
        this.form.addControl('echo_cancellation', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.aec"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.form.addControl('sip_call_timeout', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.call_timeout"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(600), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(INT_NUMBER_REGEX)]));
        this.form.addControl('sip_stream_timeout', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.stream_timeout"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(600), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(INT_NUMBER_REGEX)]));
        this.form.addControl('beep_on_answer', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.beep_on_answer"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.form.addControl('autodial1_alias', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.autodial1_alias"]));
        this.form.addControl('autodial1', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.autodial1"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(SIP_AUTODIAL_REGEX)));
        this.form.addControl('autodial2_alias', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.autodial2_alias"]));
        this.form.addControl('autodial2', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.autodial2"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(SIP_AUTODIAL_REGEX)));
        if (Object.keys(configDict).includes("epic.sip.autodial3_alias")) {
            this.form.addControl('autodial3_alias', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.autodial3_alias"]));
        }
        if (Object.keys(configDict).includes("epic.sip.autodial3")) {
            this.form.addControl('autodial3', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.autodial3"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(SIP_AUTODIAL_REGEX)));
        }
        if (Object.keys(configDict).includes("epic.sip.autodial4_alias")) {
            this.form.addControl('autodial4_alias', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.autodial4_alias"]));
        }
        if (Object.keys(configDict).includes("epic.sip.autodial4")) {
            this.form.addControl('autodial4', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.autodial4"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(SIP_AUTODIAL_REGEX)));
        }
        this.form.addControl('auto_answer', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.auto_answer"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
        this.form.addControl('auto_answer_timeout', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.sip.answer_time"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(600), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(INT_NUMBER_REGEX)]));
    }
    //Make value update while slider is moving
    onVolumeChange(event, formName) {
        //console.log(event.value);
        this.form.get(formName).setValue(event.value);
    }
    cancelChanges() {
        this.show_settings_component = false;
        /*Object.keys(this.settingsForm.value).forEach(key => {
          this.settingsForm.removeControl(key);
        });
        console.log(this.settingsForm.value);*/
        this.loadDataFromDevice();
    }
    submit() {
        // console.log(this.form);
        if (!this.formIsValid()) {
            this.toastrService.showErrorMessage("Can't submit because configurations are invalid!");
        }
        else {
            this.show_settings_component = false;
            this.submitMessage = "processing...";
            this.show_loading_component = true; // start loading spinner
            setTimeout(() => {
                //build dict with ucis to send
                let settingsToSubmit = {};
                Object.keys(this.form.value).forEach(key => {
                    settingsToSubmit[this.ucisList[key]] = this.form.get(key).value;
                });
                //console.log("settingsToSubmit");
                //console.log(settingsToSubmit);
                this.configsService.setUcis(settingsToSubmit).subscribe(data => {
                    //console.log(data.status);
                    switch (data.status) {
                        case 200: //SUCCESS
                            //this.toastr.show('Configurations set successfully.', '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-success'});
                            this.toastrService.showSuccessMessage('Configurations set successfully.');
                            this.submitMessage = "The application will restart. Please wait. The page will be automatically reloaded.";
                            setTimeout(() => this.loadDataFromDevice(), 4000);
                            break;
                        case 400: //BAD_REQUEST
                            //console.log(data);
                            //this.toastr.show(data.error['msg'], '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                            this.toastrService.showErrorMessage(data.error['msg']);
                            break;
                        case 401:
                            this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                            break;
                        case 500: //INTERNAL_SERVER_ERROR
                            this.httpResponseHandler.handle500HttpErrorResponse();
                            break;
                        default:
                            console.log("Unexpected return code: ", data.status);
                            this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                            break;
                    }
                });
            }, 1300);
        }
    }
    formIsValid() {
        if (this.form.invalid) {
            for (const key of Object.keys(this.form.controls)) {
                if (this.form.controls[key].invalid) {
                    if ((key === "hdx_level" || key === "hdx_timeout") && this.form.controls.half_duplex.value === 'false') {
                        //ignore
                    }
                    else if ((key === "mic_in_gain" || key === "audio_input") && (this.device_model === 'MS-700' || this.device_model === 'CZA-1300' || this.device_model === 'MS-775' || this.device_model === 'Barionet-MAE')) {
                        //ignore
                    }
                    else if (key === "mic_in_gain" && this.device_model !== 'MS-700' && this.device_model !== 'CZA-1300' && this.device_model !== 'MS-775' && this.device_model !== 'Barionet-MAE' && this.form.get('audio_input').value !== 'MICIN') {
                        //ignore
                    }
                    else {
                        console.log("Parameter ", key, "is invalid", this.form.controls[key].value);
                        return false;
                    }
                }
            }
        }
        if ((this.form.get('autodial1_alias').value !== '' && this.form.get('autodial1').value === '')
            || (this.form.get('autodial2_alias').value !== '' && this.form.get('autodial2').value === '')
            || ((this.device_model === "MS-700" || this.device_model === 'CZA-1300' || this.device_model === 'MS-775') && ((this.form.get('autodial3_alias').value !== '' && this.form.get('autodial3').value === '') || (this.form.get('autodial4_alias').value !== '' && this.form.get('autodial4').value === '')))) {
            //this.toastr.show("Configuration is invalid!", '', {closeButton: true, disableTimeOut: true, toastClass: 'my-toast-error'});
            //this.toastrService.showErrorMessage("Configuration is invalid!");
            console.log("Invalid auto dials");
            return false;
        }
        return true;
    }
    scrollToId(el) {
        el.scrollIntoView({ 'behavior': 'smooth' });
    }
}
SipSettingsComponent.ɵfac = function SipSettingsComponent_Factory(t) { return new (t || SipSettingsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_2__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_4__["SystemInfoService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__["ToastrMessageService"])); };
SipSettingsComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: SipSettingsComponent, selectors: [["app-sipsettings"]], decls: 139, vars: 5, consts: [["href", "https://fonts.googleapis.com/icon?family=Material+Icons", "rel", "stylesheet"], [1, "container"], [1, "tab-content"], ["class", "content", 3, "hidden", 4, "ngIf"], [1, "content", 3, "hidden"], [1, "loading-ripple"], ["src", "assets/images/Ripple-1s-170px.gif"], [1, "tab-help"], ["sipProtocolSettings", ""], ["sipAudioSettings", ""], ["sipCallSettings", ""], ["sipOutCalls", ""], [4, "ngIf"], ["sipInCalls", ""], ["autocomplete", "off", 3, "formGroup", "ngSubmit"], [2, "width", "550px"], ["hideToggle", "", 1, "config-card", "mat-elevation-z0", 3, "opened", "closed"], [1, "visual"], [4, "ngIf", "ngIfElse"], ["ProtocolSettingsClosedPanel", ""], [1, "t1"], [3, "click"], [1, "label"], [1, "value"], ["matInput", "", "placeholder", "SIP Server IP Address", "formControlName", "sip_server_ip", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "SIP username", "formControlName", "sip_username", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "SIP password", "formControlName", "sip_password", "type", "password", 1, "input", 3, "ngClass"], ["appearance", "fill"], ["formControlName", "sip_transport"], ["value", "udp"], ["value", "tcp"], ["AudioSettingsClosedPanel", ""], ["min", "0", "max", "100", "step", "1", "formControlName", "sip_volume", 3, "input"], ["min", "0", "max", "100", "step", "1", "formControlName", "input_gain", 3, "input"], [3, "click", 4, "ngIf"], ["aria-label", "Select an option", "formControlName", "half_duplex"], ["value", "true", 3, "checked"], ["value", "false", 3, "checked"], ["aria-label", "Select an option", "formControlName", "echo_cancellation"], ["CallSettingsClosedPanel", ""], ["matInput", "", "placeholder", "Call timeout", "formControlName", "sip_call_timeout", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Stream timeout", "formControlName", "sip_stream_timeout", 1, "input", 3, "ngClass"], ["aria-label", "Select an option", "formControlName", "beep_on_answer"], ["OutboundCallsClosedPanel", ""], ["colspan", "2", 1, "label"], [1, "section3"], ["matInput", "", "placeholder", "Input 1 Alias", "formControlName", "autodial1_alias", 1, "input"], ["matInput", "", "placeholder", "Input 1 Call ID", "formControlName", "autodial1", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Input 2 Alias", "formControlName", "autodial2_alias", 1, "input"], ["matInput", "", "placeholder", "Input 2 Call ID", "formControlName", "autodial2", 1, "input", 3, "ngClass"], ["InboundCallsClosedPanel", ""], ["aria-label", "Select an option", "formControlName", "auto_answer"], ["matInput", "", "placeholder", "Auto Answer Timeout", "formControlName", "auto_answer_timeout", 1, "input", 3, "ngClass"], [2, "width", "580px"], [2, "margin-top", "20px", "margin-left", "0"], [2, "float", "right"], ["type", "button", 1, "redBtn", "actionBtn", 3, "click"], ["type", "submit", 1, "submitBtn", "actionBtn"], ["formControlName", "audio_input"], ["value", "LINEIN"], ["value", "MICIN"], ["matInput", "", "placeholder", "Mic In gain", "formControlName", "mic_in_gain", 1, "input", 3, "ngClass"], ["colspan", "2"], ["matInput", "", "placeholder", "Half duplex level", "formControlName", "hdx_level", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Half duplex timeout", "formControlName", "hdx_timeout", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Input 3 Alias", "formControlName", "autodial3_alias", 1, "input"], ["matInput", "", "placeholder", "Input 3 Call ID", "formControlName", "autodial3", 1, "input", 3, "ngClass"], ["matInput", "", "placeholder", "Input 4 Alias", "formControlName", "autodial4_alias", 1, "input"], ["matInput", "", "placeholder", "Input 4 Call ID", "formControlName", "autodial4", 1, "input", 3, "ngClass"]], template: function SipSettingsComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "link", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, SipSettingsComponent_div_3_Template, 182, 50, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "img", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11, "Help");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "h3", null, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](14, "SIP Protocol Settings");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, "Configure SIP Protocol Settings:");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](20, "SIP Domain");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](21, ": Server Domain Name or IP address;");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](24, "SIP ID (username)");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25, ": SIP account ID or username;");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28, "SIP Password");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](29, ": SIP account password;");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](30, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](32, "SIP Transport");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33, ": SIP transport supported is by ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](34, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](35, "UDP");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](36, " or ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](37, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](38, "TCP");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](39, ".");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](40, "h3", null, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](42, "SIP Audio Settings");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](43, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](44, "Output Volume");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](45, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](46, " Relative output volume for SIP calls. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](47, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](48, "Input Gain");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](49, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](50, " Configure the gain, in percentage (%), for the audio input.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](51, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](52, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](53, "Input Interface");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](54, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](55, " Selection of audio input interface.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](56, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](57, " Inputs supported are ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](58, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](59, "\"Mic In\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](60, " or ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](61, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](62, "\"Line in\"");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](63, ". ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](64, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](65, "Mic Gain");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](66, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](67, " Configure the gain, in dBs, for the Mic In input interface.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](68, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](69, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](70, "Half-duplex");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](71, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](72, " Enable or disable half-duplex for SIP calls. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](73, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](74, "Half-duplex level");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](75, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](76, " Incoming audio level which puts the device in \"Listen\" mode. Accepts values from 0.0 to 1.0");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](77, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](78, " Only available when half-duplex is enabled. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](79, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](80, "Half-duplex timeout");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](81, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](82, " Timeout, in milliseconds, to switch back to \"Talk\" mode if no incoming audio is detected. Accepts values from 10 to 1000.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](83, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](84, " Only available when half-duplex is enabled. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](85, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](86, "Acoustic Echo Cancellation");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](87, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](88, " Enable or disable echo cancellation for SIP calls. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](89, "h3", null, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](91, "SIP Call Settings");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](92, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](93, "Configure general call settings.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](94, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](95, "Call Timeout");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](96, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](97, " Configure the maximum duration of an established call, in seconds. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](98, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](99, "Stream Timeout");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](100, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](101, " Configure the timeout for a silent stream, in seconds. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](102, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](103, "Beep on Call Answer");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](104, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](105, " Enable or disable beep tune when answering SIP calls. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](106, "h3", null, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](108, "SIP Outbound Calls");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](109, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](110, "Configure Outbound Calls settings.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](111, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](112, "Inputs");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](113, SipSettingsComponent_p_113_Template, 2, 0, "p", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](114, SipSettingsComponent_p_114_Template, 2, 0, "p", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](115, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](116, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](117, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](118, "Alias");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](119, ": define an alias for the input; ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](120, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](121, "b");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](122, "Call ID");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](123, ": set the call ID for the input; ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](124, "h3", null, 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](126, "SIP Inbound Calls Settings");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](127, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](128, "Configure Inbound Calls settings.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](129, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](130, "Auto Answer");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](131, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](132, " Enable or disable Auto Answer for Inbound Calls. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](133, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](134, "Auto Answer Timeout");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](135, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](136, " Configure the timeout for auto answer, in seconds. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](137, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](138, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.dataIsAvailable);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx.show_loading_component);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx.submitMessage);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](105);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.device_model !== "MS-700" && ctx.device_model !== "MS-775" && ctx.device_model !== "CZA-1300");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.device_model === "MS-700" || ctx.device_model === "MS-775" || ctx.device_model === "CZA-1300");
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_6__["NgIf"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["ɵangular_packages_forms_forms_y"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroupDirective"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_7__["MatAccordion"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_7__["MatExpansionPanel"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_7__["MatExpansionPanelHeader"], _angular_material_expansion__WEBPACK_IMPORTED_MODULE_7__["MatExpansionPanelTitle"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControlName"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgClass"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_8__["DefaultClassDirective"], _angular_material_form_field__WEBPACK_IMPORTED_MODULE_9__["MatFormField"], _angular_material_select__WEBPACK_IMPORTED_MODULE_10__["MatSelect"], _angular_material_core__WEBPACK_IMPORTED_MODULE_11__["MatOption"], _angular_material_slider__WEBPACK_IMPORTED_MODULE_12__["MatSlider"], _angular_material_radio__WEBPACK_IMPORTED_MODULE_13__["MatRadioGroup"], _angular_material_radio__WEBPACK_IMPORTED_MODULE_13__["MatRadioButton"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL3NpcC1zZXR0aW5ncy9zaXAtc2V0dGluZ3MuY29tcG9uZW50LmNzcyJ9 */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](SipSettingsComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-sipsettings',
                templateUrl: './sip-settings.component.html',
                styleUrls: ['./sip-settings.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_2__["DeviceConfigService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"] }, { type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_4__["SystemInfoService"] }, { type: _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__["ToastrMessageService"] }]; }, null); })();


/***/ }),

/***/ "MA3z":
/*!****************************************************************!*\
  !*** ./src/app/background-music/background-music.component.ts ***!
  \****************************************************************/
/*! exports provided: BackgroundMusicComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BackgroundMusicComponent", function() { return BackgroundMusicComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _validators_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../validators/utils */ "/q1Y");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/system-info.service */ "4e9C");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _angular_material_slider__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/slider */ "5RNC");












const _c0 = function (a0) { return { "input-error": a0 }; };
function BackgroundMusicComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "form", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngSubmit", function BackgroundMusicComponent_div_3_Template_form_ngSubmit_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5); const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r4.submit(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "table", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Stream URL");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "input", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10, "Volume");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "mat-slider", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function BackgroundMusicComponent_div_3_Template_mat_slider_input_12_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r6.onVolumeChange($event, "bgm_volume"); })("mousedown", function BackgroundMusicComponent_div_3_Template_mat_slider_mousedown_12_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r7.changing_volume = true; });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "td", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, "Buffer size");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](18, "input", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](20, "hr", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function BackgroundMusicComponent_div_3_Template_button_click_22_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r8.cancelChanges(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](23, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25, "Submit");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx_r0.show_settings_component);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("formGroup", ctx_r0.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](5, _c0, ctx_r0.form.get("bgm_url").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("\u00A0\u00A0\u00A0", ctx_r0.form.get("bgm_volume").value, "% ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](7, _c0, ctx_r0.form.get("bgm_buffer_size").invalid));
} }
class BackgroundMusicComponent {
    constructor(configsService, httpResponseHandler, systemInfoService, toastrService) {
        this.configsService = configsService;
        this.httpResponseHandler = httpResponseHandler;
        this.systemInfoService = systemInfoService;
        this.toastrService = toastrService;
        /* Forms */
        this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        /* Backup */ //used to check what changed exactly, to decide which message should show while submitting
        this.backupSettingsDict = {};
        this.ucisList = {
            'bgm_url': 'epic.bgm.url',
            'bgm_buffer_size': 'epic.bgm.buffer_size',
            'bgm_volume': 'epic.bgm.volume'
        };
        //System type
        this.HW_type_ID = null;
        this.hasSNMPSettings = false;
        this.hasPoESettings = false;
        this.dataIsAvailable = false;
        //loadFinished = false;
        this.show_loading_component = false;
        //whileSubmit = false;
        this.show_settings_component = false;
        this.changing_volume = false;
    }
    ngOnInit() {
        this.loadDataFromDevice();
    }
    loadDataFromDevice() {
        this.dataIsAvailable = false;
        this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        this.configsService.getUcis(this.ucisList).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    //store for backup
                    this.backupSettings(data.body);
                    //build device form group
                    this.buildDeviceFormGroup(data.body);
                    this.show_loading_component = false;
                    this.show_settings_component = true;
                    this.dataIsAvailable = true;
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    backupSettings(configDict) {
        Object.keys(configDict).forEach(key => {
            this.backupSettingsDict[key] = configDict[key];
        });
        //console.log(this.backupSettingsDict);
    }
    getBooleanFromValue(value) {
        let bool;
        switch (value) {
            case "true":
                bool = true;
                break;
            case "false":
                bool = false;
                break;
            case "http":
                bool = false;
                break;
            case "https":
                bool = true;
                break;
            default:
                console.log("Unknown value: ", value);
                break;
        }
        return bool;
    }
    buildDeviceFormGroup(configDict) {
        const BGM_URL_REGEX = "(^$)|(^rtp:\\/\\/((2(?:2[4-9]|3\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d?|0)){3}:)|@:|0.0.0.0:)(102[4-9]|10[3-9][0-9]|1[1-9][0-9]{2}|[2-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])(\\?format=\\w+&channels=\\d&rate=\\d+(&pt=\\d+)?)?$)";
        this.form.addControl('bgm_url', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.bgm.url"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(BGM_URL_REGEX)]));
        this.form.addControl('bgm_buffer_size', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.bgm.buffer_size"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(50), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(10000), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(_validators_utils__WEBPACK_IMPORTED_MODULE_2__["INT_NUMBER_REGEX"])]));
        this.form.addControl('bgm_volume', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.bgm.volume"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(100)]));
        //console.log(this.form);
    }
    //Make value update while slider is moving
    onVolumeChange(event, formName) {
        //console.log(event.value);
        this.form.get(formName).setValue(event.value);
    }
    cancelChanges() {
        this.show_settings_component = false;
        /*Object.keys(this.form.value).forEach(key => {
          this.form.removeControl(key);
        });
        console.log(this.form.value);*/
        this.loadDataFromDevice();
    }
    submit() {
        //console.log(this.form);
        //check if passwords are valid
        if (!this.form.valid) {
            //this.toastr.show("Can't submit because configurations are invalid!", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
            this.toastrService.showErrorMessage("Can't submit because configurations are invalid!");
        }
        else {
            this.show_settings_component = false;
            this.submitMessage = "processing...";
            this.show_loading_component = true; // start loading spinner
            setTimeout(() => {
                //build dict with ucis to send
                let settingsToSubmit = {};
                Object.keys(this.form.value).forEach(key => {
                    settingsToSubmit[this.ucisList[key]] = this.form.get(key).value;
                });
                //console.log("settingsToSubmit");
                //console.log(settingsToSubmit);
                this.configsService.setUcis(settingsToSubmit).subscribe(data => {
                    //console.log(data.status);
                    switch (data.status) {
                        case 200: //SUCCESS
                            //this.toastr.show('Configurations set successfully.', '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-success'});
                            this.toastrService.showSuccessMessage('Configurations set successfully.');
                            this.submitMessage = "The application will restart. Please wait. The page will be automatically reloaded.";
                            setTimeout(() => this.loadDataFromDevice(), 4000);
                            break;
                        case 400: //BAD_REQUEST
                            //console.log(data);
                            //this.toastr.show(data.error['msg'], '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                            this.toastrService.showErrorMessage(data.error['msg']);
                            break;
                        case 401:
                            this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                            break;
                        case 500: //INTERNAL_SERVER_ERROR
                            this.httpResponseHandler.handle500HttpErrorResponse();
                            break;
                        default:
                            console.log("Unexpected return code: ", data.status);
                            this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                            break;
                    }
                });
            }, 1300);
        }
    }
    scrollToId(el) {
        el.scrollIntoView({ 'behavior': 'smooth' });
    }
}
BackgroundMusicComponent.ɵfac = function BackgroundMusicComponent_Factory(t) { return new (t || BackgroundMusicComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_3__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_5__["SystemInfoService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_toastr_message_service__WEBPACK_IMPORTED_MODULE_6__["ToastrMessageService"])); };
BackgroundMusicComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: BackgroundMusicComponent, selectors: [["app-background-music"]], decls: 44, vars: 3, consts: [["href", "https://fonts.googleapis.com/icon?family=Material+Icons", "rel", "stylesheet"], [1, "container"], [1, "tab-content"], ["class", "content", 3, "hidden", 4, "ngIf"], [1, "content", 3, "hidden"], [1, "loading-ripple"], ["src", "assets/images/Ripple-1s-170px.gif"], [1, "tab-help"], ["streamURL", ""], ["volume", ""], ["bufferSize", ""], ["autocomplete", "off", 3, "formGroup", "ngSubmit"], [1, "t1"], [1, "label"], [1, "value"], ["matInput", "", "placeholder", "Stream URL", "formControlName", "bgm_url", 1, "input", 3, "ngClass"], ["min", "0", "max", "100", "step", "1", "formControlName", "bgm_volume", 3, "input", "mousedown"], ["matInput", "", "placeholder", "Buffer Size", "formControlName", "bgm_buffer_size", 1, "input", 3, "ngClass"], [2, "width", "580px"], [2, "margin-top", "20px", "margin-left", "0"], [2, "float", "right"], ["type", "button", 1, "redBtn", "actionBtn", 3, "click"], ["type", "submit", 1, "submitBtn", "actionBtn"]], template: function BackgroundMusicComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "link", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, BackgroundMusicComponent_div_3_Template, 26, 9, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](6, "img", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11, "Help");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "h3");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13, "Background Music");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15, "Configure the settings for the background music.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "h4", null, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18, "Stream URL");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](20, " Set the source IP Address and Port of the RTP Stream.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](21, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](22, " Valid formats are: ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](26, "rtp://<mcast_ip>:<port>");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](27, " for multicast RTP. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](28, "li");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "em");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](30, "rtp://0.0.0.0:<port>");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](31, " for unicast RTP. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "h4", null, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](34, "Volume");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](35, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](36, " Set the relative volume for the background music. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](37, "h4", null, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](39, "Buffer Size");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](40, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](41, " Set the size of the playback buffer for background music, in milliseconds. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](42, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](43, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.dataIsAvailable);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx.show_loading_component);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx.submitMessage);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_7__["NgIf"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["ɵangular_packages_forms_forms_y"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatusGroup"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroupDirective"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["DefaultValueAccessor"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["NgControlStatus"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControlName"], _angular_common__WEBPACK_IMPORTED_MODULE_7__["NgClass"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_8__["DefaultClassDirective"], _angular_material_slider__WEBPACK_IMPORTED_MODULE_9__["MatSlider"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2JhY2tncm91bmQtbXVzaWMvYmFja2dyb3VuZC1tdXNpYy5jb21wb25lbnQuY3NzIn0= */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](BackgroundMusicComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-background-music',
                templateUrl: './background-music.component.html',
                styleUrls: ['./background-music.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_3__["DeviceConfigService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__["HTTPResponseHandlerService"] }, { type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_5__["SystemInfoService"] }, { type: _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_6__["ToastrMessageService"] }]; }, null); })();


/***/ }),

/***/ "S1LR":
/*!************************************************************************!*\
  !*** ./src/app/open-source-licenses/open-source-licenses.component.ts ***!
  \************************************************************************/
/*! exports provided: OpenSourceLicensesComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OpenSourceLicensesComponent", function() { return OpenSourceLicensesComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/material/dialog */ "0IaG");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/material/table */ "+0xr");






function OpenSourceLicensesComponent_div_0_th_7_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "Package");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function OpenSourceLicensesComponent_div_0_td_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const elem_r9 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](elem_r9[0]);
} }
function OpenSourceLicensesComponent_div_0_th_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "Version");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function OpenSourceLicensesComponent_div_0_td_11_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const elem_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](elem_r10[1]);
} }
function OpenSourceLicensesComponent_div_0_th_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "License");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function OpenSourceLicensesComponent_div_0_td_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const elem_r11 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](elem_r11[2]);
} }
function OpenSourceLicensesComponent_div_0_tr_15_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "tr", 19);
} }
function OpenSourceLicensesComponent_div_0_tr_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "tr", 20);
} }
function OpenSourceLicensesComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "header", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function OpenSourceLicensesComponent_div_0_Template_button_click_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r13.closeModal(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "X");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "section", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "table", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](6, 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](7, OpenSourceLicensesComponent_div_0_th_7_Template, 2, 0, "th", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, OpenSourceLicensesComponent_div_0_td_8_Template, 2, 1, "td", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](9, 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, OpenSourceLicensesComponent_div_0_th_10_Template, 2, 0, "th", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](11, OpenSourceLicensesComponent_div_0_td_11_Template, 2, 1, "td", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](12, 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, OpenSourceLicensesComponent_div_0_th_13_Template, 2, 0, "th", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](14, OpenSourceLicensesComponent_div_0_td_14_Template, 2, 1, "td", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](15, OpenSourceLicensesComponent_div_0_tr_15_Template, 1, 0, "tr", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](16, OpenSourceLicensesComponent_div_0_tr_16_Template, 1, 0, "tr", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("dataSource", ctx_r0.tableData);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matHeaderRowDef", ctx_r0.displayedColumns);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matRowDefColumns", ctx_r0.displayedColumns);
} }
class OpenSourceLicensesComponent {
    constructor(dialogRef, data) {
        this.dialogRef = dialogRef;
        this.data = data;
        this.displayedColumns = ['package', 'version', 'license'];
        this.tableData = [];
        this.showData = false;
    }
    ngOnInit() {
        console.log(this.data);
        this.tableData = this.data.slice(1, this.data.length - 1);
        this.showData = true;
    }
    closeModal() {
        this.dialogRef.close();
    }
}
OpenSourceLicensesComponent.ɵfac = function OpenSourceLicensesComponent_Factory(t) { return new (t || OpenSourceLicensesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialogRef"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MAT_DIALOG_DATA"])); };
OpenSourceLicensesComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: OpenSourceLicensesComponent, selectors: [["app-open-source-licenses"]], decls: 1, vars: 1, consts: [["id", "modal-content-wrapper", 4, "ngIf"], ["id", "modal-content-wrapper"], ["id", "modal-header"], ["type", "button", 1, "closeIcon", 3, "click"], ["id", "modal-body"], ["mat-table", "", 3, "dataSource"], ["matColumnDef", "package"], ["mat-header-cell", "", "class", "headers", 4, "matHeaderCellDef"], ["mat-cell", "", "style", "padding-right: 24px;", 4, "matCellDef"], ["matColumnDef", "version"], ["mat-cell", "", "style", "padding-left: 8px; padding-right: 24px;", 4, "matCellDef"], ["matColumnDef", "license"], ["mat-cell", "", "style", "padding-left: 8px;", 4, "matCellDef"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], ["mat-header-cell", "", 1, "headers"], ["mat-cell", "", 2, "padding-right", "24px"], ["mat-cell", "", 2, "padding-left", "8px", "padding-right", "24px"], ["mat-cell", "", 2, "padding-left", "8px"], ["mat-header-row", ""], ["mat-row", ""]], template: function OpenSourceLicensesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, OpenSourceLicensesComponent_div_0_Template, 17, 3, "div", 0);
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showData);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_2__["NgIf"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatTable"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatColumnDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatHeaderCellDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatCellDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatHeaderRowDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatRowDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatHeaderCell"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatCell"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatHeaderRow"], _angular_material_table__WEBPACK_IMPORTED_MODULE_3__["MatRow"]], styles: [".closeIcon[_ngcontent-%COMP%] {\n    float: right;\n    top: -15px;\n    right: -15px;\n    background-color: transparent;\n    border: none;\n    text-align: center;\n    cursor: pointer;\n}\n\n.headers[_ngcontent-%COMP%] {\n    text-align: center;\n    font-size: 18px;\n    font-weight: 500;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvb3Blbi1zb3VyY2UtbGljZW5zZXMvb3Blbi1zb3VyY2UtbGljZW5zZXMuY29tcG9uZW50LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtJQUNJLFlBQVk7SUFDWixVQUFVO0lBQ1YsWUFBWTtJQUNaLDZCQUE2QjtJQUM3QixZQUFZO0lBQ1osa0JBQWtCO0lBQ2xCLGVBQWU7QUFDbkI7O0FBRUE7SUFDSSxrQkFBa0I7SUFDbEIsZUFBZTtJQUNmLGdCQUFnQjtBQUNwQiIsImZpbGUiOiJzcmMvYXBwL29wZW4tc291cmNlLWxpY2Vuc2VzL29wZW4tc291cmNlLWxpY2Vuc2VzLmNvbXBvbmVudC5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuY2xvc2VJY29uIHtcbiAgICBmbG9hdDogcmlnaHQ7XG4gICAgdG9wOiAtMTVweDtcbiAgICByaWdodDogLTE1cHg7XG4gICAgYmFja2dyb3VuZC1jb2xvcjogdHJhbnNwYXJlbnQ7XG4gICAgYm9yZGVyOiBub25lO1xuICAgIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgICBjdXJzb3I6IHBvaW50ZXI7XG59XG5cbi5oZWFkZXJzIHtcbiAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gICAgZm9udC1zaXplOiAxOHB4O1xuICAgIGZvbnQtd2VpZ2h0OiA1MDA7XG59Il19 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](OpenSourceLicensesComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-open-source-licenses',
                templateUrl: './open-source-licenses.component.html',
                styleUrls: ['./open-source-licenses.component.css']
            }]
    }], function () { return [{ type: _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialogRef"] }, { type: undefined, decorators: [{
                type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Inject"],
                args: [_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MAT_DIALOG_DATA"]]
            }] }]; }, null); })();


/***/ }),

/***/ "SLeU":
/*!**********************************************************!*\
  !*** ./src/app/services/httpresponse-handler.service.ts ***!
  \**********************************************************/
/*! exports provided: HTTPResponseHandlerService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HTTPResponseHandlerService", function() { return HTTPResponseHandlerService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var ngx_toastr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ngx-toastr */ "5eHb");
/* harmony import */ var _toastr_message_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./toastr-message.service */ "XtJy");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ "tyNb");





class HTTPResponseHandlerService {
    constructor(toastr, toastrService, router) {
        this.toastr = toastr;
        this.toastrService = toastrService;
        this.router = router;
    }
    handle401HttpErrorResponse(msg) {
        if (msg === "Login required") {
            //console.log(msg);
            this.router.navigate(['/login']);
        }
        else if (msg === "Invalid username or password") {
            this.toastr.show(msg, '', { closeButton: true, timeOut: 5000, toastClass: 'my-toast-error', positionClass: 'absolute-top-right' });
            //this.router.navigate(['/login']);
        }
        else if (msg === "Session expired") {
            let sessionExpireToasts = document.getElementsByClassName("session-expired");
            //console.log(sessionExpireToasts.length);
            if (sessionExpireToasts.length === 0) { //prevent from showing multiple session expired toasts
                this.toastr.show(msg, '', { closeButton: true, timeOut: 5000, toastClass: 'my-toast-error session-expired', positionClass: 'absolute-top-right' });
                this.router.navigate(['/login']);
            }
        }
        /*let loginRequiredToasts = document.getElementsByClassName("login-required");
        console.log(sessionExpireToasts.length);
        if (sessionExpireToasts.length === 0){
            this.toastr.show(msg, '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error login-required', positionClass: 'absolute-top-right'});
            this.router.navigate(['/login']);
        }*/
    }
    handle500HttpErrorResponse() {
        let error_msg = "An internal error has occurred. Please try again or reboot your device if error persists.";
        //this.toastr.show(error_msg, '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
        this.toastrService.showErrorMessage(error_msg);
    }
    handleUnexpectedHttpErrorResponse(code) {
        let error_msg = "An unexpected error occurred. Please try again or reboot your device if error persists.";
        //this.toastr.show(error_msg, '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
        this.toastrService.showErrorMessage(error_msg);
    }
}
HTTPResponseHandlerService.ɵfac = function HTTPResponseHandlerService_Factory(t) { return new (t || HTTPResponseHandlerService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](ngx_toastr__WEBPACK_IMPORTED_MODULE_1__["ToastrService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_toastr_message_service__WEBPACK_IMPORTED_MODULE_2__["ToastrMessageService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_router__WEBPACK_IMPORTED_MODULE_3__["Router"])); };
HTTPResponseHandlerService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: HTTPResponseHandlerService, factory: HTTPResponseHandlerService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](HTTPResponseHandlerService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: ngx_toastr__WEBPACK_IMPORTED_MODULE_1__["ToastrService"] }, { type: _toastr_message_service__WEBPACK_IMPORTED_MODULE_2__["ToastrMessageService"] }, { type: _angular_router__WEBPACK_IMPORTED_MODULE_3__["Router"] }]; }, null); })();


/***/ }),

/***/ "Sy1n":
/*!**********************************!*\
  !*** ./src/app/app.component.ts ***!
  \**********************************/
/*! exports provided: AppComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppComponent", function() { return AppComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/platform-browser */ "jhN1");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./services/system-info.service */ "4e9C");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "tyNb");






class AppComponent {
    constructor(titleService, systemInfoService, httpResponseHandler) {
        this.titleService = titleService;
        this.systemInfoService = systemInfoService;
        this.httpResponseHandler = httpResponseHandler;
    }
    ngOnInit() {
        this.systemInfoService.getSystemInfo(["device_model"]).subscribe(data => {
            switch (data.status) {
                case 200:
                    this.titleService.setTitle("Audio Enhancement | " + data.body["device_model"]);
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
}
AppComponent.ɵfac = function AppComponent_Factory(t) { return new (t || AppComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_platform_browser__WEBPACK_IMPORTED_MODULE_1__["Title"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_2__["SystemInfoService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"])); };
AppComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: AppComponent, selectors: [["app-root"]], decls: 1, vars: 0, template: function AppComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "router-outlet");
    } }, directives: [_angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterOutlet"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2FwcC5jb21wb25lbnQuY3NzIn0= */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](AppComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-root',
                templateUrl: './app.component.html',
                styleUrls: ['./app.component.css']
            }]
    }], function () { return [{ type: _angular_platform_browser__WEBPACK_IMPORTED_MODULE_1__["Title"] }, { type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_2__["SystemInfoService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"] }]; }, null); })();


/***/ }),

/***/ "T20q":
/*!**********************************************************!*\
  !*** ./src/app/toast-message/toast-message.component.ts ***!
  \**********************************************************/
/*! exports provided: ToastMessageComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ToastMessageComponent", function() { return ToastMessageComponent; });
/* harmony import */ var _angular_animations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/animations */ "R0Ic");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var ngx_toastr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ngx-toastr */ "5eHb");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "ofXK");






const _c0 = ["app-toast-message", ""];
function ToastMessageComponent_span_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "span", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵlistener"]("click", function ToastMessageComponent_span_1_Template_span_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵrestoreView"](_r2); const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵnextContext"](); return ctx_r1.remove(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](1, " close ");
    _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
} }
class ToastMessageComponent extends ngx_toastr__WEBPACK_IMPORTED_MODULE_2__["Toast"] {
    constructor(toastrService, toastPackage) {
        super(toastrService, toastPackage);
        this.toastrService = toastrService;
        this.toastPackage = toastPackage;
        // used for demo purposes
        this.undoString = 'undo';
    }
    action(event) {
        event.stopPropagation();
        this.undoString = 'undid';
        this.toastPackage.triggerAction();
        return false;
    }
}
ToastMessageComponent.ɵfac = function ToastMessageComponent_Factory(t) { return new (t || ToastMessageComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ngx_toastr__WEBPACK_IMPORTED_MODULE_2__["ToastrService"]), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](ngx_toastr__WEBPACK_IMPORTED_MODULE_2__["ToastPackage"])); };
ToastMessageComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineComponent"]({ type: ToastMessageComponent, selectors: [["", "app-toast-message", ""]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵInheritDefinitionFeature"]], attrs: _c0, decls: 5, vars: 5, consts: [[1, "row"], ["class", "btn btn-close material-icons", 3, "click", 4, "ngIf"], ["role", "alert", "aria-live", "polite"], [2, "white-space", "pre-line"], [1, "btn", "btn-close", "material-icons", 3, "click"]], template: function ToastMessageComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtemplate"](1, ToastMessageComponent_span_1_Template, 2, 0, "span", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementStart"](3, "span", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtext"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵstyleProp"]("display", ctx.state.value === "inactive" ? "none" : "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵproperty"]("ngIf", ctx.options.closeButton);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵattribute"]("aria-label", ctx.message);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵtextInterpolate"](ctx.message);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_3__["NgIf"]], styles: ["[_nghost-%COMP%] {\n    position: relative;\n    overflow: hidden;\n    margin: 0 0 6px;\n    padding: 15px 25px 15px 15px;\n    width: 400px;\n    border-radius: 3px 3px 3px 3px;\n    background-position: 15px center;\n    background-repeat: no-repeat;\n    background-size: 24px;\n    \n    font-family: sans-serif;\n    font-size: 15px;\n\n    pointer-events: auto;\n    cursor: pointer;\n\n\n\n    line-height: 16px;\n    \n}\n\n.btn-close[_ngcontent-%COMP%] {\n    position: absolute;\n    top: 3px;\n    right: 3px;\n    color: #000000;\n    opacity: 0.3;\n    font-size: 18px;\n}\n\n.btn-close[_ngcontent-%COMP%]:hover {\n    opacity: 0.7;\n}\n\n  .toast-container {\n    position: absolute;\n}\n\n\n\n\n\n  .my-toast-error {\n    color: #a94442;\n    background-color: #f2dede;\n    border-color: #ebccd1;\n}\n\n  .my-toast-warning {\n    color: #8a6d3b;\n    background-color: #fcf8e3;\n    border-color: #faebcc;\n}\n\n  .my-toast-success {\n    color: #3c763d;\n    background-color: #dff0d8;\n    border-color: #d6e9c6;\n}\n\n  .absolute-top-right {\n    top: 10px;\n    right: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"], data: { animation: [
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["trigger"])('flyInOut', [
                Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["state"])('inactive', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                    opacity: 0,
                })),
                Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["transition"])('inactive => active', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('500ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["keyframes"])([
                    Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                        transform: 'translate3d(100%, 0, 0)',
                        opacity: 0,
                    }),
                    Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                        transform: 'none',
                        opacity: 1,
                    }),
                ]))),
                Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["transition"])('active => removed', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('400ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["keyframes"])([
                    Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                        opacity: 1,
                    }),
                    Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                        transform: 'translate3d(100%, 0, 0) skewX(30deg)',
                        opacity: 0,
                    }),
                ]))),
            ]),
        ] } });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](ToastMessageComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"],
        args: [{
                selector: '[app-toast-message]',
                templateUrl: './toast-message.component.html',
                styleUrls: ['./toast-message.component.css'],
                animations: [
                    Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["trigger"])('flyInOut', [
                        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["state"])('inactive', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                            opacity: 0,
                        })),
                        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["transition"])('inactive => active', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('500ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["keyframes"])([
                            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                                transform: 'translate3d(100%, 0, 0)',
                                opacity: 0,
                            }),
                            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                                transform: 'none',
                                opacity: 1,
                            }),
                        ]))),
                        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["transition"])('active => removed', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('400ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["keyframes"])([
                            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                                opacity: 1,
                            }),
                            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                                transform: 'translate3d(100%, 0, 0) skewX(30deg)',
                                opacity: 0,
                            }),
                        ]))),
                    ]),
                ],
                preserveWhitespaces: false,
            }]
    }], function () { return [{ type: ngx_toastr__WEBPACK_IMPORTED_MODULE_2__["ToastrService"] }, { type: ngx_toastr__WEBPACK_IMPORTED_MODULE_2__["ToastPackage"] }]; }, null); })();


/***/ }),

/***/ "XtJy":
/*!****************************************************!*\
  !*** ./src/app/services/toastr-message.service.ts ***!
  \****************************************************/
/*! exports provided: ToastrMessageService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ToastrMessageService", function() { return ToastrMessageService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var ngx_toastr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ngx-toastr */ "5eHb");



class ToastrMessageService {
    constructor(toastr) {
        this.toastr = toastr;
        this.DEFAULT_TOASTR_TIMEOUT = 10000; //10s
    }
    showWarningMessage(message, disableTimeout = false, timeout = this.DEFAULT_TOASTR_TIMEOUT) {
        if (disableTimeout === true) {
            this.toastr.show(message, '', { closeButton: true, disableTimeOut: true, toastClass: 'my-toast-warning' });
        }
        else {
            this.toastr.show(message, '', { closeButton: true, timeOut: timeout, toastClass: 'my-toast-warning' });
        }
    }
    showErrorMessage(message, disableTimeout = false, timeout = this.DEFAULT_TOASTR_TIMEOUT) {
        if (disableTimeout === true) {
            this.toastr.show(message, '', { closeButton: true, disableTimeOut: true, toastClass: 'my-toast-error' });
        }
        else {
            this.toastr.show(message, '', { closeButton: true, timeOut: timeout, toastClass: 'my-toast-error' });
        }
    }
    showSuccessMessage(message, disableTimeout = false, timeout = this.DEFAULT_TOASTR_TIMEOUT) {
        if (disableTimeout === true) {
            this.toastr.show(message, '', { closeButton: true, disableTimeOut: true, toastClass: 'my-toast-success' });
        }
        else {
            this.toastr.show(message, '', { closeButton: true, timeOut: timeout, toastClass: 'my-toast-success' });
        }
    }
}
ToastrMessageService.ɵfac = function ToastrMessageService_Factory(t) { return new (t || ToastrMessageService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](ngx_toastr__WEBPACK_IMPORTED_MODULE_1__["ToastrService"])); };
ToastrMessageService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: ToastrMessageService, factory: ToastrMessageService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](ToastrMessageService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: ngx_toastr__WEBPACK_IMPORTED_MODULE_1__["ToastrService"] }]; }, null); })();


/***/ }),

/***/ "ZAI4":
/*!*******************************!*\
  !*** ./src/app/app.module.ts ***!
  \*******************************/
/*! exports provided: AppModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AppModule", function() { return AppModule; });
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/platform-browser */ "jhN1");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var _app_routing_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./app-routing.module */ "vY5A");
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./app.component */ "Sy1n");
/* harmony import */ var _settings_settings_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./settings/settings.component */ "70H3");
/* harmony import */ var _system_status_system_status_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./system-status/system-status.component */ "0BQl");
/* harmony import */ var _logs_logs_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./logs/logs.component */ "GMR4");
/* harmony import */ var _defaults_defaults_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./defaults/defaults.component */ "2TRi");
/* harmony import */ var _update_tab_update_tab_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./update-tab/update-tab.component */ "jzl3");
/* harmony import */ var _reboot_reboot_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./reboot/reboot.component */ "CTeh");
/* harmony import */ var _angular_material_expansion__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/expansion */ "7EHt");
/* harmony import */ var _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/platform-browser/animations */ "R1ws");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _angular_material_slider__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/slider */ "5RNC");
/* harmony import */ var _angular_material_form_field__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/material/form-field */ "kmnG");
/* harmony import */ var _angular_material_select__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/material/select */ "d3UM");
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/material/icon */ "NFeN");
/* harmony import */ var _angular_material_radio__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/material/radio */ "QibW");
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/material/table */ "+0xr");
/* harmony import */ var _angular_material_progress_bar__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @angular/material/progress-bar */ "bv9b");
/* harmony import */ var _angular_material_toolbar__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @angular/material/toolbar */ "/t3+");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @angular/material/dialog */ "0IaG");
/* harmony import */ var _angular_material_card__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @angular/material/card */ "Wp6s");
/* harmony import */ var ngx_toastr__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ngx-toastr */ "5eHb");
/* harmony import */ var _toast_message_toast_message_component__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./toast-message/toast-message.component */ "T20q");
/* harmony import */ var _login_login_component__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./login/login.component */ "vtpD");
/* harmony import */ var _main_main_component__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./main/main.component */ "wlho");
/* harmony import */ var _additional_certificates_additional_certificates_component__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./additional-certificates/additional.certificates.component */ "fSrv");
/* harmony import */ var _upload_certificate_modal_upload_certificate_modal_component__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./upload-certificate-modal/upload-certificate-modal.component */ "r2Ei");
/* harmony import */ var _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @angular/material/checkbox */ "bSwM");
/* harmony import */ var _firmware_updater_firmware_updater_component__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./firmware-updater/firmware-updater.component */ "/jIo");
/* harmony import */ var _sip_settings_sip_settings_component__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./sip-settings/sip-settings.component */ "Kx0C");
/* harmony import */ var _background_music_background_music_component__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./background-music/background-music.component */ "MA3z");
/* harmony import */ var _high_prio_notification_high_prio_notification_component__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./high-prio-notification/high-prio-notification.component */ "lBYT");
/* harmony import */ var _device_license_device_license_component__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./device-license/device-license.component */ "bnPd");
/* harmony import */ var _serial_gateway_serial_gateway_component__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./serial-gateway/serial-gateway.component */ "5Cdf");
/* harmony import */ var _validators_serial_gw_custom_validators_directive__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./validators/serial-gw-custom-validators.directive */ "zcCI");
/* harmony import */ var _home_home_component__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./home/home.component */ "9vUh");
/* harmony import */ var _timezone_selector_timezone_selector_component__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./timezone-selector/timezone-selector.component */ "K095");
/* harmony import */ var _open_source_licenses_open_source_licenses_component__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./open-source-licenses/open-source-licenses.component */ "S1LR");
/* harmony import */ var _angular_flex_layout__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! @angular/flex-layout */ "YUcS");
/* harmony import */ var _greedy_nav_greedy_nav_component__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./greedy-nav/greedy-nav.component */ "fFxi");
/* harmony import */ var _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! @angular/material/sidenav */ "XhcP");
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! @angular/material/menu */ "STbY");
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! @angular/material/button */ "bTqV");
/* harmony import */ var _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! @angular/material/slide-toggle */ "1jcm");
/* harmony import */ var _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! @angular/material/progress-spinner */ "Xa2L");


















































class AppModule {
}
AppModule.ɵmod = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({ type: AppModule, bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_4__["AppComponent"]] });
AppModule.ɵinj = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({ factory: function AppModule_Factory(t) { return new (t || AppModule)(); }, providers: [], imports: [[
            _angular_platform_browser__WEBPACK_IMPORTED_MODULE_0__["BrowserModule"],
            _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClientModule"],
            _app_routing_module__WEBPACK_IMPORTED_MODULE_3__["AppRoutingModule"],
            _angular_material_expansion__WEBPACK_IMPORTED_MODULE_11__["MatExpansionModule"],
            _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_12__["BrowserAnimationsModule"],
            _angular_forms__WEBPACK_IMPORTED_MODULE_13__["ReactiveFormsModule"],
            _angular_material_slider__WEBPACK_IMPORTED_MODULE_14__["MatSliderModule"],
            _angular_material_form_field__WEBPACK_IMPORTED_MODULE_15__["MatFormFieldModule"],
            _angular_material_select__WEBPACK_IMPORTED_MODULE_16__["MatSelectModule"],
            _angular_material_icon__WEBPACK_IMPORTED_MODULE_17__["MatIconModule"],
            _angular_material_radio__WEBPACK_IMPORTED_MODULE_18__["MatRadioModule"],
            _angular_material_table__WEBPACK_IMPORTED_MODULE_19__["MatTableModule"],
            _angular_material_progress_bar__WEBPACK_IMPORTED_MODULE_20__["MatProgressBarModule"],
            _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_30__["MatCheckboxModule"],
            _angular_material_card__WEBPACK_IMPORTED_MODULE_23__["MatCardModule"],
            _angular_material_toolbar__WEBPACK_IMPORTED_MODULE_21__["MatToolbarModule"],
            _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_43__["MatSidenavModule"],
            _angular_material_menu__WEBPACK_IMPORTED_MODULE_44__["MatMenuModule"],
            _angular_material_button__WEBPACK_IMPORTED_MODULE_45__["MatButtonModule"],
            _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_46__["MatSlideToggleModule"],
            _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_47__["MatProgressSpinnerModule"],
            _angular_forms__WEBPACK_IMPORTED_MODULE_13__["FormsModule"],
            _angular_material_dialog__WEBPACK_IMPORTED_MODULE_22__["MatDialogModule"],
            ngx_toastr__WEBPACK_IMPORTED_MODULE_24__["ToastrModule"].forRoot({
                toastComponent: _toast_message_toast_message_component__WEBPACK_IMPORTED_MODULE_25__["ToastMessageComponent"],
            }),
            /*ToastrModule.forRoot(),*/
            ngx_toastr__WEBPACK_IMPORTED_MODULE_24__["ToastContainerModule"],
            _angular_flex_layout__WEBPACK_IMPORTED_MODULE_41__["FlexLayoutModule"],
        ]] });
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](AppModule, { declarations: [_app_component__WEBPACK_IMPORTED_MODULE_4__["AppComponent"],
        _settings_settings_component__WEBPACK_IMPORTED_MODULE_5__["SettingsComponent"],
        _system_status_system_status_component__WEBPACK_IMPORTED_MODULE_6__["SystemStatusComponent"],
        _logs_logs_component__WEBPACK_IMPORTED_MODULE_7__["LogsComponent"],
        _defaults_defaults_component__WEBPACK_IMPORTED_MODULE_8__["DefaultsComponent"],
        _update_tab_update_tab_component__WEBPACK_IMPORTED_MODULE_9__["UpdateTabComponent"],
        _reboot_reboot_component__WEBPACK_IMPORTED_MODULE_10__["RebootComponent"],
        _toast_message_toast_message_component__WEBPACK_IMPORTED_MODULE_25__["ToastMessageComponent"],
        _login_login_component__WEBPACK_IMPORTED_MODULE_26__["LoginComponent"],
        _main_main_component__WEBPACK_IMPORTED_MODULE_27__["MainComponent"],
        _additional_certificates_additional_certificates_component__WEBPACK_IMPORTED_MODULE_28__["AdditionalCertificatesComponent"],
        _upload_certificate_modal_upload_certificate_modal_component__WEBPACK_IMPORTED_MODULE_29__["UploadCertificateModalComponent"],
        _firmware_updater_firmware_updater_component__WEBPACK_IMPORTED_MODULE_31__["FirmwareUpdaterComponent"],
        _sip_settings_sip_settings_component__WEBPACK_IMPORTED_MODULE_32__["SipSettingsComponent"],
        _background_music_background_music_component__WEBPACK_IMPORTED_MODULE_33__["BackgroundMusicComponent"],
        _high_prio_notification_high_prio_notification_component__WEBPACK_IMPORTED_MODULE_34__["HighPrioNotificationComponent"],
        _device_license_device_license_component__WEBPACK_IMPORTED_MODULE_35__["DeviceLicenseComponent"],
        _serial_gateway_serial_gateway_component__WEBPACK_IMPORTED_MODULE_36__["SerialGatewayComponent"],
        _validators_serial_gw_custom_validators_directive__WEBPACK_IMPORTED_MODULE_37__["SerialGwCustomValidatorsDirective"],
        _home_home_component__WEBPACK_IMPORTED_MODULE_38__["HomeComponent"],
        _timezone_selector_timezone_selector_component__WEBPACK_IMPORTED_MODULE_39__["TimezoneSelectorComponent"],
        _greedy_nav_greedy_nav_component__WEBPACK_IMPORTED_MODULE_42__["GreedyNavComponent"],
        _open_source_licenses_open_source_licenses_component__WEBPACK_IMPORTED_MODULE_40__["OpenSourceLicensesComponent"]], imports: [_angular_platform_browser__WEBPACK_IMPORTED_MODULE_0__["BrowserModule"],
        _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClientModule"],
        _app_routing_module__WEBPACK_IMPORTED_MODULE_3__["AppRoutingModule"],
        _angular_material_expansion__WEBPACK_IMPORTED_MODULE_11__["MatExpansionModule"],
        _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_12__["BrowserAnimationsModule"],
        _angular_forms__WEBPACK_IMPORTED_MODULE_13__["ReactiveFormsModule"],
        _angular_material_slider__WEBPACK_IMPORTED_MODULE_14__["MatSliderModule"],
        _angular_material_form_field__WEBPACK_IMPORTED_MODULE_15__["MatFormFieldModule"],
        _angular_material_select__WEBPACK_IMPORTED_MODULE_16__["MatSelectModule"],
        _angular_material_icon__WEBPACK_IMPORTED_MODULE_17__["MatIconModule"],
        _angular_material_radio__WEBPACK_IMPORTED_MODULE_18__["MatRadioModule"],
        _angular_material_table__WEBPACK_IMPORTED_MODULE_19__["MatTableModule"],
        _angular_material_progress_bar__WEBPACK_IMPORTED_MODULE_20__["MatProgressBarModule"],
        _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_30__["MatCheckboxModule"],
        _angular_material_card__WEBPACK_IMPORTED_MODULE_23__["MatCardModule"],
        _angular_material_toolbar__WEBPACK_IMPORTED_MODULE_21__["MatToolbarModule"],
        _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_43__["MatSidenavModule"],
        _angular_material_menu__WEBPACK_IMPORTED_MODULE_44__["MatMenuModule"],
        _angular_material_button__WEBPACK_IMPORTED_MODULE_45__["MatButtonModule"],
        _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_46__["MatSlideToggleModule"],
        _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_47__["MatProgressSpinnerModule"],
        _angular_forms__WEBPACK_IMPORTED_MODULE_13__["FormsModule"],
        _angular_material_dialog__WEBPACK_IMPORTED_MODULE_22__["MatDialogModule"], ngx_toastr__WEBPACK_IMPORTED_MODULE_24__["ToastrModule"], 
        /*ToastrModule.forRoot(),*/
        ngx_toastr__WEBPACK_IMPORTED_MODULE_24__["ToastContainerModule"],
        _angular_flex_layout__WEBPACK_IMPORTED_MODULE_41__["FlexLayoutModule"]] }); })();
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵsetClassMetadata"](AppModule, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"],
        args: [{
                declarations: [
                    _app_component__WEBPACK_IMPORTED_MODULE_4__["AppComponent"],
                    _settings_settings_component__WEBPACK_IMPORTED_MODULE_5__["SettingsComponent"],
                    _system_status_system_status_component__WEBPACK_IMPORTED_MODULE_6__["SystemStatusComponent"],
                    _logs_logs_component__WEBPACK_IMPORTED_MODULE_7__["LogsComponent"],
                    _defaults_defaults_component__WEBPACK_IMPORTED_MODULE_8__["DefaultsComponent"],
                    _update_tab_update_tab_component__WEBPACK_IMPORTED_MODULE_9__["UpdateTabComponent"],
                    _reboot_reboot_component__WEBPACK_IMPORTED_MODULE_10__["RebootComponent"],
                    _toast_message_toast_message_component__WEBPACK_IMPORTED_MODULE_25__["ToastMessageComponent"],
                    _login_login_component__WEBPACK_IMPORTED_MODULE_26__["LoginComponent"],
                    _main_main_component__WEBPACK_IMPORTED_MODULE_27__["MainComponent"],
                    _additional_certificates_additional_certificates_component__WEBPACK_IMPORTED_MODULE_28__["AdditionalCertificatesComponent"],
                    _upload_certificate_modal_upload_certificate_modal_component__WEBPACK_IMPORTED_MODULE_29__["UploadCertificateModalComponent"],
                    _firmware_updater_firmware_updater_component__WEBPACK_IMPORTED_MODULE_31__["FirmwareUpdaterComponent"],
                    _sip_settings_sip_settings_component__WEBPACK_IMPORTED_MODULE_32__["SipSettingsComponent"],
                    _background_music_background_music_component__WEBPACK_IMPORTED_MODULE_33__["BackgroundMusicComponent"],
                    _high_prio_notification_high_prio_notification_component__WEBPACK_IMPORTED_MODULE_34__["HighPrioNotificationComponent"],
                    _device_license_device_license_component__WEBPACK_IMPORTED_MODULE_35__["DeviceLicenseComponent"],
                    _serial_gateway_serial_gateway_component__WEBPACK_IMPORTED_MODULE_36__["SerialGatewayComponent"],
                    _validators_serial_gw_custom_validators_directive__WEBPACK_IMPORTED_MODULE_37__["SerialGwCustomValidatorsDirective"],
                    _home_home_component__WEBPACK_IMPORTED_MODULE_38__["HomeComponent"],
                    _timezone_selector_timezone_selector_component__WEBPACK_IMPORTED_MODULE_39__["TimezoneSelectorComponent"],
                    _greedy_nav_greedy_nav_component__WEBPACK_IMPORTED_MODULE_42__["GreedyNavComponent"],
                    _open_source_licenses_open_source_licenses_component__WEBPACK_IMPORTED_MODULE_40__["OpenSourceLicensesComponent"]
                ],
                imports: [
                    _angular_platform_browser__WEBPACK_IMPORTED_MODULE_0__["BrowserModule"],
                    _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClientModule"],
                    _app_routing_module__WEBPACK_IMPORTED_MODULE_3__["AppRoutingModule"],
                    _angular_material_expansion__WEBPACK_IMPORTED_MODULE_11__["MatExpansionModule"],
                    _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_12__["BrowserAnimationsModule"],
                    _angular_forms__WEBPACK_IMPORTED_MODULE_13__["ReactiveFormsModule"],
                    _angular_material_slider__WEBPACK_IMPORTED_MODULE_14__["MatSliderModule"],
                    _angular_material_form_field__WEBPACK_IMPORTED_MODULE_15__["MatFormFieldModule"],
                    _angular_material_select__WEBPACK_IMPORTED_MODULE_16__["MatSelectModule"],
                    _angular_material_icon__WEBPACK_IMPORTED_MODULE_17__["MatIconModule"],
                    _angular_material_radio__WEBPACK_IMPORTED_MODULE_18__["MatRadioModule"],
                    _angular_material_table__WEBPACK_IMPORTED_MODULE_19__["MatTableModule"],
                    _angular_material_progress_bar__WEBPACK_IMPORTED_MODULE_20__["MatProgressBarModule"],
                    _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_30__["MatCheckboxModule"],
                    _angular_material_card__WEBPACK_IMPORTED_MODULE_23__["MatCardModule"],
                    _angular_material_toolbar__WEBPACK_IMPORTED_MODULE_21__["MatToolbarModule"],
                    _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_43__["MatSidenavModule"],
                    _angular_material_menu__WEBPACK_IMPORTED_MODULE_44__["MatMenuModule"],
                    _angular_material_button__WEBPACK_IMPORTED_MODULE_45__["MatButtonModule"],
                    _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_46__["MatSlideToggleModule"],
                    _angular_material_progress_spinner__WEBPACK_IMPORTED_MODULE_47__["MatProgressSpinnerModule"],
                    _angular_forms__WEBPACK_IMPORTED_MODULE_13__["FormsModule"],
                    _angular_material_dialog__WEBPACK_IMPORTED_MODULE_22__["MatDialogModule"],
                    ngx_toastr__WEBPACK_IMPORTED_MODULE_24__["ToastrModule"].forRoot({
                        toastComponent: _toast_message_toast_message_component__WEBPACK_IMPORTED_MODULE_25__["ToastMessageComponent"],
                    }),
                    /*ToastrModule.forRoot(),*/
                    ngx_toastr__WEBPACK_IMPORTED_MODULE_24__["ToastContainerModule"],
                    _angular_flex_layout__WEBPACK_IMPORTED_MODULE_41__["FlexLayoutModule"],
                ],
                entryComponents: [_toast_message_toast_message_component__WEBPACK_IMPORTED_MODULE_25__["ToastMessageComponent"]],
                //providers: [CookieService],
                providers: [],
                bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_4__["AppComponent"]]
            }]
    }], null, null); })();


/***/ }),

/***/ "bnPd":
/*!************************************************************!*\
  !*** ./src/app/device-license/device-license.component.ts ***!
  \************************************************************/
/*! exports provided: DeviceLicenseComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DeviceLicenseComponent", function() { return DeviceLicenseComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ "ofXK");



class DeviceLicenseComponent {
    constructor() { }
    ngOnInit() {
    }
    createDateFromStr(stringDate) {
        //console.log(stringDate);
        let dateParams = stringDate.split('/');
        let year = dateParams[2];
        let month = parseInt(dateParams[1], 10) - 1; //months start on 0
        let day = dateParams[0];
        return new Date(year, month, day).getTime();
    }
}
DeviceLicenseComponent.ɵfac = function DeviceLicenseComponent_Factory(t) { return new (t || DeviceLicenseComponent)(); };
DeviceLicenseComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: DeviceLicenseComponent, selectors: [["app-device-license"]], inputs: { license: "license" }, decls: 38, vars: 13, consts: [[1, "t1"], [1, "label"], [1, "value"]], template: function DeviceLicenseComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "table", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "td", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "Name");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "td", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](8, "Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "td", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "td", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13, "Issue date");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "td", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](16, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "td", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19, "Expire Date");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "td", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](21);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](22, "date");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "td", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25, "ID");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "td", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](27);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](28, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "td", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](30, "Features");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "td", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](32);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](33, "tr");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](34, "td", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](35, "Signature");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](36, "td", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](37);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx.license["lic_name"], " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx.license["lic_status"], " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind2"](16, 7, ctx.createDateFromStr(ctx.license["issue_date"]), "yyyy-MM-dd HH:mm:ss Z"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind2"](22, 10, ctx.createDateFromStr(ctx.license["expire_date"]), "yyyy-MM-dd HH:mm:ss Z"), " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx.license["lic_id"], " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx.license["lic_features"], " ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx.license["lic_sign"], " ");
    } }, pipes: [_angular_common__WEBPACK_IMPORTED_MODULE_1__["DatePipe"]], styles: ["\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2RldmljZS1saWNlbnNlL2RldmljZS1saWNlbnNlLmNvbXBvbmVudC5jc3MifQ== */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](DeviceLicenseComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-device-license',
                templateUrl: './device-license.component.html',
                styleUrls: ['./device-license.component.css', '../general.css']
            }]
    }], function () { return []; }, { license: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Input"]
        }] }); })();


/***/ }),

/***/ "fFxi":
/*!****************************************************!*\
  !*** ./src/app/greedy-nav/greedy-nav.component.ts ***!
  \****************************************************/
/*! exports provided: GreedyNavComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GreedyNavComponent", function() { return GreedyNavComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_flex_layout_flex__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/flex-layout/flex */ "XiUz");
/* harmony import */ var _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material/sidenav */ "XhcP");
/* harmony import */ var _angular_material_toolbar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/material/toolbar */ "/t3+");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/button */ "bTqV");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ "tyNb");
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/menu */ "STbY");
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/icon */ "NFeN");










function GreedyNavComponent_button_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const menu_r2 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("routerLink", menu_r2.routerLink);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", menu_r2.title, " ");
} }
function GreedyNavComponent_div_5_ng_template_6_button_0_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const menu_r6 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("routerLink", menu_r6.routerLink);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", menu_r6.title, " ");
} }
function GreedyNavComponent_div_5_ng_template_6_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, GreedyNavComponent_div_5_ng_template_6_button_0_Template, 2, 2, "button", 12);
} if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r4.hiddenPrioMenu);
} }
function GreedyNavComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "button", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "more_horiz");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "mat-menu", 9, 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](6, GreedyNavComponent_div_5_ng_template_6_Template, 1, 1, "ng-template", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](5);
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matMenuTriggerFor", _r3)("matMenuTriggerData", ctx_r1.hiddenPrioMenu);
} }
class GreedyNavComponent {
    constructor(cdr) {
        this.cdr = cdr;
        this.mainMenu = [
            { title: 'Home', routerLink: 'home' },
            { title: 'Settings', routerLink: 'settings' },
            { title: 'Serial Interface', routerLink: 'serialgw' },
            { title: 'SIP', routerLink: 'sip' },
            { title: 'Background Music', routerLink: 'bgm' },
            { title: 'Notification', routerLink: 'hpn' },
            { title: 'System Status', routerLink: 'system-status' },
            { title: 'Logs', routerLink: 'logs' },
            { title: 'Defaults', routerLink: 'defaults' },
            { title: 'Update', routerLink: 'update' },
            { title: 'Reboot', routerLink: 'reboot' }
        ];
        this.hiddenPrioMenu = [];
        this.showDropDownPrio = false;
        this.breakWidths = [];
    }
    ngOnInit() {
    }
    ngAfterViewInit() {
        // get prio nav elements
        var prioNav = document.getElementById('prio-nav');
        var totalSpace = 0;
        var breakWidths = [];
        var numOfItems = 0;
        // loop over all elements and set sum of widths for each prio nav element
        for (var i = 0; i < prioNav.children.length; i++) {
            totalSpace += prioNav.children[i].clientWidth;
            this.breakWidths.push(totalSpace);
            numOfItems += 1;
        }
        // call calculation method
        this.checkCalculation();
    }
    onResize(event) {
        // call calculation method
        this.checkCalculation();
    }
    checkCalculation() {
        // get current space of parent element of prio-nav
        var availableSpace = document.getElementById('header-toolbar').offsetWidth;
        // get needed space for all elements in prio-nav parent element + last width of visible elements from breakwidth array
        var totalNeededSpace = this.breakWidths[this.mainMenu.length - 1] + 70;
        // if we need more space than we have - hide last element
        if (totalNeededSpace > availableSpace) {
            // push last element from mainMenu to hiddenPrioMenu
            //this.hiddenPrioMenu.push(this.mainMenu[this.mainMenu.length-1]);
            this.hiddenPrioMenu.unshift(this.mainMenu[this.mainMenu.length - 1]);
            // remove that last element from mainMenu
            this.mainMenu = this.mainMenu.filter(item => item !== this.mainMenu[this.mainMenu.length - 1]);
            // show hidden prio menu
            this.showDropDownPrio = true;
            // apply changes
            this.cdr.detectChanges();
            // call this method to recalculate for rest of nav elements
            this.checkCalculation();
        }
        else {
            // if we have elements in hidden prio menu and the with occupied by current menu items + 1 from hiddenPrioMenu is still under or equal to the availableSpace
            if (this.hiddenPrioMenu.length > 0 && (this.breakWidths[this.mainMenu.length] + 70) <= availableSpace) {
                // push last element from hidden menu to main menu
                //this.mainMenu.push(this.hiddenPrioMenu[this.hiddenPrioMenu.length-1]);
                this.mainMenu.push(this.hiddenPrioMenu.shift());
                // remove element from hidden menu
                //this.hiddenPrioMenu = this.hiddenPrioMenu.filter(item => item !== this.hiddenPrioMenu[this.hiddenPrioMenu.length-1]);
                // if we have or not elements in hiddenPrioMenu hide it or show it
                if (this.hiddenPrioMenu.length > 0) {
                    this.showDropDownPrio = true;
                }
                else {
                    this.showDropDownPrio = false;
                }
                // apply changes
                this.cdr.detectChanges();
                // call this method to recalculate for rest of nav elements
                this.checkCalculation();
            }
            // apply changes
            this.cdr.detectChanges();
        }
    }
}
GreedyNavComponent.ɵfac = function GreedyNavComponent_Factory(t) { return new (t || GreedyNavComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ChangeDetectorRef"])); };
GreedyNavComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: GreedyNavComponent, selectors: [["app-greedy-nav"]], hostBindings: function GreedyNavComponent_HostBindings(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("resize", function GreedyNavComponent_resize_HostBindingHandler($event) { return ctx.onResize($event); }, false, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresolveWindow"]);
    } }, decls: 6, vars: 2, consts: [["fxFlex", "", "fxLayout", "column", "fxFlex", "100"], [1, "sidenav-container"], ["color", "primary", "id", "header-toolbar", 1, "toolbar-top"], ["id", "prio-nav", 2, "display", "flex"], ["type", "button", "class", "nav-item", "mat-button", "", "routerLinkActive", "menu-selected", 3, "routerLink", 4, "ngFor", "ngForOf"], ["id", "drop-down-items", 4, "ngIf"], ["type", "button", "mat-button", "", "routerLinkActive", "menu-selected", 1, "nav-item", 3, "routerLink"], ["id", "drop-down-items"], ["mat-button", "", 2, "width", "110px", 3, "matMenuTriggerFor", "matMenuTriggerData"], ["id", "hidden-prio-nav"], ["menu", "matMenu"], ["matMenuContent", ""], ["type", "button", "class", "hidden-prio-item", "mat-button", "", "routerLinkActive", "menu-selected", 3, "routerLink", 4, "ngFor", "ngForOf"], ["type", "button", "mat-button", "", "routerLinkActive", "menu-selected", 1, "hidden-prio-item", 3, "routerLink"]], template: function GreedyNavComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-sidenav-container", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "mat-toolbar", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, GreedyNavComponent_button_4_Template, 2, 2, "button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, GreedyNavComponent_div_5_Template, 7, 2, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.mainMenu);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showDropDownPrio);
    } }, directives: [_angular_flex_layout_flex__WEBPACK_IMPORTED_MODULE_1__["DefaultFlexDirective"], _angular_flex_layout_flex__WEBPACK_IMPORTED_MODULE_1__["DefaultLayoutDirective"], _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_2__["MatSidenavContainer"], _angular_material_toolbar__WEBPACK_IMPORTED_MODULE_3__["MatToolbar"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["NgForOf"], _angular_common__WEBPACK_IMPORTED_MODULE_4__["NgIf"], _angular_material_button__WEBPACK_IMPORTED_MODULE_5__["MatButton"], _angular_router__WEBPACK_IMPORTED_MODULE_6__["RouterLinkActive"], _angular_router__WEBPACK_IMPORTED_MODULE_6__["RouterLink"], _angular_material_menu__WEBPACK_IMPORTED_MODULE_7__["MatMenuTrigger"], _angular_material_icon__WEBPACK_IMPORTED_MODULE_8__["MatIcon"], _angular_material_menu__WEBPACK_IMPORTED_MODULE_7__["_MatMenu"], _angular_material_menu__WEBPACK_IMPORTED_MODULE_7__["MatMenuContent"]], styles: [".mat-toolbar-row, .mat-toolbar-single-row[_ngcontent-%COMP%] {\n    height: 34px !important;\n    padding: unset !important;\n}\n\n .mat-drawer-content {\n    overflow: unset !important;\n}\n\n .mat-toolbar.mat-primary {\n    background-color: #182857;\n    color: #AAAAAA;\n}\n\n.nav-item[_ngcontent-%COMP%] {\n    font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n    font-weight: 600;\n    font-size: 17px;\n    line-height: 2;\n    border: solid 0 #F9F9F9;\n    \n    border-right-width: 1px;\n    padding: 0 8px;\n    min-width: 50px;\n    border-radius: unset;\n}\n\n.nav-item[_ngcontent-%COMP%]:hover {\n    text-shadow: 0 0 12px #AAAAAA;\n}\n\n.nav-item.menu-selected[_ngcontent-%COMP%] {\n    font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n    color: #182857;\n    text-shadow: 0 0 0 #727477;\n    border-left: solid 4px #182857;\n    background-color: #F9F9F9;\n    padding: 0 8px 0 5px;\n}\n\n .mat-menu-content div{\n    display: flex;\n    flex-direction: column;\n}\n\n .mat-menu-panel{\n    background-color: #182857;\n    color: #AAAAAA;\n}\n\n .mat-elevation-z4 {\n    box-shadow: none;\n}\n\n.hidden-prio-item[_ngcontent-%COMP%] {\n    font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n    font-weight: 600;\n    font-size: 17px;\n    line-height: 2;\n    border: solid 0 #F9F9F9;\n    border-bottom-width: 1px;\n    padding: 0 8px;\n    min-width: 50px;\n    border-radius: unset;\n}\n\n.hidden-prio-item[_ngcontent-%COMP%]:hover {\n    text-shadow: 0 0 12px #AAAAAA;\n}\n\n.hidden-prio-item.menu-selected[_ngcontent-%COMP%] {\n    font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n    color: #182857;\n    text-shadow: 0 0 0 #727477;\n    background-color: #F9F9F9;\n    padding: 0 8px 0 5px;\n}\n\n .mat-menu-content{\n    padding: unset !important;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](GreedyNavComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-greedy-nav',
                templateUrl: './greedy-nav.component.html',
                styleUrls: ['./greedy-nav.component.css'],
                // call onResize() method when browser window is resized
                host: {
                    '(window:resize)': 'onResize($event)'
                }
            }]
    }], function () { return [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["ChangeDetectorRef"] }]; }, null); })();


/***/ }),

/***/ "fSrv":
/*!******************************************************************************!*\
  !*** ./src/app/additional-certificates/additional.certificates.component.ts ***!
  \******************************************************************************/
/*! exports provided: AdditionalCertificatesComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AdditionalCertificatesComponent", function() { return AdditionalCertificatesComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/material/dialog */ "0IaG");
/* harmony import */ var _upload_certificate_modal_upload_certificate_modal_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../upload-certificate-modal/upload-certificate-modal.component */ "r2Ei");
/* harmony import */ var _services_additional_certificates_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/additional.certificates.service */ "+u1T");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/table */ "+0xr");
/* harmony import */ var _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/checkbox */ "bSwM");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");












function AdditionalCertificatesComponent_div_8_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, " (no certificates installed) ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function AdditionalCertificatesComponent_ng_template_9_th_10_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "th", 19);
} }
function AdditionalCertificatesComponent_ng_template_9_td_11_Template(rf, ctx) { if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "mat-checkbox", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function AdditionalCertificatesComponent_ng_template_9_td_11_Template_mat_checkbox_change_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r14); const i_r12 = ctx.index; const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2); return ctx_r13.selectOrDeselectCertificate($event.checked, i_r12); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const certificate_r11 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", certificate_r11.selected);
} }
function AdditionalCertificatesComponent_ng_template_9_th_13_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "certificate");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function AdditionalCertificatesComponent_ng_template_9_td_14_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r15 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", element_r15.name, " ");
} }
function AdditionalCertificatesComponent_ng_template_9_th_16_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "th", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "status");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
const _c0 = function (a0) { return { "certNotInstalled": a0 }; };
function AdditionalCertificatesComponent_ng_template_9_td_17_div_1_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c0, element_r16.state !== "INSTALLED"));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](element_r16.state.toLowerCase());
} }
function AdditionalCertificatesComponent_ng_template_9_td_17_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0, " unknown ");
} }
function AdditionalCertificatesComponent_ng_template_9_td_17_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "td", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, AdditionalCertificatesComponent_ng_template_9_td_17_div_1_Template, 3, 4, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, AdditionalCertificatesComponent_ng_template_9_td_17_ng_template_2_Template, 1, 0, "ng-template", null, 23, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const element_r16 = ctx.$implicit;
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", element_r16.state)("ngIfElse", _r18);
} }
function AdditionalCertificatesComponent_ng_template_9_tr_18_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "tr", 25);
} }
function AdditionalCertificatesComponent_ng_template_9_tr_19_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "tr", 26);
} }
function AdditionalCertificatesComponent_ng_template_9_Template(rf, ctx) { if (rf & 1) {
    const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "button", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function AdditionalCertificatesComponent_ng_template_9_Template_button_click_2_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23); const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r22.selectAll(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "select all");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "button", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function AdditionalCertificatesComponent_ng_template_9_Template_button_click_4_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23); const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r24.selectNone(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "select none");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function AdditionalCertificatesComponent_ng_template_9_Template_button_click_6_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23); const ctx_r25 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r25.deleteSelectedCerts(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "delete selected");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "table", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](9, 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, AdditionalCertificatesComponent_ng_template_9_th_10_Template, 1, 0, "th", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](11, AdditionalCertificatesComponent_ng_template_9_td_11_Template, 2, 1, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](12, 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, AdditionalCertificatesComponent_ng_template_9_th_13_Template, 2, 0, "th", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](14, AdditionalCertificatesComponent_ng_template_9_td_14_Template, 2, 1, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](15, 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](16, AdditionalCertificatesComponent_ng_template_9_th_16_Template, 2, 0, "th", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](17, AdditionalCertificatesComponent_ng_template_9_td_17_Template, 4, 2, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](18, AdditionalCertificatesComponent_ng_template_9_tr_18_Template, 1, 0, "tr", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](19, AdditionalCertificatesComponent_ng_template_9_tr_19_Template, 1, 0, "tr", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", !ctx_r2.isAnyCertificateSelected());
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("dataSource", ctx_r2.certificatesList);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matHeaderRowDef", ctx_r2.displayedColumns);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("matRowDefColumns", ctx_r2.displayedColumns);
} }
class AdditionalCertificatesComponent {
    constructor(matDialog, certificatesService, httpResponseHandler, toastrService) {
        this.matDialog = matDialog;
        this.certificatesService = certificatesService;
        this.httpResponseHandler = httpResponseHandler;
        this.toastrService = toastrService;
        this.displayedColumns = ['select', 'filename', 'status'];
        this.certificatesList = [];
        this.loadingEvent = new _angular_core__WEBPACK_IMPORTED_MODULE_0__["EventEmitter"]();
        this.eventFinished = new _angular_core__WEBPACK_IMPORTED_MODULE_0__["EventEmitter"]();
    }
    ngOnInit() {
        //get certificates installed from backend
        this.certificatesService.get().subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    //store for backup
                    //console.log(data.body);
                    this.certificatesList = data.body["custom"];
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    selectOrDeselectCertificate(state, idx) {
        //console.log(state);
        if (state) {
            this.certificatesList[idx]["selected"] = true;
        }
        else {
            this.certificatesList[idx]["selected"] = false;
        }
    }
    isAnyCertificateSelected() {
        for (let i = 0; i < this.certificatesList.length; i++) {
            if (this.certificatesList[i]["selected"]) {
                return true;
            }
        }
        return false;
    }
    selectAll() {
        for (let i = 0; i < this.certificatesList.length; i++) {
            this.certificatesList[i]["selected"] = true;
        }
    }
    selectNone() {
        for (let i = 0; i < this.certificatesList.length; i++) {
            this.certificatesList[i]["selected"] = false;
        }
    }
    deleteSelectedCerts() {
        let listOfFilesToBeDeleted = [];
        let stringListOfFilesToBeDeleted = "\n• ";
        for (let i = 0; i < this.certificatesList.length; i++) {
            if (this.certificatesList[i]["selected"]) {
                stringListOfFilesToBeDeleted += this.certificatesList[i]["name"] + "\n• ";
                listOfFilesToBeDeleted.push(this.certificatesList[i]["name"]);
            }
        }
        if (listOfFilesToBeDeleted.length === 0) {
            //this.toastr.show("Please select the certificates to be removed first", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-warning'});
            this.toastrService.showWarningMessage("Please select the certificates to be removed first");
        }
        else {
            stringListOfFilesToBeDeleted = stringListOfFilesToBeDeleted.substring(0, stringListOfFilesToBeDeleted.lastIndexOf("\n• "));
            //console.log(stringListOfFilesToBeDeleted);
            if (confirm("Are you sure you want to delete the custom certificates?\n" + stringListOfFilesToBeDeleted)) {
                //delete request to backend
                this.loadingEvent.emit(true);
                this.certificatesService.delete(listOfFilesToBeDeleted).subscribe(res => {
                    //console.log(res.status);
                    //console.log(res.body);
                    switch (res.status) {
                        case 200:
                            if (res.body === "0") {
                                this.eventFinished.emit({ 'toast-msg': "No certificates have been removed", 'toast-class': 'my-toast-error' });
                                //this.toastr.show("No certificates have been removed", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-error'});
                            }
                            else if (res.body === "1") {
                                this.eventFinished.emit({ 'toast-msg': "1 certificate was removed", 'toast-class': 'my-toast-success' });
                                //this.toastr.show("1 certificate was removed", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-success'});
                            }
                            else {
                                this.eventFinished.emit({ 'toast-msg': res.body + " certificates were removed", 'toast-class': 'my-toast-success' });
                                //this.toastr.show(res.body + " certificates were removed", '', {closeButton : true, disableTimeOut: true, toastClass: 'my-toast-success'});
                            }
                            break;
                        case 401:
                            this.httpResponseHandler.handle401HttpErrorResponse(res.error);
                            break;
                        case 500:
                            this.httpResponseHandler.handle500HttpErrorResponse();
                            break;
                        default:
                            console.log("Unexpected return code: ", res.status);
                            this.httpResponseHandler.handleUnexpectedHttpErrorResponse(res.status);
                            break;
                    }
                });
            }
        }
    }
    openUploadCertificateModal() {
        const dialogConfig = new _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialogConfig"]();
        // The user can't close the dialog by clicking outside its body
        dialogConfig.disableClose = false;
        dialogConfig.id = "upload-certificate-modal-component";
        dialogConfig.height = "200px";
        dialogConfig.width = "900px";
        dialogConfig.position = { left: '6%', top: '10%' };
        dialogConfig.panelClass = "no-padding-modal";
        const dialogRef = this.matDialog.open(_upload_certificate_modal_upload_certificate_modal_component__WEBPACK_IMPORTED_MODULE_2__["UploadCertificateModalComponent"], dialogConfig);
        /*const onSubmitSubscription = dialogRef.componentInstance.onSubmit.subscribe(() => {
          console.log("onSubmit");
          this.loadingEvent.emit(true);
        });
        dialogRef.afterClosed().subscribe( (res) =>{
          onSubmitSubscription.unsubscribe();
          console.log(res);
          if (res){
            this.eventFinished.emit(res);
            console.log("eventFinished emitted");
          }
        });*/
        dialogRef.afterClosed().subscribe((file) => {
            if (file) {
                this.loadingEvent.emit(true);
                this.certificatesService.upload(file).subscribe(res => {
                    //console.log(res.status);
                    //console.log(res.body);
                    switch (res.status) {
                        case 200:
                            //this.dialogRef.close({"toast-msg" : res.body, "toast-class" : 'my-toast-success'});
                            this.eventFinished.emit({ "toast-msg": res.body, "toast-class": 'my-toast-success' });
                            //console.log("eventFinished emitted");
                            break;
                        case 400:
                            //this.dialogRef.close({"toast-msg" : res.error, "toast-class" : 'my-toast-error'});
                            this.eventFinished.emit({ "toast-msg": res.error, "toast-class": 'my-toast-error' });
                            //console.log("eventFinished emitted");
                            break;
                        case 401:
                            this.httpResponseHandler.handle401HttpErrorResponse(res.error);
                            break;
                        case 500:
                            this.httpResponseHandler.handle500HttpErrorResponse();
                            break;
                        default:
                            console.log("Unexpected return code: ", res.status);
                            this.httpResponseHandler.handleUnexpectedHttpErrorResponse(res.status);
                            break;
                    }
                });
            }
        });
    }
}
AdditionalCertificatesComponent.ɵfac = function AdditionalCertificatesComponent_Factory(t) { return new (t || AdditionalCertificatesComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialog"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_additional_certificates_service__WEBPACK_IMPORTED_MODULE_3__["AdditionalCertificatesService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__["HTTPResponseHandlerService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__["ToastrMessageService"])); };
AdditionalCertificatesComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: AdditionalCertificatesComponent, selectors: [["app-additional-certificates"]], outputs: { loadingEvent: "loadingEvent", eventFinished: "eventFinished" }, decls: 11, vars: 2, consts: [["align", "right", 2, "margin-bottom", "5px"], ["type", "button", "title", "Upload certificate file", 1, "actionBtn", 3, "click"], [1, "section1"], ["id", "certificate-list", 2, "border", "solid 1px #CCCCCC", "border-radius", "4px"], ["class", "section2", "style", "font-size: 13px; font-style: italic; padding: 4px; color: #888888;", 4, "ngIf", "ngIfElse"], ["listCertificates", ""], [1, "section2", 2, "font-size", "13px", "font-style", "italic", "padding", "4px", "color", "#888888"], [1, "containerCert"], [1, "buttonsRow"], ["type", "button", 1, "actionBtn", 3, "click"], ["type", "button", 1, "actionBtn", 2, "margin-left", "128px", 3, "disabled", "click"], ["mat-table", "", 3, "dataSource"], ["matColumnDef", "select"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "filename"], ["matColumnDef", "status"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], ["mat-header-cell", ""], ["mat-cell", ""], [1, "example-margin", 3, "checked", "change"], [4, "ngIf", "ngIfElse"], ["undefinedState", ""], [3, "ngClass"], ["mat-header-row", ""], ["mat-row", ""]], template: function AdditionalCertificatesComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "Additional Certificates");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function AdditionalCertificatesComponent_Template_button_click_4_listener() { return ctx.openUploadCertificateModal(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Install certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](7, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, AdditionalCertificatesComponent_div_8_Template, 2, 0, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, AdditionalCertificatesComponent_ng_template_9_Template, 20, 4, "ng-template", null, 5, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.certificatesList.length === 0)("ngIfElse", _r1);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_6__["NgIf"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatTable"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatColumnDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatHeaderCellDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatCellDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatHeaderRowDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatRowDef"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatHeaderCell"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatCell"], _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_8__["MatCheckbox"], _angular_common__WEBPACK_IMPORTED_MODULE_6__["NgClass"], _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_9__["DefaultClassDirective"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatHeaderRow"], _angular_material_table__WEBPACK_IMPORTED_MODULE_7__["MatRow"]], styles: [".containerCert[_ngcontent-%COMP%] {\n    padding: 8px;\n}\n\n.containerCert[_ngcontent-%COMP%]   .actionBtn[_ngcontent-%COMP%] {\n    font-size: 12px;\n    height: 21px;\n    padding: 0 4px;\n    margin: 4px;\n}\n\ntable[_ngcontent-%COMP%] {\n    width: 100%;\n    font-size: 13px;\n}\n\n.mat-row[_ngcontent-%COMP%]:nth-child(even){\n    background-color: transparent;\n}\n\n.mat-row[_ngcontent-%COMP%]:nth-child(odd){\n    background-color: rgb(0,0,0,0.03);\n}\n\ntd.mat-cell[_ngcontent-%COMP%]:first-of-type{\n    padding-left: 4px !important;\n    padding-right: 10px !important;\n}\n\ntd.mat-cell[_ngcontent-%COMP%]:last-of-type{\n    padding-right: 0 !important;\n}\n\ntr.mat-header-row[_ngcontent-%COMP%] {\n    height: 3px !important;\n}\n\n.mat-table[_ngcontent-%COMP%] {\n    margin-top: 10px;\n    border-collapse:collapse !important;\n}\n\ntr.mat-row[_ngcontent-%COMP%]{\n    height: 22px !important;\n    border-style: hidden;\n}\n\n .mat-checkbox-frame {\n    border-width: 1px !important;\n}\n\n .mat-checkbox-inner-container {\n    height: 12px !important;\n    width: 12px !important;\n}\n\n .mat-checkbox-checked.mat-accent .mat-checkbox-background{\n    background-color: #3751e7 !important;\n}\n\n.mat-column-select[_ngcontent-%COMP%] {\n    font-size: 13px;\n}\n\n.mat-column-filename[_ngcontent-%COMP%] {\n    min-width: 300px;\n    font-size: 13px;\n    width: 99%\n}\n\n.mat-column-status[_ngcontent-%COMP%] {\n    min-width: unset;\n    font-size: 13px;\n}\n\n.certNotInstalled[_ngcontent-%COMP%] {\n    color: #A21010;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](AdditionalCertificatesComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-additional-certificates',
                templateUrl: './additional.certificates.component.html',
                styleUrls: ['./additional.certificates.component.css', '../general.css']
            }]
    }], function () { return [{ type: _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__["MatDialog"] }, { type: _services_additional_certificates_service__WEBPACK_IMPORTED_MODULE_3__["AdditionalCertificatesService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__["HTTPResponseHandlerService"] }, { type: _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__["ToastrMessageService"] }]; }, { loadingEvent: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Output"]
        }], eventFinished: [{
            type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Output"]
        }] }); })();


/***/ }),

/***/ "flj8":
/*!*********************************************!*\
  !*** ./src/app/services/account.service.ts ***!
  \*********************************************/
/*! exports provided: AccountService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AccountService", function() { return AccountService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common/http */ "tk/3");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../environments/environment */ "AytR");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ "kU1M");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ "qCKp");







//import { CookieService } from 'ngx-cookie-service';
const LOGIN_ENDPOINT = _environments_environment__WEBPACK_IMPORTED_MODULE_2__["environment"].loginEndpoint;
class AccountService {
    constructor(httpClient) {
        this.httpClient = httpClient;
        this.httpOptions = {
            headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpHeaders"]({
                'Content-Type': 'application/json'
            }),
            observe: 'response',
            responseType: 'text'
        };
    }
    login(username, password) {
        let dict = { 'username': username, 'password': password };
        return this.httpClient.post(LOGIN_ENDPOINT, JSON.stringify(dict), this.httpOptions).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["tap"])(res => {
            //console.log(res);
            //console.log(res.headers.get('Set-Cookie'));
            localStorage.setItem('loginState', 'isLoggedIn');
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_4__["of"])(res);
        }), 
        /*switchMap(res => {
          console.log(res.status);
          return of(res);
        }),*/
        //catchError(err1 => this.handleLoginError(err1))
        Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["catchError"])(err1 => this.handleError(err1)));
    }
    isLoggedIn$() {
        //console.log('isLoggedIn?', localStorage.getItem('loginState'));
        //console.log('cookie:', this.cookieService.get('session'));
        if (localStorage.getItem('loginState') === 'isLoggedIn') {
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_4__["of"])(true);
        }
        else {
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_4__["of"])(false);
        }
    }
    handleLoginError(error) {
        //console.log(error);
        if (error.error instanceof ErrorEvent) {
            // A client-side or network error occurred. Handle it accordingly.
            console.error('An error occurred:', error.error.message);
        }
        else {
            if (error.status === 200) {
                //this.loggedIn = true;
                //console.log(error.headers);
                //console.log(error.headers.get("session"));
                //this.cookieService.set('sessionID', error.headers['Cookie'])
                return Object(rxjs__WEBPACK_IMPORTED_MODULE_4__["of"])(new _angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpResponse"]({ body: error.message, headers: error.headers, status: error.status, url: error.url }));
            }
            else {
                console.error(`Backend returned code ${error.status}, ` +
                    `body was: ${error.error}`);
            }
        }
        return Object(rxjs__WEBPACK_IMPORTED_MODULE_4__["of"])(error);
    }
    handleError(error) {
        //console.log(error);
        if (error.error instanceof ErrorEvent) {
            // A client-side or network error occurred. Handle it accordingly.
            console.error('An error occurred:', error.error.message);
        }
        else {
            // The backend returned an unsuccessful response code.
            // The response body may contain clues as to what went wrong.
            console.error(`Backend returned code ${error.status}, ` +
                `body was: ${error.error}`);
        }
        // Return an observable with a user-facing error message.
        //return throwError('Something bad happened; please try again later.');
        return Object(rxjs__WEBPACK_IMPORTED_MODULE_4__["of"])(error); //returns HttpErrorResponse with status 0
    }
}
AccountService.ɵfac = function AccountService_Factory(t) { return new (t || AccountService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpClient"])); };
AccountService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ token: AccountService, factory: AccountService.ɵfac, providedIn: 'root' });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](AccountService, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"],
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: _angular_common_http__WEBPACK_IMPORTED_MODULE_1__["HttpClient"] }]; }, null); })();


/***/ }),

/***/ "jzl3":
/*!****************************************************!*\
  !*** ./src/app/update-tab/update-tab.component.ts ***!
  \****************************************************/
/*! exports provided: UpdateTabComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UpdateTabComponent", function() { return UpdateTabComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _services_system_info_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services/system-info.service */ "4e9C");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _firmware_updater_firmware_updater_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../firmware-updater/firmware-updater.component */ "/jIo");







function UpdateTabComponent_div_2_div_3_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "p", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](3, "Update function is currently disabled.");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} }
function UpdateTabComponent_div_2_div_4_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "app-firmware-updater", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("fileExtensionsAllowed", ctx_r2.fileExtensionsAllowed)("max_file_size", ctx_r2.max_file_size);
} }
function UpdateTabComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "h2");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "Update");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, UpdateTabComponent_div_2_div_3_Template, 4, 0, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, UpdateTabComponent_div_2_div_4_Template, 2, 2, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](5, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Currently Loaded Version");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "table", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "td", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11, "Firmware");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "td", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "td", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, "Root File System");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "td", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "td", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](21, "System WEB UI");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "td", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](25, "td", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](26, "Kernel Details");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](27, "td", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](28);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](29, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](30, "td", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](31, "Bootloader Details");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](32, "td", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](33);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r0.update_opt);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.update_opt);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.fw_version);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.rootFSDate);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.webUIVer);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.kernelVer);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r0.bootloaderVer);
} }
class UpdateTabComponent {
    constructor(getSystemInfo, configsService, httpResponseHandler) {
        this.getSystemInfo = getSystemInfo;
        this.configsService = configsService;
        this.httpResponseHandler = httpResponseHandler;
        this.loadFinished = false;
        this.update_opt = false;
        this.fw_version = "";
        this.rootFSDate = "";
        this.webUIVer = "";
        this.kernelVer = "";
        this.bootloaderVer = "";
        this.href = "";
        this.fileExtensionsAllowed = ['.tar'];
        this.max_file_size = 256 * 1024 * 1024;
    }
    ngOnInit() {
        this.getSystemInfo.getCurrentFWInfo().subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    this.fw_version = data.body["fw_version"];
                    this.rootFSDate = data.body["rootFSDate"];
                    this.webUIVer = data.body["webUIVer"];
                    this.kernelVer = data.body["kernelVer"];
                    this.bootloaderVer = data.body["bootloaderVer"];
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
            let url_parts = window.location.href.split('/');
            let ip = url_parts[2].split(':')[0];
            this.href = url_parts[0] + "//" + ip + "/sys/uifloader.html";
            //console.log(this.href);
            this.configsService.getUcis({ 'update_opt': 'security.update.enabled' }).subscribe(data => {
                //console.log("Status:", data.status);
                //console.log("Received:", data.body);
                switch (data.status) {
                    case 200:
                        //build device form group
                        if (data.body["security.update.enabled"] === "true") {
                            this.update_opt = true;
                        }
                        break;
                    case 401:
                        this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                        break;
                    case 500:
                        this.httpResponseHandler.handle500HttpErrorResponse();
                        break;
                    default:
                        console.log("Unexpected return code: ", data.status);
                        this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                        break;
                }
                this.loadFinished = true;
            });
        });
    }
}
UpdateTabComponent.ɵfac = function UpdateTabComponent_Factory(t) { return new (t || UpdateTabComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_system_info_service__WEBPACK_IMPORTED_MODULE_1__["SystemInfoService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_device_config_service__WEBPACK_IMPORTED_MODULE_2__["DeviceConfigService"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"])); };
UpdateTabComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({ type: UpdateTabComponent, selectors: [["app-update"]], decls: 25, vars: 1, consts: [[1, "container"], [1, "tab-content"], [4, "ngIf"], [1, "tab-help"], [2, "color", "red", "font-weight", "500", "font-size", "14px", "margin-top", "10px", "margin-bottom", "10px"], ["class", "section1", 4, "ngIf"], ["class", "section1", "style", "width: 60%", 4, "ngIf"], [2, "width", "100%"], [1, "label"], [1, "value"], [1, "section1"], [2, "font-size", "15px", "font-weight", "normal", "font-family", "'SourceSansPro', Arial, Helvetica, sans-serif", "color", "#333333"], [1, "section1", 2, "width", "60%"], [3, "fileExtensionsAllowed", "max_file_size"]], template: function UpdateTabComponent_Template(rf, ctx) { if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, UpdateTabComponent_div_2_Template, 34, 7, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Help");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, "Update instructions");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](9, "Contact support to obtain a copy of the latest update package for the device and place it in your local drive.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](11, "Click on \"Choose File\" and select the Firmware Update image file (.tar) from your local drive.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13, "Click on \"Upload\" and wait until the update completes.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "p", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](15, " Note: this operation can take several minutes. Do not interrupt the update process nor reboot the device while updating, to avoid permanent damage to the device. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](16, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](17, "Once the update process has finished successfully, the device will reboot and the new firmware will be started.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](18, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](19, "In case of failure, please reboot the device and retry.");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](20, "br");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](21, "h4");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](22, "Currently Loaded Version");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](24, " This section lists the versions of the Firmware and Kernel. ");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    } if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.loadFinished);
    } }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_4__["NgIf"], _firmware_updater_firmware_updater_component__WEBPACK_IMPORTED_MODULE_5__["FirmwareUpdaterComponent"]], styles: [".section1[_ngcontent-%COMP%]{\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\n.section3[_ngcontent-%COMP%]{\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n  margin-top: 16px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvdXBkYXRlLXRhYi91cGRhdGUtdGFiLmNvbXBvbmVudC5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxXQUFXO0VBQ1gseUJBQXdCO1VBQXhCLHdCQUF3QjtFQUN4Qix1QkFBc0I7VUFBdEIsc0JBQXNCO0FBQ3hCOztBQUVBO0VBQ0UsMEJBQXlCO1VBQXpCLHlCQUF5QjtFQUN6Qix3QkFBdUI7VUFBdkIsdUJBQXVCO0VBQ3ZCLGdCQUFnQjtBQUNsQiIsImZpbGUiOiJzcmMvYXBwL3VwZGF0ZS10YWIvdXBkYXRlLXRhYi5jb21wb25lbnQuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLnNlY3Rpb24xe1xuICBtYXJnaW46IDhweDtcbiAgbWFyZ2luLWlubGluZS1zdGFydDogOHB4O1xuICBtYXJnaW4taW5saW5lLWVuZDogOHB4O1xufVxuXG4uc2VjdGlvbjN7XG4gIG1hcmdpbi1pbmxpbmUtc3RhcnQ6IDI0cHg7XG4gIG1hcmdpbi1pbmxpbmUtZW5kOiAyNHB4O1xuICBtYXJnaW4tdG9wOiAxNnB4O1xufVxuXG4iXX0= */", ".container[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 0;\n  height: 90%; \n}\n\n.tab-content[_ngcontent-%COMP%]{\n  width: 60%;\n  float: left;\n  height: 100%; \n  margin-left: 16px;\n}\n\n.content[_ngcontent-%COMP%] {\n  margin: 40px 20px 0 0;\n}\n\n.tab-help[_ngcontent-%COMP%] {\n  margin-left: 60%;\n  font-size: 15px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  background-color: #E6E8EB;\n  padding-left: 8px;\n  padding-right: 8px;\n  \n  height: 100%; \n  overflow: auto;\n}\n\n\n\nmat-expansion-panel[_ngcontent-%COMP%] {\n  margin-bottom: 8px !important;\n  width: 568px !important;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%] {\n  background-color: #EEEEEE;\n  cursor: pointer;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 19px;\n  transition: 0.6s;\n  padding: 0 10px;\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  height: 38px !important;\n}\n\nmat-panel-title[_ngcontent-%COMP%] {\n  font-weight: normal;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n}\n\nmat-expansion-panel-header[_ngcontent-%COMP%]:hover {\n  background-color: #DDDDDD !important;\n}\n\nmat-expansion-panel-header.mat-expanded[_ngcontent-%COMP%] {\n  background-color: #DDDDDD !important;\n  height: 38px;\n}\n\n  .mat-expansion-panel-body {\n  padding: 20px 14px 10px 0!important;\n  background-color: transparent;\n  \n  transition: max-height 0.4s ease-out;\n  \n  vertical-align: top;\n  border-collapse: separate;\n  border-spacing: 4px;\n}\n\n.t1[_ngcontent-%COMP%] {\n  margin-left: 8px;\n  margin-bottom: 10px !important;\n}\n\ntd.label[_ngcontent-%COMP%] {\n  min-width: 160px;\n  padding: 2px 4px 2px 0;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-size: 15px;\n  color: #333333;\n  border-spacing: 4px;\n}\n\ntd.value[_ngcontent-%COMP%] {\n  min-width: 230px;\n  padding: 2px 4px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  color: #333333;\n  font-size: 15px;\n  border-spacing: 4px;\n  white-space: pre-line;\n}\n\ntable.section1[_ngcontent-%COMP%], div.section1[_ngcontent-%COMP%] {\n  margin: 8px;\n  -webkit-margin-start: 8px;\n          margin-inline-start: 8px;\n  -webkit-margin-end: 8px;\n          margin-inline-end: 8px;\n}\n\ntable.section2[_ngcontent-%COMP%], div.section2[_ngcontent-%COMP%] {\n  -webkit-margin-start: 16px;\n          margin-inline-start: 16px;\n  -webkit-margin-end: 16px;\n          margin-inline-end: 16px;\n}\n\ntable.section3[_ngcontent-%COMP%], div.section3[_ngcontent-%COMP%] {\n  -webkit-margin-start: 24px;\n          margin-inline-start: 24px;\n  -webkit-margin-end: 24px;\n          margin-inline-end: 24px;\n}\n\n\n\n  .mat-accent .mat-slider-thumb {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-accent .mat-slider-track-fill {\n  background-color: #3751e7;\n  padding: 0;\n}\n\n  .mat-slider-horizontal .mat-slider-wrapper{\n  left: 0px !important;\n  right: 0px;\n  width: 169px;\n}\n\n  .mat-slider {\n  padding: 0px !important;\n  width: 169px !important;\n}\n\n  .mat-slider-horizontal {\n  height: 38px;\n}\n\n\n\n.visual[_ngcontent-%COMP%] {\n  \n  color: #888888;\n  font-weight: bold;\n  float: left;\n  margin-right: 5px;\n}\n\n\n\n  .mat-form-field-appearance-fill .mat-form-field-flex {\n  padding: 0 !important;\n  background-color: transparent;\n  \n}\n\n  .mat-form-field-wrapper {\n  \n  padding-bottom: 0 !important;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  font-weight: 400;\n  font-size: 13px;\n}\n\n  .mat-form-field-appearance-fill .mat-form-field-infix {\n  padding: 0.25em 0 !important;\n}\n\n  .mat-form-field-infix {\n  border: solid 1px black;\n  width: 175px !important;\n}\n\n  .mat-form-field-underline {\n  width: 0 !important;\n}\n\n  .mat-select-value {\n  padding-left: 5px !important;\n}\n\n  .mat-form-field-appearance-fill .mat-select-arrow-wrapper {\n  transform: none !important;\n}\n\n.input[_ngcontent-%COMP%] {\n  padding: 3px !important;\n  width: 168px;\n}\n\n  .mat-radio-label {\n  padding-right: 10px;\n}\n\n  .mat-radio-label-content {\n  padding-left: 5px !important;\n}\n\n  .mat-radio-button.mat-accent.mat-radio-checked .mat-radio-outer-circle {\n  border-color: #3751e7 !important;\n}\n\n  .mat-radio-inner-circle {\n  background-color: #3751e7 !important;\n}\n\n.actionBtn[_ngcontent-%COMP%]{\n  \n  margin: 0 4px;\n  padding: 1px 6px;\n  cursor: pointer;\n  font-size: 15px;\n  min-width: 70px;\n  font-family: \"SourceSansPro\", Arial, Helvetica, sans-serif;\n  height: 25px;\n}\n\nbutton[_ngcontent-%COMP%]:disabled{\n  color: #AAAAAA;\n  cursor: unset;\n}\n\n.redBtn[_ngcontent-%COMP%]{\n  color: #A21010;\n\n}\n\n.submitBtn[_ngcontent-%COMP%]{\n  color: #006D13;\n}\n\n.loading-ripple[_ngcontent-%COMP%]{\n  width: 100%;\n  text-align: center;\n  top: calc(25vh);\n  position: relative;\n  color: #333333;\n  font-family: SourceSansPro, Arial, Helvetica, sans-serif;\n  font-size:19px;\n  font-weight:400;\n}\n\na[_ngcontent-%COMP%], a[_ngcontent-%COMP%]:link, a[_ngcontent-%COMP%]:visited, a[_ngcontent-%COMP%]:active {\n  color: #719ABE;\n  text-decoration: none;\n}\n\n\n\n  .toast-top-right {\n  top: 100px;\n  right: 40%;\n}\n\n\n\n.invisibleBtn[_ngcontent-%COMP%] {\n  background-color: transparent;\n  border-color: transparent;\n  cursor: pointer;\n  outline: none;\n}\n\n.invisibleBtn[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n  box-shadow: none;\n}\n\np.help[_ngcontent-%COMP%]  {\n  font-size: 14px;\n}\n\n.alignCenter[_ngcontent-%COMP%] {\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n}\n\n.input-error[_ngcontent-%COMP%] {\n  border: red 2px solid !important;\n}\n\n.settings-mat-radio-btn[_ngcontent-%COMP%] {\n  min-width: 100px;\n}\n\n.custom-select[_ngcontent-%COMP%] {\n  border: 1px solid black;\n  width: 175px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */"] });
/*@__PURE__*/ (function () { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵsetClassMetadata"](UpdateTabComponent, [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"],
        args: [{
                selector: 'app-update',
                templateUrl: './update-tab.component.html',
                styleUrls: ['./update-tab.component.css', '../general.css']
            }]
    }], function () { return [{ type: _services_system_info_service__WEBPACK_IMPORTED_MODULE_1__["SystemInfoService"] }, { type: _services_device_config_service__WEBPACK_IMPORTED_MODULE_2__["DeviceConfigService"] }, { type: _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_3__["HTTPResponseHandlerService"] }]; }, null); })();


/***/ }),

/***/ "lBYT":
/*!****************************************************************************!*\
  !*** ./src/app/high-prio-notification/high-prio-notification.component.ts ***!
  \****************************************************************************/
/*! exports provided: HighPrioNotificationComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HighPrioNotificationComponent", function() { return HighPrioNotificationComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "3Pt+");
/* harmony import */ var _validators_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../validators/utils */ "/q1Y");
/* harmony import */ var _services_device_config_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/device-config.service */ "0mv3");
/* harmony import */ var _services_httpresponse_handler_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/httpresponse-handler.service */ "SLeU");
/* harmony import */ var _services_toastr_message_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/toastr-message.service */ "XtJy");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ "ofXK");
/* harmony import */ var _angular_flex_layout_extended__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/flex-layout/extended */ "znSr");
/* harmony import */ var _angular_material_slider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/slider */ "5RNC");
/* harmony import */ var _angular_material_radio__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/radio */ "QibW");












const _c0 = function (a0) { return { "input-error": a0 }; };
function HighPrioNotificationComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "form", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("ngSubmit", function HighPrioNotificationComponent_div_3_Template_form_ngSubmit_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r5.submit(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "table", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](5, "Stream URL");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "td", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "input", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](9, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](10, "Volume");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](11, "td", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "mat-slider", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function HighPrioNotificationComponent_div_3_Template_mat_slider_input_12_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r6); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r7.onVolumeChange($event, "hpn_volume"); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](14, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](15, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](16, "Buffer size");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](17, "td", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](18, "input", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](19, "tr");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](20, "td", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](21, "High Priority");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](22, "td", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](23, "mat-radio-group", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](24, "mat-radio-button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](25, "Yes");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](26, "mat-radio-button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](27, "No");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](28, "div", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](29, "hr", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](30, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](31, "button", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function HighPrioNotificationComponent_div_3_Template_button_click_31_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r6); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](); return ctx_r8.cancelChanges(); });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](32, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](33, "button", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](34, "Submit");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
} if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("hidden", !ctx_r0.show_settings_component);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("formGroup", ctx_r0.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](7, _c0, ctx_r0.form.get("hpn_url").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("\u00A0\u00A0\u00A0", ctx_r0.form.get("hpn_volume").value, "% ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](9, _c0, ctx_r0.form.get("hpn_buffer_size").invalid));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("hpn_high_prio").value === "true");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.form.get("hpn_high_prio").value === "false");
} }
class HighPrioNotificationComponent {
    constructor(configsService, httpResponseHandler, toastrService) {
        this.configsService = configsService;
        this.httpResponseHandler = httpResponseHandler;
        this.toastrService = toastrService;
        /* Forms */
        this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        /* Backup */ //used to check what changed exactly, to decide which message should show while submitting
        this.backupSettingsDict = {};
        this.ucisList = {
            'hpn_url': 'epic.hpn.url',
            'hpn_buffer_size': 'epic.hpn.buffer_size',
            'hpn_volume': 'epic.hpn.volume',
            'hpn_high_prio': 'epic.hpn.high_prio'
        };
        this.dataIsAvailable = false;
        //loadFinished = false;
        this.show_loading_component = false;
        //whileSubmit = false;
        this.show_settings_component = false;
    }
    ngOnInit() {
        this.loadDataFromDevice();
    }
    loadDataFromDevice() {
        this.dataIsAvailable = false;
        this.form = new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormGroup"]({});
        this.configsService.getUcis(this.ucisList).subscribe(data => {
            //console.log("Status:", data.status);
            //console.log("Received:", data.body);
            switch (data.status) {
                case 200:
                    //store for backup
                    this.backupSettings(data.body);
                    //build device form group
                    this.buildDeviceFormGroup(data.body);
                    this.show_loading_component = false;
                    this.show_settings_component = true;
                    this.dataIsAvailable = true;
                    break;
                case 401:
                    this.httpResponseHandler.handle401HttpErrorResponse(data.error);
                    break;
                case 500:
                    this.httpResponseHandler.handle500HttpErrorResponse();
                    break;
                default:
                    console.log("Unexpected return code: ", data.status);
                    this.httpResponseHandler.handleUnexpectedHttpErrorResponse(data.status);
                    break;
            }
        });
    }
    backupSettings(configDict) {
        Object.keys(configDict).forEach(key => {
            this.backupSettingsDict[key] = configDict[key];
        });
        //console.log(this.backupSettingsDict);
    }
    buildDeviceFormGroup(configDict) {
        const HPN_URL_REGEX = "^rtp:\\/\\/((2(?:2[4-9]|3\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d?|0)){3}:)|@:|0.0.0.0:)(102[4-9]|10[3-9][0-9]|1[1-9][0-9]{2}|[2-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])(\\?format=\\w+&channels=\\d&rate=\\d+(&pt=\\d+)?)?$";
        this.form.addControl('hpn_url', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.hpn.url"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(HPN_URL_REGEX)]));
        this.form.addControl('hpn_buffer_size', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.hpn.buffer_size"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(50), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(10000), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].pattern(_validators_utils__WEBPACK_IMPORTED_MODULE_2__["INT_NUMBER_REGEX"])]));
        this.form.addControl('hpn_volume', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.hpn.volume"], [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required, _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].max(100)]));
        this.form.addControl('hpn_high_prio', new _angular_forms__WEBPACK_IMPORTED_MODULE_1__["FormControl"](configDict["epic.hpn.high_prio"], _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required));
    }
    //Make value update while slider is moving
    onVolumeChange(event, formName) {
        //console.log(event.value);
        this.form.get(formName).setValue(event.value);
    }
    cancelChanges() {
        this.show_settings_component = false;
        /*Object.keys(this.form.value).forEach(key => {
          this.form.removeControl(key);
        });
        console.log(this.form.value);*/
        this.loadDataFromDevice();
    }
    submit() {
        //console.log(this.form);
        //check if passwords are valid
        if (!this.form.valid) {
            //this.toast