from uci import Uci, UciExceptionNotFound, UciException
import json
import logging
import threading
from os import listdir
from os.path import isfile, join

from .common import *
from .internal_funcs import *
from .uci import *

from flask import (
    Blueprint, flash, g, redirect, render_template, request, session, url_for, Response
)
#from werkzeug.security import check_password_hash, generate_password_hash

bp = Blueprint('uci_API', __name__)

log = logging.getLogger('werkzeug')

"""
#http://127.0.0.1:5000/config/show
#http://127.0.0.1:5000/config/show?config=network
#http://127.0.0.1:5000/config/show?config=network&section=eth0
#http://127.0.0.1:5000/config/show?config=network&section=eth0&option=netmask
"""
@bp.route('/rest/uci', methods=['GET'])
@login_required
def getuci():
    log.debug(request.args)
    """
    for key in request.args.keys():
        print(key)
        print(type(key))
    """
    #print(request.args["filters"])
    #print(type(request.args["filters"]))
    #print(type(ast.literal_eval(request.args["filters"])))
    response = {}
    status_code = 200
    result = ''
    #uriList = ast.literal_eval(request.args["filters"])
    uriList = request.args

    if uriList == {}:
        log.debug("Empty uci list in request")
        uriList = getAllConfigs()

    for uciPath in uriList:
        #log.debug(uciPath)
        path_params = uciPath.split('.')
        try:
            # Instantiate Python UCI
            uci = Uci()
            #if only has config
            if len(path_params) == 1:
                # log.debug("uci.get({})".format(path_params[0]))
                """
                result = formatUCI(uci.get(path_params[0]))
                for key in result:
                    response[uciPath + "." + key] = result[key]
                """
                result = uci.get(path_params[0])
            #if it has config and section
            elif len(path_params) == 2:
                # log.debug("uci.get_all({},{})".format(path_params[0], path_params[1]))
                """
                result = formatUCI(uci.get_all(path_params[0], path_params[1]))
                for key in result:
                    response[uciPath + "." + key] = result[key]
                """
                result = uci.get_all(path_params[0], path_params[1])
            #if it has config, section and option
            elif len(path_params) == 3:
                # log.debug("uci.get({},{},{})".format(path_params[0], path_params[1], path_params[2]))
                result = uci.get(path_params[0], path_params[1], path_params[2])

            else:
                log.error("ERROR: bad formatted uci {}".format(uciPath))
                return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                              "msg": INVALID_PARAMETER_ERROR_MSG.format(uciPath)}
                log.error(return_msg)
                status_code = BAD_REQUEST_ERROR_CODE
                break
        except UciExceptionNotFound:
            log.debug("uci.get param \"{}\" NOT FOUND".format(uciPath))
            #response = {"error_code": BAD_UCI_VALUE_ERROR_CODE, "msg": "ERROR: bad uci"}
            #status_code = BAD_REQUEST_ERROR_CODE
            #break
            result = '' # an uci with an empty string value is the same a non existing string
        except Exception as e:
            """
            response = {"error_code": UNSPECIFIED_ERROR_CODE, "msg": "ERROR: It was not possible to conclude the action requested"}
            log.debug("uci.get param \"{}\" failed: {}\n".format(uciPath, e))
            # error code: Internal Server Error
            status_code = INTERNAL_SERVER_ERROR_CODE
            break
            """
            log.error(e)
            return Response(status=INTERNAL_SERVER_ERROR_CODE)
        response[uciPath] = result
    log.debug(response)
    #return json.dumps(response)
    return Response(json.dumps(response), status=status_code)
    #return "Get"

@bp.route('/rest/uci', methods=['PUT'])
@login_required
def setuci():
    log.debug("/rest/uci POST")
    # success code
    status_code = 200
    return_msg = {"error_code": ALL_OK, "msg": "All Ok"}
    uciCli = Uci()
    try:
        data = json.loads(request.data)
    except Exception as e:
        log.debug(e)
        return_msg = {"error_code": INVALID_JSON_ERROR_CODE, "msg": INVALID_JSON_ERROR_MSG}
        return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
    # param_path = data['config'] + "." + data['section'] + "." + data['option']
    # it is actually a dict
    if 'options' in data.keys():
        uciListReq = data['options']
        log.debug("List of ucis to set: {}".format(uciListReq))
        """if data['options'] == [] or data['options'] == {}:
            return_msg = {"error_code": EMPTY_PARAM_ERROR_CODE,"msg": "POST request don't have ucis to set"}
            log.debug(return_msg)
            status_code = BAD_REQUEST_ERROR_CODE
        """
        if uciListReq != {}:  # if list of ucis to set is not empty
            uciListSetted = []
            for uci in uciListReq:
                log.debug("uci: {}".format(uci))
                path_params = uci.split('.')
                # verify if params are valid (if the number of params is correct and exist)
                if len(path_params) != 2 and len(path_params) != 3:
                    return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                                  "msg": INVALID_PARAMETER_ERROR_MSG.format(uci)}
                    log.error(return_msg)
                    status_code = BAD_REQUEST_ERROR_CODE
                    break
                value = ''
                try:
                    value = uciCli.get(path_params[0], path_params[1], path_params[2])
                except UciExceptionNotFound:
                    log.debug("uci \"{}\" NOT FOUND".format(uci))
                try:
                    if value != uciListReq[uci]:
                        #    log.debug("Value from uci {} did not changed".format(uci))
                        # else:
                        log.debug("uciCli.set({},{},{},{})".format(path_params[0], path_params[1], path_params[2],
                                                                   uciListReq[uci]))
                        uciCli.set(path_params[0], path_params[1], path_params[2], str(uciListReq[uci]))
                        #uciListSetted.append(uci)
                        uciListSetted.append((path_params[0], path_params[1], path_params[2]))
                except UciException:
                    log.error("It was not possible to set uci {} with value {}".format(uci, str(uciListReq[uci])))
                    return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                                  "msg": INVALID_PARAMETER_ERROR_MSG.format(uciListReq[uci])}
                    log.error(return_msg)
                    status_code = BAD_REQUEST_ERROR_CODE
                    break
                except Exception as e:
                    """
                    return_msg = {"error_code": UNSPECIFIED_ERROR_CODE, "msg": "It was not possible to set UCI {} with value {}".format(uci, str(uciListReq[uci]))}
                    log.error("It was not possible to set UCI {} with value {}: {}".format(uci, str(uciListReq[uci]),e))
                    #error code: Internal Server Error
                    """
                    log.debug(e)
                    return Response(status=INTERNAL_SERVER_ERROR_CODE)

            if status_code != 200:
                # revert changes made
                for uci in uciListSetted:
                    try:
                        log.debug("Reverting uci {}".format(uci))
                        #uciCli.revert(uci.split('.')[0], uci.split('.')[1], uci.split('.')[2])
                        uciCli.revert(uci[0], uci[1], uci[2])
                    except Exception as e:
                        """
                        status_code = INTERNAL_SERVER_ERROR_CODE
                        return_msg = {"error_code": REVERT_UCI_ERROR_CODE,
                                      "msg": "It was not possible to revert changes made to uci {}: {}".format(uci, e)}
                        #should never happen!!
                        """
                        log.error("It was not possible to revert changes made to uci {}: {}".format(uci, e))
                        return Response(status=INTERNAL_SERVER_ERROR_CODE)
            else:
                configsList = []
                for uci in uciListSetted:
                    configsList.append(uci[0])
                if not 'commit' in data.keys():
                    return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                                  "msg": INVALID_PARAMETER_ERROR_MSG.format('commit')}
                    log.error(return_msg)
                    return Response(response=json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
                log.debug('Should commit: {}'.format(data['commit']))
                if data['commit'] and configsList != []:
                    # listToCommit = set(configsList)
                    for config in set(configsList):
                        try:
                            log.debug("Commiting config {}".format(config))
                            uciCli.commit(config)
                        except Exception as e:
                            # should never happen!!
                            # return_msg = {"error_code": COMMIT_UCI_ERROR_CODE, "msg": "It was not possible to commit config {}".format(config)}
                            log.error("Committing config {} failed: {}".format(config, e))
                            # error code: Internal Server Error
                            return Response(status=INTERNAL_SERVER_ERROR_CODE)
                #log.debug('launching thread')
                #t = threading.Thread(target=internal_funcs.createListOfServicesToRestart, args=(uciListSetted,))
                #t.start()
                result, error = internal_funcs.createListOfServicesToRestart(uciListSetted)
                if error != ALL_OK:
                    return Response(status=INTERNAL_SERVER_ERROR_CODE)
                t = threading.Thread(target=internal_funcs.restartServices)
                t.start()
        else:
            return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                          "msg": INVALID_PARAMETER_ERROR_MSG.format('options')}
            log.error(return_msg)
            status_code = BAD_REQUEST_ERROR_CODE
    else:
        return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE, "msg": INVALID_PARAMETER_ERROR_MSG.format('options')}
        log.error(return_msg)
        status_code = BAD_REQUEST_ERROR_CODE
    # return sucess_code if the sets and commits were successful
    # return error_code if they weren't

    # return_msg = {"error_code": 100000, "msg": "inputs not validated"}
    return Response(json.dumps(return_msg), status=status_code)
    # return "Set"


"""
def getAllConfigs():
    mypath = "/barix/config/current"
    config_names = [f for f in listdir(mypath) if isfile(join(mypath, f))]
    return config_names
"""

"""
@bp.route('/rest/getDeviceDetails', methods=['POST'])
def getUciFromDevice():
    # success code
    params = json.loads(request.data)
    # param_path = data['config'] + "." + data['section'] + "." + data['option']
    # it is actually a dict
    uciList = params['uci_list']
    ip_addr = params['ip_addr']
    if uciList == [] or uciList == {} or ip_addr == '':
        return_msg = {"error_code": EMPTY_PARAM_ERROR_CODE, "msg": "POST request came with empty parameters to set"}
        print(return_msg)
        status_code = BAD_REQUEST_ERROR_CODE
        return Response(return_msg, status_code)
    else:
        url = "http://" + ip_addr + ":8000/rest/uci?"
        for uciPath in uciList:
            url = url + uciPath + "&"
        url = url[:-1]
        print(url)
        try:
            resp = requests.get(url)
            return Response(response=resp.content, status=resp.status_code, headers=resp.headers.items())
        except requests.exceptions.ConnectionError as e:
            print(e)
            return_msg = {"error_code": 1010,
                          "msg": str(e)}
            return Response(response=json.dumps(return_msg), status=SERVICE_UNAVAILABLE)
        #print(resp.content)
        #print(resp.status_code)
        #print(resp.headers.items())


@bp.route('/rest/setDeviceDetails', methods=['POST'])
def setUciFromDevice():
    print('/rest/setDeviceDetails')
    params = json.loads(request.data)
    print(params)
    data = params['data']
    ip_addr = params['ip_addr']
    if data == [] or data == {} or ip_addr == '':
        return_msg = {"error_code": EMPTY_PARAM_ERROR_CODE, "msg": "POST request came with empty parameters to set"}
        print(return_msg)
        status_code = BAD_REQUEST_ERROR_CODE
        return Response(return_msg, status_code)
    else:
        url = "http://" + ip_addr + ":8000/rest/uci"
        res = requests.post(url, data=json.dumps(data))
        return Response(response=res.content, status=res.status_code, headers=res.headers.items())

"""
    
"""
#GET http://0.0.0.0:8000/config/show?filters={flexa_ip_former.source1.prio}
print("request")
print(request) #<Request 'http://0.0.0.0:8000/config/show?filters=%7Bflexa_ip_former.source1.prio%7D' [GET]>
#print("data")
#print(request.data) #b''
print("args")
print(request.args) #ImmutableMultiDict([('filters', '{flexa_ip_former.source1.prio}')])
print("values")
print(request.values) #CombinedMultiDict([ImmutableMultiDict([('filters', '{flexa_ip_former.source1.prio}')]), ImmutableMultiDict([])])
#print("json")
#print(request.json) #None
#print("force json")
#print(request.get_json(force=True)) #400 Bad Request

#GET http://0.0.0.0:8000/config/show?flexa_ip_former.source1.prio&flexa_ip_former.source2.prio
request: <Request 'http://0.0.0.0:8000/config/show?flexa_ip_former.source1.prio&flexa_ip_former.source2.prio' [GET]>
args: ImmutableMultiDict([('flexa_ip_former.source1.prio', ''), ('flexa_ip_former.source2.prio', '')])

#GET http://0.0.0.0:8000/config/show?filters={flexa_ip_former.source1.prio,flexa_ip_former.source2.prio}
args: ImmutableMultiDict([('filters', '{flexa_ip_former.source1.prio,flexa_ip_former.source2.prio}')])

GET http://0.0.0.0:8000/config/show?{flexa_ip_former.source1.prio,flexa_ip_former.source2.prio}
args: ImmutableMultiDict([('{flexa_ip_former.source1.prio,flexa_ip_former.source2.prio}', '')])

#GET http://0.0.0.0:8000/uci?filters={flexa_ip_former.source1.prio,flexa_ip_former.source2.prio}
#print("args")
#print(request.args) #ImmutableMultiDict([('filters', '{flexa_ip_former.source1.prio,flexa_ip_former.source2.prio}')])
#print(type(request.args)) #<class 'werkzeug.datastructures.ImmutableMultiDict'>
#print(request.args["filters"]) #{flexa_ip_former.source1.prio,flexa_ip_former.source2.prio}
#print(type(request.args["filters"])) #str
#print(request.args["filters"][1:-1]) #flexa_ip_former.source1.prio,flexa_ip_former.source2.prio


# GET /rest/uci?filters=['flexa_ip_former.source1.prio','flexa_ip_former.source2.prio']
#print(request.args) #ImmutableMultiDict([('filters', '[flexa_ip_former.source1.prio,flexa_ip_former.source2.prio]')])


GET /rest/uci?{%22filters%22:[%27flexa_ip_former.source1.prio%27,%20%27flexa_ip_former.source2.prio%27]%20}
#{"filters":['flexa_ip_former.source1.prio', 'flexa_ip_former.source2.prio'] }


GET /rest/uci?flexa_ip_former.source1.prio&flexa_ip_former.source1.name&flexa_ip_former.source1.type
"""

"""
GET API
uci.get(config)
Returns a dictionary of dictionaries where first level keys are section names and the lower level keys are then names of
options.
uci.get(config, section)
Returns type of section.
uci.get(config, section, option)
Only that specific value is returned. 

If any requested config, section or option are not found then UciExceptionNotFound is thrown.

If UciExceptionNotFound occurs, returns 400 Bad Request.
If any kind of other exception occurs, returns 500 Internal server error.
If cannot divide structure received in config/section/option, returns 400 Bad Request. 
"""

"""
POST {"options": {"application.audio.volume":"100"}, "commit": true}
If "options" is empty, returns 400 Bad Request.
If section does not exist, throws UciException => returns 400 Bad Request.
If an error occured => it doesn't commit and revert any change made => returns 400 Bad Request
If can't commit => returns 500 Internal Server Error and revert any change made

If one set fails, all changes will be reverted. It cannot update some ucis and others not.


SET API
uci.set(config, section, option, value)
If value from option is string, then value is set as option. 
If value from option is table/tuple then it is set as list.
If section does not exist, throws UciException.
If option does not exist, it creates it and sets its value.
uci.set(config, section, value) creates section with name = value or changes section name.
"""

"""
try:
    f = open("/etc/barix/soundcard.conf", 'r')
    lines = f.read().split('\n')
    mixer = ((lines[2].split('='))[1]).strip('\n')
    audio_dev = ((lines[1].split('='))[1]).strip('\n')
    f.close()
except Exception as e:
    customLogger().error(e)
    mixer = "Line Out"
    audio_dev = "plug:dmixer"

customLogger().debug("Using mixer: "+mixer)
customLogger().debug("Using audio_dev: "+audio_dev)

cmd = "/usr/bin/amixer -q -M -c 2 set '" + mixer + "' " + str(vol) + "%"
"""
