########################################################################################
#
#   Discovery.py
#
#   Discover IP Speakers using zeroconf python module
#
#   zeroconf - Multicast DNS Service Discovery for Python
#
########################################################################################

from zeroconf import ServiceBrowser, Zeroconf
import socket
import time
import logging
from threading import Lock

class Discovery:
    def __init__(self, serv_type="_https._tcp.local."):
        self.serv_type = serv_type
        self.zeroconf = None
        self.listener = None
        self.running = False
        #self.run()
        self.lock = Lock()

        self.log = logging.getLogger('werkzeug')

    def run(self):
        self.zeroconf = Zeroconf()
        self.listener = MyListener()
        ServiceBrowser(self.zeroconf, self.serv_type, self.listener)
        self.lock.acquire()
        self.running = True
        self.lock.release()
        while self.running:
            time.sleep(0.01)
        #self.log.debug("##################End run")

    def stopRunning(self):
        self.log.debug("Stopping...")
        self.lock.acquire()
        self.running = False
        self.lock.release()
        self.zeroconf.close()

    def __del__(self):
        self.zeroconf.close()

class MyListener:
    def __init__(self):
        self.discoverDict = {"discovery": list()}
        #self.update_json()
        self.log = logging.getLogger('werkzeug')
        #self.log.debug(self.discoverDict)

    def remove_service(self, zeroconf, type, name):
        self.log.debug("Service %s removed" % (name,))
        result = name.split("|")
        for elem in self.discoverDict["discovery"]:
            if elem["mac"] == str(result[1]):
                self.discoverDict["discovery"].remove(elem)
                #self.update_json()
                self.log.debug(self.discoverDict)
                break

    def add_service(self, zeroconf, type, name):
        info = zeroconf.get_service_info(type, name)
        host_ip = socket.inet_ntoa(info.addresses[0])
        self.log.debug("Service %s added, service info: %s" % (name, info))
        self.log.debug("Host: {}".format(host_ip))
        discover_host = dict()
        if name.startswith('IP Audio Client'):
            result = name.split("|")
            discover_host["name"] = result[0]
            discover_host["mac"] = result[1]
            discover_host["ip"] = host_ip
            #remove byte characters
            properties = { k.decode('utf-8') : v.decode('utf-8') for k, v in info.properties.items()}
            #discover_host["info"] = str(info.properties)
            discover_host["info"] = properties
            discover_host["timestamp"] = time.time()
            self.discoverDict["discovery"].append(discover_host)
            #self.update_json()
            self.log.debug(self.discoverDict)

    def update_service(self, zeroconf, type, name):
        info = zeroconf.get_service_info(type, name)
        host_ip = socket.inet_ntoa(info.addresses[0])
        self.log.debug("Update host {} - info: {}".format(host_ip, info))
        result = name.split("|")
        #check if device already is in list
        for idx,elem in enumerate(self.discoverDict["discovery"]):
            if elem["mac"] == str(result[1]):
                discover_host = dict()
                discover_host["name"] = result[0]
                discover_host["mac"] = result[1]
                discover_host["ip"] = host_ip
                # remove byte characters
                properties = {k.decode('utf-8'): v.decode('utf-8') for k, v in info.properties.items()}
                # discover_host["info"] = str(info.properties)
                discover_host["info"] = properties
                discover_host["timestamp"] = time.time()
                self.discoverDict["discovery"][idx] = discover_host
                #self.update_json()
                self.log.debug(self.discoverDict)
                break

    #def update_json(self):
        #f = open("/usr/local/www/current/app/discovery.json", 'w')
        #f.write(json.dumps(self.discoverDict))
        #f.close()


#if __name__=="__main__":
#    Discovery()