import logging
import subprocess

log = logging.getLogger('flask-backend')

'''
Execute a speaker test with a sine wave frequency of 800Hz for approximately 4 seconds.
Playback device is retrieved from "/etc/barix/soundcard.conf" file. Default is plug:dmixer.
'''
def executeSoundtest():
    # default audio_dev
    audio_dev = "plug:dmixer"

    # get appropriate audioDev
    try:
        f = open("/etc/barix/soundcard.conf", 'r')
        lines = f.read().split('\n')
        for line in lines:
            if line.startswith('master.device'):
                audio_dev = ((line.split('='))[1]).strip('\n')
        f.close()
    except Exception as e:
        log.error("Can't get master.device".format(e))
        raise e

    try:
        cmd = ["speaker-test", "-D", audio_dev, "-t", "sine", "--frequency", "800", "-buffer", "10000", "--nloops", "1"]
        p = subprocess.Popen(cmd)
        p.wait()
    except Exception as e:
        log.error("Can't execute speaker test".format(e))
        raise e