#!/usr/bin/python3 -u

# For testing
# snmpwalk -v2c -c AESNMP1978 localhost .1.3.6.1.2.1.1
# snmpwalk -v2c -c AESNMP1978 localhost .1.3.6.1.4.1.17491.1.161.3

import os
import logging
from logging.handlers import RotatingFileHandler
import json
import snmp_passpersist as snmp
from uci import Uci

def uciGet(uci: Uci, config: str, section: str, opt: str) -> str:
    try:
        return uci.get(config, section, opt)
    except:
        return None

def update():
    global OIDmap
    global IP
    
    count = 1

    # Device type
    with open("/barix/apps/epic-sip/MODEL") as f:
        devName=f.readlines()[0].strip()
    oid = "3.{}".format(count)
    pp.add_str(oid, devName)
    count += 1

    # Uptime in "DDHHMM" format
    with open("/proc/uptime") as f:
        tmp=f.readlines()[0].strip()
        tmp=tmp.split(" ")
        uptime = int(float(tmp[0]))
        utDays = int(uptime/86400)
        utHours= int((uptime-utDays*86400)/3600)
        utMinutes=int((uptime-utDays*86400-utHours*3600)/60)
        uptime = "{:02d}{:02d}{:02d}".format(utDays, utHours, utMinutes)
    oid = "3.{}".format(count)
    pp.add_str(oid, uptime)
    count += 1

    # IP
    oid = "3.{}".format(count)
    pp.add_str(oid, IP)
    count += 1

    # FW version
    with open("/barix/info/VERSION") as f:
        fwVer=f.readlines()[0].strip()
    oid = "3.{}".format(count)
    pp.add_str(oid, fwVer)
    count += 1

    # Device alias
    alias=uciGet(Uci(), "epic", "main", "device_alias")
    if alias == None or alias == "":
        alias = "-"
    alias = alias.strip()
    oid = "3.{}".format(count)
    pp.add_str(oid, alias)
    count += 1

    # Device description
    descr=uciGet(Uci(), "epic", "main", "description")
    if descr == None or descr == "":
        descr = "-"
    descr = descr.strip()
    oid = "3.{}".format(count)
    pp.add_str(oid, descr)
    count += 1
    
    # Static data
    for item in OIDmap:
        # print(item)
        objType = OIDmap[item]['type']
        objValue = OIDmap[item]['value'].strip()
        # print("type:{}, value:{} ".format(objType, objValue))
        oid = "3.{}".format(count)
        if objType == "INTEGER":
            pp.add_int(oid, objValue)
        elif objType == "DisplayString":
            pp.add_str(oid, objValue)
        else:
            raise Exception("Unknown object type")
            
        count += 1

AE_BASE_OID = ".1.3.6.1.4.1.17491.1.161"

logger = logging.getLogger('ae_logger')
logger.setLevel(logging.INFO)
f_handler = RotatingFileHandler('/var/log/snmp.log', maxBytes=2*1024*1024, backupCount=3)
format1 = logging.Formatter('%(asctime)s  %(levelname)s  %(filename)s:%(lineno)s  %(message)s')
f_handler.setFormatter(format1)
logger.addHandler(f_handler)

myIP = os.popen('ifconfig eth0 | grep "inet "').read().strip().split()
IP = myIP[1]

try:
    logger.info('Reading json MIB file...')
    json_file = open('/barix/apps/epic-sip/SNMP/BARIX_AE.json')
    OIDmap = json.load(json_file)
    json_file.close()

except Exception as e:
    logger.info('Error reading json MIB file: ', e)
    sys.exit("Error reading json MIB file")

pp=snmp.PassPersist(AE_BASE_OID)
pp.start(update, 10) # Every 10s
    

