#!/bin/sh

TIMEOUT=10
LOG_FILE="/var/log/messages"
LEDG="/sys/class/leds/barix:led1:green/brightness"
ETH="eth0"
SAFE_PATH="/mnt/data/WD"
LOG_FILE="$SAFE_PATH/watchdog.log"

log() {
        stamp=$(date '+%b %e %H:%M:%S')
        record="$0: $stamp $1"
        echo $record >> $LOG_FILE
#        echo $record
}

backup_log() {
    if [ -f $SAFE_PATH/watchdog3.log ]; then
        rm -f $SAFE_PATH/watchdog3.log
    fi
    if [ -f $SAFE_PATH/watchdog2.log ]; then
        mv $SAFE_PATH/watchdog2.log $SAFE_PATH/watchdog3.log
    fi
    if [ -f $SAFE_PATH/watchdog1.log ]; then
        mv $SAFE_PATH/watchdog1.log $SAFE_PATH/watchdog2.log
    fi
    if [ -f $SAFE_PATH/watchdog.log ]; then
        mv $SAFE_PATH/watchdog.log $SAFE_PATH/watchdog1.log
    fi
}

mkdir -p $SAFE_PATH

# Backup previous log
backup_log

log "Watchdog started"

echo "" > EPIC_IP
EPIC=""
COUNT=0
FEED_WD=1
IP=""
PING_FAIL_COUNT=0
NO_EPIC_IP_COUNT=0
LINK_CHANGE_COUNT=0
BACKUP_COUNT=0
while true; do
    if [ "$COUNT" = "$((TIMEOUT-2))" ]; then
        ip=$(ip -o -4 addr list $ETH | awk '{print $4}' | cut -d/ -f1)
        echo "IP: $ip, FEED_WD: $FEED_WD, LINK_CHANGE_COUNT: $((LINK_CHANGE_COUNT - 1)), NO_EPIC_IP_COUNT: $NO_EPIC_IP_COUNT, PING_FAIL_COUNT: $PING_FAIL_COUNT"
        
        # Link test
        lnk_chng=$(cat /sys/class/net/eth0/carrier_changes)
        if [ "$LINK_CHANGE_COUNT" != "0" ] && [ "$LINK_CHANGE_COUNT" != "$lnk_chng" ]; then
            status="up"
            if (( lnk_chng%2==1 )); then status="down"; fi
            log "Link status changed to '$status' - Counter: $((lnk_chng - 2))"
        fi
        LINK_CHANGE_COUNT=$lnk_chng
        
        # Check eth0 IP
        if [ "$ip" = "" ]; then
            log "eth0 failed or no IP"
        elif [ "$ip" != "$IP" ]; then
            if [ "$IP" != "" ]; then
                log "eth0 IP changed"
            fi
            IP="$ip"
        fi
        
        #Check EPIC server IP if exists and if it responds
        epic=$(cat EPIC_IP)
        if [ "$epic" = "" ]; then
            NO_EPIC_IP_COUNT=$((NO_EPIC_IP_COUNT+1))
            if ((NO_EPIC_IP_COUNT>37)); then
                log "EPIC server IP not available after 5min"
                NO_EPIC_IP_COUNT=0
            fi
        else
            if [ "$epic" != "$EPIC" ]; then
                log "EPIC server IP changed"
            fi
            
            EPIC="$epic"
            NO_EPIC_IP_COUNT=0
#            echo "EPIC: $EPIC"
            
            epic_test=$(ping -c 1 -W 1 $EPIC)
            if [[ ${epic_test} != *" 0% packet loss"* ]]; then
                PING_FAIL_COUNT=$((PING_FAIL_COUNT+1))
                if ((PING_FAIL_COUNT>37)); then
                    log "EPIC server not responding to ping for 5min"
                    FEED_WD=0
                fi
            else
                if [ "$PING_FAIL_COUNT" != "0" ]; then PING_FAIL_COUNT=$((PING_FAIL_COUNT-1)); fi
            fi
            
        fi
        
        if [ "$FEED_WD" = "1" ]; then
            echo "$TIMEOUT" > /dev/watchdog0
#            echo "Feed WD"
        else
            PING_FAIL_COUNT=0
            NO_EPIC_IP_COUNT=0
            FEED_WD=1
            echo "" > EPIC_IP
            log "WD died starving!"
        fi
        
        COUNT=0
    fi
    
#    led_stat=$(cat $LEDG)
#    if [ "$led_stat" = "1" ]; then
#        echo "0" > $LEDG
#        sleep 0.1
#        echo "1" > $LEDG
#    else
#        echo "1" > $LEDG
#        sleep 0.1
#        echo "0" > $LEDG
#    fi
    
    if [ "$BACKUP_COUNT" = "600" ]; then
        sz=$(stat -c%s "$LOG_FILE")
        if (( sz > 50000000 )); then
            log "Log exeeded 50MB, so backup and rotate activated."
            backup_log
            log "Log started, after a backup."
        fi
        BACKUP_COUNT=0
    fi
    
    BACKUP_COUNT=$((BACKUP_COUNT+1))
    COUNT=$((COUNT+1))
    
    sleep 0.9
done
