import os
import time
from smbus2 import SMBus

PADAUK1=0x42
PADAUK2=0x43
MS6266 =0x44

class I2C:
    CH_A = [0xe0, 0x90, 0x50, 0x10, 0x30, 0x70, 0xb0]
    CH_B = [0xd0, 0x80, 0x40, 0x00, 0x20, 0x60, 0xa0]

    def __init__(self):
        self.bus = SMBus(0)
        self.muteMS6266()

    def muteMS6266(self):
        self.bus.write_byte(MS6266, 0xf9)

    def unmuteMS6266(self):
        self.bus.write_byte(MS6266, 0xf8)
        self.bus.write_byte(MS6266, 0xe0)
        self.bus.write_byte(MS6266, 0xd0)

    def getInputVolume(self) -> int:
        v=self.bus.read_byte_data(PADAUK1, 0x04)
        return v

    def getOutputVolume(self) -> int:
        v=self.bus.read_byte_data(PADAUK1, 0x05)
        return v

    def getAmpStatus(self) -> bool:
        v=self.bus.read_byte_data(PADAUK2, 0x00)
        return ((v&2) == 2)

    def getAmpFault(self) -> bool:
        v=self.bus.read_byte_data(PADAUK2, 0x04)
        return v

    def setChannelVolume(self, ch: int, v: int):
        if v > 16:
            v = 16
        if v < -79:
            v = -79
        if v > 0:
            self.B = (v - 1) // 2 + 8
            self.A = 0
            if v % 2 > 0:
                self.A = 1
        if v < 0:
            v *= -1
            self.B = v // 10
            self.A = v - (self.B * 10)
        if v == 0:
            self.B = 0
            self.A = 0
        self.A |= self.CH_A[ch]
        self.B |= self.CH_B[ch]

        done=False
        while not done:
            try:
                self.bus.write_byte(MS6266, self.B)
                done=True
            except:
                os.system("./i2c-reset")
        done=False
        while not done:
            try:
                self.bus.write_byte(MS6266, self.A)
                done=True
            except:
                os.system("./i2c-reset")

'''
i2c=I2C()
while True:
    print("Vi: {}".format(i2c.getInputVolume()))
    print("Vo: {}".format(i2c.getOutputVolume()))
    time.sleep(0.5)
'''
