import subprocess


class Padauk:
    padauks = ["0x43", "0x42"]
    leds = ["0x08", "0x09", "0x0a", "0x0b"]
    colors = ["off", "red", "green", "yellow", "blue", "purple", "light blue", "white"]

    def __init__(self, ic):
        self.padauk = self.padauks[ic - 1]

    def lightLED(self, led, intensity, color):
        n = self.leds[led - 1]

        if intensity > 4:
            intensity = 4
        if intensity < 0:
            intensity = 0
        intns = str(intensity)

        if color in self.colors:
            clr = str(self.colors.index(color))
        else:
            clr = "0"

        led_val = "0x" + intns + clr
        self.i2c_write(n, led_val)

    def pin_read(self, pin) -> int:
        with open("/sys/class/gpio/gpio"+pin+"/value") as f:
            return int(f.readline().strip())

    def pin_write(self, pin, value):
        subprocess.run("echo \"{}\" > /sys/class/gpio/gpio{}/value".format(value, pin), shell=True)

    def i2c_read(self, addr, reg):
        process = subprocess.Popen(["i2cget", "-y", "0", addr, reg], stdout=subprocess.PIPE)
        process.wait()
        return int(process.stdout.read().decode("utf-8").strip())

    def i2c_write(self, reg, value):
        cmd = "i2cset -y 0 {} {} {}".format(self.padauk, reg, value)
        subprocess.run(cmd, shell=True)
