#!/bin/sh

LOG_FILE=/var/log/epic.log

LAST_LOG=""
log() {
    if [ ! "$LAST_LOG" = "$2" ]; then
        LAST_LOG=$2
        stamp=$(date +'%d-%m-%Y %H:%M:%S')
        record="$stamp,000 $1 $3 $2"
        echo $record >> $LOG_FILE
        if [ "$2" = "ERROR" ]; then
            >&2 echo "$3: $2"
        fi

        echo $record
    fi
}

APP_NAME="USBkeyMonitor"
INTERVAL=3    # sec
STICK_FOUND=""

log "$APP_NAME" "Monitor started" "INFO"

while true
do
    sleep $INTERVAL

    TMP=$(ps -A | grep 'dropbear' | wc -l)
    if [ ! "$TMP" = "0" ]; then                               # SSH already running
        if [ "$STICK_FOUND" = "yes" ] && [ ! -e "$STICK/ssh_unlock.txt" ]; then
            log "$APP_NAME" "USB key removed. Rebooting the device." "INFO"
            sleep 2
            reboot
        else
            log "$APP_NAME" "SSH already running" "INFO"
        fi
        
        continue
    fi

    STICK="/run/media/sda1"
    if [ ! -e "$STICK" ]; then STICK="/run/media/sdb1"; fi
    if [ ! -e "$STICK" ]; then STICK="/run/media/sdc1"; fi
    if [ ! -e "$STICK" ]; then STICK="/run/media/sdd1"; fi
    if [ ! -e "$STICK" ]; then   # No stick found
        STICK_FOUND="";
        log "$APP_NAME" "Key not found" "INFO"
        continue;
    fi
    STICK_FOUND="yes"
    log "$APP_NAME" "USB stick found" "INFO"
    echo "Mount point: $STICK"
    log "$APP_NAME" "USB stick detected" "INFO"

    if [ ! -e "$STICK/ssh_unlock.txt" ]; then
        log "$APP_NAME" "Key file not found" "WARNING"
        continue                                              # Stick does not contain the 'ssh_unlock.txt' file
    fi

    MAC=$(cat /sys/class/net/eth0/address)
    echo "MAC: $MAC"

    KEY1=$(cat $STICK/ssh_unlock.txt)
    echo "KEY1: $KEY1"

    KEY2=$(echo -n "$MAC" | openssl sha512 | cut -d' ' -f2)
    echo "KEY2: $KEY2"

    if [ "$KEY1" = "$KEY2" ]; then
        uci -q set dropbear.RunCtl.enable='on_until_reboot'
        uci -q commit dropbear
        log "$APP_NAME" "SSH enabled" "INFO"
        /barix/hooks/application/dropbear.hook start
    else
        log "$APP_NAME" "Wrong key" "ERROR"
        continue                                              # Incorrect 'key' - at least for this device
    fi

done
