import urllib
import logging
import traceback

from flask import Blueprint, request, Response

from barix import HttpMethod

from .internal_funcs import *

bp = Blueprint('CGIs_API', __name__)

log = logging.getLogger('werkzeug')

def iterform(multidict):
    for key in multidict.keys():
        for value in multidict.getlist(key):
            yield (key.encode("utf8"), value.encode("utf8"))

@bp.route('/basic.cgi') #command.cgi -> :48081/command.cgi
@bp.route('/command.cgi')
def redirectToAnotherEndpoint():
    try:
        #log.debug("URL")
        #log.debug(request.url)
        #log.debug("Query")
        #log.debug(request.args)
        #log.debug("Method")
        #log.debug(request.method)
        #log.debug("Headers")
        #log.debug(request.headers)
        #for (key, val) in request.headers:
        #    log.debug(key, val)
        #log.debug("Query")
        #log.debug(request.query_string)

        log.info("Request to redirect received: {}".format(request.url))
        request_headers = {}
        if request.method == "POST":
            form_data = list(iterform(request.form))
            form_data = urllib.urlencode(form_data)
            request_headers["Content-Length"] = len(form_data)
        else:
            form_data = None

        redirectionURL = "http://127.0.0.1:48081/command.cgi"+"?"+request.query_string.decode("utf-8")
        r = urllib.request.Request(url=redirectionURL, data=form_data, method=request.method)

        # Get headers from request
        for (key, val) in request.headers:
            if key != "Host":
                r.add_header(key, val)
        for (key, val) in request_headers:
            r.add_header(key, val)

        resp = urllib.request.urlopen(r)

        # Process response
        data = resp.read()
        log.debug("Response data from redirect endpoint received: {}".format(data))
        #log.debug(data)
        enc = resp.headers.get_content_charset('utf-8')
        payload = data.decode(enc)
        # Clean up response headers for forwarding
        response_headers = {}
        #log.debug("Response headers")
        #log.debug(resp.headers)
        for (key, value) in resp.headers.items():
            if key in ["content-length", "connection"]:
                continue
            response_headers[key] = value

        return Response(response=payload, status=resp.status, headers=response_headers)
    except Exception as e:
        log.error(e, exc_info=True)
        #traceback.print_exc()
        #log.error(traceback.print_exc())
    return Response(status=500)


@bp.route('/rest/app/status', methods=['GET'])
@login_required
def getAppStatus():
    try:
        resp = HttpMethod.get('http://127.0.0.1:48081/status')
        data = resp.read()
        log.debug("Status {}".format(data))
        enc = resp.headers.get_content_charset('utf-8')
        payload = data.decode(enc)
        log.debug("Received status {}".format(json.dumps(payload)))
        # {
        #     "sipStatus": "NOT CONFIGURED|IDLE|CALLING|INCOMMING|RINGING|CONNECTED|GETTING_NOTIF",
        #     "sipRegStatus": "REGISTERED|UNREGISTERED",
        #     "sipPeer": "someguy@barix.com",
        #     "sipRegistrationCode": "some string",
        #     "hpnStatus": "NOT CONFIGURED|IDLE|ALIVE",
        #     "bgmStatus": "SAME_AS_HPN :-)",
        #     "audioStatus": "IDLE|SIP|HPN|BGM"
        # }
        # payload = { "sipStatus": "NOT CONFIGURED",
        #             "sipRegStatus": "REGISTERED",
        #             "sipPeer": "someguy@barix.com",
        #             "sipRegistrationCode": "some string",
        #             "hpnStatus": "IDLE",
        #             "bgmStatus": "ALIVE",
        #             "audioStatus": "BGM"
        #           }
        return Response(json.dumps({"appStatus" : payload}), status=200)
    except Exception as e:
        log.error(e)
        return Response(status=INTERNAL_SERVER_ERROR_CODE)

