import os.path
import sys

import logging
from logging.handlers import RotatingFileHandler
from flask import Flask, Response, current_app, render_template, make_response, request, redirect, session
from werkzeug.utils import redirect
from .common import *
from uci import Uci
import json
from datetime import timedelta

import tempfile


from . import internal_funcs
from app import uci_API
from app import system_info_API
from app import system_funcs_API
from app import settings_API
from app import auth_API
from app import CGIs_API
from app import external_API
from app import CZ300_settings_API

class tcolor:
    FAIL = '\033[91m'
    RESET = '\033[0m'
#     HEADER = '\033[95m'
#     OKBLUE = '\033[94m'
#     OKGREEN = '\033[92m'
#     WARNING = '\033[93m'
#     BOLD = '\033[1m'
#     UNDERLINE = '\033[4m'


app = Flask(__name__, static_url_path='', static_folder='static', template_folder='static')
# static_url_path='' removes any preceding path from the URL (i.e. the default /static).
# static_folder='web/static' to serve any files found in the folder web/static as static files.
# template_folder='web/templates' similarly, this changes the templates folder.


app.secret_key = b'\xb3\xa482C\x98\x81\xa9\x8e5\xe9\x7f\xe2\xf9y/'
#app.config['SESSION_COOKIE_HTTPONLY'] = False
#app.config['PERMANENT_SESSION_LIFETIME'] = timedelta(minutes=30)
app.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER
app.config['MAX_CONTENT_LENGTH'] = MAX_FILE_SIZE_UPDATE

# Test file exists and include angular static content routes
def include_angular_routes():
    try:
        from app.static.angularRoutes4Flask import angularRoutes
        app.register_blueprint(angularRoutes)
    except:
        print(" * {}[ERROR]{} Can not import module 'angularRoutes' from 'static/angularRoutes4Flask'".format(tcolor.FAIL, tcolor.RESET))
        return False
    else:
        print(" * Imported module 'angularRoutes4Flask'")
        return True


# # By default serve index.html from static/
# @app.route('/')
# def index(**kwargs):
#     #app.logger.info('current_name')
#     #app.logger.info(current_app.name)
#     #log.info('route')
#     return render_template('index.html')

"""
Init logger
"""
log = logging.getLogger('werkzeug')
log.setLevel(logging.DEBUG)
rotHandler = RotatingFileHandler("/var/log/flask-backend.log", maxBytes=2*1024*1024, backupCount=5)
format1 = logging.Formatter('%(asctime)s  %(levelname)s  %(filename)s:%(lineno)s  %(message)s')
rotHandler.setFormatter(format1)
log.addHandler(rotHandler)
# stderr to logfile
#sys.stderr = log

log.info("Starting Flask Backend...")

# Check if has services to restart
internal_funcs.restartServices()

"""
Include routes
"""
# Include routes from UCI REST endpoints
app.register_blueprint(system_info_API.bp)
app.register_blueprint(uci_API.bp)
app.register_blueprint(system_funcs_API.bp)
app.register_blueprint(settings_API.bp)
app.register_blueprint(auth_API.bp)
app.register_blueprint(CGIs_API.bp)
app.register_blueprint(external_API.bp)
app.register_blueprint(CZ300_settings_API.bp)

# Include custom routes from angular
include_angular_routes()

"""
@app.before_request
def require_login():
    print("request endpoint: ")
    print(request.endpoint)
    #print("request: ")
    #print(request)
    if not request.endpoint.startswith('angularRoutes') and 'sessionID' not in session:
        #return Response(status=INVALID_LOGIN)
        return redirect('/login')
"""

"""
Create unexisting directories
"""
from pathlib import Path

p = Path(UPLOAD_FOLDER)
if not p.exists():
    try:
        p.mkdir()
    except Exception as e:
        log.error(e)

"""
p = Path('/mnt/data/aes67')
if not p.exists():
    try:
        p.mkdir()
    except Exception as e:
        log.error(e)
"""

p = Path(UPDATES_FOLDER)
if not p.exists():
    try:
        p.mkdir()
    except Exception as e:
        log.error(e)


p = Path(CA_CERTIFICATES_FOLDER)
if not p.exists():
    try:
        p.mkdir()
    except Exception as e:
        log.error(e)


"""
Override default werkzeug formparser to allow to update files to the UPLOAD_FOLDER instead of default
"""

from io import BytesIO
from tempfile import TemporaryFile, SpooledTemporaryFile
from flask.wrappers import Request

class MemoryRequest(Request):
    def _get_file_stream(self, total_content_length, content_type, filename, content_length):
        max_size = 1024 * 500

        #log.debug("default_stream_factory")

        if SpooledTemporaryFile is not None:
            return SpooledTemporaryFile(max_size=max_size, mode="rb+", dir=UPLOAD_FOLDER)
        elif total_content_length is None or total_content_length > max_size:
            return TemporaryFile(mode="rb+", dir=UPLOAD_FOLDER)

        return BytesIO()

app.request_class = MemoryRequest

#log.debug("SESSION_KEY: {}".format(SESSION_KEY))


"""
Get web protocol from uci to launch app

uciCli = Uci()
protocol = uciCli.get('httpd','webserver','protocol')

if protocol == "https":
    app.run(host=HOST, port=443, threaded=True, ssl_context=('/mnt/data/certs/barix.pem', '/mnt/data/certs/barix.pem'))
    
else:
"""
app.run(host=HOST, port=80, threaded=True)
