
def is_ae_uci_change_immediately(config: str, section: str, option: str, device_model: str) -> bool:
    """
    Based on:
    https://docs.google.com/spreadsheets/d/13saud-efRDXpaHH1Gnu_JZeTdY0P1siARJbHGwX0IKI/edit?pli=1&gid=0#gid=0

    CZA-1300
    MS-775
    MS-720
    MS700   <-- but changed on getDeviceModel() to MS-700
    MS-500A
    MS-300B

    """
    if config == "ae_ms":

        if device_model == "MS-700" or device_model == "MS700":  # just in case (see getDeviceModel())
            if section == "mixer" or section == "volume" or section == "eq" or section == "talkback":
                return True

        elif device_model == "CZA-1300":
            if section == "mixer":
                if (option == "ch1" or
                   option == "ch4" or
                   option == "ch5" or
                   option == "ch100" or
                   option == "enable1" or
                   option == "enable4" or
                   option == "enable5" or
                   option == "enable100"):
                    return True
            if section == "volume":
                if (option == "out1" or
                   option == "out4" or
                   option == "enable1" or
                   option == "enable4"):
                    return True
            if section == "talkback":
                if option == "level_wpa" or option == "level_rp1":
                    return True

        elif device_model == "MS-775" or device_model == "MS-720":
            if section == "mixer":
                if (option == "ch1" or
                   option == "ch4" or
                   option == "ch100" or
                   option == "enable1" or
                   option == "enable4" or
                   option == "enable100"):
                    return True
            if section == "volume":
                if (option == "out0" or
                   option == "out1" or
                   option == "out4" or
                   option == "enable0" or
                   option == "enable1" or
                   option == "enable4"):
                    return True
            if section == "talkback":
                if option == "level_wpa" or option == "level_rp1":
                    return True

    return False
