#from uci import Uci, UciExceptionNotFound, UciException
import json
import logging
import threading
from os import listdir
from os.path import isfile, join
from .common import *
from . import internal_funcs
from .uci import *
from .internal_funcs import *

from flask import (
    Blueprint, flash, g, redirect, render_template, request, session, url_for, Response
)

import app.common as common

bp = Blueprint('auth_API', __name__)

log = logging.getLogger('werkzeug')

@bp.route('/rest/login', methods=['POST'])
def login():
    try:
        data = json.loads(request.data)
        username = data['username']
        #print(username)
        password = data['password']
        #print(password)
        if checkIfUsernameAndPwdAreValid(username, password):
            #session.permanent = True
            #log.debug("Login")
            #log.debug("Previous session: {}".format(session))
            #log.debug("Session_key: {}".format(common.SESSION_KEY))
            session['sessionID'] = getSessionKey()
            session.modified = True
            #log.debug("Updated session: {}".format(session))
            #return redirect('/settings')
            return Response(status=200)
        else:
            log.debug("Invalid username or password")
            return Response('Invalid username or password', status=INVALID_LOGIN, headers={"Content-Type" : "text/plain"})
    except Exception as e:
        log.debug("Exception during login {}".format(e))
    #return Response(status=200)

def checkIfUsernameAndPwdAreValid(username, password):
    if username == USERNAME:
        result, error_code = currPasswordIsValid(password)
        if error_code == ALL_OK and result:
            return True
    return False

