import json
import logging
import threading
from os import listdir
from os.path import isfile, join

from .internal_funcs import login_required
from .common import *
from . import internal_funcs
from .internal_funcs import *


from flask import (
    Blueprint, flash, g, redirect, render_template, request, session, url_for, Response
)

from barix import HttpMethod

bp = Blueprint('settings_API', __name__)

log = logging.getLogger('werkzeug')

@bp.route('/rest/settings', methods=['PUT'])
@login_required
def setDeviceSettings():
    log.debug("PUT request received")
    status_code = SUCCESS
    return_msg = {}
    try:
        data = json.loads(request.data)
    except Exception as e:
        log.debug(e)
        return_msg = {"error_code": INVALID_JSON_ERROR_CODE, "msg": INVALID_JSON_ERROR_MSG}
        return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)

    if 'pwdSettings' in data.keys():
        """
        if 'pwd_old' not in data['pwdSettings'].keys() and 'pwd_set' not in data['pwdSettings'].keys():
            return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                          "msg": INVALID_PARAMETER_ERROR_MSG.format('pwdSettings')}
            log.error(return_msg)
            return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
        else:
        """
        pwd_old = ''
        pwd_set = ''
        if 'pwd_old' in data['pwdSettings'].keys():
            pwd_old = data['pwdSettings']['pwd_old']
        if 'pwd_set' in data['pwdSettings'].keys():
            pwd_set = data['pwdSettings']['pwd_set']
        if pwd_old != '' or pwd_set != '': # otherwise do nothing
            webui_pass_flag = getUci('httpd.webserver.password_set')
            if webui_pass_flag == "true" and pwd_old == '' and pwd_set != '':
                return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                              "msg": INVALID_PARAMETER_ERROR_MSG.format('pwdSettings')}
                log.error(return_msg)
                return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
            elif webui_pass_flag == "true":
                result = currPasswordIsValid(pwd_old)
                if result[1] != ALL_OK:
                    return Response(status=INTERNAL_SERVER_ERROR_CODE)
                else:
                    if result[0]: #password is valid
                        if pwd_set != '':  # webui_pass_flag == "true" and pwd_old != '' and pwd_set != ''
                            result = setNewWebUIpassword(pwd_set)
                        else:  # webui_pass_flag == "true" and pwd_old != '' and pwd_set == ''
                            result = enableOrdisableWebUIpassword('false')
                    else:
                        return_msg = {"error_code": INVALID_PASSWORD_ERROR_CODE,
                                      "msg": INVALID_PASSWORD_ERROR_MSG}
                        log.error(return_msg)
                        return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
            else: # webui_pass_flag == "false" and pwd_old == '' and pwd_set != ''
                result = setNewWebUIpassword(pwd_set)
            if result != ALL_OK:
                return Response(status=INTERNAL_SERVER_ERROR_CODE)

    if 'ucis' in data.keys():
        if not 'commit' in data.keys():
            return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                          "msg": INVALID_PARAMETER_ERROR_MSG.format('commit')}
            log.error(return_msg)
            return Response(response=json.dumps(return_msg), status = BAD_REQUEST_ERROR_CODE)
        jsonUcis = data['ucis']
        if not validateUciValues(jsonUcis):
            return_msg = {"error_code": INVALID_VALUE_ERROR_CODE,
                          "msg": INVALID_VALUE_ERROR_MSG}
            log.error(return_msg)
            return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
        error, reason, ucisConfigured = setNewUciConfigs(jsonUcis, data['commit'], True, setAppSettingsAdditionalChecks)
        if error == EXCEPTION_OCCURRED_ERROR_CODE:
            return Response(status=INTERNAL_SERVER_ERROR_CODE)
        elif error == INVALID_PARAMETER_ERROR_CODE:
            return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                          "msg": INVALID_PARAMETER_ERROR_MSG.format(reason)}
            log.error(return_msg)
            return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
        else:
            uciListSet = []
            for uciTuple in ucisConfigured:
                uciListSet.append(formatUciTupleIntoString(uciTuple))
            return_msg = {"ucisSet": uciListSet}
            status_code = SUCCESS

            log.debug("Return message: {}".format(return_msg))

    return Response(json.dumps(return_msg), status=status_code)

def setAppSettingsAdditionalChecks(ucisChanged):
    # check if web protocol changed to HTTPS
    for uciTuple in ucisChanged:
        if ('httpd', 'webserver', 'protocol') == uciTuple:
            generateNewSessionKey()
            if getUci('httpd.webserver.protocol') == 'https':
                generateSSLCerts()
            break

@bp.route('/rest/settings/volume', methods=['PUT'])
@login_required
def setVolume():
    try:
        uciList = json.loads(request.data)
    except Exception as e:
        log.debug(e)
        return_msg = {"error_code": INVALID_JSON_ERROR_CODE, "msg": INVALID_JSON_ERROR_MSG}
        return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
    log.debug("List of ucis to set: {}".format(uciList))

    if not validateUciValues(uciList):
        return_msg = {"error_code": INVALID_VALUE_ERROR_CODE,
                      "msg": INVALID_VALUE_ERROR_MSG}
        log.error(return_msg)
        return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
    error, reason, ucisConfigured = setNewUciConfigs(uciList, True, True)
    if error == ALL_OK:
        return Response(status=SUCCESS)
    elif error == INVALID_PARAMETER_ERROR_CODE:
        return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                      "msg": INVALID_PARAMETER_ERROR_MSG.format(reason)}
        log.error(return_msg)
        return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
    else:
        return Response(status=INTERNAL_SERVER_ERROR_CODE)
