from uci import Uci, UciExceptionNotFound, UciException
import json
import logging
import threading
from os import listdir
from os.path import isfile, join

from .common import *
from .internal_funcs import *
from .uci import *

from flask import (
    Blueprint, flash, g, redirect, render_template, request, session, url_for, Response
)

bp = Blueprint('uci_API', __name__)

log = logging.getLogger('werkzeug')

"""
#http://127.0.0.1:5000/config/show
#http://127.0.0.1:5000/config/show?config=network
#http://127.0.0.1:5000/config/show?config=network&section=eth0
#http://127.0.0.1:5000/config/show?config=network&section=eth0&option=netmask
"""
@bp.route('/rest/uci', methods=['GET'])
@login_required
def getuci():
    log.debug(request.args)

    response = {}
    status_code = 200
    result = ''

    uriList = request.args

    if uriList == {}:
        log.debug("Empty uci list in request")
        uriList = getAllConfigs()

    for uciPath in uriList:
        #log.debug(uciPath)
        path_params = uciPath.split('.')
        try:
            # Instantiate Python UCI
            uci = Uci()
            #if only has config
            if len(path_params) == 1:
                # log.debug("uci.get({})".format(path_params[0]))
                """
                result = formatUCI(uci.get(path_params[0]))
                for key in result:
                    response[uciPath + "." + key] = result[key]
                """
                result = uci.get(path_params[0])
            #if it has config and section
            elif len(path_params) == 2:
                # log.debug("uci.get_all({},{})".format(path_params[0], path_params[1]))
                """
                result = formatUCI(uci.get_all(path_params[0], path_params[1]))
                for key in result:
                    response[uciPath + "." + key] = result[key]
                """
                result = uci.get_all(path_params[0], path_params[1])
            #if it has config, section and option
            elif len(path_params) == 3:
                # log.debug("uci.get({},{},{})".format(path_params[0], path_params[1], path_params[2]))
                result = uci.get(path_params[0], path_params[1], path_params[2])

            else:
                log.error("ERROR: bad formatted uci {}".format(uciPath))
                return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                              "msg": INVALID_PARAMETER_ERROR_MSG.format(uciPath)}
                log.error(return_msg)
                status_code = BAD_REQUEST_ERROR_CODE
                break
        except UciExceptionNotFound:
            log.debug("uci.get param \"{}\" NOT FOUND".format(uciPath))
            result = ''  # an uci with an empty string value is the same a non existing string
        except Exception as e:
            """
            response = {"error_code": UNSPECIFIED_ERROR_CODE, "msg": "ERROR: It was not possible to conclude the action requested"}
            log.debug("uci.get param \"{}\" failed: {}\n".format(uciPath, e))
            # error code: Internal Server Error
            status_code = INTERNAL_SERVER_ERROR_CODE
            break
            """
            log.error(e)
            return Response(status=INTERNAL_SERVER_ERROR_CODE)
        response[uciPath] = result
    log.debug(response)
    return Response(json.dumps(response), status=status_code)


@bp.route('/rest/uci', methods=['PUT'])
@login_required
def setuci():
    log.debug("/rest/uci POST")
    # success code
    status_code = 200
    return_msg = {"error_code": ALL_OK, "msg": "All Ok"}
    uciCli = Uci()
    try:
        data = json.loads(request.data)
    except Exception as e:
        log.debug(e)
        return_msg = {"error_code": INVALID_JSON_ERROR_CODE, "msg": INVALID_JSON_ERROR_MSG}
        return Response(json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)

    # it is actually a dict
    if 'options' in data.keys():
        uciListReq = data['options']
        log.debug("List of ucis to set: {}".format(uciListReq))

        if uciListReq != {}:  # if list of ucis to set is not empty
            uciListSetted = []
            for uci in uciListReq:
                log.debug("uci: {}".format(uci))
                path_params = uci.split('.')
                # verify if params are valid (if the number of params is correct and exist)
                if len(path_params) != 2 and len(path_params) != 3:
                    return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                                  "msg": INVALID_PARAMETER_ERROR_MSG.format(uci)}
                    log.error(return_msg)
                    status_code = BAD_REQUEST_ERROR_CODE
                    break
                value = ''
                try:
                    value = uciCli.get(path_params[0], path_params[1], path_params[2])
                except UciExceptionNotFound:
                    log.debug("uci \"{}\" NOT FOUND".format(uci))
                try:
                    if value != uciListReq[uci]:
                        log.debug("uciCli.set({},{},{},{})".format(path_params[0], path_params[1], path_params[2], uciListReq[uci]))
                        uciCli.set(path_params[0], path_params[1], path_params[2], str(uciListReq[uci]))
                        uciListSetted.append((path_params[0], path_params[1], path_params[2]))

                except UciException:
                    log.error("It was not possible to set uci {} with value {}".format(uci, str(uciListReq[uci])))
                    return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                                  "msg": INVALID_PARAMETER_ERROR_MSG.format(uciListReq[uci])}
                    log.error(return_msg)
                    status_code = BAD_REQUEST_ERROR_CODE
                    break
                except Exception as e:
                    log.debug(e)
                    return Response(status=INTERNAL_SERVER_ERROR_CODE)

            if status_code != 200:
                # revert changes made
                for uci in uciListSetted:
                    try:
                        log.debug("Reverting uci {}".format(uci))
                        uciCli.revert(uci[0], uci[1], uci[2])
                    except Exception as e:
                        log.error("It was not possible to revert changes made to uci {}: {}".format(uci, e))
                        return Response(status=INTERNAL_SERVER_ERROR_CODE)
            else:
                configsList = []
                for uci in uciListSetted:
                    configsList.append(uci[0])
                if not 'commit' in data.keys():
                    return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                                  "msg": INVALID_PARAMETER_ERROR_MSG.format('commit')}
                    log.error(return_msg)
                    return Response(response=json.dumps(return_msg), status=BAD_REQUEST_ERROR_CODE)
                log.debug('Should commit: {}'.format(data['commit']))
                if data['commit'] and configsList != []:

                    for config in set(configsList):
                        try:
                            log.debug("Commiting config {}".format(config))
                            uciCli.commit(config)
                        except Exception as e:
                            # should never happen!!
                            log.error("Committing config {} failed: {}".format(config, e))
                            # error code: Internal Server Error
                            return Response(status=INTERNAL_SERVER_ERROR_CODE)

                result, error = internal_funcs.createListOfServicesToRestart(uciListSetted)
                if error != ALL_OK:
                    return Response(status=INTERNAL_SERVER_ERROR_CODE)
                t = threading.Thread(target=internal_funcs.restartServices)
                t.start()
        else:
            return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE,
                          "msg": INVALID_PARAMETER_ERROR_MSG.format('options')}
            log.error(return_msg)
            status_code = BAD_REQUEST_ERROR_CODE
    else:
        return_msg = {"error_code": INVALID_PARAMETER_ERROR_CODE, "msg": INVALID_PARAMETER_ERROR_MSG.format('options')}
        log.error(return_msg)
        status_code = BAD_REQUEST_ERROR_CODE

    # return sucess_code if the sets and commits were successful
    # return error_code if they weren't

    # return_msg = {"error_code": 100000, "msg": "inputs not validated"}
    return Response(json.dumps(return_msg), status=status_code)
