--[[
  Implements an abstraction for the different kinds of configuration
  formats the Arcanix needs to deal to.
  The following configuration formats are currently supported:
     - uci
     - json
]]

AUTH_MODE = {
    PIN=1,
    -- ARCANIX=2
}

AUTH_ALGO = {
    MD5=1,
    -- SHA1=2
}

-- Base class definition
local ConfigurationHandler = {}

function ConfigurationHandler:new(o)
    o = o or {}
    setmetatable(o, self)
    self.__index = self
    -- callbacks to reload settings
    self.reloadCallbacks = {}
    -- Directory where configurations files are stored
    self.confDirectory = {}
    return o
end

function ConfigurationHandler:read_arcarnix_conf()
    error("Function not implemented! Please use function from derived class")
end

function ConfigurationHandler:read_configurations()
    error("Function not implemented! Please use function from derived class")
end

function ConfigurationHandler:start_monitor()
    error("Function not implemented! Please use function from derived class")
end

function ConfigurationHandler:reload_settings()
    if self.reloadCallbacks then
        for k, uci_cbk in pairs(self.reloadCallbacks) do
            uci_cbk();
        end
        self.reloadCallbacks = {};
    end
end

function ConfigurationHandler:save_new_pin()
    error("Function not implemented! Please use function from derived class")
end

function ConfigurationHandler:add_ble_characteristics(callback)
    error("Function not implemented! Please use function from derived class")
end

function ConfigurationHandler:get_value(name)
    error("Function not implemented! Please use function from derived class")
end

function ConfigurationHandler:validate_uuid(uuid)
    if type(uuid) ~= "number" or uuid < 0xffff then
        return false
    end
    return true
end

return ConfigurationHandler

