local system = require("system");
local logging = require("logging");
local logger = logging.defaultLogger();

-- number of allowed failed authentication attempts
local BLOCK_AUTH_ATTEMPTS = 5;

-- blocked time in seconds after a BLOCK_AUTH_ATTEMPTS of failed authentication
local BLOCK_TIME = 300;

local pin_auth_enabled = false;

local Device = {
}

local module = {
    devices={}
};

function Device:new(o)
    o = o or {};
    setmetatable(o, self);
    self.__index = self;
    return o;
end

function Device:isBlocked()
    return self.blockTime ~= 0 and (system.monotime() - self.blockTime) <= BLOCK_TIME;
end

function Device:setAuthFailed()
    self.failedAuthCount = self.failedAuthCount + 1;
    logger:debug("[%s] failed authentication count %d", self.name, self.failedAuthCount);
    if self.failedAuthCount >= BLOCK_AUTH_ATTEMPTS then
        self.blockTime = system.monotime();
        logger:info("[%s] block time %f", self.name, self.blockTime);
    end
    self.challenge = nil;
end

function Device:setAuthenticated()
    self.authenticated = true;
    self.failedAuthCount = 0;
    self.blockTime = 0;
end

function module.add_device(name)
    module.devices[name] = Device:new{
        name=name,
        authenticated=not pin_auth_enabled,
        lastRandom=0,
        blockTime=0,
        failedAuthCount=0
    }
    return module.devices[name];
end

function module.remove_device(name)
    module.devices[name] = nil;
end

function module.find(name)
    return module.devices[name];
end

function module.enable_pin_auth(enable)
    pin_auth_enabled=enable;
end

return module;
