local module = {};

local handlers = {};
local handlersUsed = {};

local managedObjects = {};

local dbus;
function module.init(_dbus)
	dbus = _dbus;

	dbus.on("GetManagedObjects", function() end, {
        type = "method_call",
        interface = "org.freedesktop.DBus.ObjectManager",
        bus = "system",
        handler = function(obj, ...)
        	return "a{oa{sa{sv}}}", managedObjects["system"] or {}
        end
    });

	dbus.on("GetManagedObjects", function() end, {
        type = "method_call",
        interface = "org.freedesktop.DBus.ObjectManager",
        bus = "session",
        handler = function(obj, ...)
        	return "a{oa{sa{sv}}}", managedObjects["session"] or {}
        end
    });
end

function module.offMethodCall(methodName, interface, targetInterface, bus)
	handlers[bus][interface][targetInterface][methodName] = nil;

	local n = 0;
	for k,v in pairs(handlers[bus][interface][targetInterface]) do
		if v~=nil then
			n = n+1;
		end
	end

	if n==0 then
		handlers[bus][interface][targetInterface] = nil;
	end

	n = 0;
	for k,v in pairs(handlers[bus][interface]) do
		if v~=nil then
			n = n+1;
		end
	end

	if n==0 then
		handlers[bus][interface] = nil;
		dbus.off("", handlersUsed[bus][interface].handler, handlersUsed[bus][interface]);
		handlersUsed[bus][interface] = nil;
	end

	n = 0;
	for k,v in pairs(handlers[bus]) do
		if v~=nil then
			n = n+1;
		end
	end

	if n==0 then
		handlers[bus] = nil;
	end
end

function module.onMethodCall(methodName, interface, targetInterface, handler, bus)
	if handlers[bus]==nil then
		handlers[bus] = {};
		handlersUsed[bus] = {};
	end
	if handlers[bus][interface]==nil then
		handlers[bus][interface] = {};
		handlersUsed[bus][interface] = {
	        type = "method_call",
	        interface = interface,
	        bus = bus,
	        handler = function(obj, ...)
	        	--[[print("HANDLER RECV");
	        	for k,v in pairs(obj) do
	        		print(k,v)
	        	end]]
	        	if handlers[bus][interface][obj.path]~=nil then
	        		if handlers[bus][interface][obj.path][obj.member]~=nil then
	        			return handlers[bus][interface][obj.path][obj.member](obj, ...);
	        		end
	        	end
	        end
	    };
	    dbus.on("", function(...) end, handlersUsed[bus][interface]);

	end
	if handlers[bus][interface][targetInterface]==nil then
		handlers[bus][interface][targetInterface] = {};
	end
	handlers[bus][interface][targetInterface][methodName] = handler;
end

--[[
	properties{} {
		typ: "s",
		value: "asdasd"
	}
]]
function module.new(path, interfaceName, properties, bus, methods)

	local obj = {};

	obj.properties = properties;
	obj.methods = methods;

	local dict = {
        ["org.freedesktop.DBus.Introspectable"] = { }
    };

    if obj.properties~=nil then
        dict[interfaceName] = obj.properties;
    	dict["org.freedesktop.DBus.Properties"] = { };
    else
        dict[interfaceName] = { };
    end

   	if managedObjects[bus or "system"]==nil then
   		managedObjects[bus or "system"] = {};
   	end
   	managedObjects[bus or "system"][path] = dict;

    dbus.emit_signal("InterfacesAdded",{
        bus = bus or 'system',
        path = '/',
        interface = "org.freedesktop.DBus.ObjectManager",
        args = {
            "o",
            path,
            "a{sa{sv}}",
            dict
        }
    });

    if obj.methods~=nil then
	    for k,v in pairs(obj.methods) do
	    	module.onMethodCall(k, interfaceName, path, v, bus or "system");
	    end
	end

    if obj.properties~=nil then

    	for k,v in pairs(obj.properties) do
    		v.notifyChanged = function()
    			dbus.emit_signal("PropertiesChanged", {
    				bus = bus or "system",
    				path = path,
    				interface = "org.freedesktop.DBus.Properties",
    				args = {
    					"s",
    					interfaceName,
    					"a{sv}",
    					{
    						[k] = v
    					},
    					"as",
    					{}
    				}
    			});
    		end;
    	end

    	module.onMethodCall("GetAll", "org.freedesktop.DBus.Properties", path, function(reqObj, ifaceName)
    		
            return 
                "a{sv}",
                obj.properties

    	end, bus or "system");

    	module.onMethodCall("Get", "org.freedesktop.DBus.Properties", path, function(reqObj, ifaceName, propertyName)
    		
            return 
                "v",
                obj.properties[propertyName]

    	end, bus or "system");

    	module.onMethodCall("Set", "org.freedesktop.DBus.Properties", path, function(reqObj, ifaceName, propertyName, propertyValue)
    		
    		obj.properties[propertyName].value = propertyValue;

    	end, bus or "system");

    end

    return obj;

end

return module;
