import logging
import os
import shlex
import subprocess

from .exceptions import *
from .constants import *

log = logging.getLogger('flask-backend')

'''
Reboots the device if there is no firmware update running.
'''
def reboot():
    # check if there is no updater process running
    if not os.path.isfile(FW_UPDATE_FILE_PATH):
        try:
            cmd = "/sbin/reboot"
            subprocess.Popen(shlex.split(cmd))
        except Exception as e:
            log.error(e)
            raise e
    else:
        #raise Exception("Firmware update running: can't reboot device.")
        raise FwUpdateRunningError("Firmware update running: can't reboot device.")
