#!/bin/sh

DIAGNOSTICS="/var/log/diagnostics"

rm -rf $DIAGNOSTICS
mkdir $DIAGNOSTICS

env > $DIAGNOSTICS/environment.txt

uci show > $DIAGNOSTICS/uci_config.txt

#tar czf $DIAGNOSTICS/conf.tar.gz -C /mnt/data conf

uptime > $DIAGNOSTICS/uptime.txt

top -b -n 5 > $DIAGNOSTICS/top_samples.txt


ps -ef > $DIAGNOSTICS/ps_list.txt

cp /proc/meminfo $DIAGNOSTICS/meminfo.txt

tar czf $DIAGNOSTICS/netstats.tar.gz -C /proc/net .

#ping -c 10 player.manage.barix.com > $DIAGNOSTICS/ping_portal.txt

#traceroute player.manage.barix.com > $DIAGNOSTICS/traceroute_portal.txt

cp /etc/resolv.conf $DIAGNOSTICS/resolv.conf

cp /etc/network/interfaces $DIAGNOSTICS/network_interfaces.txt

df -h > $DIAGNOSTICS/filesystem_usage.txt

nslookup 1.barix.pool.ntp.org > $DIAGNOSTICS/lookup_ntp.txt

#nslookup release.barixupdate.com > $DIAGNOSTICS/lookup_downloads.txt

echo "NO_INFO" > $DIAGNOSTICS/factory_info
echo "NO_INFO" > $DIAGNOSTICS/factory_info.json

cp /tmp/factory_info_partition/factory_info $DIAGNOSTICS/factory_info
cp /tmp/factory_info_partition/factory_info_json $DIAGNOSTICS/factory_info.json

#cp -R /mnt/data/conf/ $DIAGNOSTICS/conf

#mkdir $DIAGNOSTICS/fallback_tracks
#cp -R /mnt/data/fallback_tracks/conf/ $DIAGNOSTICS/fallback_tracks
#ls -l /mnt/data/music > $DIAGNOSTICS/fallback_tracks/asset_list.txt

#mkdir $DIAGNOSTICS/assets
#cp -R /mnt/data/assets/conf/ $DIAGNOSTICS/assets
#ls -l /mnt/data/assets/data > $DIAGNOSTICS/assets/asset_list.txt

#cp -R /mnt/shadow /var/log/

tar czf /mnt/data/last_logs.tar.gz -C /var/log .
